/*
 * Decompiled with CFR 0.152.
 */
package symbolic.comp;

import dv.DoubleVector;
import io.ModelExportFormat;
import io.ModelExportOptions;
import io.ModelExportTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import mtbdd.PrismMTBDD;
import odd.ODDNode;
import odd.ODDUtils;
import parser.Values;
import parser.VarList;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionFilter;
import parser.ast.ExpressionFormula;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionProp;
import parser.ast.ExpressionUnaryOp;
import parser.ast.ExpressionVar;
import parser.ast.LabelList;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.type.Type;
import parser.type.TypeBool;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.type.TypeVoid;
import parser.visitor.ReplaceLabels;
import prism.Accuracy;
import prism.Filter;
import prism.Interval;
import prism.ModelType;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import prism.Result;
import symbolic.comp.LTLModelChecker;
import symbolic.comp.ModelChecker;
import symbolic.comp.NonProbModelChecker;
import symbolic.comp.NondetModelChecker;
import symbolic.comp.ProbModelChecker;
import symbolic.comp.StochModelChecker;
import symbolic.model.Model;
import symbolic.model.ModelSymbolic;
import symbolic.model.NondetModel;
import symbolic.model.ProbModel;
import symbolic.states.StateListMTBDD;
import symbolic.states.StateValues;
import symbolic.states.StateValuesDV;
import symbolic.states.StateValuesMTBDD;
import symbolic.states.StateValuesVoid;

public class StateModelChecker
extends PrismComponent
implements ModelChecker {
    protected Prism prism;
    protected PropertiesFile propertiesFile;
    protected Values constantValues;
    protected Model model;
    protected VarList varList;
    protected JDDNode trans;
    protected JDDNode trans01;
    protected JDDNode transActions;
    protected JDDNode start;
    protected JDDNode reach;
    protected ODDNode odd;
    protected JDDVars allDDRowVars;
    protected JDDVars allDDColVars;
    protected JDDVars[] varDDRowVars;
    protected Filter currentFilter;
    protected Result result;
    protected int engine;
    protected double termCritParam;
    protected boolean doIntervalIteration;
    protected boolean verbose;
    protected boolean storeVector = false;
    protected boolean genStrat = false;

    public StateModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism);
        this.prism = prism;
        this.model = model;
        this.propertiesFile = propertiesFile;
        this.constantValues = new Values();
        this.constantValues.addValues(this.model.getConstantValues());
        if (propertiesFile != null) {
            this.constantValues.addValues(propertiesFile.getConstantValues());
        }
        this.varList = this.model.getVarList();
        this.trans = this.model.getTrans();
        this.trans01 = this.model.getTrans01();
        if (model instanceof NondetModel) {
            this.transActions = ((NondetModel)this.model).getTransActions();
        }
        this.start = this.model.getStart();
        this.reach = this.model.getReach();
        this.odd = this.model.getODD();
        this.allDDRowVars = this.model.getAllDDRowVars();
        this.allDDColVars = this.model.getAllDDColVars();
        this.varDDRowVars = this.model.getVarDDRowVars();
        this.engine = prism.getEngine();
        this.termCritParam = prism.getTermCritParam();
        this.doIntervalIteration = prism.getSettings().getBoolean("prism.intervalIter");
        this.verbose = prism.getVerbose();
        this.storeVector = prism.getStoreVector();
        this.genStrat = prism.getGenStrat();
    }

    public StateModelChecker(Prism prism, VarList varList, JDDVars jDDVars, JDDVars[] jDDVarsArray, Values values) throws PrismException {
        super(prism);
        this.prism = prism;
        this.varList = varList;
        this.allDDRowVars = jDDVars;
        this.varDDRowVars = jDDVarsArray;
        this.constantValues = values;
        this.reach = null;
        ProbModel probModel = new ProbModel(JDD.Constant(0.0), JDD.Constant(0.0), jDDVars.copy(), new JDDVars(), null, varList, JDDVars.copyArray(jDDVarsArray), null);
        probModel.setConstantValues(values);
        this.model = probModel;
    }

    public static StateModelChecker createModelChecker(ModelType modelType, Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        NonProbModelChecker nonProbModelChecker = null;
        switch (modelType) {
            case DTMC: {
                nonProbModelChecker = new ProbModelChecker(prism, model, propertiesFile);
                break;
            }
            case MDP: {
                nonProbModelChecker = new NondetModelChecker(prism, model, propertiesFile);
                break;
            }
            case CTMC: {
                nonProbModelChecker = new StochModelChecker(prism, model, propertiesFile);
                break;
            }
            default: {
                throw new PrismException("Cannot create model checker for model type " + String.valueOf((Object)modelType));
            }
        }
        return nonProbModelChecker;
    }

    public ModelChecker createModelChecker(Model model) throws PrismException {
        return StateModelChecker.createModelChecker(model.getModelType(), this.prism, model, this.propertiesFile);
    }

    public void clearDummyModel() {
        this.model.clear();
    }

    @Override
    public Result check(Expression expression) throws PrismException {
        long l = 0L;
        this.result = new Result();
        this.currentFilter = null;
        if (this.storeVector) {
            ExpressionFilter expressionFilter = new ExpressionFilter("store", expression);
            expressionFilter.setInvisible(true);
            expressionFilter.typeCheck();
            expression = expressionFilter;
        }
        expression = ExpressionFilter.addDefaultFilterIfNeeded(expression, this.model.getNumInitialStates() == 1);
        l = System.currentTimeMillis();
        StateValues stateValues = this.checkExpression(expression, this.model.getReach().copy());
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nTime for model checking: " + (double)l / 1000.0 + " seconds.");
        Object object = "Result";
        if (!"Result".equals(expression.getResultName())) {
            object = (String)object + " (" + expression.getResultName().toLowerCase() + ")";
        }
        object = (String)object + ": " + this.result.getResultAndAccuracy();
        this.mainLog.print("\n" + (String)object + "\n");
        stateValues.clear();
        return this.result;
    }

    @Override
    public StateValues checkExpression(Expression expression, JDDNode jDDNode) throws PrismException {
        StateValues stateValues;
        if (expression instanceof ExpressionITE) {
            stateValues = this.checkExpressionITE((ExpressionITE)expression, jDDNode);
        } else if (expression instanceof ExpressionBinaryOp) {
            stateValues = this.checkExpressionBinaryOp((ExpressionBinaryOp)expression, jDDNode);
        } else if (expression instanceof ExpressionUnaryOp) {
            stateValues = this.checkExpressionUnaryOp((ExpressionUnaryOp)expression, jDDNode);
        } else if (expression instanceof ExpressionFunc) {
            stateValues = this.checkExpressionFunc((ExpressionFunc)expression, jDDNode);
        } else {
            if (expression instanceof ExpressionIdent) {
                throw new PrismException("Unknown identifier \"" + ((ExpressionIdent)expression).getName() + "\"");
            }
            if (expression instanceof ExpressionLiteral) {
                stateValues = this.checkExpressionLiteral((ExpressionLiteral)expression, jDDNode);
            } else if (expression instanceof ExpressionConstant) {
                stateValues = this.checkExpressionConstant((ExpressionConstant)expression, jDDNode);
            } else {
                if (expression instanceof ExpressionFormula) {
                    if (((ExpressionFormula)expression).getDefinition() != null) {
                        return this.checkExpression(((ExpressionFormula)expression).getDefinition(), jDDNode);
                    }
                    throw new PrismException("Unexpanded formula \"" + ((ExpressionFormula)expression).getName() + "\"");
                }
                if (expression instanceof ExpressionVar) {
                    stateValues = this.checkExpressionVar((ExpressionVar)expression, jDDNode);
                } else if (expression instanceof ExpressionLabel) {
                    stateValues = this.checkExpressionLabel((ExpressionLabel)expression, jDDNode);
                } else if (expression instanceof ExpressionProp) {
                    stateValues = this.checkExpressionProp((ExpressionProp)expression, jDDNode);
                } else if (expression instanceof ExpressionFilter) {
                    stateValues = this.checkExpressionFilter((ExpressionFilter)expression, jDDNode);
                } else {
                    JDD.Deref(jDDNode);
                    throw new PrismException("Couldn't check " + String.valueOf(expression.getClass()));
                }
            }
        }
        if (stateValues instanceof StateValuesMTBDD && this.reach != null) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    @Override
    public JDDNode checkExpressionDD(Expression expression, JDDNode jDDNode) throws PrismException {
        StateValuesMTBDD stateValuesMTBDD = this.checkExpression(expression, jDDNode).convertToStateValuesMTBDD();
        JDDNode jDDNode2 = stateValuesMTBDD.getJDDNode().copy();
        stateValuesMTBDD.clear();
        return jDDNode2;
    }

    protected StateValues checkExpressionITE(ExpressionITE expressionITE, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        StateValues stateValues3 = null;
        try {
            stateValues = this.checkExpression(expressionITE.getOperand1(), jDDNode.copy());
            stateValues2 = this.checkExpression(expressionITE.getOperand2(), jDDNode.copy());
            stateValues3 = this.checkExpression(expressionITE.getOperand3(), jDDNode.copy());
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            if (stateValues2 != null) {
                stateValues2.clear();
            }
            throw prismException;
        }
        finally {
            JDD.Deref(jDDNode);
        }
        JDDNode jDDNode2 = stateValues.convertToStateValuesMTBDD().getJDDNode();
        if (stateValues2 instanceof StateValuesMTBDD && stateValues3 instanceof StateValuesMTBDD) {
            JDDNode jDDNode3 = ((StateValuesMTBDD)stateValues2).getJDDNode();
            JDDNode jDDNode4 = ((StateValuesMTBDD)stateValues3).getJDDNode();
            JDDNode jDDNode5 = JDD.ITE(jDDNode2, jDDNode3, jDDNode4);
            return new StateValuesMTBDD(jDDNode5, this.model);
        }
        DoubleVector doubleVector = stateValues2.convertToStateValuesDV().getDoubleVector();
        doubleVector.filter(jDDNode2, this.allDDRowVars, this.odd);
        DoubleVector doubleVector2 = stateValues3.convertToStateValuesDV().getDoubleVector();
        jDDNode2 = JDD.Not(jDDNode2);
        doubleVector2.filter(jDDNode2, this.allDDRowVars, this.odd);
        doubleVector.add(doubleVector2);
        doubleVector2.clear();
        JDD.Deref(jDDNode2);
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionBinaryOp(ExpressionBinaryOp expressionBinaryOp, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n = expressionBinaryOp.getOperator();
        if (n >= 5 && n <= 10) {
            return this.checkExpressionRelOp(n, expressionBinaryOp.getOperand1(), expressionBinaryOp.getOperand2(), jDDNode);
        }
        try {
            stateValues = this.checkExpression(expressionBinaryOp.getOperand1(), jDDNode.copy());
            stateValues2 = this.checkExpression(expressionBinaryOp.getOperand2(), jDDNode.copy());
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        finally {
            JDD.Deref(jDDNode);
        }
        if (stateValues instanceof StateValuesMTBDD && stateValues2 instanceof StateValuesMTBDD) {
            JDDNode jDDNode2;
            JDDNode jDDNode3 = ((StateValuesMTBDD)stateValues).getJDDNode();
            JDDNode jDDNode4 = ((StateValuesMTBDD)stateValues2).getJDDNode();
            switch (n) {
                case 1: {
                    jDDNode2 = JDD.Or(JDD.Not(jDDNode3), jDDNode4);
                    break;
                }
                case 2: {
                    jDDNode2 = JDD.Not(JDD.Xor(jDDNode3, jDDNode4));
                    break;
                }
                case 3: {
                    jDDNode2 = JDD.Or(jDDNode3, jDDNode4);
                    break;
                }
                case 4: {
                    jDDNode2 = JDD.And(jDDNode3, jDDNode4);
                    break;
                }
                case 11: {
                    jDDNode2 = JDD.Apply(1, jDDNode3, jDDNode4);
                    break;
                }
                case 12: {
                    jDDNode2 = JDD.Apply(2, jDDNode3, jDDNode4);
                    break;
                }
                case 13: {
                    jDDNode2 = JDD.Apply(3, jDDNode3, jDDNode4);
                    break;
                }
                case 14: {
                    jDDNode2 = JDD.Apply(4, jDDNode3, jDDNode4);
                    break;
                }
                case 15: {
                    JDD.Ref(jDDNode3);
                    JDD.Ref(jDDNode4);
                    jDDNode2 = JDD.Apply(15, jDDNode3, jDDNode4);
                    if (expressionBinaryOp.getType() instanceof TypeInt) {
                        JDD.Ref(jDDNode4);
                        jDDNode2 = JDD.ITE(JDD.LessThan(jDDNode4, 0.0), JDD.Constant(Double.NaN), jDDNode2);
                        JDD.Ref(jDDNode2);
                        jDDNode2 = JDD.ITE(JDD.GreaterThan(jDDNode2, 2.147483647E9), JDD.Constant(Double.NaN), jDDNode2);
                    }
                    JDD.Deref(jDDNode3);
                    JDD.Deref(jDDNode4);
                    break;
                }
                default: {
                    throw new PrismException("Unknown binary operator");
                }
            }
            return new StateValuesMTBDD(jDDNode2, this.model);
        }
        DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
        DoubleVector doubleVector2 = stateValues2.convertToStateValuesDV().getDoubleVector();
        int n2 = doubleVector.getSize();
        switch (n) {
            case 1: 
            case 3: 
            case 4: {
                throw new PrismException("Internal error: Explicit evaluation of Boolean");
            }
            case 11: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, doubleVector.getElement(i) + doubleVector2.getElement(i));
                }
                break;
            }
            case 12: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, doubleVector.getElement(i) - doubleVector2.getElement(i));
                }
                break;
            }
            case 13: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, doubleVector.getElement(i) * doubleVector2.getElement(i));
                }
                break;
            }
            case 14: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, doubleVector.getElement(i) / doubleVector2.getElement(i));
                }
                break;
            }
            case 15: {
                if (expressionBinaryOp.getType() instanceof TypeInt) {
                    for (int i = 0; i < n2; ++i) {
                        double d = doubleVector.getElement(i);
                        double d2 = doubleVector2.getElement(i);
                        double d3 = Math.pow(d, d2);
                        doubleVector.setElement(i, d2 < 0.0 || d3 > 2.147483647E9 ? Double.NaN : d3);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        doubleVector.setElement(i, Math.pow(doubleVector.getElement(i), doubleVector2.getElement(i)));
                    }
                }
                break;
            }
            default: {
                throw new PrismException("Unknown binary operator");
            }
        }
        doubleVector2.clear();
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionRelOp(int n, Expression expression, Expression expression2, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        if (expression instanceof ExpressionVar && expression2.isConstant() && expression2.getType() instanceof TypeInt) {
            JDD.Deref(jDDNode);
            ExpressionVar expressionVar = (ExpressionVar)expression;
            Expression expression3 = expression2;
            String string = expressionVar.getName();
            int n2 = this.varList.getIndex(string);
            if (n2 == -1) {
                throw new PrismLangException("Unknown variable \"" + expressionVar.getName() + "\" (no index information)", expressionVar);
            }
            int n3 = this.varList.getLow(n2);
            int n4 = this.varList.getHigh(n2);
            JDDNode jDDNode3 = JDD.Constant(0.0);
            int n5 = expression3.evaluateInt(this.constantValues);
            switch (n) {
                case 5: {
                    if (n5 < n3 || n5 > n4) break;
                    jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n2], n5 - n3, 1.0);
                    break;
                }
                case 6: {
                    if (n5 >= n3 && n5 <= n4) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n2], n5 - n3, 1.0);
                    }
                    jDDNode3 = JDD.Not(jDDNode3);
                    break;
                }
                case 7: {
                    for (int i = n5 + 1; i <= n4; ++i) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n2], i - n3, 1.0);
                    }
                    break;
                }
                case 8: {
                    for (int i = n5; i <= n4; ++i) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n2], i - n3, 1.0);
                    }
                    break;
                }
                case 9: {
                    for (int i = n5 - 1; i >= n3; --i) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n2], i - n3, 1.0);
                    }
                    break;
                }
                case 10: {
                    for (int i = n5; i >= n3; --i) {
                        jDDNode3 = JDD.SetVectorElement(jDDNode3, this.varDDRowVars[n2], i - n3, 1.0);
                    }
                    break;
                }
                default: {
                    throw new PrismException("Unknown relational operator");
                }
            }
            return new StateValuesMTBDD(jDDNode3, this.model);
        }
        if (expression.isConstant() && expression.getType() instanceof TypeInt && expression2 instanceof ExpressionVar) {
            JDD.Deref(jDDNode);
            Expression expression4 = expression;
            ExpressionVar expressionVar = (ExpressionVar)expression2;
            String string = expressionVar.getName();
            int n6 = this.varList.getIndex(string);
            if (n6 == -1) {
                throw new PrismLangException("Unknown variable \"" + expressionVar.getName() + "\" (no index information)", expressionVar);
            }
            int n7 = this.varList.getLow(n6);
            int n8 = this.varList.getHigh(n6);
            JDDNode jDDNode4 = JDD.Constant(0.0);
            int n9 = expression4.evaluateInt(this.constantValues);
            switch (n) {
                case 5: {
                    if (n9 < n7 || n9 > n8) break;
                    jDDNode4 = JDD.SetVectorElement(jDDNode4, this.varDDRowVars[n6], n9 - n7, 1.0);
                    break;
                }
                case 6: {
                    if (n9 >= n7 && n9 <= n8) {
                        jDDNode4 = JDD.SetVectorElement(jDDNode4, this.varDDRowVars[n6], n9 - n7, 1.0);
                    }
                    jDDNode4 = JDD.Not(jDDNode4);
                    break;
                }
                case 7: {
                    for (int i = n9 - 1; i >= n7; --i) {
                        jDDNode4 = JDD.SetVectorElement(jDDNode4, this.varDDRowVars[n6], i - n7, 1.0);
                    }
                    break;
                }
                case 8: {
                    for (int i = n9; i >= n7; --i) {
                        jDDNode4 = JDD.SetVectorElement(jDDNode4, this.varDDRowVars[n6], i - n7, 1.0);
                    }
                    break;
                }
                case 9: {
                    for (int i = n9 + 1; i <= n8; ++i) {
                        jDDNode4 = JDD.SetVectorElement(jDDNode4, this.varDDRowVars[n6], i - n7, 1.0);
                    }
                    break;
                }
                case 10: {
                    for (int i = n9; i <= n8; ++i) {
                        jDDNode4 = JDD.SetVectorElement(jDDNode4, this.varDDRowVars[n6], i - n7, 1.0);
                    }
                    break;
                }
                default: {
                    throw new PrismException("Unknown relational operator");
                }
            }
            return new StateValuesMTBDD(jDDNode4, this.model);
        }
        try {
            stateValues = this.checkExpression(expression, jDDNode.copy());
            stateValues2 = this.checkExpression(expression2, jDDNode.copy());
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        finally {
            JDD.Deref(jDDNode);
        }
        JDDNode jDDNode5 = stateValues.convertToStateValuesMTBDD().getJDDNode();
        JDDNode jDDNode6 = stateValues2.convertToStateValuesMTBDD().getJDDNode();
        switch (n) {
            case 5: {
                jDDNode2 = JDD.Apply(7, jDDNode5, jDDNode6);
                break;
            }
            case 6: {
                jDDNode2 = JDD.Apply(8, jDDNode5, jDDNode6);
                break;
            }
            case 7: {
                jDDNode2 = JDD.Apply(9, jDDNode5, jDDNode6);
                break;
            }
            case 8: {
                jDDNode2 = JDD.Apply(10, jDDNode5, jDDNode6);
                break;
            }
            case 9: {
                jDDNode2 = JDD.Apply(11, jDDNode5, jDDNode6);
                break;
            }
            case 10: {
                jDDNode2 = JDD.Apply(12, jDDNode5, jDDNode6);
                break;
            }
            default: {
                throw new PrismException("Unknown relational operator");
            }
        }
        return new StateValuesMTBDD(jDDNode2, this.model);
    }

    protected StateValues checkExpressionUnaryOp(ExpressionUnaryOp expressionUnaryOp, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        int n = expressionUnaryOp.getOperator();
        stateValues = this.checkExpression(expressionUnaryOp.getOperand(), jDDNode);
        if (n == 3) {
            return stateValues;
        }
        if (stateValues instanceof StateValuesMTBDD) {
            JDDNode jDDNode2;
            JDDNode jDDNode3 = ((StateValuesMTBDD)stateValues).getJDDNode();
            switch (n) {
                case 1: {
                    jDDNode2 = JDD.Not(jDDNode3);
                    break;
                }
                case 2: {
                    jDDNode2 = JDD.Apply(2, JDD.Constant(0.0), jDDNode3);
                    break;
                }
                default: {
                    throw new PrismException("Unknown unary operator");
                }
            }
            return new StateValuesMTBDD(jDDNode2, this.model);
        }
        DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
        int n2 = doubleVector.getSize();
        switch (n) {
            case 1: {
                throw new PrismException("Internal error: Explicit evaluation of Boolean");
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, -doubleVector.getElement(i));
                }
                break;
            }
            default: {
                throw new PrismException("Unknown unary operator");
            }
        }
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionFunc(ExpressionFunc expressionFunc, JDDNode jDDNode) throws PrismException {
        switch (expressionFunc.getNameCode()) {
            case 0: 
            case 1: {
                return this.checkExpressionFuncNary(expressionFunc, jDDNode);
            }
            case 2: 
            case 3: 
            case 4: {
                return this.checkExpressionFuncUnary(expressionFunc, jDDNode);
            }
            case 5: 
            case 6: 
            case 7: {
                return this.checkExpressionFuncBinary(expressionFunc, jDDNode);
            }
            case 8: {
                JDD.Deref(jDDNode);
                throw new PrismException("Multi-objective model checking is not supported for " + String.valueOf((Object)this.model.getModelType()) + "s");
            }
        }
        JDD.Deref(jDDNode);
        throw new PrismException("Unrecognised function \"" + expressionFunc.getName() + "\"");
    }

    protected StateValues checkExpressionFuncUnary(ExpressionFunc expressionFunc, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        int n = expressionFunc.getNameCode();
        stateValues = this.checkExpression(expressionFunc.getOperand(0), jDDNode);
        if (stateValues instanceof StateValuesMTBDD) {
            JDDNode jDDNode2 = ((StateValuesMTBDD)stateValues).getJDDNode();
            switch (n) {
                case 2: {
                    jDDNode2 = JDD.MonadicApply(13, jDDNode2);
                    break;
                }
                case 3: {
                    jDDNode2 = JDD.MonadicApply(14, jDDNode2);
                    break;
                }
                case 4: {
                    jDDNode2 = JDD.MonadicApply(13, JDD.Plus(jDDNode2, JDD.Constant(0.5)));
                }
            }
            return new StateValuesMTBDD(jDDNode2, this.model);
        }
        DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
        int n2 = doubleVector.getSize();
        switch (n) {
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, Math.floor(doubleVector.getElement(i)));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, Math.ceil(doubleVector.getElement(i)));
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, Math.round(doubleVector.getElement(i)));
                }
                break;
            }
        }
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionFuncBinary(ExpressionFunc expressionFunc, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        JDDNode jDDNode2 = null;
        int n = expressionFunc.getNameCode();
        double d = 0.0;
        try {
            stateValues = this.checkExpression(expressionFunc.getOperand(0), jDDNode.copy());
            stateValues2 = this.checkExpression(expressionFunc.getOperand(1), jDDNode.copy());
        }
        catch (PrismException prismException) {
            if (stateValues != null) {
                stateValues.clear();
            }
            throw prismException;
        }
        finally {
            JDD.Deref(jDDNode);
        }
        if (stateValues instanceof StateValuesMTBDD && stateValues2 instanceof StateValuesMTBDD) {
            JDDNode jDDNode3 = ((StateValuesMTBDD)stateValues).getJDDNode();
            JDDNode jDDNode4 = ((StateValuesMTBDD)stateValues2).getJDDNode();
            switch (n) {
                case 5: {
                    JDD.Ref(jDDNode3);
                    JDD.Ref(jDDNode4);
                    jDDNode2 = JDD.Apply(15, jDDNode3, jDDNode4);
                    if (expressionFunc.getType() instanceof TypeInt) {
                        JDD.Ref(jDDNode4);
                        jDDNode2 = JDD.ITE(JDD.LessThan(jDDNode4, 0.0), JDD.Constant(Double.NaN), jDDNode2);
                        JDD.Ref(jDDNode2);
                        jDDNode2 = JDD.ITE(JDD.GreaterThan(jDDNode2, 2.147483647E9), JDD.Constant(Double.NaN), jDDNode2);
                    }
                    JDD.Deref(jDDNode3);
                    JDD.Deref(jDDNode4);
                    break;
                }
                case 6: {
                    jDDNode2 = JDD.Apply(16, jDDNode3, jDDNode4);
                    break;
                }
                case 7: {
                    jDDNode2 = JDD.Apply(17, jDDNode3, jDDNode4);
                }
            }
            return new StateValuesMTBDD(jDDNode2, this.model);
        }
        DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
        DoubleVector doubleVector2 = stateValues2.convertToStateValuesDV().getDoubleVector();
        int n2 = doubleVector.getSize();
        switch (n) {
            case 5: {
                if (expressionFunc.getType() instanceof TypeInt) {
                    for (int i = 0; i < n2; ++i) {
                        double d2 = doubleVector.getElement(i);
                        double d3 = doubleVector2.getElement(i);
                        double d4 = Math.pow(d2, d3);
                        doubleVector.setElement(i, d3 < 0.0 || d4 > 2.147483647E9 ? Double.NaN : d4);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        doubleVector.setElement(i, Math.pow(doubleVector.getElement(i), doubleVector2.getElement(i)));
                    }
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n2; ++i) {
                    double d5 = (int)doubleVector2.getElement(i);
                    d = d5 <= 0.0 ? Double.NaN : (double)((int)doubleVector.getElement(i) % (int)d5);
                    doubleVector.setElement(i, d < 0.0 ? d + d5 : d);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < n2; ++i) {
                    doubleVector.setElement(i, PrismUtils.log(doubleVector.getElement(i), doubleVector2.getElement(i)));
                }
                break;
            }
        }
        doubleVector2.clear();
        return new StateValuesDV(doubleVector, this.model);
    }

    protected StateValues checkExpressionFuncNary(ExpressionFunc expressionFunc, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        int n = expressionFunc.getNameCode();
        stateValues = this.checkExpression(expressionFunc.getOperand(0), jDDNode.copy());
        int n2 = expressionFunc.getNumOperands();
        boolean bl = stateValues instanceof StateValuesMTBDD;
        for (int i = 1; i < n2; ++i) {
            try {
                stateValues2 = this.checkExpression(expressionFunc.getOperand(i), jDDNode.copy());
            }
            catch (PrismException prismException) {
                if (stateValues2 != null) {
                    stateValues2.clear();
                }
                JDD.Deref(jDDNode);
                throw prismException;
            }
            if (!bl || !(stateValues2 instanceof StateValuesMTBDD)) {
                bl = false;
                DoubleVector doubleVector = stateValues.convertToStateValuesDV().getDoubleVector();
                DoubleVector doubleVector2 = stateValues2.convertToStateValuesDV().getDoubleVector();
                int n3 = doubleVector.getSize();
                switch (n) {
                    case 0: {
                        int n4;
                        for (n4 = 0; n4 < n3; ++n4) {
                            doubleVector.setElement(n4, Math.min(doubleVector.getElement(i), doubleVector2.getElement(i)));
                        }
                        break;
                    }
                    case 1: {
                        int n4;
                        for (n4 = 0; n4 < n3; ++n4) {
                            doubleVector.setElement(n4, Math.max(doubleVector.getElement(i), doubleVector2.getElement(i)));
                        }
                        break;
                    }
                }
                doubleVector2.clear();
                stateValues = new StateValuesDV(doubleVector, this.model);
                continue;
            }
            JDDNode jDDNode2 = ((StateValuesMTBDD)stateValues).getJDDNode();
            JDDNode jDDNode3 = ((StateValuesMTBDD)stateValues2).getJDDNode();
            switch (n) {
                case 0: {
                    jDDNode2 = JDD.Apply(5, jDDNode2, jDDNode3);
                    break;
                }
                case 1: {
                    jDDNode2 = JDD.Apply(6, jDDNode2, jDDNode3);
                }
            }
            stateValues = new StateValuesMTBDD(jDDNode2, this.model);
        }
        JDD.Deref(jDDNode);
        return stateValues;
    }

    protected StateValues checkExpressionLiteral(ExpressionLiteral expressionLiteral, JDDNode jDDNode) throws PrismException {
        JDD.Deref(jDDNode);
        double d = StateModelChecker.encodeToDouble(expressionLiteral.getType(), expressionLiteral.evaluate());
        return new StateValuesMTBDD(JDD.Constant(d), this.model);
    }

    protected StateValues checkExpressionConstant(ExpressionConstant expressionConstant, JDDNode jDDNode) throws PrismException {
        JDD.Deref(jDDNode);
        double d = StateModelChecker.encodeToDouble(expressionConstant.getType(), expressionConstant.evaluate(this.constantValues));
        return new StateValuesMTBDD(JDD.Constant(d), this.model);
    }

    protected StateValues checkExpressionVar(ExpressionVar expressionVar, JDDNode jDDNode) throws PrismException {
        JDD.Deref(jDDNode);
        String string = expressionVar.getName();
        int n = this.varList.getIndex(string);
        if (n == -1) {
            throw new PrismLangException("Unknown variable \"" + expressionVar.getName() + "\"", expressionVar);
        }
        int n2 = this.varList.getLow(n);
        int n3 = this.varList.getHigh(n);
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (int i = n2; i <= n3; ++i) {
            jDDNode2 = JDD.SetVectorElement(jDDNode2, this.varDDRowVars[n], i - n2, i);
        }
        return new StateValuesMTBDD(jDDNode2, this.model);
    }

    protected StateValues checkExpressionLabel(ExpressionLabel expressionLabel, JDDNode jDDNode) throws PrismException {
        if (expressionLabel.isDeadlockLabel()) {
            JDD.Deref(jDDNode);
            JDDNode jDDNode2 = this.model.getDeadlocks();
            JDD.Ref(jDDNode2);
            return new StateValuesMTBDD(jDDNode2, this.model);
        }
        if (expressionLabel.isInitLabel()) {
            JDD.Deref(jDDNode);
            JDDNode jDDNode3 = this.start;
            JDD.Ref(jDDNode3);
            return new StateValuesMTBDD(jDDNode3, this.model);
        }
        if (this.model.hasLabelDD(expressionLabel.getName())) {
            JDD.Deref(jDDNode);
            JDDNode jDDNode4 = this.model.getLabelDD(expressionLabel.getName());
            return new StateValuesMTBDD(jDDNode4.copy(), this.model);
        }
        LabelList labelList = this.getLabelList();
        int n = -1;
        if (labelList != null) {
            n = labelList.getLabelIndex(expressionLabel.getName());
        }
        if (n == -1) {
            throw new PrismException("Unknown label \"" + expressionLabel.getName() + "\" in property");
        }
        return this.checkExpression(labelList.getLabel(n), jDDNode);
    }

    protected StateValues checkExpressionProp(ExpressionProp expressionProp, JDDNode jDDNode) throws PrismException {
        Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
        if (property != null) {
            this.mainLog.println("\nModel checking : " + String.valueOf(property));
            return this.checkExpression(property.getExpression(), jDDNode);
        }
        JDD.Deref(jDDNode);
        throw new PrismException("Unknown property reference " + String.valueOf(expressionProp));
    }

    protected StateValues checkExpressionFilter(ExpressionFilter expressionFilter, JDDNode jDDNode) throws PrismException {
        StateListMTBDD stateListMTBDD;
        boolean bl;
        Expression expression = expressionFilter.getFilter();
        if (expression == null) {
            expression = Expression.True();
        }
        String string = (bl = Expression.isTrue(expression)) ? "all states" : "states satisfying filter";
        JDDNode jDDNode2 = this.checkExpressionDD(expression, this.model.getReach().copy());
        StateListMTBDD stateListMTBDD2 = new StateListMTBDD(jDDNode2, this.model);
        if (jDDNode2.equals(JDD.ZERO)) {
            throw new PrismException("Filter satisfies no states");
        }
        boolean bl2 = expression instanceof ExpressionLabel && ((ExpressionLabel)expression).isInitLabel();
        boolean bl3 = bl2 & this.model.getNumInitialStates() == 1;
        ExpressionFilter.FilterOperator filterOperator = expressionFilter.getOperatorType();
        if (filterOperator == ExpressionFilter.FilterOperator.STATE && ODDUtils.hasIntValue(this.odd)) {
            if (stateListMTBDD2.size() != 1) {
                Object object = "Filter should be satisfied in exactly 1 state";
                object = (String)object + " (but \"" + String.valueOf(expression) + "\" is true in " + stateListMTBDD2.size() + " states)";
                throw new PrismException((String)object);
            }
            this.currentFilter = new Filter(Filter.FilterOperator.STATE, ODDUtils.GetIndexOfFirstFromDD(jDDNode2, this.odd, this.allDDRowVars));
        } else {
            this.currentFilter = filterOperator == ExpressionFilter.FilterOperator.FORALL && bl2 && bl3 && ODDUtils.hasIntValue(this.odd) ? new Filter(Filter.FilterOperator.STATE, ODDUtils.GetIndexOfFirstFromDD(jDDNode2, this.odd, this.allDDRowVars)) : (filterOperator == ExpressionFilter.FilterOperator.FIRST && bl2 && bl3 && ODDUtils.hasIntValue(this.odd) ? new Filter(Filter.FilterOperator.STATE, ODDUtils.GetIndexOfFirstFromDD(jDDNode2, this.odd, this.allDDRowVars)) : null);
        }
        StateValues stateValues = null;
        try {
            stateValues = this.checkExpression(expressionFilter.getOperand(), jDDNode2.copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode2);
            JDD.Deref(jDDNode);
            throw prismException;
        }
        if (!bl2 && !expressionFilter.isInvisible()) {
            this.mainLog.println("\nStates satisfying filter " + String.valueOf(expression) + ": " + stateListMTBDD2.sizeString());
        }
        filterOperator = expressionFilter.getOperatorType();
        StateValues stateValues2 = null;
        JDDNode jDDNode3 = null;
        JDDNode jDDNode4 = null;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl4 = false;
        Object object = null;
        Object object2 = null;
        Accuracy accuracy = null;
        switch (filterOperator) {
            case PRINT: 
            case PRINTALL: {
                if (expressionFilter.getType() instanceof TypeBool) {
                    this.mainLog.print("\nSatisfying states");
                    this.mainLog.println((String)(bl ? ":" : " that are also in filter " + String.valueOf(expression) + ":"));
                    jDDNode4 = stateValues.deepCopy().convertToStateValuesMTBDD().getJDDNode();
                    JDD.Ref(jDDNode2);
                    jDDNode4 = JDD.And(jDDNode4, jDDNode2);
                    new StateListMTBDD(jDDNode4, this.model).print(this.mainLog);
                    JDD.Deref(jDDNode4);
                } else if (filterOperator == ExpressionFilter.FilterOperator.PRINT) {
                    this.mainLog.println("\nResults (non-zero only) for filter " + String.valueOf(expression) + ":");
                    stateValues.printFiltered(this.mainLog, jDDNode2);
                } else {
                    this.mainLog.println("\nResults (including zeros) for filter " + String.valueOf(expression) + ":");
                    stateValues.printFiltered(this.mainLog, jDDNode2, false, false, true);
                }
                stateValues2 = stateValues;
                stateValues = null;
                break;
            }
            case STORE: {
                stateValues2 = stateValues;
                stateValues = null;
                break;
            }
            case MIN: {
                d = stateValues.minOverBDD(jDDNode2);
                object2 = StateModelChecker.decodeFromDouble(expressionFilter.getType(), d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                object = "Minimum value over " + string;
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                jDDNode3 = stateValues.getBDDFromCloseValue(d);
                JDD.Ref(jDDNode2);
                jDDNode3 = JDD.And(jDDNode3, jDDNode2);
                break;
            }
            case MAX: {
                d = stateValues.maxOverBDD(jDDNode2);
                object2 = StateModelChecker.decodeFromDouble(expressionFilter.getType(), d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                object = "Maximum value over " + string;
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                jDDNode3 = stateValues.getBDDFromCloseValue(d);
                JDD.Ref(jDDNode2);
                jDDNode3 = JDD.And(jDDNode3, jDDNode2);
                break;
            }
            case ARGMIN: {
                d = stateValues.minOverBDD(jDDNode2);
                this.mainLog.print("\nMinimum value over " + string + ": ");
                this.mainLog.println(StateModelChecker.decodeFromDouble(expressionFilter.getType(), d));
                jDDNode3 = stateValues.getBDDFromCloseValue(d);
                JDD.Ref(jDDNode2);
                jDDNode3 = JDD.And(jDDNode3, jDDNode2);
                stateValues2 = new StateValuesMTBDD(jDDNode3, this.model);
                this.mainLog.println("\nNumber of states with minimum value: " + stateValues2.getNNZString());
                jDDNode3 = null;
                break;
            }
            case ARGMAX: {
                d = stateValues.maxOverBDD(jDDNode2);
                this.mainLog.print("\nMaximum value over " + string + ": ");
                this.mainLog.println(StateModelChecker.decodeFromDouble(expressionFilter.getType(), d));
                jDDNode3 = stateValues.getBDDFromCloseValue(d);
                JDD.Ref(jDDNode2);
                jDDNode3 = JDD.And(jDDNode3, jDDNode2);
                stateValues2 = new StateValuesMTBDD(jDDNode3, this.model);
                this.mainLog.println("\nNumber of states with maximum value: " + stateValues2.getNNZString());
                jDDNode3 = null;
                break;
            }
            case COUNT: {
                stateValues.filter(jDDNode2);
                d = stateValues.getNNZ();
                object2 = (int)d;
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                object = bl ? "Count of satisfying states" : "Count of satisfying states also in filter";
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case SUM: {
                d = stateValues.sumOverBDD(jDDNode2);
                object2 = StateModelChecker.decodeFromDouble(expressionFilter.getType(), d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                object = "Sum over " + string;
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case AVG: {
                d = stateValues.sumOverBDD(jDDNode2) / JDD.GetNumMinterms(jDDNode2, this.allDDRowVars.n());
                object2 = d;
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                object = "Average over " + string;
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case FIRST: {
                d = stateValues.firstFromBDD(jDDNode2);
                object2 = StateModelChecker.decodeFromDouble(expressionFilter.getType(), d);
                stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                object = "Value in ";
                object = bl2 ? (String)object + (bl3 ? "the initial state" : "first initial state") : (String)object + (bl ? "the first state" : "first state satisfying filter");
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case RANGE: {
                d = stateValues.minOverBDD(jDDNode2);
                d2 = stateValues.maxOverBDD(jDDNode2);
                object2 = expressionFilter.getOperand().getType() instanceof TypeInt ? new Interval((int)d, (int)d2) : new Interval(d, d2);
                stateValues2 = stateValues;
                stateValues = null;
                object = "Range of values over ";
                object = (String)object + (bl2 ? "initial states" : string);
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            case FORALL: {
                jDDNode4 = stateValues.convertToStateValuesMTBDD().getJDDNode();
                JDD.Ref(jDDNode2);
                jDDNode4 = JDD.And(jDDNode4, jDDNode2);
                stateListMTBDD = new StateListMTBDD(jDDNode4, this.model);
                bl4 = jDDNode4.equals(jDDNode2);
                object2 = bl4;
                stateValues2 = new StateValuesMTBDD(JDD.Constant(bl4 ? 1.0 : 0.0), this.model);
                stateValues = null;
                object = "Property " + (bl4 ? "" : "not ") + "satisfied in ";
                this.mainLog.print("\nProperty satisfied in " + stateListMTBDD.sizeString());
                if (bl2) {
                    object = bl3 ? (String)object + "the initial state" : (String)object + "all initial states";
                    this.mainLog.println(" of " + this.model.getNumInitialStatesString() + " initial states.");
                } else if (bl) {
                    object = (String)object + "all states";
                    this.mainLog.println(" of all " + this.model.getNumStatesString() + " states.");
                } else {
                    object = (String)object + "all filter states";
                    this.mainLog.println(" of " + stateListMTBDD2.sizeString() + " filter states.");
                }
                JDD.Deref(jDDNode4);
                break;
            }
            case EXISTS: {
                jDDNode4 = stateValues.convertToStateValuesMTBDD().getJDDNode();
                JDD.Ref(jDDNode2);
                jDDNode4 = JDD.And(jDDNode4, jDDNode2);
                bl4 = !jDDNode4.equals(JDD.ZERO);
                object2 = bl4;
                stateValues2 = new StateValuesMTBDD(JDD.Constant(bl4 ? 1.0 : 0.0), this.model);
                stateValues = null;
                object = "Property satisfied in ";
                object = bl ? (String)object + (bl4 ? "at least one state" : "no states") : (String)object + (bl4 ? "at least one filter state" : "no filter states");
                this.mainLog.println("\n" + (String)object);
                JDD.Deref(jDDNode4);
                break;
            }
            case STATE: {
                if (expressionFilter.getType() instanceof TypeVoid) {
                    object2 = ((StateValuesVoid)stateValues).getValue();
                    stateValues2 = stateValues;
                    stateValues = null;
                } else {
                    d = stateValues.firstFromBDD(jDDNode2);
                    object2 = StateModelChecker.decodeFromDouble(expressionFilter.getType(), d);
                    accuracy = stateValues.getAccuracy();
                    stateValues2 = new StateValuesMTBDD(JDD.Constant(d), this.model);
                }
                object = "Value in ";
                object = bl2 ? (String)object + "the initial state" : (String)object + "the filter state";
                this.mainLog.println("\n" + (String)object + ": " + String.valueOf(object2));
                break;
            }
            default: {
                JDD.Deref(jDDNode2);
                throw new PrismException("Unrecognised filter type \"" + expressionFilter.getOperatorName() + "\"");
            }
        }
        if (jDDNode3 != null) {
            stateListMTBDD = new StateListMTBDD(jDDNode3, this.model);
            this.mainLog.print("\nThere are " + stateListMTBDD.sizeString() + " states with ");
            this.mainLog.print((expressionFilter.getType() instanceof TypeDouble ? "(approximately) " : "") + "this value");
            if (!(this.verbose || stateListMTBDD.size() != -1 && stateListMTBDD.size() <= 10)) {
                this.mainLog.print(".\nThe first 10 states are displayed below. To view them all, enable verbose mode or use a print filter.\n");
                stateListMTBDD.print(this.mainLog, 10);
            } else {
                this.mainLog.print(":\n");
                stateListMTBDD.print(this.mainLog);
            }
            JDD.Deref(jDDNode3);
        }
        this.result.setResult(object2);
        this.result.setAccuracy(accuracy);
        if (expressionFilter.getExplanationEnabled() && object != null) {
            this.result.setExplanation(((String)object).toLowerCase());
        } else {
            this.result.setExplanation(null);
        }
        if (filterOperator == ExpressionFilter.FilterOperator.STORE) {
            this.result.setVector(stateValues2);
        }
        if (stateValues != null && !Expression.isFilter(expressionFilter.getOperand(), ExpressionFilter.FilterOperator.STORE)) {
            stateValues.clear();
        }
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
        return stateValues2;
    }

    public static double encodeToDouble(Type type, Object object) throws PrismException {
        if (type instanceof TypeInt) {
            return ((TypeInt)type).castValueTo(object).intValue();
        }
        if (type instanceof TypeDouble) {
            return ((TypeDouble)type).castValueTo(object).doubleValue();
        }
        if (type instanceof TypeBool) {
            return ((TypeBool)type).castValueTo(object) != false ? 1.0 : 0.0;
        }
        throw new PrismException("Could not encode type " + String.valueOf(type) + " into an MTBDD");
    }

    public static Object decodeFromDouble(Type type, double d) {
        if (type instanceof TypeInt) {
            return (int)d;
        }
        if (type instanceof TypeDouble) {
            return d;
        }
        if (type instanceof TypeBool) {
            return d > 0.0;
        }
        return null;
    }

    public Expression handleMaximalStateFormulas(Expression expression) throws PrismException {
        if (!(this.model instanceof ModelSymbolic)) {
            throw new PrismNotSupportedException("Need ModelSymbolic for LTL checking in this instance");
        }
        Vector<JDDNode> vector = new Vector<JDDNode>();
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        Expression expression2 = lTLModelChecker.checkMaximalStateFormulas(this, this.model, expression.deepCopy(), vector);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < vector.size(); ++i) {
            String string = "L" + i;
            String string2 = ((ModelSymbolic)this.model).addUniqueLabelDD("phi", vector.get(i), this.getDefinedLabelNames());
            hashMap.put(string, string2);
        }
        return (Expression)expression2.accept(new ReplaceLabels(hashMap));
    }

    public JDDNode getStateRewardsByIndexObject(Object object, Model model, Values values) throws PrismException {
        JDDNode jDDNode = null;
        if (model.getNumRewardStructs() == 0) {
            throw new PrismException("Model has no rewards specified");
        }
        if (object == null) {
            jDDNode = model.getStateRewards(0);
        } else if (object instanceof Expression) {
            int n = ((Expression)object).evaluateInt(values);
            object = n;
            jDDNode = model.getStateRewards(n - 1);
        } else if (object instanceof String) {
            jDDNode = model.getStateRewards((String)object);
        }
        if (jDDNode == null) {
            throw new PrismException("Invalid reward structure index \"" + String.valueOf(object) + "\"");
        }
        return jDDNode;
    }

    public JDDNode getTransitionRewardsByIndexObject(Object object, Model model, Values values) throws PrismException {
        JDDNode jDDNode = null;
        if (model.getNumRewardStructs() == 0) {
            throw new PrismException("Model has no rewards specified");
        }
        if (object == null) {
            jDDNode = model.getTransRewards(0);
        } else if (object instanceof Expression) {
            int n = ((Expression)object).evaluateInt(values);
            object = n;
            jDDNode = model.getTransRewards(n - 1);
        } else if (object instanceof String) {
            jDDNode = model.getTransRewards((String)object);
        }
        if (jDDNode == null) {
            throw new PrismException("Invalid reward structure index \"" + String.valueOf(object) + "\"");
        }
        return jDDNode;
    }

    public void checkNegativeRewards(JDDNode jDDNode, String string) throws PrismException {
        double d = JDD.FindMin(jDDNode);
        if (d < 0.0) {
            throw new PrismException(string + " rewards are negative (" + d + ") for some states");
        }
    }

    @Override
    public Values getConstantValues() {
        return this.constantValues;
    }

    public LabelList getLabelList() {
        if (this.propertiesFile != null) {
            return this.propertiesFile.getCombinedLabelList();
        }
        return null;
    }

    public Set<String> getDefinedLabelNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        LabelList labelList = this.getLabelList();
        if (labelList != null) {
            treeSet.addAll(labelList.getLabelNames());
        }
        return treeSet;
    }

    public void exportModel(ModelExportTask modelExportTask) throws PrismException {
        ModelExportOptions modelExportOptions = modelExportTask.getExportOptions();
        File file = modelExportTask.getFile();
        if (modelExportOptions.getFormat() == ModelExportFormat.DD_DOT) {
            JDD.ExportDDToDotFileLabelled(this.model.getTrans(), file.getPath(), this.model.getDDVarNames());
            return;
        }
        if (modelExportOptions.getFormat() == ModelExportFormat.DRN || modelExportOptions.getFormat() == ModelExportFormat.UMB) {
            throw new PrismException("Export " + modelExportOptions.getFormat().description() + " not yet supported by the symbolic engine");
        }
        try {
            this.model.exportToFile(file, modelExportOptions);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PrismException("Could not open file \"" + file.getName() + "\" for output");
        }
        if (modelExportOptions.getFormat() == ModelExportFormat.DOT) {
            try (PrismLog prismLog = this.getPrismLogForFile(file, true);){
                this.model.getReachableStates().printDot(prismLog);
                prismLog.println("}");
            }
        }
    }

    public void exportTransitions(File file, ModelExportOptions modelExportOptions) throws PrismException {
        this.exportModel(ModelExportTask.fromOptions(file, modelExportOptions));
    }

    public void exportStateRewards(int n, File file, ModelExportOptions modelExportOptions) throws PrismException {
        try {
            this.model.exportStateRewardsToFile(n, file, modelExportOptions);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PrismException("Could not open file \"" + file.getName() + "\" for output");
        }
    }

    public void exportTransRewards(int n, File file, ModelExportOptions modelExportOptions) throws PrismException {
        try {
            this.model.exportTransRewardsToFile(n, file, modelExportOptions);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PrismException("Could not open file \"" + file.getName() + "\" for output");
        }
    }

    public void exportStates(File file, ModelExportOptions modelExportOptions) throws PrismException {
        try (PrismLog prismLog = this.getPrismLogForFile(file);){
            this.model.exportStates(Prism.convertExportType(modelExportOptions), prismLog);
        }
    }

    public void exportLabels(List<String> list, File file, ModelExportOptions modelExportOptions) throws PrismException {
        int n = list.size();
        JDDNode[] jDDNodeArray = new JDDNode[n];
        for (int i = 0; i < n; ++i) {
            jDDNodeArray[i] = this.checkExpressionDD(new ExpressionLabel(list.get(i)), this.model.getReach().copy());
        }
        String string = "l";
        String[] stringArray = list.toArray(new String[list.size()]);
        try {
            PrismMTBDD.ExportLabels(jDDNodeArray, stringArray, string, this.allDDRowVars, this.odd, Prism.convertExportType(modelExportOptions), file != null ? file.getPath() : null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PrismException("Could not open file \"" + file.getName() + "\" for output");
        }
        for (int i = 0; i < n; ++i) {
            JDD.Deref(jDDNodeArray[i]);
        }
    }

    public void exportTransitionsToSpyFile(File file) throws PrismException {
        int n = this.model.getAllDDRowVars().n();
        if (n > 9) {
            n = 9;
        }
        JDDNode jDDNode = this.model.getTrans();
        JDD.Ref(jDDNode);
        if (this.model.getModelType() == ModelType.MDP) {
            jDDNode = JDD.MaxAbstract(jDDNode, ((NondetModel)this.model).getAllDDNondetVars());
        }
        JDD.ExportMatrixToSpyFile(jDDNode, this.model.getAllDDRowVars(), this.model.getAllDDColVars(), n, file.getPath());
        JDD.Deref(jDDNode);
    }
}

