/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import parser.State;
import parser.VarList;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import simulator.Path;
import simulator.PathDisplayer;
import simulator.PathToGraph;
import simulator.PathToText;
import simulator.SimulatorEngine;
import userinterface.graph.Graph;

public class GenerateSimulationPath {
    private SimulatorEngine engine;
    private PrismLog mainLog;
    private List<String> warnings = new ArrayList<String>();
    private State initialState;
    private long maxPathLength;
    private File file;
    private PathType simPathType = null;
    private int simPathLength = 0;
    private double simPathTime = 0.0;
    private String simPathSep = " ";
    private ArrayList<Integer> simVars = null;
    private boolean simLoopCheck = true;
    private int simPathRepeat = 1;
    private boolean simPathShowProbs = false;
    private boolean simPathShowRewards = false;
    private boolean simPathShowChangesOnly = false;
    private boolean simPathSnapshots = false;
    private double simPathSnapshotTime = 0.0;

    public int getNumWarnings() {
        return this.warnings.size();
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    private void warning(String string) {
        this.mainLog.printWarning(string + ".");
        this.warnings.add(string);
    }

    public GenerateSimulationPath(SimulatorEngine simulatorEngine, PrismLog prismLog) {
        this.engine = simulatorEngine;
        this.mainLog = prismLog;
    }

    public void generateSimulationPath(State state, String string, long l, File file) throws PrismException {
        this.initialState = state;
        this.maxPathLength = l;
        this.file = file;
        this.warnings.clear();
        this.parseDetails(string);
        PathDisplayer pathDisplayer = this.generateDisplayerForExport();
        if (this.simPathType == PathType.SIM_PATH_DEADLOCK) {
            this.generateMultiplePaths(pathDisplayer);
        } else {
            this.generatePath(pathDisplayer);
        }
        pathDisplayer.close();
    }

    public void generateAndPlotSimulationPath(State state, String string, long l, Graph graph) throws PrismException {
        this.initialState = state;
        this.maxPathLength = l;
        this.parseDetails(string);
        PathDisplayer pathDisplayer = this.generateDisplayerForPlotting(graph);
        if (this.simPathType == PathType.SIM_PATH_DEADLOCK) {
            this.generateMultiplePaths(pathDisplayer);
        } else {
            this.generatePath(pathDisplayer);
        }
    }

    public void generateAndPlotSimulationPathInThread(State state, String string, long l, Graph graph) throws PrismException {
        new GenerateAndPlotThread(state, string, l, graph).start();
    }

    private void parseDetails(String string) throws PrismException {
        boolean bl = false;
        boolean bl2 = false;
        String[] stringArray = string.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            Object object;
            if (stringArray[i].indexOf("time=") == 0) {
                this.simPathType = PathType.SIM_PATH_TIME;
                try {
                    this.simPathTime = Double.parseDouble(stringArray[i].substring(5));
                    if (!(this.simPathTime < 0.0)) continue;
                    throw new NumberFormatException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Invalid path time limit \"" + stringArray[i] + "\"");
                }
            }
            if (stringArray[i].equals("deadlock")) {
                this.simPathType = PathType.SIM_PATH_DEADLOCK;
                continue;
            }
            if (stringArray[i].indexOf("sep=") == 0) {
                this.simPathSep = stringArray[i].substring(4);
                if (this.simPathSep.equals("space")) {
                    this.simPathSep = " ";
                    continue;
                }
                if (this.simPathSep.equals("tab")) {
                    this.simPathSep = "\t";
                    continue;
                }
                if (this.simPathSep.equals("comma")) {
                    this.simPathSep = ",";
                    continue;
                }
                throw new PrismException("Separator must be one of: \"space\", \"tab\", \"comma\"");
            }
            if (stringArray[i].indexOf("vars=") == 0) {
                int n2;
                bl = true;
                object = this.engine.getModel().createVarList();
                this.simVars = new ArrayList();
                boolean bl3 = false;
                string2 = stringArray[i].substring(5);
                if (string2.length() < 1 || string2.charAt(0) != '(') {
                    throw new PrismException("Invalid format for \"vars=(...)\"");
                }
                if ((string2 = string2.substring(1)).indexOf(41) > -1) {
                    string2 = string2.substring(0, string2.length() - 1);
                    bl3 = true;
                }
                if (string2.length() > 0) {
                    n2 = ((VarList)object).getIndex(string2);
                    if (n2 == -1) {
                        throw new PrismException("Unknown variable \"" + string2 + "\" in \"vars=(...)\" list");
                    }
                    this.simVars.add(n2);
                }
                while (i < n && !bl3) {
                    if ((string2 = stringArray[++i]).indexOf(41) > -1) {
                        string2 = string2.substring(0, string2.length() - 1);
                        bl3 = true;
                    }
                    if ((n2 = ((VarList)object).getIndex(string2)) == -1) {
                        throw new PrismException("Unknown variable \"" + string2 + "\" in \"vars=(...)\" list");
                    }
                    this.simVars.add(n2);
                }
                continue;
            }
            if (stringArray[i].indexOf("loopcheck=") == 0) {
                string2 = stringArray[i].substring(10);
                if (string2.equals("true")) {
                    this.simLoopCheck = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.simLoopCheck = false;
                    continue;
                }
                throw new PrismException("Value for \"loopcheck\" flag must be \"true\" or \"false\"");
            }
            if (stringArray[i].indexOf("repeat=") == 0) {
                try {
                    this.simPathRepeat = Integer.parseInt(stringArray[i].substring(7));
                    if (this.simPathRepeat >= 1) continue;
                    throw new NumberFormatException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Value for \"repeat\" option must be a positive integer");
                }
            }
            if (stringArray[i].indexOf("snapshot=") == 0) {
                try {
                    this.simPathSnapshots = true;
                    this.simPathSnapshotTime = Double.parseDouble(stringArray[i].substring(9));
                    if (!(this.simPathSnapshotTime <= 0.0)) continue;
                    throw new NumberFormatException();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Value for \"snapshot\" option must be a positive double");
                }
            }
            if (stringArray[i].indexOf("probs=") == 0) {
                object = stringArray[i].substring(6).toLowerCase();
                if (((String)object).equals("true")) {
                    this.simPathShowProbs = true;
                    continue;
                }
                if (((String)object).equals("false")) {
                    this.simPathShowProbs = false;
                    continue;
                }
                throw new PrismException("Value for \"rewards\" option must \"true\" or \"false\"");
            }
            if (stringArray[i].indexOf("rewards=") == 0) {
                object = stringArray[i].substring(8).toLowerCase();
                if (((String)object).equals("true")) {
                    this.simPathShowRewards = true;
                    continue;
                }
                if (((String)object).equals("false")) {
                    this.simPathShowRewards = false;
                    continue;
                }
                throw new PrismException("Value for \"rewards\" option must \"true\" or \"false\"");
            }
            if (stringArray[i].indexOf("changes=") == 0) {
                object = stringArray[i].substring(8).toLowerCase();
                if (((String)object).equals("true")) {
                    this.simPathShowChangesOnly = true;
                    continue;
                }
                if (((String)object).equals("false")) {
                    bl2 = true;
                    this.simPathShowChangesOnly = false;
                    continue;
                }
                throw new PrismException("Value for \"changes\" option must \"true\" or \"false\"");
            }
            this.simPathType = PathType.SIM_PATH_NUM_STEPS;
            try {
                this.simPathLength = Integer.parseInt(stringArray[i]);
                if (this.simPathLength >= 0) continue;
                throw new NumberFormatException();
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("Invalid path option \"" + stringArray[i] + "\"");
            }
        }
        if (this.simPathType == null) {
            throw new PrismException("Invalid path details \"" + string + "\"");
        }
        if (bl && !bl2) {
            this.simPathShowChangesOnly = true;
        }
        if (this.simPathRepeat > 1 && this.simPathType != PathType.SIM_PATH_DEADLOCK) {
            this.simPathRepeat = 1;
            this.mainLog.printWarning("Ignoring \"repeat\" option - it is only valid when looking for deadlocks.");
        }
    }

    public static void printOptions(PrismLog prismLog) {
        prismLog.println(" * <n> - generate a path of <n> steps");
        prismLog.println(" * time=<x> - generate a path of at least <x> time units");
        prismLog.println(" * deadlock - generate a path until a deadlock is reached");
        prismLog.println(" * repeat=<n> - try <n> paths until a deadlock is found");
        prismLog.println(" * sep=<val> - use <val> as column separator (space, tab, comma)");
        prismLog.println(" * vars=<x1,x2,...> - show values for variables x1,x2,.. only");
        prismLog.println(" * loopcheck=<true|false> - whether to detect deterministic loops");
        prismLog.println(" * snapshot=<x> - view states at fixed timepoints of interval <x>");
        prismLog.println(" * probs=<true|false> - display probability (or rate) of transitions taken");
        prismLog.println(" * rewards=<true|false> - display state/transition rewards");
        prismLog.println(" * changes=<true|false> - only display states where displayed variables change");
    }

    private PathDisplayer generateDisplayerForExport() throws PrismException {
        PrismLog prismLog;
        if (this.file != null) {
            prismLog = new PrismFileLog(this.file.getPath());
            if (!prismLog.ready()) {
                throw new PrismException("Could not open file \"" + String.valueOf(this.file) + "\" for output");
            }
        } else {
            prismLog = this.mainLog;
        }
        PathToText pathToText = new PathToText(prismLog, this.engine.getModel(), this.engine.getRewardGenerator());
        pathToText.setColSep(this.simPathSep);
        pathToText.setVarsToShow(this.simVars);
        pathToText.setShowProbs(this.simPathShowProbs);
        pathToText.setShowRewards(this.simPathShowRewards);
        pathToText.setShowChangesOnly(this.simPathShowChangesOnly);
        if (this.simPathSnapshots) {
            pathToText.setToShowSnapShots(this.simPathSnapshotTime);
        }
        return pathToText;
    }

    private PathDisplayer generateDisplayerForPlotting(Graph graph) throws PrismException {
        PathToGraph pathToGraph = new PathToGraph(graph, this.engine.getModel(), this.engine.getRewardGenerator());
        pathToGraph.setVarsToShow(this.simVars);
        pathToGraph.setShowProbs(this.simPathShowProbs);
        pathToGraph.setShowRewards(this.simPathShowRewards);
        pathToGraph.setShowChangesOnly(this.simPathShowChangesOnly);
        if (this.simPathSnapshots) {
            pathToGraph.setToShowSnapShots(this.simPathSnapshotTime);
        }
        return pathToGraph;
    }

    private void generatePath(PathDisplayer pathDisplayer) throws PrismException {
        Path path = null;
        long l = 0L;
        switch (this.simPathType.ordinal()) {
            case 0: {
                this.mainLog.println("\nGenerating random path of length " + this.simPathLength + " steps...");
                break;
            }
            case 1: {
                this.mainLog.println("\nGenerating random path with time limit " + this.simPathTime + "...");
            }
        }
        this.engine.createNewOnTheFlyPath();
        path = this.engine.getPath();
        this.engine.initialisePath(this.initialState);
        if (pathDisplayer instanceof PathToText && this.file == null) {
            this.mainLog.println();
        }
        pathDisplayer.start(path.getCurrentState(), path.getCurrentStateRewards());
        l = 0L;
        boolean bl = false;
        while (!bl) {
            this.engine.automaticTransition();
            ++l;
            if (this.simPathType != PathType.SIM_PATH_DEADLOCK) {
                pathDisplayer.step(path.getTimeInPreviousState(), path.getTotalTime(), path.getPreviousActionString(), path.getPreviousProbability(), path.getPreviousTransitionRewards(), path.size(), path.getCurrentState(), path.getCurrentStateRewards());
            }
            switch (this.simPathType.ordinal()) {
                case 0: {
                    if (l < (long)this.simPathLength && !this.engine.queryIsDeadlock()) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if (!(path.getTotalTime() >= this.simPathTime) && l < this.maxPathLength && !this.engine.queryIsDeadlock()) break;
                    bl = true;
                }
            }
            if (!this.simLoopCheck || !this.engine.isPathLooping()) continue;
        }
        pathDisplayer.end();
        if (this.simLoopCheck && this.engine.isPathLooping()) {
            this.warning("Deterministic loop detected after " + this.engine.getPathSize() + " steps (use loopcheck=false option to extend path)");
        }
        if (this.simPathType == PathType.SIM_PATH_TIME && path.getTotalTime() < this.simPathTime) {
            this.warning("Path terminated before time " + this.simPathTime + " because maximum path length (" + this.maxPathLength + ") was reached");
        }
        this.mainLog.print("\nGenerated path: " + path.size() + " step" + (path.size() == 1L ? "" : "s"));
        if (this.engine.getModel().getModelType().continuousTime()) {
            this.mainLog.print(", total time " + path.getTotalTime());
        }
        if (this.file != null) {
            this.mainLog.println(" (exported to " + String.valueOf(this.file) + ")");
        } else {
            this.mainLog.println();
        }
    }

    private void generateMultiplePaths(PathDisplayer pathDisplayer) throws PrismException {
        Path path = null;
        int n = 0;
        int n2 = 0;
        switch (this.simPathType.ordinal()) {
            case 2: {
                this.mainLog.println("\nGenerating random path(s) until deadlock state...");
            }
        }
        this.engine.createNewPath();
        for (n2 = 0; n2 < this.simPathRepeat; ++n2) {
            path = this.engine.getPath();
            this.engine.initialisePath(this.initialState);
            n = 0;
            boolean bl = false;
            while (!bl) {
                this.engine.automaticTransition();
                ++n;
                switch (this.simPathType.ordinal()) {
                    case 2: {
                        if (!this.engine.queryIsDeadlock() && (long)n < this.maxPathLength) break;
                        bl = true;
                    }
                }
                if (!this.simLoopCheck || !this.engine.isPathLooping()) continue;
            }
            if (this.engine.queryIsDeadlock()) break;
        }
        if (n2 < this.simPathRepeat) {
            ++n2;
        }
        if (!this.engine.queryIsDeadlock()) {
            this.mainLog.print("\nNo deadlock state found within " + this.maxPathLength + " steps");
            if (this.simPathRepeat > 1) {
                this.mainLog.print(" (generated " + this.simPathRepeat + " paths)");
            }
            this.mainLog.println(".");
            return;
        }
        if (this.file == null) {
            this.mainLog.println();
        }
        this.engine.getPathFull().display(pathDisplayer);
        if (this.simPathRepeat > 1 && n2 > 1) {
            this.mainLog.print("\nGenerated " + n2 + " paths. Final path: ");
        } else {
            this.mainLog.print("\nGenerated path: ");
        }
        this.mainLog.print(path.size() + " steps");
        if (this.engine.getModel().getModelType().continuousTime()) {
            this.mainLog.print(", total time " + path.getTotalTime());
        }
        if (this.file != null) {
            this.mainLog.println(" (exported to " + String.valueOf(this.file) + ")");
        } else {
            this.mainLog.println();
        }
    }

    private static enum PathType {
        SIM_PATH_NUM_STEPS,
        SIM_PATH_TIME,
        SIM_PATH_DEADLOCK;

    }

    class GenerateAndPlotThread
    extends Thread {
        private State initialState;
        private String details;
        private long maxPathLength;
        private Graph graphModel;

        public GenerateAndPlotThread(State state, String string, long l, Graph graph) {
            this.initialState = state;
            this.details = string;
            this.maxPathLength = l;
            this.graphModel = graph;
        }

        @Override
        public void run() {
            try {
                GenerateSimulationPath.this.generateAndPlotSimulationPath(this.initialState, this.details, this.maxPathLength, this.graphModel);
            }
            catch (PrismException prismException) {
                GenerateSimulationPath.this.mainLog.printWarning("Error occured during path plot: " + prismException.getMessage());
            }
        }
    }
}

