/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import parser.State;
import parser.ast.ASTElement;
import parser.ast.Command;
import parser.ast.Expression;
import parser.ast.Update;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class Updates
extends ASTElement {
    private ArrayList<Expression> probs = new ArrayList();
    private ArrayList<Update> updates = new ArrayList();
    private Command parent = null;

    public void addUpdate(Expression expression, Update update) {
        this.probs.add(expression);
        this.updates.add(update);
        update.setParent(this);
    }

    public void setUpdate(int n, Update update) {
        this.updates.set(n, update);
        update.setParent(this);
    }

    public void setProbability(int n, Expression expression) {
        this.probs.set(n, expression);
    }

    public void setParent(Command command) {
        this.parent = command;
    }

    public int getNumUpdates() {
        return this.updates.size();
    }

    public Update getUpdate(int n) {
        return this.updates.get(n);
    }

    public List<Update> getUpdates() {
        return this.updates;
    }

    public Expression getProbability(int n) {
        return this.probs.get(n);
    }

    public double getProbabilityInState(int n, State state) throws PrismLangException {
        Expression expression = this.probs.get(n);
        return expression == null ? 1.0 : expression.evaluateDouble(state);
    }

    public Command getParent() {
        return this.parent;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        int n = this.getNumUpdates();
        for (int i = 0; i < n - 1; ++i) {
            if (this.getProbability(i) != null) {
                object = (String)object + String.valueOf(this.getProbability(i)) + " : ";
            }
            object = (String)object + String.valueOf(this.getUpdate(i)) + " + ";
        }
        if (this.getProbability(n - 1) != null) {
            object = (String)object + String.valueOf(this.getProbability(n - 1)) + " : ";
        }
        object = (String)object + String.valueOf(this.getUpdate(n - 1));
        return object;
    }

    @Override
    public Updates deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.probs);
        int n = this.getNumUpdates();
        for (int i = 0; i < n; ++i) {
            Update update = Objects.requireNonNull(this.getUpdate(i));
            this.setUpdate(i, deepCopy.copy(update));
        }
        deepCopy.copyAll(this.updates);
        return this;
    }

    @Override
    public Updates clone() {
        Updates updates = (Updates)super.clone();
        updates.probs = (ArrayList)this.probs.clone();
        updates.updates = (ArrayList)this.updates.clone();
        return updates;
    }
}

