/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionObs
extends Expression {
    private String name;
    private int index;

    public ExpressionObs(String string) {
        this.name = string;
        this.index = -1;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return true;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = evaluateContext.getObservableValue(this.name, this.index);
        if (object == null) {
            throw new PrismLangException("Could not evaluate observable", this);
        }
        return this.getType().castValueTo(object, evaluateContext.getEvaluationMode());
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionObs deepCopy(DeepCopy deepCopy) {
        return this;
    }

    @Override
    public ExpressionObs clone() {
        return (ExpressionObs)super.clone();
    }

    @Override
    public String toString() {
        return "\"" + this.name + "\"";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.index;
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionObs expressionObs = (ExpressionObs)object;
        if (this.index != expressionObs.index) {
            return false;
        }
        return !(this.name == null ? expressionObs.name != null : !this.name.equals(expressionObs.name));
    }
}

