/*
 * Decompiled with CFR 0.152.
 */
package jltl2ba;

import java.io.PrintStream;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Vector;
import jltl2ba.APSet;

public class MyBitSet
extends BitSet
implements Comparable<BitSet>,
Iterable<Integer> {
    private int _size;

    public MyBitSet() {
        this._size = 0;
    }

    public MyBitSet(int n) {
        super(n);
        this._size = n > 0 ? n : 0;
    }

    @Override
    public int size() {
        if (this._size > 0) {
            return this._size;
        }
        return super.size();
    }

    public boolean containsAll(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.or(bitSet);
        return bitSet2.equals(this);
    }

    public Vector<Integer> IntegerList() {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i)) continue;
            vector.add(i);
        }
        return vector;
    }

    public void print(PrintStream printStream) {
        boolean bl = true;
        printStream.print("{");
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i)) continue;
            if (!bl) {
                printStream.print(",");
            }
            printStream.print(i);
            bl = false;
        }
        printStream.print("}");
    }

    public void print(PrintStream printStream, APSet aPSet, boolean bl) {
        boolean bl2 = true;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i)) continue;
            if (!bl2) {
                printStream.print(" & ");
            }
            if (!bl) {
                printStream.print("!");
            }
            printStream.print(aPSet.getAP(i));
            bl2 = false;
        }
    }

    @Override
    public int compareTo(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.andNot(bitSet);
        BitSet bitSet3 = (BitSet)bitSet.clone();
        bitSet3.andNot(this);
        return bitSet2.length() - bitSet3.length();
    }

    public void increment() {
        int n = this.nextClearBit(0);
        this.clear(0, n);
        this.set(n);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new MyBitSetIterator(this);
    }

    public static class MyBitSetIterator
    implements Iterator<Integer> {
        private MyBitSet _bitset;
        private int index;

        public MyBitSetIterator(MyBitSet myBitSet) {
            this._bitset = myBitSet;
            this.index = this._bitset.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public Integer next() {
            Integer n = this.index;
            this.index = this._bitset.nextSetBit(this.index + 1);
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

