/*
 * Decompiled with CFR 0.152.
 */
package io;

import explicit.Model;
import explicit.PartiallyObservableModel;
import io.ModelExportOptions;
import io.ModelExporter;
import java.util.BitSet;
import java.util.List;
import parser.State;
import parser.VarList;
import prism.ModelInfo;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;

public class MatlabExporter<Value>
extends ModelExporter<Value> {
    public MatlabExporter() {
    }

    public MatlabExporter(ModelExportOptions modelExportOptions) {
        super(modelExportOptions);
    }

    @Override
    public void exportModel(Model<Value> model, PrismLog prismLog) throws PrismException {
        throw new PrismNotSupportedException("Model export not supported in Matlab format");
    }

    public void exportStates(Model<Value> model, VarList varList, PrismLog prismLog) throws PrismException {
        int n;
        List<State> list = model.getStatesList();
        if (list == null) {
            return;
        }
        prismLog.print("% (");
        int n2 = varList.getNumVars();
        for (n = 0; n < n2; ++n) {
            prismLog.print(varList.getName(n));
            if (n >= n2 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        prismLog.println("states=[");
        n = list.size();
        for (int i = 0; i < n; ++i) {
            prismLog.println(list.get(i).toStringNoParentheses());
        }
        prismLog.println("];");
    }

    public void exportObservations(PartiallyObservableModel<Value> partiallyObservableModel, ModelInfo modelInfo, PrismLog prismLog) throws PrismException {
        int n;
        List<State> list = partiallyObservableModel.getObservationsList();
        prismLog.print("% (");
        int n2 = modelInfo.getNumObservables();
        for (n = 0; n < n2; ++n) {
            prismLog.print(modelInfo.getObservableName(n));
            if (n >= n2 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        prismLog.println("obs=[");
        n = partiallyObservableModel.getNumObservations();
        for (int i = 0; i < n; ++i) {
            prismLog.println(list.get(i).toStringNoParentheses());
        }
        prismLog.println("];");
    }

    public void exportLabels(Model<Value> model, List<String> list, List<BitSet> list2, PrismLog prismLog) throws PrismException {
        int n;
        this.setEvaluator(model.getEvaluator());
        int n2 = model.getNumStates();
        String string = "l";
        int n3 = list.size();
        for (n = 0; n < n3; ++n) {
            prismLog.println(string + "_" + list.get(n) + "=sparse(" + n2 + ",1);");
        }
        prismLog.println();
        for (n = 0; n < n2; ++n) {
            boolean bl = true;
            for (int i = 0; i < n3; ++i) {
                if (!list2.get(i).get(n)) continue;
                prismLog.println(string + "_" + list.get(i) + "(" + (n + 1) + ")=1;");
            }
        }
    }
}

