/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Belief;
import explicit.Distribution;
import explicit.IndexedSet;
import explicit.MDP;
import explicit.MDPModelChecker;
import explicit.MDPSimple;
import explicit.ModelCheckerResult;
import explicit.POMDP;
import explicit.POMDPSimple;
import explicit.ProbModelChecker;
import explicit.rewards.MDPRewards;
import explicit.rewards.StateRewardsSimple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import prism.Accuracy;
import prism.AccuracyFactory;
import prism.Pair;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import strat.FMDObsStrategyBeliefs;

public class POMDPModelChecker
extends ProbModelChecker {
    public POMDPModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public ModelCheckerResult computeReachProbs(POMDP<Double> pOMDP, BitSet bitSet, BitSet bitSet2, boolean bl, BitSet bitSet3) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        if (bitSet3 == null) {
            bitSet3 = new BitSet();
            bitSet3.set(pOMDP.getFirstInitialState());
        } else if (bitSet3.cardinality() > 1) {
            throw new PrismNotSupportedException("POMDPs can only be solved from a single start state");
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting probabilistic reachability (" + (bl ? "min" : "max") + ")...");
        modelCheckerResult = this.computeReachProbsFixedGrid(pOMDP, bitSet, bitSet2, bl, bitSet3.nextSetBit(0));
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachProbsFixedGrid(POMDP<Double> pOMDP, BitSet bitSet, BitSet bitSet2, boolean bl, int n) throws PrismException {
        int n2;
        BitSet bitSet3;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting fixed-resolution grid approximation (" + (bl ? "min" : "max") + ")...");
        BitSet bitSet4 = this.getObservationsMatchingStates(pOMDP, bitSet2);
        if (bitSet4 == null) {
            throw new PrismException("Target for reachability is not observable");
        }
        BitSet bitSet5 = bitSet3 = bitSet == null ? null : this.getObservationsMatchingStates(pOMDP, bitSet);
        if (bitSet != null && bitSet3 == null) {
            throw new PrismException("Left-hand side of until is not observable");
        }
        this.mainLog.println("target obs=" + bitSet4.cardinality() + (String)(bitSet3 == null ? "" : ", remain obs=" + bitSet3.cardinality()));
        BitSet bitSet6 = new BitSet();
        bitSet6.set(0, pOMDP.getNumObservations());
        bitSet6.andNot(bitSet4);
        if (bitSet3 != null) {
            bitSet6.and(bitSet3);
        }
        List<Belief> list = this.initialiseGridPoints(pOMDP, bitSet6);
        this.mainLog.println("Grid statistics: resolution=" + this.gridResolution + ", points=" + list.size());
        this.mainLog.println("Building belief space approximation...");
        List<BeliefMDPState> list2 = this.buildBeliefMDP(pOMDP, null, list);
        HashMap<Belief, Double> hashMap = new HashMap<Belief, Double>();
        HashMap<Belief, Double> hashMap2 = new HashMap<Belief, Double>();
        for (Belief object2 : list) {
            hashMap.put(object2, 0.0);
            hashMap2.put(object2, 0.0);
        }
        Function<Belief, Double> function = belief -> this.approximateReachProb((Belief)belief, (HashMap<Belief, Double>)hashMap2, bitSet4, bitSet6);
        BeliefMDPBackUp beliefMDPBackUp = (belief, beliefMDPState) -> this.approximateReachProbBackup((Belief)belief, (BeliefMDPState)beliefMDPState, function, bl);
        this.mainLog.println("Solving belief space approximation...");
        long l2 = System.currentTimeMillis();
        boolean bl2 = false;
        for (n2 = 0; !bl2 && n2 < this.maxIters; ++n2) {
            int string = list.size();
            for (int d = 0; d < string; ++d) {
                Belief belief2 = list.get(d);
                Pair pair = (Pair)beliefMDPBackUp.apply(belief2, list2.get(d));
                hashMap.put(belief2, (Double)pair.first);
            }
            bl2 = PrismUtils.doublesAreClose(hashMap, hashMap2, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.RELATIVE);
            Set i = hashMap.entrySet();
            for (Map.Entry entry : i) {
                hashMap2.put((Belief)entry.getKey(), (Double)entry.getValue());
            }
        }
        if (!bl2 && this.errorOnNonConverge) {
            String belief3 = "Iterative method did not converge within " + n2 + " iterations.";
            belief3 = belief3 + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(belief3);
        }
        l2 = System.currentTimeMillis() - l2;
        this.mainLog.print("Belief space value iteration (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l2 / 1000.0 + " seconds.");
        Belief belief3 = Belief.pointDistribution(n, pOMDP);
        double d = (Double)function.apply(belief3);
        double d2 = PrismUtils.measureSupNorm(hashMap, hashMap2, this.termCrit == ProbModelChecker.TermCrit.RELATIVE);
        Accuracy accuracy = AccuracyFactory.valueIteration(this.termCritParam, d2, this.termCrit == ProbModelChecker.TermCrit.RELATIVE);
        this.mainLog.println("Outer bound: " + d + " (" + accuracy.toString(d) + ")");
        this.mainLog.println("\nBuilding strategy-induced model...");
        POMDPStrategyModel pOMDPStrategyModel = this.buildStrategyModel(pOMDP, n, null, bitSet4, bitSet6, beliefMDPBackUp);
        MDP<Double> mDP = pOMDPStrategyModel.mdp;
        this.mainLog.print("Strategy-induced model: " + mDP.infoString());
        FMDObsStrategyBeliefs<Double> fMDObsStrategyBeliefs = null;
        if (this.genStrat) {
            fMDObsStrategyBeliefs = new FMDObsStrategyBeliefs<Double>(pOMDP, pOMDPStrategyModel.mdp, pOMDPStrategyModel.mdpStates, pOMDPStrategyModel.unobsBeliefs);
        }
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        mDPModelChecker.setGenStrat(false);
        ModelCheckerResult modelCheckerResult = mDPModelChecker.computeReachProbs(mDP, mDP.getLabelStates("target"), true);
        double d3 = modelCheckerResult.soln[0];
        Accuracy accuracy2 = modelCheckerResult.accuracy;
        String string = "" + d3;
        if (accuracy2 != null) {
            string = string + " (" + accuracy2.toString(d3) + ")";
        }
        this.mainLog.println("Inner bound: " + string);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\nFixed-resolution grid approximation (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + (double)l / 1000.0 + " seconds.");
        Pair<Double, Accuracy> pair = bl ? AccuracyFactory.valueAndAccuracyFromInterval(d, accuracy, d3, accuracy2) : AccuracyFactory.valueAndAccuracyFromInterval(d3, accuracy2, d, accuracy);
        double d4 = (Double)pair.first;
        Accuracy accuracy3 = (Accuracy)pair.second;
        this.mainLog.println("Result bounds: [" + accuracy3.getResultLowerBound(d4) + "," + accuracy3.getResultUpperBound(d4) + "]");
        double[] dArray = new double[pOMDP.getNumStates()];
        dArray[n] = d4;
        ModelCheckerResult modelCheckerResult2 = new ModelCheckerResult();
        if (this.genStrat) {
            modelCheckerResult2.strat = fMDObsStrategyBeliefs;
        }
        modelCheckerResult2.soln = dArray;
        modelCheckerResult2.accuracy = accuracy3;
        modelCheckerResult2.numIters = n2;
        modelCheckerResult2.timeTaken = (double)l / 1000.0;
        return modelCheckerResult2;
    }

    public ModelCheckerResult computeReachRewards(POMDP<Double> pOMDP, MDPRewards<Double> mDPRewards, BitSet bitSet, boolean bl, BitSet bitSet2) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        if (bitSet2 == null) {
            bitSet2 = new BitSet();
            bitSet2.set(pOMDP.getFirstInitialState());
        } else if (bitSet2.cardinality() > 1) {
            throw new PrismNotSupportedException("POMDPs can only be solved from a single start state");
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected reachability (" + (bl ? "min" : "max") + ")...");
        modelCheckerResult = this.computeReachRewardsFixedGrid(pOMDP, mDPRewards, bitSet, bl, bitSet2.nextSetBit(0));
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Expected reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    protected ModelCheckerResult computeReachRewardsFixedGrid(POMDP<Double> pOMDP, MDPRewards<Double> mDPRewards, BitSet bitSet, boolean bl, int n) throws PrismException {
        int n2;
        long l = System.currentTimeMillis();
        this.mainLog.println("Starting fixed-resolution grid approximation (" + (bl ? "min" : "max") + ")...");
        BitSet bitSet2 = this.getObservationsMatchingStates(pOMDP, bitSet);
        if (bitSet2 == null) {
            throw new PrismException("Target for expected reachability is not observable");
        }
        MDPModelChecker mDPModelChecker = new MDPModelChecker(this);
        BitSet bitSet3 = mDPModelChecker.prob1(pOMDP, null, bitSet, false, null);
        bitSet3.flip(0, pOMDP.getNumStates());
        BitSet bitSet4 = this.getObservationsCoveredByStates(pOMDP, bitSet3);
        this.mainLog.println("target obs=" + bitSet2.cardinality() + ", inf obs=" + bitSet4.cardinality());
        BitSet bitSet5 = new BitSet();
        bitSet5.set(0, pOMDP.getNumObservations());
        bitSet5.andNot(bitSet2);
        bitSet5.andNot(bitSet4);
        List<Belief> list = this.initialiseGridPoints(pOMDP, bitSet5);
        this.mainLog.println("Grid statistics: resolution=" + this.gridResolution + ", points=" + list.size());
        this.mainLog.println("Building belief space approximation...");
        List<BeliefMDPState> list2 = this.buildBeliefMDP(pOMDP, mDPRewards, list);
        HashMap<Belief, Double> hashMap = new HashMap<Belief, Double>();
        HashMap<Belief, Double> hashMap2 = new HashMap<Belief, Double>();
        for (Belief object2 : list) {
            hashMap.put(object2, 0.0);
            hashMap2.put(object2, 0.0);
        }
        Function<Belief, Double> function = belief -> this.approximateReachReward((Belief)belief, (HashMap<Belief, Double>)hashMap2, bitSet2, bitSet4);
        BeliefMDPBackUp beliefMDPBackUp = (belief, beliefMDPState) -> this.approximateReachRewardBackup((Belief)belief, (BeliefMDPState)beliefMDPState, function, bl);
        this.mainLog.println("Solving belief space approximation...");
        long l2 = System.currentTimeMillis();
        boolean bl2 = false;
        for (n2 = 0; !bl2 && n2 < this.maxIters; ++n2) {
            int string = list.size();
            for (int d = 0; d < string; ++d) {
                Belief belief2 = list.get(d);
                Pair pair = (Pair)beliefMDPBackUp.apply(belief2, list2.get(d));
                hashMap.put(belief2, (Double)pair.first);
            }
            bl2 = PrismUtils.doublesAreClose(hashMap, hashMap2, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.RELATIVE);
            Set i = hashMap.entrySet();
            for (Map.Entry entry : i) {
                hashMap2.put((Belief)entry.getKey(), (Double)entry.getValue());
            }
        }
        if (!bl2 && this.errorOnNonConverge) {
            String belief3 = "Iterative method did not converge within " + n2 + " iterations.";
            belief3 = belief3 + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(belief3);
        }
        l2 = System.currentTimeMillis() - l2;
        this.mainLog.print("Belief space value iteration (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l2 / 1000.0 + " seconds.");
        Belief belief3 = Belief.pointDistribution(n, pOMDP);
        double d = (Double)function.apply(belief3);
        double d2 = PrismUtils.measureSupNorm(hashMap, hashMap2, this.termCrit == ProbModelChecker.TermCrit.RELATIVE);
        Accuracy accuracy = AccuracyFactory.valueIteration(this.termCritParam, d2, this.termCrit == ProbModelChecker.TermCrit.RELATIVE);
        this.mainLog.println("Outer bound: " + d + " (" + accuracy.toString(d) + ")");
        this.mainLog.println("\nBuilding strategy-induced model...");
        POMDPStrategyModel pOMDPStrategyModel = this.buildStrategyModel(pOMDP, n, mDPRewards, bitSet2, bitSet5, beliefMDPBackUp);
        MDP<Double> mDP = pOMDPStrategyModel.mdp;
        MDPRewards<Double> mDPRewards2 = pOMDPStrategyModel.mdpRewards;
        this.mainLog.print("Strategy-induced model: " + mDP.infoString());
        FMDObsStrategyBeliefs<Double> fMDObsStrategyBeliefs = null;
        if (this.genStrat) {
            fMDObsStrategyBeliefs = new FMDObsStrategyBeliefs<Double>(pOMDP, pOMDPStrategyModel.mdp, pOMDPStrategyModel.mdpStates, pOMDPStrategyModel.unobsBeliefs);
        }
        MDPModelChecker mDPModelChecker2 = new MDPModelChecker(this);
        mDPModelChecker2.setGenStrat(false);
        ModelCheckerResult modelCheckerResult = mDPModelChecker2.computeReachRewards(mDP, mDPRewards2, mDP.getLabelStates("target"), true);
        double d3 = modelCheckerResult.soln[0];
        Accuracy accuracy2 = modelCheckerResult.accuracy;
        String string = "" + d3;
        if (accuracy2 != null) {
            string = string + " (" + accuracy2.toString(d3) + ")";
        }
        this.mainLog.println("Inner bound: " + string);
        l = System.currentTimeMillis() - l;
        this.mainLog.print("\nFixed-resolution grid approximation (" + (bl ? "min" : "max") + ")");
        this.mainLog.println(" took " + (double)l / 1000.0 + " seconds.");
        Pair<Double, Accuracy> pair = bl ? AccuracyFactory.valueAndAccuracyFromInterval(d, accuracy, d3, accuracy2) : AccuracyFactory.valueAndAccuracyFromInterval(d3, accuracy2, d, accuracy);
        double d4 = (Double)pair.first;
        Accuracy accuracy3 = (Accuracy)pair.second;
        this.mainLog.println("Result bounds: [" + accuracy3.getResultLowerBound(d4) + "," + accuracy3.getResultUpperBound(d4) + "]");
        double[] dArray = new double[pOMDP.getNumStates()];
        dArray[n] = d4;
        ModelCheckerResult modelCheckerResult2 = new ModelCheckerResult();
        if (this.genStrat) {
            modelCheckerResult2.strat = fMDObsStrategyBeliefs;
        }
        modelCheckerResult2.soln = dArray;
        modelCheckerResult2.accuracy = accuracy3;
        modelCheckerResult2.numIters = n2;
        modelCheckerResult2.timeTaken = (double)l / 1000.0;
        return modelCheckerResult2;
    }

    protected BitSet getObservationsMatchingStates(POMDP<Double> pOMDP, BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            bitSet2.set(pOMDP.getObservation(n));
            n = bitSet.nextSetBit(n + 1);
        }
        BitSet bitSet3 = new BitSet();
        int n2 = pOMDP.getNumStates();
        for (int i = 0; i < n2; ++i) {
            if (!bitSet2.get(pOMDP.getObservation(i))) continue;
            bitSet3.set(i);
        }
        if (!bitSet.equals(bitSet3)) {
            return null;
        }
        return bitSet2;
    }

    protected BitSet getObservationsCoveredByStates(POMDP<Double> pOMDP, BitSet bitSet) throws PrismException {
        BitSet bitSet2 = new BitSet();
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            bitSet2.set(pOMDP.getObservation(n));
            n = bitSet.nextSetBit(n + 1);
        }
        n = pOMDP.getNumStates();
        int n2 = bitSet2.nextSetBit(0);
        while (n2 >= 0) {
            for (int i = 0; i < n; ++i) {
                if (pOMDP.getObservation(i) != n2 || bitSet.get(i)) continue;
                bitSet2.set(n2, false);
                break;
            }
            n2 = bitSet2.nextSetBit(n2 + 1);
        }
        return bitSet2;
    }

    protected List<Belief> initialiseGridPoints(POMDP<Double> pOMDP, BitSet bitSet) {
        ArrayList<Belief> arrayList = new ArrayList<Belief>();
        int n = pOMDP.getNumUnobservations();
        int n2 = pOMDP.getNumStates();
        int n3 = bitSet.nextSetBit(0);
        while (n3 >= 0) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < n2; ++i) {
                if (n3 != pOMDP.getObservation(i)) continue;
                arrayList2.add(pOMDP.getUnobservation(i));
            }
            ArrayList<ArrayList<Double>> arrayList3 = this.fullAssignment(arrayList2.size(), this.gridResolution);
            for (ArrayList<Double> arrayList4 : arrayList3) {
                double[] dArray = new double[n];
                int n4 = 0;
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    int n5 = (Integer)iterator.next();
                    dArray[n5] = arrayList4.get(n4);
                    ++n4;
                }
                arrayList.add(new Belief(n3, dArray));
            }
            n3 = bitSet.nextSetBit(n3 + 1);
        }
        return arrayList;
    }

    protected List<BeliefMDPState> buildBeliefMDP(POMDP<Double> pOMDP, MDPRewards<Double> mDPRewards, List<Belief> list) {
        ArrayList<BeliefMDPState> arrayList = new ArrayList<BeliefMDPState>();
        for (Belief belief : list) {
            arrayList.add(this.buildBeliefMDPState(pOMDP, mDPRewards, belief));
        }
        return arrayList;
    }

    protected BeliefMDPState buildBeliefMDPState(POMDP<Double> pOMDP, MDPRewards<Double> mDPRewards, Belief belief) {
        double[] dArray = belief.toDistributionOverStates(pOMDP);
        BeliefMDPState beliefMDPState = new BeliefMDPState();
        int n = pOMDP.getNumChoicesForObservation(belief.so);
        for (int i = 0; i < n; ++i) {
            HashMap<Integer, Double> hashMap = pOMDP.computeObservationProbsAfterAction(dArray, i);
            HashMap<Belief, Double> hashMap2 = new HashMap<Belief, Double>();
            for (Map.Entry<Integer, Double> entry : hashMap.entrySet()) {
                int n2 = entry.getKey();
                Belief belief2 = pOMDP.getBeliefAfterChoiceAndObservation(belief, i, n2);
                hashMap2.put(belief2, entry.getValue());
            }
            beliefMDPState.trans.add(hashMap2);
            if (mDPRewards == null) continue;
            beliefMDPState.rewards.add(pOMDP.getRewardAfterChoice(belief, i, mDPRewards));
        }
        return beliefMDPState;
    }

    protected Pair<Double, Integer> approximateReachProbBackup(Belief belief, BeliefMDPState beliefMDPState, Function<Belief, Double> function, boolean bl) {
        int n = beliefMDPState.trans.size();
        double d = bl ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            double d2 = 0.0;
            for (Map.Entry<Belief, Double> entry : beliefMDPState.trans.get(i).entrySet()) {
                double d3 = entry.getValue();
                Belief belief2 = entry.getKey();
                d2 += d3 * function.apply(belief2);
            }
            if (bl && d - d2 > 1.0E-6 || !bl && d2 - d > 1.0E-6) {
                d = d2;
                n2 = i;
                continue;
            }
            if (!(Math.abs(d2 - d) < 1.0E-6)) continue;
            n2 = i;
        }
        return new Pair<Double, Integer>(d, n2);
    }

    protected Pair<Double, Integer> approximateReachRewardBackup(Belief belief, BeliefMDPState beliefMDPState, Function<Belief, Double> function, boolean bl) {
        int n = beliefMDPState.trans.size();
        double d = bl ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d2 = beliefMDPState.rewards.get(i);
            for (Map.Entry<Belief, Double> entry : beliefMDPState.trans.get(i).entrySet()) {
                double d3 = entry.getValue();
                Belief belief2 = entry.getKey();
                d2 += d3 * function.apply(belief2);
            }
            if (bl && d - d2 > 1.0E-6 || !bl && d2 - d > 1.0E-6) {
                d = d2;
                n2 = i;
                continue;
            }
            if (!(Math.abs(d2 - d) < 1.0E-6)) continue;
            n2 = i;
        }
        return new Pair<Double, Integer>(d, n2);
    }

    protected double approximateReachProb(Belief belief, HashMap<Belief, Double> hashMap, BitSet bitSet, BitSet bitSet2) {
        if (bitSet.get(belief.so)) {
            return 1.0;
        }
        if (!bitSet2.get(belief.so)) {
            return 0.0;
        }
        return this.interpolateOverGrid(belief, hashMap);
    }

    protected double approximateReachReward(Belief belief, HashMap<Belief, Double> hashMap, BitSet bitSet, BitSet bitSet2) {
        if (bitSet.get(belief.so)) {
            return 0.0;
        }
        if (bitSet2.get(belief.so)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.interpolateOverGrid(belief, hashMap);
    }

    protected double interpolateOverGrid(Belief belief, HashMap<Belief, Double> hashMap) {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        double[] dArray = new double[belief.bu.length];
        this.getSubSimplexAndLambdas(belief.bu, arrayList, dArray, this.gridResolution);
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] >= 1.0E-6)) continue;
            d += dArray[i] * hashMap.get(new Belief(belief.so, arrayList.get(i)));
        }
        return d;
    }

    protected POMDPStrategyModel buildStrategyModel(POMDP<Double> pOMDP, int n, MDPRewards<Double> mDPRewards, BitSet bitSet, BitSet bitSet2, BeliefMDPBackUp beliefMDPBackUp) throws PrismException {
        Object object;
        MDPSimple<Double> mDPSimple = new MDPSimple<Double>();
        IndexedSet<double[]> indexedSet = new IndexedSet<double[]>((dArray, dArray2) -> Arrays.compare(dArray, dArray2));
        IndexedSet<int[]> indexedSet2 = new IndexedSet<int[]>((nArray, nArray2) -> Arrays.compare(nArray, nArray2));
        LinkedList<Belief> linkedList = new LinkedList<Belief>();
        BitSet bitSet3 = new BitSet();
        StateRewardsSimple<Double> stateRewardsSimple = new StateRewardsSimple<Double>();
        Belief belief = Belief.pointDistribution(n, pOMDP);
        indexedSet.add(belief.bu);
        indexedSet2.add(new int[]{belief.so, indexedSet.getIndexOfLastAdd()});
        linkedList.offer(belief);
        mDPSimple.addState();
        mDPSimple.addInitialState(0);
        int n2 = -1;
        while (!linkedList.isEmpty()) {
            object = (Belief)linkedList.pollFirst();
            ++n2;
            if (bitSet.get(((Belief)object).so)) {
                bitSet3.set(n2);
            }
            if (bitSet2.get(((Belief)object).so)) {
                BeliefMDPState beliefMDPState = this.buildBeliefMDPState(pOMDP, mDPRewards, (Belief)object);
                Pair pair = (Pair)beliefMDPBackUp.apply(object, beliefMDPState);
                int n3 = (Integer)pair.second;
                Distribution<Double> distribution = Distribution.ofDouble();
                for (Map.Entry<Belief, Double> entry : beliefMDPState.trans.get(n3).entrySet()) {
                    double d = entry.getValue();
                    Belief belief2 = entry.getKey();
                    indexedSet.add(belief2.bu);
                    int[] nArray3 = new int[]{belief2.so, indexedSet.getIndexOfLastAdd()};
                    if (indexedSet2.add(nArray3)) {
                        linkedList.add(belief2);
                        mDPSimple.addState();
                    }
                    int n4 = indexedSet2.getIndexOfLastAdd();
                    distribution.add(n4, d);
                }
                mDPSimple.addActionLabelledChoice(n2, distribution, pOMDP.getActionForObservation(((Belief)object).so, n3));
                if (mDPRewards != null) {
                    stateRewardsSimple.setStateReward(n2, pOMDP.getRewardAfterChoice((Belief)object, n3, mDPRewards));
                    continue;
                }
                stateRewardsSimple.setStateReward(n2, 0.0);
                continue;
            }
            stateRewardsSimple.setStateReward(n2, 0.0);
        }
        mDPSimple.findDeadlocks(true);
        mDPSimple.addLabel("target", bitSet3);
        object = new POMDPStrategyModel();
        ((POMDPStrategyModel)object).mdp = mDPSimple;
        ((POMDPStrategyModel)object).mdpStates = new ArrayList<int[]>();
        ((POMDPStrategyModel)object).mdpStates.addAll(indexedSet2.toArrayList());
        ((POMDPStrategyModel)object).unobsBeliefs = new ArrayList<double[]>();
        ((POMDPStrategyModel)object).unobsBeliefs.addAll(indexedSet.toArrayList());
        ((POMDPStrategyModel)object).mdpRewards = stateRewardsSimple;
        return object;
    }

    protected ArrayList<ArrayList<Integer>> assignGPrime(int n, int n2, int n3, int n4) {
        ArrayList<ArrayList<Integer>> arrayList = new ArrayList<ArrayList<Integer>>();
        if (n == n4 - 1) {
            for (int i = n2; i <= n3; ++i) {
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                arrayList2.add(i);
                arrayList.add(arrayList2);
            }
        } else {
            for (int i = n2; i <= n3; ++i) {
                ArrayList<ArrayList<Integer>> arrayList3 = this.assignGPrime(n + 1, 0, i, n4);
                for (ArrayList<Integer> arrayList4 : arrayList3) {
                    ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
                    arrayList5.add(i);
                    for (Integer n5 : arrayList4) {
                        arrayList5.add(n5);
                    }
                    arrayList.add(arrayList5);
                }
            }
        }
        return arrayList;
    }

    private ArrayList<ArrayList<Double>> fullAssignment(int n, int n2) {
        ArrayList<ArrayList<Integer>> arrayList = this.assignGPrime(0, n2, n2, n);
        ArrayList<ArrayList<Double>> arrayList2 = new ArrayList<ArrayList<Double>>();
        for (ArrayList<Integer> arrayList3 : arrayList) {
            int n3;
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            for (n3 = 0; n3 < n - 1; ++n3) {
                int n4 = arrayList3.get(n3) - arrayList3.get(n3 + 1);
                arrayList4.add((double)n4 / (double)n2);
            }
            arrayList4.add((double)arrayList3.get(n3).intValue() / (double)n2);
            arrayList2.add(arrayList4);
        }
        return arrayList2;
    }

    private int[] getSortedPermutation(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n - 1;
        boolean bl = false;
        for (n2 = n - 1; n2 >= 0; --n2) {
            if (dArray[n2] != 0.0) continue;
            dArray2[n5] = 0.0;
            nArray[n5] = n2;
            --n5;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (dArray[n2] == 0.0) continue;
            dArray2[n4] = dArray[n2];
            nArray[n4] = n2;
            ++n4;
        }
        while (!bl) {
            bl = true;
            for (n2 = 0; n2 < n4 - n3 - 1; ++n2) {
                if (!(dArray2[n2] < dArray2[n2 + 1])) continue;
                this.swap(dArray2, n2, n2 + 1);
                this.swap(nArray, n2, n2 + 1);
                bl = false;
            }
            ++n3;
        }
        return nArray;
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    protected boolean getSubSimplexAndLambdas(double[] dArray, ArrayList<double[]> arrayList, double[] dArray2, int n) {
        int n2;
        int n3 = dArray.length;
        int n4 = n;
        double[] dArray3 = new double[n3];
        int[] nArray = new int[n3];
        double[] dArray4 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray3[i] = 0.0;
            for (int j = i; j < n3; ++j) {
                int n5 = i;
                dArray3[n5] = dArray3[n5] + (double)n4 * dArray[j];
            }
            dArray3[i] = (double)Math.round(dArray3[i] * 1000000.0) / 1000000.0;
            nArray[i] = (int)Math.floor(dArray3[i]);
            dArray4[i] = dArray3[i] - (double)nArray[i];
        }
        int[] nArray2 = this.getSortedPermutation(dArray4);
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        for (int i = 0; i < n3; ++i) {
            int n6;
            int[] nArray3 = new int[n3];
            if (i == 0) {
                for (n6 = 0; n6 < n3; ++n6) {
                    nArray3[n6] = nArray[n6];
                }
                arrayList2.add(nArray3);
                continue;
            }
            for (n6 = 0; n6 < n3; ++n6) {
                nArray3[n6] = n6 == nArray2[i - 1] ? ((int[])arrayList2.get(i - 1))[n6] + 1 : ((int[])arrayList2.get(i - 1))[n6];
            }
            arrayList2.add(nArray3);
        }
        for (int[] nArray3 : arrayList2) {
            int n7;
            double[] dArray5 = new double[n3];
            for (n7 = 0; n7 < n3 - 1; ++n7) {
                int n8 = nArray3[n7] - nArray3[n7 + 1];
                dArray5[n7] = (double)n8 / (double)n4;
            }
            dArray5[n7] = (double)nArray3[n7] / (double)n4;
            arrayList.add(dArray5);
        }
        double d = 0.0;
        for (n2 = 1; n2 < n3; ++n2) {
            double d2;
            dArray2[n2] = d2 = dArray4[nArray2[n2 - 1]] - dArray4[nArray2[n2]];
            d += d2;
        }
        dArray2[0] = 1.0 - d;
        for (n2 = 0; n2 < n3; ++n2) {
            double d3 = 0.0;
            for (int i = 0; i < n3; ++i) {
                d3 += dArray2[i] * arrayList.get(i)[n2];
            }
            if (!(Math.abs(dArray[n2] - d3) > 1.0E-4)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTargetBelief(double[] dArray, BitSet bitSet) {
        double d = 0.0;
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            d += dArray[n];
            n = bitSet.nextSetBit(n + 1);
        }
        return Math.abs(d - 1.0) < 1.0E-6;
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        try {
            POMDPModelChecker pOMDPModelChecker = new POMDPModelChecker(null);
            MDPSimple mDPSimple = new MDPSimple();
            mDPSimple.buildFromPrismExplicit(stringArray[0]);
            Map<String, BitSet> map = POMDPModelChecker.loadLabelsFile(stringArray[1]);
            BitSet bitSet = map.get("init");
            BitSet bitSet2 = map.get(stringArray[2]);
            if (bitSet2 == null) {
                throw new PrismException("Unknown label \"" + stringArray[2] + "\"");
            }
            for (int i = 3; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-min")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-max")) {
                    bl = false;
                    continue;
                }
                if (!stringArray[i].equals("-nopre")) continue;
                pOMDPModelChecker.setPrecomp(false);
            }
            POMDPSimple<Double> pOMDPSimple = new POMDPSimple<Double>(mDPSimple);
            ModelCheckerResult modelCheckerResult = pOMDPModelChecker.computeReachRewards(pOMDPSimple, null, bitSet2, bl, null);
            System.out.println(modelCheckerResult.soln[bitSet.nextSetBit(0)]);
        }
        catch (PrismException prismException) {
            System.out.println(prismException);
        }
    }

    @FunctionalInterface
    static interface BeliefMDPBackUp
    extends BiFunction<Belief, BeliefMDPState, Pair<Double, Integer>> {
    }

    class BeliefMDPState {
        public List<HashMap<Belief, Double>> trans = new ArrayList<HashMap<Belief, Double>>();
        public List<Double> rewards = new ArrayList<Double>();
    }

    class POMDPStrategyModel {
        public MDP<Double> mdp;
        public List<int[]> mdpStates;
        public List<double[]> unobsBeliefs;
        public MDPRewards<Double> mdpRewards;

        POMDPStrategyModel() {
        }
    }
}

