/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.util.function.Function;
import java.util.function.Supplier;
import prism.PrismLog;

public class StopWatch {
    protected PrismLog log;
    protected String taskDescription;
    protected long time = 0L;
    protected boolean running = false;

    public StopWatch() {
    }

    public StopWatch(PrismLog prismLog) {
        this.log = prismLog;
    }

    public StopWatch start() {
        return this.start(null);
    }

    public StopWatch start(String string) {
        this.taskDescription = string;
        this.running = true;
        this.time = System.currentTimeMillis();
        return this;
    }

    public long stop() {
        return this.stop(null);
    }

    public long stop(String string) {
        this.time = System.currentTimeMillis() - this.time;
        this.running = false;
        if (this.log != null) {
            if (this.taskDescription != null) {
                this.log.print("Time for " + this.taskDescription + ": " + this.elapsedSeconds() + " seconds");
                if (string != null) {
                    this.log.print(", " + string);
                }
                this.log.println(".");
            } else if (string != null) {
                this.log.println("Time: " + this.elapsedSeconds() + " seconds, " + string + ".");
            }
        }
        return this.time;
    }

    public long elapsedMillis() {
        return this.running ? System.currentTimeMillis() - this.time : this.time;
    }

    public double elapsedSeconds() {
        return (double)this.elapsedMillis() / 1000.0;
    }

    public long run(Runnable runnable) {
        return this.run(runnable, null, null);
    }

    public long run(Runnable runnable, String string, String string2) {
        this.start(string);
        runnable.run();
        return this.stop(string2);
    }

    public <T> T run(Supplier<T> supplier) {
        return this.run(supplier, null, (String)null);
    }

    public <T> T run(Supplier<T> supplier, String string, String string2) {
        this.start(string);
        T t = supplier.get();
        this.stop(string2);
        return t;
    }

    public <T> T run(Supplier<T> supplier, String string, Function<? super T, String> function) {
        this.start(string);
        T t = supplier.get();
        this.stop(function.apply(t));
        return t;
    }
}

