/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import common.StackTraceHelper;
import jdd.JDD;
import prism.Prism;
import prism.PrismException;
import userinterface.GUIPlugin;

public class GUIComputationThread
extends Thread {
    protected GUIPlugin plug;
    protected Prism prism;
    protected int STACK_TRACE_LIMIT = 25;

    public GUIComputationThread(GUIPlugin gUIPlugin) {
        this.plug = gUIPlugin;
        this.prism = gUIPlugin.getPrism();
    }

    public void error(String string) {
        this.errorLog(string);
        this.errorDialog(string);
    }

    public void error(Throwable throwable) {
        if (throwable instanceof JDD.CuddOutOfMemoryException) {
            this.error(throwable.getMessage() + ".\nTry increasing the value of \"CUDD max. memory\" in the options and then restart PRISM");
        } else if (throwable instanceof PrismException) {
            this.error(throwable.getMessage());
        } else if (throwable instanceof StackOverflowError) {
            String string = "\nTry increasing the value of the Java stack size (via the -javastack argument)";
            this.errorLog(throwable.toString() + "\n" + StackTraceHelper.asString(throwable, this.STACK_TRACE_LIMIT) + string);
            this.errorDialog(throwable.toString() + string);
        } else {
            this.error(throwable.toString() + "\nThis is an unexpected error, it might be a good idea to restart PRISM");
        }
        if (throwable instanceof Error && !(throwable instanceof StackOverflowError)) {
            throw (Error)throwable;
        }
    }

    public void errorLog(String string) {
        this.logln("\nError: " + string + ".");
    }

    public void errorLog(Throwable throwable) {
        if (throwable instanceof PrismException || throwable instanceof JDD.CuddOutOfMemoryException) {
            this.logln("\nError: " + throwable.getMessage() + ".");
        } else {
            this.logln("\nError: " + throwable.toString() + ".");
        }
    }

    public void log(Object object) {
        this.plug.log(object);
    }

    public void log(int n) {
        this.plug.log(n);
    }

    public void log(double d) {
        this.plug.log(d);
    }

    public void log(float f) {
        this.plug.log(f);
    }

    public void log(short s) {
        this.plug.log(s);
    }

    public void log(byte by) {
        this.plug.log(by);
    }

    public void log(boolean bl) {
        this.plug.log(bl);
    }

    public void logln() {
        this.plug.logln();
    }

    public void logln(Object object) {
        this.plug.logln(object);
    }

    public void logln(int n) {
        this.plug.logln(n);
    }

    public void logln(double d) {
        this.plug.logln(d);
    }

    public void logln(float f) {
        this.plug.logln(f);
    }

    public void logln(short s) {
        this.plug.logln(s);
    }

    public void logln(byte by) {
        this.plug.logln(by);
    }

    public void logln(boolean bl) {
        this.plug.logln(bl);
    }

    public void logSeparator() {
        this.plug.logSeparator();
    }

    public void logWarning(String string) {
        this.plug.logWarning(string);
    }

    public void errorDialog(String string) {
        this.plug.error(string);
    }
}

