/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.Belief;
import explicit.ConstructStrategyProduct;
import explicit.MDP;
import explicit.POMDP;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import parser.State;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import strat.Strategy;
import strat.StrategyExplicit;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public class FMDObsStrategyBeliefs<Value>
extends StrategyExplicit<Value> {
    protected POMDP<Value> pomdp;
    protected MDP<Value> mdpStrat;
    protected List<int[]> mdpStates;
    protected List<double[]> unobsBeliefs;

    public FMDObsStrategyBeliefs(POMDP<Value> pOMDP, MDP<Value> mDP, List<int[]> list, List<double[]> list2) {
        super(pOMDP);
        this.pomdp = pOMDP;
        this.mdpStrat = mDP;
        this.mdpStates = list;
        this.unobsBeliefs = list2;
    }

    @Override
    public StrategyInfo.Memory memory() {
        return StrategyInfo.Memory.FINITE;
    }

    @Override
    public Object getChoiceAction(int n, int n2) {
        int n3 = this.pomdp.getObservation(n);
        int n4 = this.findMatchingMDPState(n3, n2);
        return n4 == -1 ? Strategy.UNDEFINED : this.getActionPickedByMDP(n4);
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        int n3 = this.pomdp.getObservation(n);
        int n4 = this.findMatchingMDPState(n3, n2);
        if (n4 == -1) {
            return -1;
        }
        Object object = this.getActionPickedByMDP(n4);
        int n5 = -1;
        if (object != UNDEFINED) {
            int[] nArray = this.mdpStates.get(n4);
            n5 = this.pomdp.getChoiceByActionForObservation(nArray[0], object);
        }
        return n5;
    }

    @Override
    public int getMemorySize() {
        return this.unobsBeliefs.size();
    }

    @Override
    public int getInitialMemory(int n) {
        int n2 = this.pomdp.getObservation(n);
        int n3 = this.mdpStrat.getFirstInitialState();
        if (this.mdpStates.get(n3)[0] != n2) {
            return -1;
        }
        return this.mdpStates.get(n3)[1];
    }

    @Override
    public int getUpdatedMemory(int n, Object object, int n2) {
        if (n == -1) {
            return -1;
        }
        int n3 = this.pomdp.getObservation(n2);
        int n4 = this.mdpStates.size();
        for (int i = 0; i < n4; ++i) {
            int n5;
            if (this.mdpStates.get(i)[1] != n || (n5 = this.findMatchingMemoryUpdate(i, n3)) == -1) continue;
            return n5;
        }
        return -1;
    }

    @Override
    public String getMemoryString(int n) {
        return n == -1 ? "?" : Belief.toStringUnobs(this.unobsBeliefs.get(n), this.pomdp);
    }

    @Override
    public explicit.Model<Value> constructInducedModel(StrategyExportOptions strategyExportOptions) throws PrismException {
        ConstructStrategyProduct constructStrategyProduct = new ConstructStrategyProduct();
        constructStrategyProduct.setMode(strategyExportOptions.getMode());
        explicit.Model model = constructStrategyProduct.constructProductModel(this.model, this);
        return model;
    }

    @Override
    public void exportActions(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        int n = this.mdpStrat.getNumStates();
        for (int i = 0; i < n; ++i) {
            Object object = this.getActionPickedByMDP(i);
            if (object == UNDEFINED) continue;
            int[] nArray = this.mdpStates.get(i);
            if (strategyExportOptions.getShowStates()) {
                prismLog.print(Belief.toString(nArray[0], this.unobsBeliefs.get(nArray[1]), this.pomdp));
            } else {
                prismLog.print(nArray[0] + "," + nArray[1]);
            }
            prismLog.println("=" + String.valueOf(object == null ? "" : object));
        }
    }

    @Override
    public void exportIndices(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        int n = this.mdpStrat.getNumStates();
        for (int i = 0; i < n; ++i) {
            Object object = this.getActionPickedByMDP(i);
            if (object == UNDEFINED) continue;
            int[] nArray = this.mdpStates.get(i);
            int n2 = this.pomdp.getChoiceByActionForObservation(nArray[0], object);
            prismLog.println(nArray[0] + "," + nArray[1] + "=" + n2);
        }
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        if (strategyExportOptions.getMergeObservations()) {
            this.exportInducedModelObs(prismLog, strategyExportOptions);
        } else {
            this.exportInducedModelNonObs(prismLog, strategyExportOptions);
        }
    }

    public void exportInducedModelObs(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        this.mdpStrat.exportToPrismExplicitTra(prismLog, strategyExportOptions.getModelPrecision());
    }

    public void exportInducedModelNonObs(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        Model model = this.constructInducedModel(strategyExportOptions);
        model.exportToPrismExplicitTra(prismLog, strategyExportOptions.getModelPrecision());
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        if (strategyExportOptions.getMergeObservations()) {
            this.exportDotFileObs(prismLog, strategyExportOptions);
        } else {
            this.exportDotFileNonObs(prismLog, strategyExportOptions);
        }
    }

    public void exportDotFileObs(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        if (strategyExportOptions.getShowStates()) {
            arrayList.add(new Decorator(){

                @Override
                public Decoration decorateState(int n, Decoration decoration) {
                    decoration.labelAddBelow(Belief.toString(FMDObsStrategyBeliefs.this.mdpStates.get(n)[0], FMDObsStrategyBeliefs.this.unobsBeliefs.get(FMDObsStrategyBeliefs.this.mdpStates.get(n)[1]), FMDObsStrategyBeliefs.this.pomdp));
                    return decoration;
                }
            });
        }
        this.mdpStrat.exportToDotFile(prismLog, arrayList, strategyExportOptions.getModelPrecision());
    }

    public void exportDotFileNonObs(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        Model model = this.constructInducedModel(strategyExportOptions);
        final List<State> list = model.getStatesList();
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        if (strategyExportOptions.getShowStates()) {
            arrayList.add(new Decorator(){

                @Override
                public Decoration decorateState(int n, Decoration decoration) {
                    int n2;
                    Object[] objectArray = ((State)list.get((int)n)).varValues;
                    int n3 = objectArray.length;
                    Object object = "(";
                    for (n2 = 0; n2 < n3 - 1; ++n2) {
                        if (n2 > 0) {
                            object = (String)object + ",";
                        }
                        object = (String)object + State.valueToString(objectArray[n2]);
                    }
                    object = (String)object + "),";
                    n2 = (Integer)objectArray[n3 - 1];
                    object = (String)object + FMDObsStrategyBeliefs.this.getMemoryString(n2);
                    decoration.labelAddBelow((String)object);
                    return decoration;
                }
            });
        }
        model.exportToDotFile(prismLog, arrayList, strategyExportOptions.getModelPrecision());
    }

    @Override
    public void clear() {
        this.mdpStrat = null;
        this.mdpStates = null;
        this.unobsBeliefs = null;
    }

    private int findMatchingMDPState(int n, int n2) {
        if (n2 == -1) {
            return -1;
        }
        int n3 = this.mdpStates.size();
        for (int i = 0; i < n3; ++i) {
            if (this.mdpStates.get(i)[0] != n || this.mdpStates.get(i)[1] != n2) continue;
            return i;
        }
        return -1;
    }

    private int findMatchingMemoryUpdate(int n, int n2) {
        SuccessorsIterator successorsIterator = this.mdpStrat.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (this.mdpStates.get(n3)[0] != n2) continue;
            return this.mdpStates.get(n3)[1];
        }
        return -1;
    }

    private Object getActionPickedByMDP(int n) {
        if (n < 0 || n >= this.mdpStrat.getNumStates() || this.mdpStrat.isDeadlockState(n)) {
            return UNDEFINED;
        }
        return this.mdpStrat.getAction(n, 0);
    }

    public String toString() {
        return "[" + IntStream.range(0, this.mdpStrat.getNumStates()).mapToObj(n -> this.mdpStates.get(n)[0] + "," + this.mdpStates.get(n)[1] + "=" + String.valueOf(this.getActionPickedByMDP(n))).collect(Collectors.joining(",")) + "]";
    }
}

