/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.List;
import parser.EvaluateContext;
import parser.VarList;
import parser.ast.DeclarationType;
import parser.type.Type;
import prism.ModelInfo;
import prism.ModelType;
import prism.PrismException;

public class BasicModelInfo
implements ModelInfo {
    private EvaluateContext ecConstants;
    private ModelType modelType;
    private List<Object> actionList;
    private VarList varList;
    private List<String> observableNameList;
    private List<Type> observableTypeList;
    private List<String> labelNameList;

    public BasicModelInfo(ModelType modelType) {
        this.modelType = modelType;
        this.ecConstants = EvaluateContext.create();
        this.actionList = null;
        this.varList = new VarList();
        this.observableNameList = new ArrayList<String>();
        this.observableTypeList = new ArrayList<Type>();
        this.labelNameList = new ArrayList<String>();
    }

    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    public void setActionList(List<Object> list) {
        this.actionList = list;
    }

    public void setVarList(VarList varList) {
        this.varList = varList;
    }

    public void setObservableNameList(List<String> list) {
        this.observableNameList = list;
    }

    public void setObservableTypeList(List<Type> list) {
        this.observableTypeList = list;
    }

    public void setLabelNameList(List<String> list) {
        this.labelNameList = list;
    }

    public List<Object> getActionList() {
        return this.actionList;
    }

    public VarList getVarList() {
        return this.varList;
    }

    public List<String> getObservableNameList() {
        return this.observableNameList;
    }

    public List<Type> getObservableTypeList() {
        return this.observableTypeList;
    }

    public List<String> getLabelNameList() {
        return this.labelNameList;
    }

    @Override
    public ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public void setSomeUndefinedConstants(EvaluateContext evaluateContext) throws PrismException {
        this.ecConstants = evaluateContext == null ? EvaluateContext.create() : EvaluateContext.create(evaluateContext);
    }

    @Override
    public EvaluateContext getEvaluateContext() {
        return this.ecConstants;
    }

    @Override
    public List<Object> getActions() {
        return this.actionList;
    }

    @Override
    public int getNumVars() {
        return this.varList.getNumVars();
    }

    @Override
    public List<String> getVarNames() {
        int n = this.varList.getNumVars();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.varList.getName(i));
        }
        return arrayList;
    }

    @Override
    public int getVarIndex(String string) {
        return this.varList.getIndex(string);
    }

    @Override
    public String getVarName(int n) {
        return this.varList.getName(n);
    }

    @Override
    public List<Type> getVarTypes() {
        int n = this.varList.getNumVars();
        ArrayList<Type> arrayList = new ArrayList<Type>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.varList.getType(i));
        }
        return arrayList;
    }

    @Override
    public Type getVarType(int n) throws PrismException {
        return this.varList.getType(n);
    }

    @Override
    public DeclarationType getVarDeclarationType(int n) {
        return this.varList.getDeclarationType(n);
    }

    @Override
    public List<String> getObservableNames() {
        return this.observableNameList;
    }

    @Override
    public List<Type> getObservableTypes() {
        return this.observableTypeList;
    }

    @Override
    public List<String> getLabelNames() {
        return this.labelNameList;
    }
}

