/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import parser.ast.ConstantList;
import parser.ast.Expression;
import parser.ast.ExpressionConstant;
import parser.type.Type;
import parser.visitor.ASTTraverseModify;
import prism.PrismLangException;

public class ExpandConstants
extends ASTTraverseModify {
    private ConstantList constantList;
    private boolean all;

    public ExpandConstants(ConstantList constantList) {
        this(constantList, true);
    }

    public ExpandConstants(ConstantList constantList, boolean bl) {
        this.constantList = constantList;
        this.all = bl;
    }

    @Override
    public Object visit(ExpressionConstant expressionConstant) throws PrismLangException {
        int n = this.constantList.getConstantIndex(expressionConstant.getName());
        if (n != -1 && this.constantList.getConstant(n) != null) {
            Expression expression = this.constantList.getConstant(n).deepCopy();
            expression = (Expression)expression.expandConstants(this.constantList, this.all);
            Type type = expression.getType();
            expression = Expression.Parenth(expression);
            expression.setType(type);
            return expression;
        }
        if (this.all) {
            throw new PrismLangException("Undefined constant", expressionConstant);
        }
        return expressionConstant;
    }
}

