/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.HashMap;
import param.BigRational;
import param.CachedFunctionFactory;
import param.DagFunctionFactory;
import param.Function;
import param.JasFunctionFactory;
import parser.EvaluateContext;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionITE;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeInt;
import parser.visitor.ASTTraverse;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismSettings;

public abstract class FunctionFactory {
    protected String[] parameterNames;
    protected BigRational[] lowerBounds;
    protected BigRational[] upperBounds;
    protected HashMap<String, Integer> varnameToInt;
    protected EvaluateContext ec = EvaluateContext.create(EvaluateContext.EvalMode.EXACT);

    public static FunctionFactory create(String[] stringArray, String[] stringArray2, String[] stringArray3, PrismSettings prismSettings) throws PrismException {
        BigRational[] bigRationalArray = new BigRational[stringArray2.length];
        BigRational[] bigRationalArray2 = new BigRational[stringArray3.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            bigRationalArray[i] = new BigRational(stringArray2[i]);
            bigRationalArray2[i] = new BigRational(stringArray3[i]);
        }
        String string = prismSettings.getString("prism.param.function");
        if (string.equals("JAS")) {
            return new JasFunctionFactory(stringArray, bigRationalArray, bigRationalArray2);
        }
        if (string.equals("JAS-cached")) {
            return new CachedFunctionFactory(new JasFunctionFactory(stringArray, bigRationalArray, bigRationalArray2));
        }
        if (string.equals("DAG")) {
            double d = prismSettings.getDouble("prism.param.functionDagMaxError");
            return new DagFunctionFactory(stringArray, bigRationalArray, bigRationalArray2, d, false);
        }
        throw new PrismException("Unknown function factory type \"" + string + "\"");
    }

    public static FunctionFactory createDummy(PrismSettings prismSettings) throws PrismException {
        String[] stringArray = new String[]{"dummy"};
        String[] stringArray2 = new String[]{"0"};
        String[] stringArray3 = new String[]{"1"};
        return FunctionFactory.create(stringArray, stringArray2, stringArray3, prismSettings);
    }

    public FunctionFactory(String[] stringArray, BigRational[] bigRationalArray, BigRational[] bigRationalArray2) {
        this.parameterNames = stringArray;
        this.lowerBounds = bigRationalArray;
        this.upperBounds = bigRationalArray2;
        this.varnameToInt = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            this.varnameToInt.put(stringArray[i], i);
        }
    }

    public abstract Function getOne();

    public abstract Function getZero();

    public abstract Function getNaN();

    public abstract Function getInf();

    public abstract Function getMInf();

    public abstract Function fromBigRational(BigRational var1);

    public abstract Function getVar(int var1);

    public Function getVar(String string) {
        return this.getVar(this.varnameToInt.get(string));
    }

    public String getParameterName(int n) {
        return this.parameterNames[n];
    }

    public BigRational getLowerBound(int n) {
        return this.lowerBounds[n];
    }

    public BigRational getUpperBound(int n) {
        return this.upperBounds[n];
    }

    public int getNumVariables() {
        return this.parameterNames.length;
    }

    public Function fromLong(long l) {
        return this.fromBigRational(new BigRational(l));
    }

    public Function expr2function(Expression expression) throws PrismLangException {
        return this.expr2function(expression, null);
    }

    public Function expr2function(Expression expression, Values values) throws PrismLangException {
        if (expression instanceof ExpressionLiteral) {
            String string = ((ExpressionLiteral)expression).getString();
            if (string == null || string.equals("")) {
                throw new PrismLangException("Cannot create rational function from literal for which no string is set", expression);
            }
            return this.fromBigRational(new BigRational(string));
        }
        if (expression instanceof ExpressionConstant) {
            String string = ((ExpressionConstant)expression).getName();
            if (values != null && values.contains(string)) {
                Object object = values.getValueOf(string);
                return this.fromBigRational(new BigRational(object.toString()));
            }
            return this.getVar(string);
        }
        if (expression instanceof ExpressionBinaryOp) {
            ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)expression;
            if (expressionBinaryOp.getOperator() == 15) {
                if (!FunctionFactory.containsParameter(expressionBinaryOp.getOperand2(), values) && expressionBinaryOp.getOperand2().getType() instanceof TypeInt) {
                    int n = expressionBinaryOp.getOperand2().evaluateInt(this.ec);
                    Function function = this.expr2function(expressionBinaryOp.getOperand1());
                    return function.pow(n);
                }
                throw new PrismLangException("Cannot create rational function for expression " + String.valueOf(expression), expression);
            }
            Function function = this.expr2function(expressionBinaryOp.getOperand1());
            Function function2 = this.expr2function(expressionBinaryOp.getOperand2());
            switch (expressionBinaryOp.getOperator()) {
                case 11: {
                    return function.add(function2);
                }
                case 12: {
                    return function.subtract(function2);
                }
                case 13: {
                    return function.multiply(function2);
                }
                case 14: {
                    return function.divide(function2);
                }
            }
            throw new PrismLangException("Cannot create rational function for this operator: " + String.valueOf(expression), expression);
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            Function function = this.expr2function(expressionUnaryOp.getOperand());
            switch (expressionUnaryOp.getOperator()) {
                case 2: {
                    return function.negate();
                }
                case 3: {
                    return function;
                }
            }
            throw new PrismLangException("Cannot create rational function for this operator: " + String.valueOf(expression), expression);
        }
        if (expression instanceof ExpressionITE) {
            ExpressionITE expressionITE = (ExpressionITE)expression;
            if (!FunctionFactory.containsParameter(expressionITE.getOperand1(), values)) {
                boolean bl = expressionITE.getOperand1().evaluateBoolean(this.ec);
                if (bl) {
                    return this.expr2function(expressionITE.getOperand2());
                }
                return this.expr2function(expressionITE.getOperand3());
            }
            throw new PrismLangException("Cannot create rational function for expression " + String.valueOf(expression), expression);
        }
        if (expression instanceof ExpressionFunc) {
            if (!FunctionFactory.containsParameter(expression, values)) {
                BigRational bigRational = expression.evaluateBigRational(this.ec);
                return this.fromBigRational(bigRational);
            }
            throw new PrismLangException("Cannot create rational function for this function: " + String.valueOf(expression), expression);
        }
        throw new PrismLangException("Cannot create rational function for expression " + String.valueOf(expression), expression);
    }

    private static boolean containsParameter(Expression expression, final Values values) {
        try {
            expression.accept(new ASTTraverse(){

                @Override
                public void visitPre(ExpressionConstant expressionConstant) throws PrismLangException {
                    String string = expressionConstant.getName();
                    if (values == null || !values.contains(string)) {
                        throw new PrismLangException("Found one");
                    }
                }
            });
        }
        catch (PrismLangException prismLangException) {
            return true;
        }
        return false;
    }
}

