/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import acceptance.AcceptanceRabin;
import automata.DA;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.BitSet;
import jltl2ba.SimpleLTL;
import jltl2dstar.LTL2Rabin;

public class Jltl2dstarCmdLine {
    public int run(String string, PrintStream printStream) throws Exception {
        SimpleLTL simpleLTL = SimpleLTL.parseFormulaLBT(string);
        simpleLTL = simpleLTL.simplify();
        DA<BitSet, AcceptanceRabin> dA = LTL2Rabin.ltl2rabin(simpleLTL);
        dA.printHOA(printStream);
        return 0;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        int n2 = 1;
        BufferedReader bufferedReader = null;
        try {
            String string;
            String string2;
            if (stringArray.length == 0) {
                Jltl2dstarCmdLine.usage("");
            }
            if (stringArray[0].equals("--ltl")) {
                if (stringArray.length <= 1) {
                    Jltl2dstarCmdLine.usage("Missing formula");
                }
                string2 = stringArray[1];
                ++n2;
            } else {
                bufferedReader = stringArray[0].equals("-") ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(stringArray[0]));
            }
            if (n2 >= stringArray.length) {
                Jltl2dstarCmdLine.usage("Missing output file");
            }
            PrintStream printStream = (string = stringArray[n2]).equals("-") ? System.out : new PrintStream(string);
            string2 = bufferedReader.readLine();
            bufferedReader.close();
            Jltl2dstarCmdLine jltl2dstarCmdLine = new Jltl2dstarCmdLine();
            n = jltl2dstarCmdLine.run(string2, printStream);
            printStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            n = 1;
        }
        if (n != 0) {
            System.exit(n);
        }
    }

    private static void usage(String string) {
        if (!string.isEmpty()) {
            System.err.println("Error: " + string);
            System.err.println();
        }
        System.err.println("Usage:");
        System.err.println("  --ltl formula out-file");
        System.err.println(" or");
        System.err.println("  in-file out-file");
        System.err.println("\n  Filename of '-' stands for standard input/output");
        System.exit(1);
    }
}

