/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmctools.umbj;

import io.github.pmctools.umbj.UMBIndex;
import java.util.List;
import java.util.function.Predicate;

public class UMBFormat {
    public static final String INDEX_FILE = "index.json";
    public static final String BIN_FILE_EXT = ".bin";
    public static final String STATE_CHOICE_OFFSETS_FILE = "state-to-choices.bin";
    public static final String STATE_PLAYERS = "state-to-player.bin";
    public static final String INITIAL_STATES_FILE = "state-is-initial.bin";
    public static final String MARKOVIAN_STATES_FILE = "state-is-markovian.bin";
    public static final String STATE_EXIT_RATES_FILE = "state-to-exit-rate.bin";
    public static final String CHOICE_BRANCH_OFFSETS_FILE = "choice-to-branches.bin";
    public static final String BRANCH_TARGETS_FILE = "branch-to-target.bin";
    public static final String BRANCH_PROBABILITIES_FILE = "branch-to-probability.bin";
    public static final String ACTIONS_FOLDER = "actions";
    public static final String OBSERVATIONS_FOLDER = "observations";
    public static final String OBSERVATIONS_FILE = "values.bin";
    public static final String STRING_OFFSETS_FILE = "string-mapping.bin";
    public static final String STRINGS_FILE = "strings.bin";
    public static final String ANNOTATIONS_FOLDER = "annotations";
    public static final String ANNOTATION_VALUES_FILE = "values.bin";
    public static final String ANNOTATION_DISTRIBUTION_FILE = "distribution-mapping.bin";
    public static final String ANNOTATION_PROBABILITIES_FILE = "probabilities.bin";
    public static final String AP_ANNOTATIONS_GROUP = "aps";
    public static final String REWARD_ANNOTATIONS_GROUP = "rewards";
    public static final String VALUATIONS_FOLDER = "valuations";
    public static final String VALUATIONS_FILE = "valuations.bin";
    public static final String VALUATION_CLASSES = "valuation-to-class.bin";
    public static final List<CompressionFormat> ALLOWED_COMPRESSION_FORMATS = List.of(CompressionFormat.GZIP, CompressionFormat.XZ);
    public static final CompressionFormat DEFAULT_COMPRESSION_FORMAT = CompressionFormat.GZIP;

    public static String stringOffsetsFile(String string) {
        return string + "/string-mapping.bin";
    }

    public static String stringsFile(String string) {
        return string + "/strings.bin";
    }

    public static String observationsFolder(UMBIndex.UMBEntity uMBEntity) {
        return "observations/" + String.valueOf(uMBEntity);
    }

    public static String observationsFile(UMBIndex.UMBEntity uMBEntity) {
        return UMBFormat.observationsFolder(uMBEntity) + "/values.bin";
    }

    public static String annotationFolder(String string, String string2, UMBIndex.UMBEntity uMBEntity) {
        return "annotations/" + string + "/" + string2 + "/" + String.valueOf(uMBEntity);
    }

    public static String annotationFile(String string, String string2, UMBIndex.UMBEntity uMBEntity) {
        return UMBFormat.annotationFolder(string, string2, uMBEntity) + "/values.bin";
    }

    public static String annotationDistributionFile(String string, String string2, UMBIndex.UMBEntity uMBEntity) {
        return UMBFormat.annotationFolder(string, string2, uMBEntity) + "/distribution-mapping.bin";
    }

    public static String annotationProbabilitiesFile(String string, String string2, UMBIndex.UMBEntity uMBEntity) {
        return UMBFormat.annotationFolder(string, string2, uMBEntity) + "/probabilities.bin";
    }

    public static String valuationsFolder(UMBIndex.UMBEntity uMBEntity) {
        return "valuations/" + String.valueOf(uMBEntity);
    }

    public static String valuationsFile(UMBIndex.UMBEntity uMBEntity) {
        return UMBFormat.valuationsFolder(uMBEntity) + "/valuations.bin";
    }

    public static String valuationClassesFile(UMBIndex.UMBEntity uMBEntity) {
        return UMBFormat.valuationsFolder(uMBEntity) + "/valuation-to-class.bin";
    }

    public static boolean isValidID(String string) {
        return string.matches("[a-z0-9_-]+");
    }

    public static String toValidID(String string) {
        return string.toLowerCase().replaceAll("[^a-z0-9_-]", "_").replace("^[0-9]", "_");
    }

    public static String toValidUniqueID(String string, Predicate<String> predicate) {
        Object object = UMBFormat.toValidID(string);
        while (predicate.test((String)object)) {
            object = (String)object + "_";
        }
        return object;
    }

    public static enum CompressionFormat {
        GZIP,
        XZ;


        public String extension() {
            switch (this.ordinal()) {
                case 0: {
                    return "gz";
                }
                case 1: {
                    return "xz";
                }
            }
            throw new IllegalStateException("Unknown compression format: " + String.valueOf((Object)this));
        }
    }
}

