/*
 * Decompiled with CFR 0.152.
 */
package io;

import common.Interval;
import common.iterable.SingletonIterator;
import explicit.CTMC;
import explicit.DTMC;
import explicit.IDTMC;
import explicit.IMDP;
import explicit.IPOMDP;
import explicit.IntervalModel;
import explicit.LTS;
import explicit.MDP;
import explicit.Model;
import explicit.NondetModel;
import explicit.PartiallyObservableModel;
import explicit.Utils;
import explicit.rewards.Rewards;
import io.ModelAccessIterators;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import param.BigRational;
import prism.Evaluator;
import prism.ModelType;

public interface ModelAccess<Value> {
    public ModelType getModelType();

    public Evaluator<Value> getEvaluator();

    public List<Object> getActions();

    public List<String> getActionStrings();

    public int getNumPlayers();

    public int getNumObservations();

    public int getNumStates();

    public int getNumChoices(int var1);

    default public int getNumChoices() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumChoices(i);
        }
        return n;
    }

    public int getNumTransitions(int var1, int var2);

    default public int getNumTransitions(int n) {
        int n2 = this.getNumChoices(n);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += this.getNumTransitions(n, i);
        }
        return n3;
    }

    default public int getNumTransitions() {
        int n = this.getNumStates();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getNumTransitions(i);
        }
        return n2;
    }

    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int var1, int var2);

    public int getTransitionSuccessor(int var1, int var2, int var3);

    public Value getExitRate(int var1);

    public Object getChoiceAction(int var1, int var2);

    public int getChoiceActionIndex(int var1, int var2);

    public Iterator<Object> getTransitionActionsIterator(int var1, int var2);

    public PrimitiveIterator.OfInt getTransitionActionIndicesIterator(int var1, int var2);

    public int getNumInitialStates();

    public PrimitiveIterator.OfInt getInitialStates();

    public int getStateObservation(int var1);

    public ModelAccess<Interval<Value>> getIntervalModel();

    public static <Value> ModelAccess<Value> wrap(final Model<Value> model) {
        return new ModelAccess<Value>(){

            @Override
            public ModelType getModelType() {
                return model.getModelType();
            }

            @Override
            public Evaluator<Value> getEvaluator() {
                return model.getEvaluator();
            }

            @Override
            public List<Object> getActions() {
                return model.getActions();
            }

            @Override
            public List<String> getActionStrings() {
                return model.getActionStrings();
            }

            @Override
            public int getNumPlayers() {
                return model.getNumPlayers();
            }

            @Override
            public int getNumObservations() {
                if (this.getModelType().partiallyObservable()) {
                    return ((PartiallyObservableModel)model).getNumObservations();
                }
                return 0;
            }

            @Override
            public int getNumStates() {
                return model.getNumStates();
            }

            @Override
            public int getNumChoices(int n) {
                if (model instanceof NondetModel) {
                    return ((NondetModel)model).getNumChoices(n);
                }
                return 1;
            }

            @Override
            public int getNumTransitions(int n, int n2) {
                if (model instanceof NondetModel) {
                    return ((NondetModel)model).getNumTransitions(n, n2);
                }
                return model.getNumTransitions(n);
            }

            @Override
            public int getTransitionSuccessor(int n, int n2, int n3) {
                Iterator iterator = this.getTransitionsIterator(n, n2);
                for (int i = 0; i < n3; ++i) {
                    iterator.next();
                }
                return iterator.next().getKey();
            }

            @Override
            public Value getExitRate(int n) {
                if (model instanceof CTMC) {
                    return ((CTMC)model).getExitRate(n);
                }
                return null;
            }

            @Override
            public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int n, int n2) {
                if (model instanceof MDP) {
                    return ((MDP)model).getTransitionsIterator(n, n2);
                }
                if (model instanceof CTMC) {
                    return ((CTMC)model).getEmbeddedTransitionsIterator(n);
                }
                if (model instanceof DTMC) {
                    return ((DTMC)model).getTransitionsIterator(n);
                }
                if (model instanceof LTS) {
                    return new SingletonIterator.Of(new AbstractMap.SimpleImmutableEntry<Integer, Object>(((LTS)model).getSuccessor(n, n2), null));
                }
                if (model instanceof IMDP) {
                    return ((IMDP)model).getIntervalModel().getTransitionsMappedIterator(n, n2, Interval::getLower);
                }
                if (model instanceof IDTMC) {
                    return ((IDTMC)model).getIntervalModel().getTransitionsMappedIterator(n, Interval::getLower);
                }
                if (model instanceof IPOMDP) {
                    return ((IPOMDP)model).getIntervalModel().getTransitionsMappedIterator(n, n2, Interval::getLower);
                }
                return null;
            }

            @Override
            public Object getChoiceAction(int n, int n2) {
                if (model instanceof NondetModel) {
                    return ((NondetModel)model).getAction(n, n2);
                }
                return null;
            }

            @Override
            public int getChoiceActionIndex(int n, int n2) {
                if (model instanceof NondetModel) {
                    return ((NondetModel)model).getActionIndex(n, n2);
                }
                return -1;
            }

            @Override
            public Iterator<Object> getTransitionActionsIterator(int n, int n2) {
                if (model instanceof DTMC) {
                    return ((DTMC)model).getActionsIterator(n);
                }
                if (model instanceof IDTMC) {
                    return ((IDTMC)model).getIntervalModel().getActionsIterator(n);
                }
                return Collections.nCopies(this.getNumTransitions(n, n2), null).iterator();
            }

            @Override
            public PrimitiveIterator.OfInt getTransitionActionIndicesIterator(int n, int n2) {
                if (model instanceof DTMC) {
                    return ((DTMC)model).getActionIndicesIterator(n);
                }
                if (model instanceof IDTMC) {
                    return ((IDTMC)model).getIntervalModel().getActionIndicesIterator(n);
                }
                return Utils.nCopiesIntIterator(this.getNumTransitions(n, n2), -1);
            }

            @Override
            public int getNumInitialStates() {
                return model.getNumInitialStates();
            }

            @Override
            public PrimitiveIterator.OfInt getInitialStates() {
                return IntIterators.asIntIterator(model.getInitialStates().iterator());
            }

            @Override
            public int getStateObservation(int n) {
                if (model instanceof PartiallyObservableModel) {
                    return ((PartiallyObservableModel)model).getObservation(n);
                }
                return -1;
            }

            @Override
            public ModelAccess<Interval<Value>> getIntervalModel() {
                if (model instanceof IntervalModel) {
                    return ModelAccess.wrap(((IntervalModel)model).getIntervalModel());
                }
                return null;
            }
        };
    }

    default public PrimitiveIterator.OfInt getStateChoiceOffsets() {
        return new ModelAccessIterators.GetStateChoiceCounts<Value>(this){
            boolean first;
            int iCount;
            {
                this.first = true;
                this.iCount = 0;
            }

            @Override
            public int nextInt() {
                if (this.first) {
                    this.first = false;
                    return 0;
                }
                this.iCount += super.nextInt();
                return this.iCount;
            }
        };
    }

    default public PrimitiveIterator.OfInt getStateTransitionOffsets() {
        return new ModelAccessIterators.GetStateTransitionCounts<Value>(this){
            boolean first;
            int jCount;
            {
                this.first = true;
                this.jCount = 0;
            }

            @Override
            public int nextInt() {
                if (this.first) {
                    this.first = false;
                    return 0;
                }
                this.jCount += super.nextInt();
                return this.jCount;
            }
        };
    }

    default public PrimitiveIterator.OfInt getChoiceTransitionOffsets() {
        return new ModelAccessIterators.GetChoiceTransitionCounts<Value>(this){
            boolean first;
            int jCount;
            {
                this.first = true;
                this.jCount = 0;
            }

            @Override
            public int nextInt() {
                if (this.first) {
                    this.first = false;
                    return 0;
                }
                this.jCount += super.nextInt();
                return this.jCount;
            }
        };
    }

    default public Iterator<Value> getTransitionProbabilities() {
        if (this.getModelType().intervals()) {
            return new ModelAccessIterators.UnpackIntervals(this.getIntervalModel().getTransitionProbabilities());
        }
        return new ModelAccessIterators.GetTransitionValues<Value, Value>(this){

            @Override
            public Value getValue() {
                return this.transition.getValue();
            }
        };
    }

    default public Iterator<?> getTransitionProbabilitiesAsPrimitives() {
        return this.valuesToPrimitives(this.getTransitionProbabilities());
    }

    default public PrimitiveIterator.OfInt getTransitionSuccessors() {
        return new ModelAccessIterators.GetTransitionIntValues<Value>(this){

            @Override
            public int getIntValue() {
                return (Integer)this.transition.getKey();
            }
        };
    }

    default public Iterator<Value> getExitRates() {
        return new ModelAccessIterators.GetStateValues<Value, Value>(this){

            @Override
            public Value getValue() {
                return this.model.getExitRate(this.s);
            }
        };
    }

    default public Iterator<?> getExitRatesAsPrimitives() {
        return this.valuesToPrimitives(this.getExitRates());
    }

    default public Iterator<Object> getChoiceActions() {
        if (this.getModelType().nondeterministic()) {
            return new ModelAccessIterators.GetChoiceValues<Value, Object>(this){

                @Override
                public Object getValue() {
                    return this.model.getChoiceAction(this.s, this.i);
                }
            };
        }
        return Collections.nCopies(this.getNumChoices(), null).iterator();
    }

    default public PrimitiveIterator.OfInt getChoiceActionIndices() {
        if (this.getModelType().nondeterministic()) {
            return new ModelAccessIterators.GetChoiceIntValues<Value>(this){

                @Override
                public int getIntValue() {
                    return this.model.getChoiceActionIndex(this.s, this.i);
                }
            };
        }
        return Utils.nCopiesIntIterator(this.getNumChoices(), -1);
    }

    default public PrimitiveIterator.OfInt getTransitionActionIndices() {
        return new ModelAccessIterators.GetTransitionIntValues<Value>(this, true){

            @Override
            public int getIntValue() {
                return this.actionIndex;
            }
        };
    }

    default public PrimitiveIterator.OfInt getStateObservations() {
        return new ModelAccessIterators.GetStateIntValues<Value>(this){

            @Override
            public int getIntValue() {
                return this.model.getStateObservation(this.s);
            }
        };
    }

    default public <E> Iterator<E> getStateRewards(final Rewards<E> rewards) {
        return new ModelAccessIterators.GetStateValues<Value, E>(this){

            @Override
            public E getValue() {
                return rewards.getStateReward(this.s);
            }
        };
    }

    default public <E> Iterator<?> getStateRewardsAsPrimitives(Rewards<E> rewards) {
        return this.valuesToPrimitives(this.getStateRewards(rewards));
    }

    default public <E> Iterator<E> getTransitionRewards(final Rewards<E> rewards) {
        if (this.getModelType().nondeterministic()) {
            return new ModelAccessIterators.GetChoiceValues<Value, E>(this){

                @Override
                public E getValue() {
                    return rewards.getTransitionReward(this.s, this.i);
                }
            };
        }
        return new ModelAccessIterators.GetTransitionValues<Value, E>(this){

            @Override
            public E getValue() {
                return rewards.getTransitionReward(this.s, this.j);
            }
        };
    }

    default public <E> Iterator<?> getTransitionRewardsAsPrimitives(Rewards<E> rewards) {
        return this.valuesToPrimitives(this.getTransitionRewards(rewards));
    }

    default public Iterator<?> valuesToPrimitives(Iterator<?> iterator) {
        if (this.getEvaluator().exact()) {
            return new ModelAccessIterators.UnpackBigRationals(iterator);
        }
        return DoubleIterators.asDoubleIterator(iterator);
    }

    public static <Value> Consumer<?> primitivesToValues(Evaluator<Value> evaluator, Consumer<Value> consumer) {
        if (evaluator.exact()) {
            Consumer<BigRational> consumer2 = consumer;
            return new ModelAccessIterators.PackBigRationals(consumer2);
        }
        return consumer;
    }

    public static class ValueListFromPrimitives<Value> {
        List<Value> valueList;
        Consumer<?> primitiveConsumer;

        ValueListFromPrimitives(Evaluator<Value> evaluator, int n) {
            if (evaluator.exact()) {
                ArrayList<Value> arrayList = new ArrayList<Value>(n);
                this.valueList = arrayList;
                this.primitiveConsumer = new ModelAccessIterators.PackBigRationals(arrayList::add);
            } else {
                DoubleArrayList doubleArrayList;
                this.valueList = doubleArrayList = new DoubleArrayList(n);
                this.primitiveConsumer = arg_0 -> ((DoubleList)doubleArrayList).add(arg_0);
            }
        }
    }
}

