/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.CTMC;
import explicit.CTMCSimple;
import explicit.DTMC;
import explicit.DTMCSimple;
import explicit.Distribution;
import explicit.MDPSimple;
import explicit.Model;
import explicit.ModelExplicit;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.State;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class Bisimulation<Value>
extends PrismComponent {
    protected int numStates;
    protected int[] partition;
    protected int numBlocks;
    protected MDPSimple<Value> mdp;

    public Bisimulation(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
    }

    public Model<Value> minimise(Model<Value> model, List<String> list, List<BitSet> list2) throws PrismException {
        switch (model.getModelType()) {
            case DTMC: {
                return this.minimiseDTMC((DTMC)model, list, list2);
            }
            case CTMC: {
                return this.minimiseCTMC((CTMC)model, list, list2);
            }
        }
        throw new PrismNotSupportedException("Bisimulation minimisation not yet supported for " + String.valueOf((Object)model.getModelType()) + "s");
    }

    private DTMC<Value> minimiseDTMC(DTMC<Value> dTMC, List<String> list, List<BitSet> list2) {
        this.initialisePartitionInfo(dTMC, list2);
        boolean bl = true;
        while (bl) {
            bl = this.splitDTMC(dTMC);
        }
        this.mainLog.println("Minimisation: " + this.numStates + " to " + this.numBlocks + " States");
        DTMCSimple dTMCSimple = new DTMCSimple(this.numBlocks);
        for (int i = 0; i < this.numBlocks; ++i) {
            for (Map.Entry entry : this.mdp.getChoice(i, 0)) {
                dTMCSimple.setProbability(i, (Integer)entry.getKey(), entry.getValue());
            }
        }
        this.attachStatesAndLabels(dTMC, dTMCSimple, list, list2);
        return dTMCSimple;
    }

    private CTMC<Value> minimiseCTMC(CTMC<Value> cTMC, List<String> list, List<BitSet> list2) {
        this.initialisePartitionInfo(cTMC, list2);
        boolean bl = true;
        while (bl) {
            bl = this.splitDTMC(cTMC);
        }
        this.mainLog.println("Minimisation: " + this.numStates + " to " + this.numBlocks + " States");
        CTMCSimple cTMCSimple = new CTMCSimple(this.numBlocks);
        for (int i = 0; i < this.numBlocks; ++i) {
            for (Map.Entry entry : this.mdp.getChoice(i, 0)) {
                cTMCSimple.setProbability(i, (Integer)entry.getKey(), entry.getValue());
            }
        }
        this.attachStatesAndLabels(cTMC, cTMCSimple, list, list2);
        return cTMCSimple;
    }

    private void initialisePartitionInfo(Model<Value> model, List<BitSet> list) {
        int n;
        BitSet bitSet;
        int n2;
        this.numStates = model.getNumStates();
        this.partition = new int[this.numStates];
        ArrayList<BitSet> arrayList = new ArrayList<BitSet>();
        BitSet bitSet2 = (BitSet)list.get(0).clone();
        BitSet bitSet3 = (BitSet)bitSet2.clone();
        bitSet3.flip(0, this.numStates);
        arrayList.add(bitSet2);
        arrayList.add(bitSet3);
        int n3 = list.size();
        for (n2 = 1; n2 < n3; ++n2) {
            bitSet = list.get(n2);
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                bitSet2 = (BitSet)arrayList.get(i);
                bitSet3 = (BitSet)bitSet2.clone();
                bitSet3.andNot(bitSet);
                bitSet2.and(bitSet);
                if (bitSet2.isEmpty()) {
                    arrayList.set(i, bitSet3);
                    continue;
                }
                if (bitSet3.isEmpty()) continue;
                arrayList.add(bitSet3);
            }
        }
        this.numBlocks = arrayList.size();
        for (n2 = 0; n2 < this.numBlocks; ++n2) {
            bitSet = (BitSet)arrayList.get(n2);
            n = bitSet.nextSetBit(0);
            while (n >= 0) {
                this.partition[n] = n2;
                n = bitSet.nextSetBit(n + 1);
            }
        }
    }

    private boolean splitDTMC(DTMC<Value> dTMC) {
        boolean bl;
        int[] nArray = new int[this.numStates];
        int n = 0;
        this.mdp = new MDPSimple(this.numBlocks);
        for (int i = 0; i < this.numStates; ++i) {
            Iterator<Map.Entry<Integer, Value>> iterator = dTMC.getTransitionsIterator(i);
            Distribution<Value> distribution = new Distribution<Value>(dTMC.getEvaluator());
            while (iterator.hasNext()) {
                Map.Entry<Integer, Value> entry = iterator.next();
                distribution.add(this.partition[entry.getKey()], entry.getValue());
            }
            int n2 = this.partition[i];
            int n3 = this.mdp.getNumChoices(n2);
            int n4 = this.mdp.addChoice(n2, distribution);
            if (n4 == n3) {
                this.mdp.setAction(n2, n4, n++);
            }
            nArray[i] = (Integer)this.mdp.getAction(n2, n4);
        }
        boolean bl2 = bl = this.numBlocks != n;
        if (bl) {
            this.partition = nArray;
            this.numBlocks = n;
        }
        return bl;
    }

    private void printPartition(Model<Value> model) {
        for (int i = 0; i < this.numBlocks; ++i) {
            this.mainLog.print(i + ":");
            for (int j = 0; j < this.numStates; ++j) {
                if (this.partition[j] != i) continue;
                if (model.getStatesList() != null) {
                    this.mainLog.print(" " + String.valueOf(model.getStatesList().get(j)));
                    continue;
                }
                this.mainLog.print(" " + j);
            }
            this.mainLog.println();
        }
    }

    private void attachStatesAndLabels(Model<Value> model, ModelExplicit<Value> modelExplicit, List<String> list, List<BitSet> list2) {
        if (model.getStatesList() != null) {
            int n;
            List<State> list3 = model.getStatesList();
            ArrayList<State> arrayList = new ArrayList<State>(this.numBlocks);
            for (n = 0; n < this.numBlocks; ++n) {
                arrayList.add(null);
            }
            for (n = 0; n < this.numStates; ++n) {
                if (arrayList.get(this.partition[n]) != null) continue;
                arrayList.set(this.partition[n], list3.get(n));
            }
            modelExplicit.setStatesList(arrayList);
        }
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            BitSet bitSet = list2.get(i);
            BitSet bitSet2 = new BitSet();
            int n2 = bitSet.nextSetBit(0);
            while (n2 >= 0) {
                bitSet2.set(this.partition[n2]);
                n2 = bitSet.nextSetBit(n2 + 1);
            }
            modelExplicit.addLabel(string, bitSet2);
        }
    }
}

