/*
 * Decompiled with CFR 0.152.
 */
package csv;

import csv.ReplacingReader;
import java.io.IOException;
import java.io.Reader;

public interface BasicReader
extends AutoCloseable {
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int EOF = -1;

    public static Wrapper wrap(Reader reader) {
        return new Wrapper(reader);
    }

    @Override
    public void close() throws IOException;

    default public ReplacingReader<BasicReader> convert(int n) {
        return new ReplacingReader.FromChar(this, n);
    }

    default public ReplacingReader<PeekableReader> convert(int n, int n2) throws IOException {
        return new ReplacingReader.FromPair(this, n, n2);
    }

    default public ReplacingReader.ToChar normalizeLineEndings() throws IOException {
        return this.normalizLineEndings(10);
    }

    default public ReplacingReader.ToChar normalizLineEndings(int n) throws IOException {
        return this.convert(13, 10).convert(13).to(n);
    }

    default public ReplacingReader.ToPair normalizLineEndings(int n, int n2) throws IOException {
        return this.convert(13, 10).convert(13).to(n, n2);
    }

    public int read() throws IOException;

    default public PeekableReader peekable() throws IOException {
        if (this instanceof PeekableReader) {
            return (PeekableReader)this;
        }
        return new PeekableReader(this);
    }

    public static class Wrapper
    implements BasicReader {
        protected final Reader source;

        public Wrapper(Reader reader) {
            this.source = reader;
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }

        @Override
        public int read() throws IOException {
            return this.source.read();
        }
    }

    public static class PeekableReader
    implements BasicReader {
        protected final BasicReader source;
        protected int next;

        public PeekableReader(Reader reader) throws IOException {
            this.source = new Wrapper(reader);
            this.next = reader.read();
        }

        public PeekableReader(BasicReader basicReader) throws IOException {
            this.source = basicReader;
            this.next = basicReader.read();
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }

        @Override
        public int read() throws IOException {
            int n = this.next;
            this.next = this.source.read();
            return n;
        }

        public int peek() {
            return this.next;
        }
    }
}

