/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import java.util.Iterator;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public interface PrimitiveIterable<E, E_CONS>
extends Iterable<E> {
    public static OfDouble unboxDouble(Iterable<Double> iterable) {
        Objects.requireNonNull(iterable);
        return () -> PrimitiveIterable.unboxDouble(iterable.iterator());
    }

    public static PrimitiveIterator.OfDouble unboxDouble(final Iterator<Double> iterator) {
        Objects.requireNonNull(iterator);
        if (iterator instanceof PrimitiveIterator.OfDouble) {
            return (PrimitiveIterator.OfDouble)iterator;
        }
        return new PrimitiveIterator.OfDouble(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public double nextDouble() {
                return (Double)iterator.next();
            }
        };
    }

    public static OfInt unboxInt(Iterable<Integer> iterable) {
        Objects.requireNonNull(iterable);
        return () -> PrimitiveIterable.unboxInt(iterable.iterator());
    }

    public static PrimitiveIterator.OfInt unboxInt(final Iterator<Integer> iterator) {
        Objects.requireNonNull(iterator);
        if (iterator instanceof PrimitiveIterator.OfInt) {
            return (PrimitiveIterator.OfInt)iterator;
        }
        return new PrimitiveIterator.OfInt(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public int nextInt() {
                return (Integer)iterator.next();
            }
        };
    }

    public static OfLong unboxLong(Iterable<Long> iterable) {
        Objects.requireNonNull(iterable);
        return () -> PrimitiveIterable.unboxLong(iterable.iterator());
    }

    public static PrimitiveIterator.OfLong unboxLong(final Iterator<Long> iterator) {
        Objects.requireNonNull(iterator);
        if (iterator instanceof PrimitiveIterator.OfLong) {
            return (PrimitiveIterator.OfLong)iterator;
        }
        return new PrimitiveIterator.OfLong(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public long nextLong() {
                return (Long)iterator.next();
            }
        };
    }

    public PrimitiveIterator<E, E_CONS> iterator();

    default public void forEach(E_CONS E_CONS) {
        this.iterator().forEachRemaining(E_CONS);
    }

    public static interface OfDouble
    extends PrimitiveIterable<Double, DoubleConsumer> {
        @Override
        public PrimitiveIterator.OfDouble iterator();
    }

    public static interface OfInt
    extends PrimitiveIterable<Integer, IntConsumer> {
        @Override
        public PrimitiveIterator.OfInt iterator();
    }

    public static interface OfLong
    extends PrimitiveIterable<Long, LongConsumer> {
        @Override
        public PrimitiveIterator.OfLong iterator();
    }
}

