/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.functions.DoubleObjToDoubleFunction;
import common.functions.IntObjToIntFunction;
import common.functions.LongObjToLongFunction;
import common.iterable.ChainedIterable;
import common.iterable.EmptyIterable;
import common.iterable.FilteringIterable;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.IterableArray;
import common.iterable.MappingIterable;
import common.iterable.PrimitiveIterable;
import common.iterable.Reducible;
import common.iterable.SingletonIterable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public interface FunctionalIterable<E>
extends Reducible<E, Iterable<? extends E>>,
Iterable<E> {
    @SafeVarargs
    public static <E> FunctionalIterable<E> of(E ... EArray) {
        switch (EArray.length) {
            case 0: {
                return EmptyIterable.of();
            }
            case 1: {
                return new SingletonIterable.Of<E>(EArray[0]);
            }
        }
        return new IterableArray.Of<E>(EArray);
    }

    public static FunctionalPrimitiveIterable.OfDouble ofDouble(double ... dArray) {
        switch (dArray.length) {
            case 0: {
                return EmptyIterable.ofDouble();
            }
            case 1: {
                return new SingletonIterable.OfDouble(dArray[0]);
            }
        }
        return new IterableArray.OfDouble(dArray);
    }

    public static FunctionalPrimitiveIterable.OfInt ofInt(int ... nArray) {
        switch (nArray.length) {
            case 0: {
                return EmptyIterable.ofInt();
            }
            case 1: {
                return new SingletonIterable.OfInt(nArray[0]);
            }
        }
        return new IterableArray.OfInt(nArray);
    }

    public static FunctionalPrimitiveIterable.OfLong ofLong(long ... lArray) {
        switch (lArray.length) {
            case 0: {
                return EmptyIterable.ofLong();
            }
            case 1: {
                return new SingletonIterable.OfLong(lArray[0]);
            }
        }
        return new IterableArray.OfLong(lArray);
    }

    @Override
    public FunctionalIterator<E> iterator();

    @Override
    default public void forEach(Consumer<? super E> consumer) {
        this.iterator().forEach(consumer);
    }

    @Override
    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    default public FunctionalIterable<E> concat(Iterable<? extends E> iterable) {
        return new ChainedIterable.Of(new IterableArray.Of<Iterable>(this, iterable));
    }

    default public FunctionalIterable<E> dedupe() {
        return (FunctionalIterable)Reducible.super.dedupe();
    }

    default public FunctionalIterable<E> distinct() {
        return (FunctionalIterable)Reducible.super.distinct();
    }

    default public FunctionalIterable<E> filter(Predicate<? super E> predicate) {
        return new FilteringIterable.Of<E>(this, predicate);
    }

    default public <T> FunctionalIterable<T> flatMap(Function<? super E, ? extends Iterable<? extends T>> function) {
        return new ChainedIterable.Of(this.map(function));
    }

    default public FunctionalPrimitiveIterable.OfDouble flatMapToDouble(Function<? super E, PrimitiveIterable.OfDouble> function) {
        return new ChainedIterable.OfDouble((Iterable<? extends PrimitiveIterable.OfDouble>)((Object)this.map(function)));
    }

    default public FunctionalPrimitiveIterable.OfInt flatMapToInt(Function<? super E, PrimitiveIterable.OfInt> function) {
        return new ChainedIterable.OfInt((Iterable<? extends PrimitiveIterable.OfInt>)((Object)this.map(function)));
    }

    default public FunctionalPrimitiveIterable.OfLong flatMapToLong(Function<? super E, PrimitiveIterable.OfLong> function) {
        return new ChainedIterable.OfLong((Iterable<? extends PrimitiveIterable.OfLong>)((Object)this.map(function)));
    }

    default public <T> FunctionalIterable<T> map(Function<? super E, ? extends T> function) {
        return new MappingIterable.ObjToObj<E, T>(this, function);
    }

    default public FunctionalPrimitiveIterable.OfDouble mapToDouble(ToDoubleFunction<? super E> toDoubleFunction) {
        return new MappingIterable.ObjToDouble<E>(this, toDoubleFunction);
    }

    default public FunctionalPrimitiveIterable.OfInt mapToInt(ToIntFunction<? super E> toIntFunction) {
        return new MappingIterable.ObjToInt<E>(this, toIntFunction);
    }

    default public FunctionalPrimitiveIterable.OfLong mapToLong(ToLongFunction<? super E> toLongFunction) {
        return new MappingIterable.ObjToLong<E>(this, toLongFunction);
    }

    default public FunctionalIterable<E> nonNull() {
        return (FunctionalIterable)Reducible.super.nonNull();
    }

    default public FunctionalIterable<E> consume() {
        return (FunctionalIterable)Reducible.super.consume();
    }

    @Override
    default public E detect(Predicate<? super E> predicate) {
        return this.iterator().detect(predicate);
    }

    @Override
    default public Optional<E> reduce(BinaryOperator<E> binaryOperator) {
        return this.iterator().reduce(binaryOperator);
    }

    @Override
    default public <T> T reduce(T t, BiFunction<T, ? super E, T> biFunction) {
        return this.iterator().reduce(t, biFunction);
    }

    @Override
    default public double reduce(double d, DoubleObjToDoubleFunction<? super E> doubleObjToDoubleFunction) {
        return this.iterator().reduce(d, doubleObjToDoubleFunction);
    }

    @Override
    default public int reduce(int n, IntObjToIntFunction<? super E> intObjToIntFunction) {
        return this.iterator().reduce(n, intObjToIntFunction);
    }

    @Override
    default public long reduce(long l, LongObjToLongFunction<? super E> longObjToLongFunction) {
        return this.iterator().reduce(l, longObjToLongFunction);
    }
}

