/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.structure.RingElem;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BasicLinAlg<C extends RingElem<C>>
implements Serializable {
    private static final Logger logger = LogManager.getLogger(BasicLinAlg.class);

    public C scalarProduct(List<C> list, List<C> list2) {
        RingElem ringElem = null;
        Iterator<C> iterator = list.iterator();
        Iterator<C> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            RingElem ringElem2 = (RingElem)iterator.next();
            RingElem ringElem3 = (RingElem)iterator2.next();
            if (ringElem2 == null || ringElem3 == null) continue;
            if (ringElem == null) {
                ringElem = ringElem2.multiply(ringElem3);
                continue;
            }
            ringElem = ringElem.sum(ringElem2.multiply(ringElem3));
        }
        if (iterator.hasNext() || iterator2.hasNext()) {
            logger.error("scalarProduct wrong sizes");
        }
        return (C)ringElem;
    }

    public List<C> leftScalarProduct(List<C> list, List<List<C>> list2) {
        List<RingElem> list3 = null;
        Iterator<C> iterator = list.iterator();
        Iterator<List<C>> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            RingElem ringElem = (RingElem)iterator.next();
            List<C> list4 = iterator2.next();
            if (ringElem == null || list4 == null) continue;
            List<RingElem> list5 = this.scalarProduct(ringElem, list4);
            if (list3 == null) {
                list3 = list5;
                continue;
            }
            list3 = this.vectorAdd(list3, list5);
        }
        if (iterator.hasNext() || iterator2.hasNext()) {
            logger.error("scalarProduct wrong sizes");
        }
        return list3;
    }

    public List<C> rightScalarProduct(List<C> list, List<List<C>> list2) {
        List<RingElem> list3 = null;
        Iterator<C> iterator = list.iterator();
        Iterator<List<C>> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            RingElem ringElem = (RingElem)iterator.next();
            List<C> list4 = iterator2.next();
            if (ringElem == null || list4 == null) continue;
            List<RingElem> list5 = this.scalarProduct(list4, ringElem);
            if (list3 == null) {
                list3 = list5;
                continue;
            }
            list3 = this.vectorAdd(list3, list5);
        }
        if (iterator.hasNext() || iterator2.hasNext()) {
            logger.error("scalarProduct wrong sizes");
        }
        return list3;
    }

    public List<C> vectorAdd(List<C> list, List<C> list2) {
        if (list == null) {
            return list2;
        }
        if (list2 == null) {
            return list;
        }
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(list.size());
        Iterator<C> iterator = list.iterator();
        Iterator<C> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            RingElem ringElem = (RingElem)iterator.next();
            RingElem ringElem2 = (RingElem)iterator2.next();
            RingElem ringElem3 = ringElem.sum(ringElem2);
            arrayList.add(ringElem3);
        }
        if (iterator.hasNext() || iterator2.hasNext()) {
            logger.error("vectorAdd wrong sizes");
        }
        return arrayList;
    }

    public boolean isZero(List<C> list) {
        if (list == null) {
            return true;
        }
        for (RingElem ringElem : list) {
            if (ringElem == null || ringElem.isZERO()) continue;
            return false;
        }
        return true;
    }

    public List<C> scalarProduct(C ringElem, List<C> list) {
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(list.size());
        for (RingElem ringElem2 : list) {
            ringElem2 = ringElem != null ? ringElem.multiply((RingElem)ringElem2) : null;
            arrayList.add(ringElem2);
        }
        return arrayList;
    }

    public List<C> scalarProduct(List<C> list, C c) {
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(list.size());
        for (RingElem ringElem : list) {
            if (ringElem != null) {
                ringElem = (RingElem)ringElem.multiply(c);
            }
            arrayList.add(ringElem);
        }
        return arrayList;
    }

    public GenVector<C> leftProduct(GenVector<C> genVector, GenMatrix<C> genMatrix) {
        ArrayList arrayList = new ArrayList(genVector.val.size());
        for (ArrayList arrayList2 : genMatrix.matrix) {
            if (arrayList2 == null) continue;
            Object c = this.scalarProduct(genVector.val, (List<C>)arrayList2);
            arrayList.add(c);
        }
        return new GenVector(genVector.modul, arrayList);
    }

    public GenVector<C> rightProduct(GenVector<C> genVector, GenMatrix<C> genMatrix) {
        ArrayList arrayList = new ArrayList(genVector.val.size());
        for (ArrayList arrayList2 : genMatrix.matrix) {
            if (arrayList2 == null) continue;
            Object c = this.scalarProduct((List<C>)arrayList2, genVector.val);
            arrayList.add(c);
        }
        return new GenVector(genVector.modul, arrayList);
    }
}

