/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.Monomial;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import edu.jas.ufd.SquarefreeFieldCharP;
import java.math.BigInteger;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SquarefreeInfiniteFieldCharP<C extends GcdRingElem<C>>
extends SquarefreeFieldCharP<Quotient<C>> {
    private static final Logger logger = LogManager.getLogger(SquarefreeInfiniteFieldCharP.class);
    protected final SquarefreeAbstract<C> qengine;

    public SquarefreeInfiniteFieldCharP(RingFactory<Quotient<C>> ringFactory) {
        super(ringFactory);
        if (ringFactory.isFinite()) {
            throw new IllegalArgumentException("fac must be in-finite");
        }
        QuotientRing quotientRing = (QuotientRing)ringFactory;
        GenPolynomialRing genPolynomialRing = quotientRing.ring;
        this.qengine = SquarefreeFactory.getImplementation(genPolynomialRing);
    }

    @Override
    public SortedMap<Quotient<C>, Long> squarefreeFactors(Quotient<C> quotient) {
        Quotient quotient2;
        GenPolynomial genPolynomial;
        SortedMap sortedMap;
        if (quotient == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        TreeMap<Quotient<C>, Long> treeMap = new TreeMap<Quotient<C>, Long>();
        if (quotient.isZERO()) {
            return treeMap;
        }
        if (quotient.isONE()) {
            treeMap.put(quotient, 1L);
            return treeMap;
        }
        GenPolynomial genPolynomial2 = quotient.num;
        GenPolynomial genPolynomial3 = quotient.den;
        QuotientRing quotientRing = quotient.ring;
        MonoidElem monoidElem = quotientRing.ring.getONE();
        if (!genPolynomial2.isONE()) {
            sortedMap = this.qengine.squarefreeFactors(genPolynomial2);
            for (Map.Entry entry : sortedMap.entrySet()) {
                genPolynomial = entry.getKey();
                quotient2 = new Quotient(quotientRing, genPolynomial);
                treeMap.put(quotient2, entry.getValue());
            }
        }
        if (genPolynomial3.isONE()) {
            if (treeMap.size() == 0) {
                treeMap.put(quotient, 1L);
            }
            return treeMap;
        }
        sortedMap = this.qengine.squarefreeFactors(genPolynomial3);
        for (Map.Entry entry : sortedMap.entrySet()) {
            genPolynomial = entry.getKey();
            quotient2 = new Quotient(quotientRing, monoidElem, genPolynomial);
            treeMap.put(quotient2, entry.getValue());
        }
        if (treeMap.size() == 0) {
            treeMap.put(quotient, 1L);
        }
        return treeMap;
    }

    public SortedMap<Quotient<C>, Long> rootCharacteristic(Quotient<C> quotient) {
        Long l;
        Quotient<C> quotient2;
        if (quotient == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P == null");
        }
        BigInteger bigInteger = quotient.ring.characteristic();
        if (bigInteger.signum() == 0) {
            return null;
        }
        TreeMap<Quotient<C>, Long> treeMap = new TreeMap<Quotient<C>, Long>();
        if (quotient.isZERO()) {
            return treeMap;
        }
        if (quotient.isONE()) {
            treeMap.put(quotient, 1L);
            return treeMap;
        }
        SortedMap<Quotient<C>, Long> sortedMap = this.squarefreeFactors(quotient);
        if (sortedMap.size() == 0) {
            return null;
        }
        if (logger.isInfoEnabled()) {
            logger.info("sf,quot = " + sortedMap);
        }
        Long l2 = null;
        long l3 = bigInteger.longValueExact();
        for (Map.Entry<Quotient<C>, Long> entry : sortedMap.entrySet()) {
            quotient2 = entry.getKey();
            if (quotient2.isConstant()) continue;
            l = entry.getValue();
            long l4 = l;
            long l5 = l4 % l3;
            if (l5 != 0L) {
                return null;
            }
            if (l2 == null) {
                l2 = l;
                continue;
            }
            if (l2 < l) continue;
            l2 = l;
        }
        if (l2 == null) {
            l2 = 1L;
        }
        for (Map.Entry<Quotient<C>, Long> entry : sortedMap.entrySet()) {
            quotient2 = entry.getKey();
            l = entry.getValue();
            if (l >= l2) {
                l = l / l3;
                treeMap.put(quotient2, l);
                continue;
            }
            treeMap.put(quotient2, l);
        }
        return treeMap;
    }

    public GenPolynomial<Quotient<C>> rootCharacteristic(GenPolynomial<Quotient<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
            GenPolynomial<GenPolynomial<Quotient<C>>> genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
            GenPolynomial genPolynomial3 = this.recursiveUnivariateRootCharacteristic(genPolynomial2);
            if (genPolynomial3 == null) {
                return null;
            }
            GenPolynomial<Quotient<C>> genPolynomial4 = PolyUtil.distribute(genPolynomialRing, genPolynomial3);
            return genPolynomial4;
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        if (ringFactory.characteristic().signum() != 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for ModInteger polynomials " + ringFactory);
        }
        long l = ringFactory.characteristic().longValueExact();
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial<Quotient<C>> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l2 = expVector.getVal(0);
            if (l2 % l != 0L) {
                return null;
            }
            l2 /= l;
            SortedMap<Quotient<C>, Long> sortedMap = this.rootCharacteristic((Quotient)monomial.c);
            if (sortedMap == null) {
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info("sm,root = " + sortedMap);
            }
            Quotient<Quotient<Quotient>> quotient = (Quotient<Quotient<Quotient>>)ringFactory.getONE();
            for (Map.Entry<Quotient<C>, Long> entry : sortedMap.entrySet()) {
                Quotient quotient2 = entry.getKey();
                long l3 = entry.getValue();
                if (l3 > 1L) {
                    quotient2 = (Quotient)quotient2.power(l3);
                }
                quotient = quotient.multiply(quotient2);
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            ((GenPolynomial)element).doPutToMap(expVector2, quotient);
        }
        logger.info("sm,root,d = " + (GenPolynomial)element);
        return element;
    }

    @Override
    public GenPolynomial<Quotient<C>> baseRootCharacteristic(GenPolynomial<Quotient<C>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate polynomials");
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        if (ringFactory.characteristic().signum() != 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for char p > 0 " + ringFactory);
        }
        long l = ringFactory.characteristic().longValueExact();
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial<Quotient<C>> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l2 = expVector.getVal(0);
            if (l2 % l != 0L) {
                return null;
            }
            l2 /= l;
            SortedMap<Quotient<C>, Long> sortedMap = this.rootCharacteristic((Quotient)monomial.c);
            if (sortedMap == null) {
                return null;
            }
            if (logger.isInfoEnabled()) {
                logger.info("sm,base,root = " + sortedMap);
            }
            Quotient<Quotient<Quotient>> quotient = (Quotient<Quotient<Quotient>>)ringFactory.getONE();
            for (Map.Entry<Quotient<C>, Long> entry : sortedMap.entrySet()) {
                Quotient quotient2 = entry.getKey();
                long l3 = entry.getValue();
                Quotient quotient3 = quotient2;
                if (l3 > 1L) {
                    quotient3 = (Quotient)quotient2.power(l3);
                }
                quotient = quotient.multiply(quotient3);
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            ((GenPolynomial)element).doPutToMap(expVector2, quotient);
        }
        if (logger.isInfoEnabled()) {
            logger.info("sm,base,d = " + (GenPolynomial)element);
        }
        return element;
    }

    @Override
    public GenPolynomial<GenPolynomial<Quotient<C>>> recursiveUnivariateRootCharacteristic(GenPolynomial<GenPolynomial<Quotient<C>>> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar > 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for univariate recursive polynomials");
        }
        RingFactory ringFactory = genPolynomialRing.coFac;
        if (ringFactory.characteristic().signum() != 1) {
            throw new IllegalArgumentException(genPolynomial.getClass().getName() + " only for char p > 0 " + ringFactory);
        }
        long l = ringFactory.characteristic().longValueExact();
        Element element = ((GenPolynomial)genPolynomialRing.getZERO()).copy();
        for (Monomial<GenPolynomial<Quotient<C>>> monomial : genPolynomial) {
            ExpVector expVector = monomial.e;
            long l2 = expVector.getVal(0);
            if (l2 % l != 0L) {
                return null;
            }
            l2 /= l;
            GenPolynomial<Quotient<C>> genPolynomial2 = this.rootCharacteristic((GenPolynomial)monomial.c);
            if (genPolynomial2 == null) {
                return null;
            }
            ExpVector expVector2 = ExpVector.create(1, 0, l2);
            ((GenPolynomial)element).doPutToMap(expVector2, genPolynomial2);
        }
        return element;
    }
}

