/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.Monomial;
import edu.jas.structure.RingElem;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.function.Consumer;

public class PolySpliterator<C extends RingElem<C>>
implements Spliterator<Monomial<C>> {
    protected Spliterator<Map.Entry<ExpVector, C>> ms;
    protected SortedMap<ExpVector, C> sm;

    public PolySpliterator(SortedMap<ExpVector, C> sortedMap) {
        this(sortedMap.entrySet().spliterator(), sortedMap);
    }

    protected PolySpliterator(Spliterator<Map.Entry<ExpVector, C>> spliterator, SortedMap<ExpVector, C> sortedMap) {
        this.sm = sortedMap;
        this.ms = spliterator;
    }

    public String toString() {
        return "PolySpliterator(" + this.estimateSize() + ", " + this.characteristics() + ")";
    }

    @Override
    public int characteristics() {
        return this.ms.characteristics();
    }

    @Override
    public long estimateSize() {
        return this.ms.estimateSize();
    }

    @Override
    public Comparator<Monomial<C>> getComparator() {
        return new Comparator<Monomial<C>>(){

            @Override
            public int compare(Monomial<C> monomial, Monomial<C> monomial2) {
                if (PolySpliterator.this.sm == null) {
                    throw new RuntimeException("sm == null");
                }
                int n = PolySpliterator.this.sm.comparator().compare(monomial.e, monomial2.e);
                if (n != 0) {
                    return n;
                }
                return monomial.c.compareTo(monomial2.c);
            }
        };
    }

    @Override
    public PolySpliterator<C> trySplit() {
        Spliterator<Map.Entry<ExpVector, C>> spliterator = this.ms.trySplit();
        return new PolySpliterator<C>(spliterator, this.sm);
    }

    @Override
    public boolean tryAdvance(final Consumer<? super Monomial<C>> consumer) {
        Consumer consumer2 = new Consumer<Map.Entry<ExpVector, C>>(){

            @Override
            public void accept(Map.Entry<ExpVector, C> entry) {
                consumer.accept(new Monomial<RingElem>(entry.getKey(), (RingElem)entry.getValue()));
            }
        };
        return this.ms.tryAdvance(consumer2);
    }
}

