/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.gb.WordGroebnerBase;
import edu.jas.gbufd.WordGroebnerBasePseudoSeq;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenWordPolynomial;
import edu.jas.poly.GenWordPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.WordFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class WordGroebnerBasePseudoSeqTest
extends TestCase {
    GenWordPolynomialRing<BigInteger> fac;
    WordFactory wfac;
    List<GenWordPolynomial<BigInteger>> L;
    List<GenWordPolynomial<BigInteger>> G;
    PolynomialList<BigInteger> F;
    WordGroebnerBase<BigInteger> bb;
    GenWordPolynomial<BigInteger> a;
    GenWordPolynomial<BigInteger> b;
    GenWordPolynomial<BigInteger> c;
    GenWordPolynomial<BigInteger> d;
    GenWordPolynomial<BigInteger> e;
    int kl = 3;
    int ll = 7;
    int el = 4;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)WordGroebnerBasePseudoSeqTest.suite());
    }

    public WordGroebnerBasePseudoSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(WordGroebnerBasePseudoSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigInteger bigInteger = new BigInteger(0L);
        this.wfac = new WordFactory("a");
        this.fac = new GenWordPolynomialRing<BigInteger>(bigInteger, this.wfac);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new WordGroebnerBasePseudoSeq<BigInteger>(bigInteger);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.bb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenWordPolynomial<BigInteger>>();
        this.a = this.fac.random(this.kl, this.ll, this.el);
        this.b = this.fac.random(this.kl, this.ll, this.el);
        this.c = this.fac.random(this.kl, this.ll, this.el);
        this.d = this.fac.random(this.kl, this.ll, this.el);
        this.e = this.d;
        while (this.a.isZERO()) {
            this.a = this.fac.random(this.kl, this.ll, this.el);
        }
        while (this.b.isZERO()) {
            this.b = this.fac.random(this.kl, this.ll, this.el);
        }
        while (this.c.isZERO()) {
            this.c = this.fac.random(this.kl, this.ll, this.el);
        }
        while (this.d.isZERO()) {
            this.d = this.fac.random(this.kl, this.ll, this.el);
        }
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.a.multiply((BigInteger)((Object)this.b)));
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.a.multiply((BigInteger)((Object)this.c)));
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.a.multiply((BigInteger)((Object)this.d)));
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
        this.L.add(this.e);
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d, e } )", (boolean)this.bb.isGB(this.L));
        this.L.clear();
        this.L.add(this.a);
        this.L.add(this.a.multiply((BigInteger)((Object)this.b)));
        this.L.add(this.a.multiply((BigInteger)((Object)this.c)));
        this.L.add(this.a.multiply((BigInteger)((Object)this.d)));
        this.L = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( { a, b, c, d } )", (boolean)this.bb.isGB(this.L));
    }

    public void testExample1GBase() {
        String string = "(x,y,z) L ( ( z y**2 + 2 x + 1/2 )( z x**2 - y**2 - 1/2 x )( -z + y**2 x + 4 x**2 + 1/4 ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            WordGroebnerBasePseudoSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            WordGroebnerBasePseudoSeqTest.fail((String)("" + iOException));
        }
        this.fac = new GenWordPolynomialRing(this.F.ring);
        this.L = this.fac.valueOf(this.F.list);
        this.G = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( G )", (boolean)this.bb.isGB(this.G));
    }

    public void testTrinks7GBase() {
        String string = "(B,S,T,Z,P,W) L ( ( 45 P + 35 S - 165 B - 36 ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - 165 B**2 ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - 11 B**3 ), ( 99 W - 11 B S + 3 B**2 ), ( B**2 + 33/50 B + 2673/10000 ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            WordGroebnerBasePseudoSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            WordGroebnerBasePseudoSeqTest.fail((String)("" + iOException));
        }
        this.fac = new GenWordPolynomialRing(this.F.ring);
        this.L = this.fac.valueOf(this.F.list);
        this.L.addAll(this.fac.commute());
        this.G = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( G )", (boolean)this.bb.isGB(this.G));
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"#G == 6", (this.G.size() == 6 ? 1 : 0) != 0);
    }

    public void testExample2GBase() {
        String string = "(x,y,z) L ( ( x y - z )( y z + 2 x + z )( y z + x ) )";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            this.F = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            WordGroebnerBasePseudoSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            WordGroebnerBasePseudoSeqTest.fail((String)("" + iOException));
        }
        this.fac = new GenWordPolynomialRing(this.F.ring);
        this.L = this.fac.valueOf(this.F.list);
        this.G = this.bb.GB(this.L);
        WordGroebnerBasePseudoSeqTest.assertTrue((String)"isGB( G )", (boolean)this.bb.isGB(this.G));
    }
}

