/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.arith.BigInteger;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gbufd.SolvableGroebnerBasePseudoRecSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SolvableGroebnerBasePseudoRecSeqTest
extends TestCase {
    GenSolvablePolynomial<GenPolynomial<BigInteger>> a;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> b;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> c;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> d;
    GenSolvablePolynomial<GenPolynomial<BigInteger>> e;
    List<GenSolvablePolynomial<GenPolynomial<BigInteger>>> L;
    PolynomialList<GenPolynomial<BigInteger>> F;
    PolynomialList<GenPolynomial<BigInteger>> G;
    GenSolvablePolynomialRing<GenPolynomial<BigInteger>> ring;
    SolvableGroebnerBaseAbstract<GenPolynomial<BigInteger>> sbb;
    BigInteger cfac;
    TermOrder tord;
    int rl = 4;
    int kl = 2;
    int ll = 5;
    int el = 3;
    float q = 0.3f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)SolvableGroebnerBasePseudoRecSeqTest.suite());
        ComputerThreads.terminate();
    }

    public SolvableGroebnerBasePseudoRecSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableGroebnerBasePseudoRecSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigInteger(9L);
        this.tord = new TermOrder();
        String[] stringArray = new String[]{"a", "b"};
        String[] stringArray2 = new String[]{"x", "y"};
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(this.cfac, this.tord, stringArray);
        this.ring = new GenSolvablePolynomialRing<BigInteger>(genPolynomialRing, this.tord, stringArray2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.sbb = new SolvableGroebnerBasePseudoRecSeq<BigInteger>(genPolynomialRing);
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.d = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.e = this.d;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.ring = null;
        this.tord = null;
        this.cfac = null;
        this.sbb = null;
    }

    public void testSequentialGBase() {
        this.L = new ArrayList<GenSolvablePolynomial<GenPolynomial<BigInteger>>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testWeylSequentialGBase() {
        WeylRelations<GenPolynomial<BigInteger>> weylRelations = new WeylRelations<GenPolynomial<BigInteger>>();
        weylRelations.generate(this.ring);
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.d = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.e = this.d;
        this.L = new ArrayList<GenSolvablePolynomial<GenPolynomial<BigInteger>>>();
        this.L.add(this.a);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a, b } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a, b, c } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d } )", (boolean)this.sbb.isLeftGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.leftGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isLeftGB( { a, b, c, d, e } )", (boolean)this.sbb.isLeftGB(this.L));
    }

    public void testSequentialTSGBase() {
        this.L = new ArrayList<GenSolvablePolynomial<GenPolynomial<BigInteger>>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }

    public void testWeylSequentialTSGBase() {
        WeylRelations<GenPolynomial<BigInteger>> weylRelations = new WeylRelations<GenPolynomial<BigInteger>>();
        weylRelations.generate(this.ring);
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.d = this.ring.random(this.kl, this.ll - 1, this.el - 1, this.q);
        this.e = this.d;
        this.L = new ArrayList<GenSolvablePolynomial<GenPolynomial<BigInteger>>>();
        this.L.add(this.a);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.b);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a, b } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.c);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.d);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d } )", (boolean)this.sbb.isTwosidedGB(this.L));
        this.L.add(this.e);
        this.L = this.sbb.twosidedGB(this.L);
        SolvableGroebnerBasePseudoRecSeqTest.assertTrue((String)"isTwosidedGB( { a, b, c, d, e } )", (boolean)this.sbb.isTwosidedGB(this.L));
    }
}

