/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigQuaternion;
import edu.jas.arith.BigQuaternionInteger;
import edu.jas.arith.BigQuaternionRing;
import edu.jas.arith.BigRational;
import edu.jas.arith.PrimeInteger;
import java.math.BigInteger;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigQuaternionIntegerTest
extends TestCase {
    BigQuaternion a;
    BigQuaternion b;
    BigQuaternion c;
    BigQuaternion d;
    BigQuaternion e;
    BigQuaternion f;
    BigQuaternionRing fac;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BigQuaternionIntegerTest.suite());
    }

    public BigQuaternionIntegerTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(BigQuaternionIntegerTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new BigQuaternionRing(true);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
    }

    public void testConstants() {
        this.a = this.fac.getZERO();
        this.b = this.fac.getONE();
        this.c = this.b.subtract(this.b);
        BigQuaternionIntegerTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        BigQuaternionIntegerTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigQuaternionIntegerTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(0)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(1)", (boolean)this.b.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
    }

    public void testBitLength() {
        this.a = this.fac.ZERO;
        this.b = this.fac.ONE;
        this.c = this.fac.random(100);
        BigQuaternionIntegerTest.assertEquals((String)"len(0) = 12", (long)12L, (long)this.a.bitLength());
        BigQuaternionIntegerTest.assertEquals((String)"len(1) = 13", (long)13L, (long)this.b.bitLength());
        BigQuaternionIntegerTest.assertEquals((String)"len(-1) = 13", (long)13L, (long)this.b.negate().bitLength());
        BigQuaternionIntegerTest.assertTrue((String)"len(random) >= 12", (12L <= this.c.bitLength() ? 1 : 0) != 0);
        this.d = this.fac.I;
        BigQuaternionIntegerTest.assertEquals((String)"len(i) = 13", (long)13L, (long)this.d.bitLength());
        BigQuaternionIntegerTest.assertEquals((String)"len(-i) = 13", (long)13L, (long)this.d.negate().bitLength());
        this.d = this.fac.J;
        BigQuaternionIntegerTest.assertEquals((String)"len(j) = 13", (long)13L, (long)this.d.bitLength());
        BigQuaternionIntegerTest.assertEquals((String)"len(-j) = 13", (long)13L, (long)this.d.negate().bitLength());
        this.d = this.fac.K;
        BigQuaternionIntegerTest.assertEquals((String)"len(k) = 13", (long)13L, (long)this.d.bitLength());
        BigQuaternionIntegerTest.assertEquals((String)"len(-k) = 13", (long)13L, (long)this.d.negate().bitLength());
    }

    public void testConstructor() {
        this.a = new BigQuaternionInteger(this.fac, "6/8");
        this.b = new BigQuaternionInteger(this.fac, "3/4");
        BigQuaternionIntegerTest.assertEquals((String)"6/8 = 3/4", (Object)this.a, (Object)this.b);
        BigQuaternionIntegerTest.assertFalse((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertFalse((String)"isEntier(b)", (boolean)this.b.isEntier());
        this.a = new BigQuaternionInteger(this.fac, "3/4 i 4/5 j 1/5 k 2/5");
        this.b = new BigQuaternionInteger(this.fac, "-3/4 i -4/5 j -1/5 k -2/5");
        BigQuaternionIntegerTest.assertEquals((String)"3/4 + i 4/5 + j 1/5 + k 2/5", (Object)this.a, (Object)this.b.negate());
        BigQuaternionIntegerTest.assertFalse((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertFalse((String)"isEntier(b)", (boolean)this.b.isEntier());
        String string = "6/1111111111111111111111111111111111111111111";
        this.a = new BigQuaternionInteger(this.fac, string);
        String string2 = this.a.toString();
        BigQuaternionIntegerTest.assertFalse((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
        this.a = new BigQuaternionInteger(this.fac, 1L);
        this.b = new BigQuaternionInteger(this.fac, -1L);
        this.c = this.b.sum(this.a);
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(b)", (boolean)this.b.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigQuaternionIntegerTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)this.fac.ZERO);
    }

    public void testRandom() {
        this.a = this.fac.random(50);
        this.b = new BigQuaternionInteger(this.fac, this.a.getRe(), this.a.getIm(), this.a.getJm(), this.a.getKm());
        this.c = this.b.subtract(this.a);
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(b)", (boolean)this.b.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertEquals((String)"a-b = 0", (Object)this.fac.ZERO, (Object)this.c);
        this.d = new BigQuaternionInteger(this.fac, this.b);
        BigQuaternionIntegerTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(d)", (boolean)this.d.isEntier());
    }

    public void testAddition() {
        this.a = this.fac.random(10);
        this.b = this.a.sum(this.a);
        this.c = this.b.subtract(this.a);
        BigQuaternionIntegerTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        BigQuaternionIntegerTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(b)", (boolean)this.b.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
        this.d = this.a.sum(this.fac.ZERO);
        BigQuaternionIntegerTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.fac.ZERO);
        BigQuaternionIntegerTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.subtract(this.a);
        BigQuaternionIntegerTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)this.fac.ZERO);
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(d)", (boolean)this.d.isEntier());
    }

    public void testMultiplication() {
        this.a = this.fac.random(10);
        this.b = this.a.multiply(this.a);
        this.c = this.b.leftDivide(this.a);
        BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.fac, this.b);
        this.d = bigQuaternionInteger.leftDivide(this.a);
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(b)", (boolean)this.b.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(d)", (boolean)this.d.isEntier());
        BigQuaternionIntegerTest.assertEquals((String)"a*a/a = a", (Object)this.d, (Object)this.a);
        this.d = this.a.multiply(this.fac.ONE);
        BigQuaternionIntegerTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = this.a.divide(this.fac.ONE);
        BigQuaternionIntegerTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.b = this.a.norm();
        this.c = this.a.conjugate();
        this.d = this.a.multiply(this.c);
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertEquals((String)"abs(a)^2 = a a^", (Object)this.b, (Object)this.d);
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(b)", (boolean)this.b.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(d)", (boolean)this.d.isEntier());
    }

    public void testMultiplicationAxioms() {
        this.a = this.fac.random(10);
        this.b = this.fac.random(10);
        this.c = this.a.multiply(this.b);
        this.d = this.b.multiply(this.a);
        BigQuaternionIntegerTest.assertFalse((String)("a*b != b*a: " + this.c + ", " + this.d), (boolean)this.c.equals(this.d));
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(b)", (boolean)this.b.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(d)", (boolean)this.d.isEntier());
        this.c = this.fac.random(10);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        BigQuaternionIntegerTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.e.equals(this.d));
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(d)", (boolean)this.d.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(e)", (boolean)this.e.isEntier());
    }

    public void testDistributive() {
        this.a = this.fac.random(20);
        this.b = this.fac.random(20);
        this.c = this.fac.random(20);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigQuaternionIntegerTest.assertEquals((String)"a(b+c) = ab+ac", (Object)this.d, (Object)this.e);
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(a)", (boolean)this.a.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(b)", (boolean)this.b.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(c)", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(d)", (boolean)this.d.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"isEntier(e)", (boolean)this.e.isEntier());
    }

    public void testDivideEntier() {
        this.a = new BigQuaternionInteger(this.fac, "3 i 4 j 5 k 2");
        BigQuaternionIntegerTest.assertTrue((String)"a is entier", (boolean)this.a.isEntier());
        this.b = new BigQuaternionInteger(this.fac, "-3/2 i -5/2 j -1/2 k -7/2");
        BigQuaternionIntegerTest.assertTrue((String)"b is entier", (boolean)this.b.isEntier());
        this.c = this.a.multiply(this.a);
        BigQuaternionIntegerTest.assertTrue((String)"c is entier", (boolean)this.c.isEntier());
        this.c = this.b.multiply(this.b);
        BigQuaternionIntegerTest.assertTrue((String)"c is entier", (boolean)this.c.isEntier());
        this.c = this.a.multiply(this.b);
        BigQuaternionIntegerTest.assertTrue((String)"c is entier", (boolean)this.c.isEntier());
        this.c = this.b.multiply(this.a);
        BigQuaternionIntegerTest.assertTrue((String)"c is entier", (boolean)this.c.isEntier());
        this.d = this.a.norm();
        BigQuaternionIntegerTest.assertTrue((String)"d is entier", (boolean)this.d.isEntier());
        this.d = this.b.norm();
        BigQuaternionIntegerTest.assertTrue((String)"d is entier", (boolean)this.d.isEntier());
        BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.fac, this.a);
        BigQuaternionInteger bigQuaternionInteger2 = new BigQuaternionInteger(this.fac, this.b);
        BigQuaternion[] bigQuaternionArray = bigQuaternionInteger.leftQuotientAndRemainder(bigQuaternionInteger2);
        this.c = bigQuaternionArray[0];
        this.d = bigQuaternionArray[1];
        BigQuaternionIntegerTest.assertTrue((String)"c is entier", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"d is entier", (boolean)this.d.isEntier());
        BigQuaternionIntegerTest.assertEquals((String)"a == b * q + r: ", (Object)this.a, (Object)this.b.multiply(this.c).sum(this.d));
        BigQuaternionIntegerTest.assertTrue((String)"norm(r) < norm(b): ", (this.d.norm().re.compareTo(this.b.norm().re) < 0 ? 1 : 0) != 0);
        bigQuaternionArray = bigQuaternionInteger.rightQuotientAndRemainder(bigQuaternionInteger2);
        this.c = bigQuaternionArray[0];
        this.d = bigQuaternionArray[1];
        BigQuaternionIntegerTest.assertTrue((String)"c is entier", (boolean)this.c.isEntier());
        BigQuaternionIntegerTest.assertTrue((String)"d is entier", (boolean)this.d.isEntier());
        BigQuaternionIntegerTest.assertEquals((String)"a == q * b + r: ", (Object)this.a, (Object)this.c.multiply(this.b).sum(this.d));
        BigQuaternionIntegerTest.assertTrue((String)"norm(r) < norm(b): ", (this.d.norm().re.compareTo(this.b.norm().re) < 0 ? 1 : 0) != 0);
    }

    public void testGcdEntier() {
        this.a = this.fac.random(10);
        this.b = this.fac.random(10);
        BigQuaternionInteger bigQuaternionInteger = new BigQuaternionInteger(this.fac, this.a);
        BigQuaternionInteger bigQuaternionInteger2 = new BigQuaternionInteger(this.fac, this.b);
        BigQuaternion bigQuaternion = bigQuaternionInteger.leftGcd(bigQuaternionInteger2);
        BigQuaternionIntegerTest.assertTrue((String)"g is entier", (boolean)bigQuaternion.isEntier());
        BigQuaternion bigQuaternion2 = bigQuaternionInteger.leftQuotientAndRemainder(bigQuaternion)[1];
        BigQuaternionIntegerTest.assertTrue((String)"r == 0: ", (boolean)bigQuaternion2.isZERO());
        bigQuaternion2 = bigQuaternionInteger2.leftQuotientAndRemainder(bigQuaternion)[1];
        BigQuaternionIntegerTest.assertTrue((String)("r == 0: " + bigQuaternion2), (boolean)bigQuaternion2.isZERO());
        BigQuaternion bigQuaternion3 = bigQuaternionInteger.rightGcd(bigQuaternionInteger2);
        BigQuaternionIntegerTest.assertTrue((String)"h is entier", (boolean)bigQuaternion3.isEntier());
        bigQuaternion2 = bigQuaternionInteger.rightQuotientAndRemainder(bigQuaternion3)[1];
        BigQuaternionIntegerTest.assertTrue((String)"r == 0: ", (boolean)bigQuaternion2.isZERO());
        bigQuaternion2 = bigQuaternionInteger2.rightQuotientAndRemainder(bigQuaternion3)[1];
        BigQuaternionIntegerTest.assertTrue((String)"r == 0: ", (boolean)bigQuaternion2.isZERO());
        this.a = this.fac.random(20).roundToLipschitzian();
        this.b = this.a.norm();
        BigInteger bigInteger = this.b.re.floor();
        long l = bigInteger.longValue();
        SortedMap<Long, Integer> sortedMap = PrimeInteger.factors(l);
        for (Long l2 : sortedMap.keySet()) {
            this.c = new BigQuaternion(this.fac, new BigRational(l2));
            this.d = this.a.leftGcd(this.c);
            this.e = this.d.norm();
            BigQuaternionIntegerTest.assertTrue((String)("norm(gcd) == c: " + this.c + " : " + this.e), (this.c.equals(this.e) || this.c.equals(this.e.power(2L)) || ((BigQuaternion)this.c.power(2L)).equals(this.e) ? 1 : 0) != 0);
        }
    }
}

