/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.application.ColoredSystem;
import edu.jas.application.Condition;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OrderedPolynomialList;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerSystem<C extends GcdRingElem<C>> {
    private static final Logger logger = LogManager.getLogger(GroebnerSystem.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final List<ColoredSystem<C>> list;
    protected List<Condition<C>> conds;
    protected PolynomialList<GenPolynomial<C>> cgb;

    public GroebnerSystem(List<ColoredSystem<C>> list) {
        this.list = list;
        this.conds = null;
        this.cgb = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GroebnerSystem: \n");
        boolean bl = true;
        for (ColoredSystem<C> object : this.list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append(object.toString());
        }
        stringBuffer.append("Conditions:\n");
        bl = true;
        for (Condition condition : this.getConditions()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append(condition.toString());
        }
        stringBuffer.append("\n");
        if (this.cgb == null) {
            stringBuffer.append("Comprehensive Groebner Base not jet computed\n");
        } else {
            stringBuffer.append("Comprehensive Groebner Base:\n");
            bl = true;
            for (GenPolynomial genPolynomial : this.getCGB()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",\n");
                }
                stringBuffer.append(genPolynomial.toString());
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("GroebnerSystem: \n");
        boolean bl = true;
        for (ColoredSystem<C> object : this.list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append(object.toScript());
        }
        stringBuffer.append("Conditions:\n");
        bl = true;
        for (Condition condition : this.getConditions()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append(condition.toScript());
        }
        stringBuffer.append("\n");
        if (this.cgb == null) {
            stringBuffer.append("Comprehensive Groebner Base not jet computed\n");
        } else {
            stringBuffer.append("Comprehensive Groebner Base:\n");
            bl = true;
            for (GenPolynomial genPolynomial : this.getCGB()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",\n");
                }
                stringBuffer.append(genPolynomial.toScript());
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        GroebnerSystem groebnerSystem = null;
        try {
            groebnerSystem = (GroebnerSystem)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (groebnerSystem == null) {
            return false;
        }
        boolean bl = this.list.equals(groebnerSystem.list);
        return bl;
    }

    public int hashCode() {
        int n = this.list.hashCode();
        return n;
    }

    public boolean checkInvariant() {
        for (ColoredSystem<C> coloredSystem : this.list) {
            if (coloredSystem.checkInvariant()) continue;
            return false;
        }
        return true;
    }

    public boolean isDetermined() {
        for (ColoredSystem<C> coloredSystem : this.list) {
            if (coloredSystem.isDetermined()) continue;
            return false;
        }
        return true;
    }

    public List<Condition<C>> getConditions() {
        if (this.conds != null) {
            return this.conds;
        }
        ArrayList<Condition<C>> arrayList = new ArrayList<Condition<C>>(this.list.size());
        for (ColoredSystem<C> coloredSystem : this.list) {
            arrayList.add(coloredSystem.condition);
        }
        this.conds = arrayList;
        return this.conds;
    }

    /*
     * WARNING - void declaration
     */
    public List<GenPolynomial<GenPolynomial<C>>> getCGB() {
        void var4_7;
        if (this.cgb != null) {
            return this.cgb.list;
        }
        List<Condition<C>> list = this.getConditions();
        if (list.isEmpty()) {
            logger.info("unused is empty");
        }
        HashSet hashSet = new HashSet();
        for (ColoredSystem<C> object2 : this.list) {
            if (debug) {
                if (!object2.isDetermined()) {
                    System.out.println("not determined, cs = " + object2);
                }
                if (!object2.checkInvariant()) {
                    System.out.println("not invariant, cs = " + object2);
                }
            }
            for (ColorPolynomial colorPolynomial : object2.list) {
                GenPolynomial genPolynomial = colorPolynomial.getPolynomial();
                hashSet.add(genPolynomial);
            }
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Object var4_5 = null;
        if (arrayList.size() > 0) {
            GenPolynomialRing genPolynomialRing = ((GenPolynomial)arrayList.get((int)0)).ring;
        }
        this.cgb = new OrderedPolynomialList<GenPolynomial<C>>(var4_7, arrayList);
        return arrayList;
    }
}

