/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.ufd.PolyUfdUtil;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import edu.jas.vector.GenMatrix;
import edu.jas.vector.GenMatrixRing;
import edu.jas.vector.LinAlg;
import java.util.List;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class QuotientRatTest
extends TestCase {
    QuotientRing<BigRational> zFac;
    QuotientRing<BigRational> efac;
    GenPolynomialRing<BigRational> mfac;
    Quotient<BigRational> a;
    Quotient<BigRational> b;
    Quotient<BigRational> c;
    Quotient<BigRational> d;
    Quotient<BigRational> e;
    Quotient<BigRational> az;
    Quotient<BigRational> bz;
    Quotient<BigRational> cz;
    Quotient<BigRational> dz;
    Quotient<BigRational> ez;
    int rl = 3;
    int kl = 5;
    int ll = 3;
    int el = 2;
    float q = 0.4f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)QuotientRatTest.suite());
    }

    public QuotientRatTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(QuotientRatTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        TermOrder termOrder = new TermOrder(2);
        this.mfac = new GenPolynomialRing<BigRational>(new BigRational(1L), this.rl, termOrder);
        this.efac = new QuotientRing<BigRational>(this.mfac);
        this.zFac = new QuotientRing<BigRational>(this.mfac, false);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.efac = null;
        this.zFac = null;
        ComputerThreads.terminate();
    }

    public void testConstruction() {
        this.c = this.efac.getONE();
        QuotientRatTest.assertTrue((String)"length( c ) = 1", (this.c.num.length() == 1 ? 1 : 0) != 0);
        QuotientRatTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        QuotientRatTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.efac.getZERO();
        QuotientRatTest.assertTrue((String)"length( d ) = 0", (this.d.num.length() == 0 ? 1 : 0) != 0);
        QuotientRatTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        QuotientRatTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
    }

    public void testRandom() {
        for (int i = 0; i < 7; ++i) {
            this.a = this.efac.random(this.kl * (i + 1), this.ll + 2 + 2 * i, this.el, this.q);
            if (this.a.isZERO() || this.a.isONE()) continue;
            QuotientRatTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.num.length() >= 0 ? 1 : 0) != 0);
            QuotientRatTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            QuotientRatTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        this.d = this.d.monic();
        QuotientRatTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        QuotientRatTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        QuotientRatTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        this.c = this.a.sum((Quotient<BigRational>)this.efac.getZERO());
        this.d = this.a.subtract((Quotient<BigRational>)this.efac.getZERO());
        QuotientRatTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Quotient)this.efac.getZERO()).sum(this.a);
        this.d = ((Quotient)this.efac.getZERO()).subtract(this.a.negate());
        QuotientRatTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.e = this.d.subtract(this.c);
        QuotientRatTest.assertTrue((String)("isZERO( a*b-b*a ) " + this.e), (boolean)this.e.isZERO());
        QuotientRatTest.assertTrue((String)"a*b = b*a", (boolean)this.c.equals(this.d));
        QuotientRatTest.assertEquals((String)"a*b = b*a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        QuotientRatTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        QuotientRatTest.assertTrue((String)"a(bc) = (ab)c", (boolean)this.d.equals(this.e));
        this.c = this.a.multiply((BigRational)this.efac.getONE());
        this.d = ((Quotient)this.efac.getONE()).multiply(this.a);
        QuotientRatTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply((BigRational)((Object)this.a));
            QuotientRatTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }

    public void xtestAdditionGcd() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.az = new Quotient<BigRational>(this.zFac, this.a.num, this.a.den, true);
        this.bz = new Quotient<BigRational>(this.zFac, this.b.num, this.b.den, true);
        long l = System.currentTimeMillis();
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        this.d = this.d.monic();
        l = System.currentTimeMillis() - l;
        QuotientRatTest.assertEquals((String)"a+b-b = a", this.a, this.d);
        long l2 = System.currentTimeMillis();
        this.cz = this.az.sum(this.bz);
        this.dz = this.cz.subtract(this.bz);
        this.dz = this.dz.monic();
        l2 = System.currentTimeMillis() - l2;
        QuotientRatTest.assertEquals((String)"a+b-b = a", this.az, this.dz);
        System.out.println("te = " + l);
        System.out.println("tz = " + l2);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        QuotientRatTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.cz = new Quotient<BigRational>(this.zFac, this.c.num, this.c.den, true);
        l = System.currentTimeMillis();
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        l = System.currentTimeMillis() - l;
        QuotientRatTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
        l2 = System.currentTimeMillis();
        this.dz = this.cz.sum(this.az.sum(this.bz));
        this.ez = this.cz.sum(this.az).sum(this.bz);
        l2 = System.currentTimeMillis() - l2;
        QuotientRatTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.dz, this.ez);
        System.out.println("te = " + l);
        System.out.println("tz = " + l2);
        this.c = this.a.sum((Quotient<BigRational>)this.efac.getZERO());
        this.d = this.a.subtract((Quotient<BigRational>)this.efac.getZERO());
        QuotientRatTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((Quotient)this.efac.getZERO()).sum(this.a);
        this.d = ((Quotient)this.efac.getZERO()).subtract(this.a.negate());
        QuotientRatTest.assertEquals((String)"0+a = 0+(-a)", this.c, this.d);
    }

    public void testParse() {
        this.a = this.efac.random(this.kl * 2, this.ll * 2, this.el * 2, this.q * 2.0f);
        PrettyPrint.setPretty();
        String string = this.a.toString();
        this.b = this.efac.parse(string);
        QuotientRatTest.assertEquals((String)"parse(a.toSting()) = a", this.a, this.b);
    }

    public void testFactors() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.b.multiply((BigRational)((Object)this.b));
        this.c = this.a.multiply((BigRational)((Object)this.b));
        SortedMap sortedMap = PolyUfdUtil.factors(this.c);
        boolean bl = PolyUfdUtil.isFactorization(this.c, sortedMap);
        QuotientRatTest.assertTrue((String)("c == prod(factors): " + this.c + ", " + sortedMap), (boolean)bl);
    }

    public void testLinAlg() {
        BigRational bigRational = new BigRational(11L);
        GenPolynomialRing<BigRational> genPolynomialRing = new GenPolynomialRing<BigRational>(bigRational, new String[]{"a"});
        QuotientRing<BigRational> quotientRing = new QuotientRing<BigRational>(genPolynomialRing);
        Quotient<BigRational> quotient = new Quotient<BigRational>(quotientRing, genPolynomialRing.univariate(0));
        int n = 3;
        GenMatrixRing<BigRational> genMatrixRing = new GenMatrixRing<BigRational>(quotientRing, n, n);
        GenMatrixRing<BigRational> genMatrixRing2 = genMatrixRing.transpose();
        RingElem[][] ringElemArray = new Quotient[n][n];
        ringElemArray[0][0] = quotientRing.fromInteger(1L);
        ringElemArray[0][1] = quotient;
        ringElemArray[0][2] = quotientRing.fromInteger(2L);
        ringElemArray[1][0] = quotientRing.getZERO();
        ringElemArray[1][1] = quotientRing.fromInteger(1L);
        ringElemArray[1][2] = quotientRing.fromInteger(1L);
        ringElemArray[2][0] = quotientRing.fromInteger(-1L);
        ringElemArray[2][1] = quotientRing.fromInteger(1L);
        ringElemArray[2][2] = quotientRing.fromInteger(1L);
        GenMatrix genMatrix = new GenMatrix(genMatrixRing, ringElemArray);
        LinAlg linAlg = new LinAlg();
        GenMatrix genMatrix2 = linAlg.rowEchelonForm(genMatrix);
        long l = linAlg.rankRE(genMatrix2);
        GenMatrix genMatrix3 = linAlg.rowEchelonFormSparse(genMatrix2);
        QuotientRatTest.assertTrue((String)"rank1 == rank2: ", (linAlg.rankRE(genMatrix3) == l ? 1 : 0) != 0);
        genMatrix = new GenMatrix(genMatrixRing, ringElemArray);
        List<Integer> list = linAlg.decompositionLU(genMatrix);
        GenMatrix genMatrix4 = linAlg.inverseLU(genMatrix, list);
        GenMatrix genMatrix5 = new GenMatrix(genMatrixRing, ringElemArray);
        GenMatrix genMatrix6 = genMatrix5.multiply(genMatrix4);
        QuotientRatTest.assertTrue((String)"C*I == 1: ", (boolean)genMatrix6.isONE());
        GenMatrix genMatrix7 = genMatrix5.sum(genMatrix5);
        GenMatrix genMatrix8 = genMatrix.divide(genMatrix7);
        GenMatrix genMatrix9 = genMatrix.divideLeft(genMatrix7);
        QuotientRatTest.assertFalse((String)"C/A != A\\C: ", (boolean)genMatrix8.equals(genMatrix9));
    }
}

