/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gb.SolvableExtendedGB;
import edu.jas.gb.SolvableGroebnerBaseAbstract;
import edu.jas.gbufd.SolvablePseudoReduction;
import edu.jas.gbufd.SolvablePseudoReductionSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.GreatestCommonDivisorFake;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolvableGroebnerBasePseudoRecSeq<C extends GcdRingElem<C>>
extends SolvableGroebnerBaseAbstract<GenPolynomial<C>> {
    private static final Logger logger = LogManager.getLogger(SolvableGroebnerBasePseudoRecSeq.class);
    private static final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final SolvablePseudoReduction<C> sredRec;
    protected final SolvablePseudoReduction<GenPolynomial<C>> sred;
    protected final GenPolynomialRing<C> cofac;

    public SolvableGroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory) {
        this(ringFactory, new SolvablePseudoReductionSeq());
    }

    public SolvableGroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory, PairList<GenPolynomial<C>> pairList) {
        this(ringFactory, new SolvablePseudoReductionSeq(), pairList);
    }

    public SolvableGroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory, SolvablePseudoReduction<C> solvablePseudoReduction) {
        this(ringFactory, solvablePseudoReduction, new OrderedPairlist<GenPolynomial<C>>());
    }

    public SolvableGroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory, SolvablePseudoReduction<C> solvablePseudoReduction, PairList<GenPolynomial<C>> pairList) {
        super(solvablePseudoReduction, pairList);
        this.sred = solvablePseudoReduction;
        this.sredRec = solvablePseudoReduction;
        this.cofac = (GenPolynomialRing)ringFactory;
        if (!this.cofac.isCommutative()) {
            logger.warn("right reduction not correct for " + this.cofac.toScript());
            this.engine = new GreatestCommonDivisorFake();
        } else {
            this.engine = GCDFactory.getProxy(this.cofac.coFac);
        }
    }

    @Override
    public List<GenSolvablePolynomial<GenPolynomial<C>>> leftGB(int n, List<GenSolvablePolynomial<GenPolynomial<C>>> list) {
        List<GenSolvablePolynomial<GenPolynomial<C>>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(PolyUtil.monicRec(this.engine.recursivePrimitivePart(PolynomialList.castToList(list2))))).size() <= 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (genSolvablePolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        logger.info("leftGB start " + pairList);
        while (pairList.hasNext()) {
            GenSolvablePolynomial genSolvablePolynomial;
            GenSolvablePolynomial genSolvablePolynomial2;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)pair.pj;
            if (debug) {
                logger.debug("pi    = " + genSolvablePolynomial3);
                logger.debug("pj    = " + genSolvablePolynomial4);
            }
            if ((genSolvablePolynomial2 = this.sred.leftSPolynomial(genSolvablePolynomial3, genSolvablePolynomial4)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.info("ht(S) = " + genSolvablePolynomial2.leadingExpVector());
            }
            if ((genSolvablePolynomial = this.sredRec.leftNormalformRecursive(list2, genSolvablePolynomial2)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.info("ht(H) = " + genSolvablePolynomial.leadingExpVector() + ", #(H) = " + genSolvablePolynomial.length());
            }
            genSolvablePolynomial = (GenSolvablePolynomial)this.engine.recursivePrimitivePart(genSolvablePolynomial);
            if ((genSolvablePolynomial = PolyUtil.monic(genSolvablePolynomial)).isConstant()) {
                list2.clear();
                list2.add(genSolvablePolynomial);
                return list2;
            }
            if (debug) {
                logger.info("lc(pp(H)) = " + ((GenPolynomial)genSolvablePolynomial.leadingBaseCoefficient()).toScript());
            }
            if (genSolvablePolynomial.length() <= 0) continue;
            list2.add(genSolvablePolynomial);
            pairList.put(genSolvablePolynomial);
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("leftGB end  " + pairList);
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<GenPolynomial<C>>> leftMinimalGB(List<GenSolvablePolynomial<GenPolynomial<C>>> list) {
        GenSolvablePolynomial genSolvablePolynomial;
        List<GenSolvablePolynomial<GenPolynomial<C>>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        ArrayList arrayList = new ArrayList(list2.size());
        while (list2.size() > 0) {
            genSolvablePolynomial = list2.remove(0);
            if (this.sred.isTopReducible(list2, genSolvablePolynomial) || this.sred.isTopReducible(arrayList, genSolvablePolynomial)) {
                if (!debug) continue;
                System.out.println("dropped " + genSolvablePolynomial);
                ArrayList<GenSolvablePolynomial<GenPolynomial<C>>> arrayList2 = new ArrayList<GenSolvablePolynomial<GenPolynomial<C>>>(list2);
                arrayList2.addAll(arrayList);
                if ((genSolvablePolynomial = this.sredRec.leftNormalformRecursive(arrayList2, genSolvablePolynomial)).isZERO()) continue;
                System.out.println("error, nf(a) " + genSolvablePolynomial);
                continue;
            }
            arrayList.add(genSolvablePolynomial);
        }
        list2 = arrayList;
        if (list2.size() <= 1) {
            return list2;
        }
        Collections.reverse(list2);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            genSolvablePolynomial = list2.remove(0);
            genSolvablePolynomial = this.sredRec.leftNormalformRecursive(list2, genSolvablePolynomial);
            genSolvablePolynomial = (GenSolvablePolynomial)this.engine.recursivePrimitivePart(genSolvablePolynomial);
            genSolvablePolynomial = PolyUtil.monic(genSolvablePolynomial);
            list2.add(genSolvablePolynomial);
        }
        return list2;
    }

    @Override
    public List<GenSolvablePolynomial<GenPolynomial<C>>> twosidedGB(int n, List<GenSolvablePolynomial<GenPolynomial<C>>> list) {
        GenSolvablePolynomial genSolvablePolynomial;
        GenSolvablePolynomial genSolvablePolynomial2;
        List<GenSolvablePolynomial<GenPolynomial<C>>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = PolynomialList.castToSolvableList(PolyUtil.monicRec(this.engine.recursivePrimitivePart(PolynomialList.castToList(list2))))).size() < 1) {
            return list2;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list2.get((int)0).ring;
        if (genSolvablePolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        List list3 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators(n));
        logger.info("right multipliers = " + list3);
        ArrayList<GenSolvablePolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenSolvablePolynomial<GenPolynomial<C>>>(list2.size() * (1 + list3.size()));
        arrayList.addAll(list2);
        for (int i = 0; i < arrayList.size(); ++i) {
            genSolvablePolynomial2 = (GenSolvablePolynomial)arrayList.get(i);
            for (int j = 0; j < list3.size(); ++j) {
                genSolvablePolynomial = list3.get(j);
                if (genSolvablePolynomial.isONE()) continue;
                GenSolvablePolynomial genSolvablePolynomial3 = genSolvablePolynomial2.multiply(genSolvablePolynomial);
                if ((genSolvablePolynomial3 = this.sredRec.leftNormalformRecursive(arrayList, genSolvablePolynomial3)).isZERO()) continue;
                genSolvablePolynomial3 = (GenSolvablePolynomial)this.engine.recursivePrimitivePart(genSolvablePolynomial3);
                genSolvablePolynomial3 = PolyUtil.monic(genSolvablePolynomial3);
                arrayList.add(genSolvablePolynomial3);
            }
        }
        list2 = arrayList;
        PairList pairList = this.strategy.create(n, genSolvablePolynomialRing);
        pairList.put(PolynomialList.castToList(list2));
        logger.info("twosidedGB start " + pairList);
        while (pairList.hasNext()) {
            GenSolvablePolynomial genSolvablePolynomial4;
            GenSolvablePolynomial genSolvablePolynomial5;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenSolvablePolynomial genSolvablePolynomial6 = (GenSolvablePolynomial)pair.pi;
            GenSolvablePolynomial genSolvablePolynomial7 = (GenSolvablePolynomial)pair.pj;
            if (debug) {
                logger.debug("pi    = " + genSolvablePolynomial6);
                logger.debug("pj    = " + genSolvablePolynomial7);
            }
            if ((genSolvablePolynomial5 = this.sred.leftSPolynomial(genSolvablePolynomial6, genSolvablePolynomial7)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.info("ht(S) = " + genSolvablePolynomial5.leadingExpVector());
            }
            if ((genSolvablePolynomial4 = this.sredRec.leftNormalformRecursive(list2, genSolvablePolynomial5)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (debug) {
                logger.info("ht(H) = " + genSolvablePolynomial4.leadingExpVector());
            }
            genSolvablePolynomial4 = (GenSolvablePolynomial)this.engine.recursivePrimitivePart(genSolvablePolynomial4);
            if ((genSolvablePolynomial4 = PolyUtil.monic(genSolvablePolynomial4)).isONE()) {
                list2.clear();
                list2.add(genSolvablePolynomial4);
                return list2;
            }
            if (debug) {
                logger.info("lc(pp(H)) = " + genSolvablePolynomial4.leadingBaseCoefficient());
            }
            if (genSolvablePolynomial4.length() <= 0) continue;
            list2.add(genSolvablePolynomial4);
            pairList.put(genSolvablePolynomial4);
            for (int i = 0; i < list3.size(); ++i) {
                genSolvablePolynomial = list3.get(i);
                if (genSolvablePolynomial.isONE()) continue;
                genSolvablePolynomial2 = genSolvablePolynomial4.multiply(genSolvablePolynomial);
                if ((genSolvablePolynomial2 = this.sredRec.leftNormalformRecursive(list2, genSolvablePolynomial2)).isZERO()) continue;
                genSolvablePolynomial2 = (GenSolvablePolynomial)this.engine.recursivePrimitivePart(genSolvablePolynomial2);
                if ((genSolvablePolynomial2 = PolyUtil.monic(genSolvablePolynomial2)).isONE()) {
                    list2.clear();
                    list2.add(genSolvablePolynomial2);
                    return list2;
                }
                list2.add(genSolvablePolynomial2);
                pairList.put(genSolvablePolynomial2);
            }
        }
        logger.debug("#sequential list = " + list2.size());
        list2 = this.leftMinimalGB(list2);
        logger.info("twosidedGB end  " + pairList);
        return list2;
    }

    @Override
    public boolean isLeftGBsimple(int n, List<GenSolvablePolynomial<GenPolynomial<C>>> list) {
        for (int i = 0; i < list.size(); ++i) {
            GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2;
                GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3;
                GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial4 = list.get(j);
                if (!this.red.moduleCriterion(n, genSolvablePolynomial, genSolvablePolynomial4) || (genSolvablePolynomial3 = this.sred.leftSPolynomial(genSolvablePolynomial, genSolvablePolynomial4)).isZERO() || (genSolvablePolynomial2 = this.sredRec.leftNormalformRecursive(list, genSolvablePolynomial3)).isZERO()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isLeftGBidem(int n, List<GenSolvablePolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        PolynomialList polynomialList = new PolynomialList(genSolvablePolynomialRing, list);
        List list2 = this.leftGB(n, list);
        PolynomialList polynomialList2 = new PolynomialList(genSolvablePolynomialRing, list2);
        return polynomialList.compareTo(polynomialList2) == 0;
    }

    @Override
    public boolean isTwosidedGB(int n, List<GenSolvablePolynomial<GenPolynomial<C>>> list) {
        int n2;
        int n3;
        if (list == null || list.size() == 0) {
            return true;
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = list.get((int)0).ring;
        List list2 = PolynomialList.castToSolvableList(genSolvablePolynomialRing.generators());
        ArrayList arrayList = new ArrayList();
        for (GenSolvablePolynomial<Object> genSolvablePolynomial : list2) {
            if (!genSolvablePolynomial.isConstant()) continue;
            arrayList.add(genSolvablePolynomial);
        }
        list2 = arrayList;
        list2.addAll(genSolvablePolynomialRing.univariateList(n));
        logger.info("right multipliers = " + list2);
        ArrayList arrayList2 = new ArrayList(list.size() * (1 + list2.size()));
        arrayList2.addAll(list);
        for (n3 = 0; n3 < list.size(); ++n3) {
            GenSolvablePolynomial<Object> genSolvablePolynomial;
            genSolvablePolynomial = list.get(n3);
            for (n2 = 0; n2 < list2.size(); ++n2) {
                GenSolvablePolynomial genSolvablePolynomial2 = list2.get(n2);
                if (genSolvablePolynomial2.isONE()) continue;
                genSolvablePolynomial = genSolvablePolynomial.multiply((Object)genSolvablePolynomial2);
                if ((genSolvablePolynomial = this.sredRec.leftNormalformRecursive(arrayList2, genSolvablePolynomial)).isZERO()) continue;
                return false;
            }
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            GenSolvablePolynomial genSolvablePolynomial = (GenSolvablePolynomial)arrayList2.get(n3);
            for (n2 = n3 + 1; n2 < arrayList2.size(); ++n2) {
                GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial3;
                GenSolvablePolynomial genSolvablePolynomial4;
                GenSolvablePolynomial genSolvablePolynomial5 = (GenSolvablePolynomial)arrayList2.get(n2);
                if (!this.red.moduleCriterion(n, genSolvablePolynomial, genSolvablePolynomial5) || (genSolvablePolynomial4 = this.sred.leftSPolynomial(genSolvablePolynomial, genSolvablePolynomial5)).isZERO() || (genSolvablePolynomial3 = this.sredRec.leftNormalformRecursive(arrayList2, genSolvablePolynomial4)).isZERO()) continue;
                logger.info("is not TwosidedGB: " + genSolvablePolynomial3);
                return false;
            }
        }
        return true;
    }

    @Override
    public SolvableExtendedGB<GenPolynomial<C>> extLeftGB(int n, List<GenSolvablePolynomial<GenPolynomial<C>>> list) {
        throw new UnsupportedOperationException();
    }
}

