/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseSigSeqIter;
import edu.jas.gb.SigPair;
import edu.jas.gb.SigPoly;
import edu.jas.gb.SigReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GroebnerBaseF5zSigSeqIter<C extends RingElem<C>>
extends GroebnerBaseSigSeqIter<C> {
    private static final Logger logger = LogManager.getLogger(GroebnerBaseF5zSigSeqIter.class);

    public GroebnerBaseF5zSigSeqIter() {
        this(new SigReductionSeq());
    }

    public GroebnerBaseF5zSigSeqIter(SigReductionSeq<C> sigReductionSeq) {
        super(sigReductionSeq);
    }

    @Override
    SigPoly<C> sigNormalform(List<GenPolynomial<C>> list, List<SigPoly<C>> list2, SigPoly<C> sigPoly) {
        return this.sred.sigSemiNormalform(list, list2, sigPoly);
    }

    @Override
    List<SigPair<C>> pruneP(List<SigPair<C>> list, List<ExpVector> list2) {
        ArrayList<SigPair<C>> arrayList = new ArrayList<SigPair<C>>(list.size());
        for (SigPair<C> sigPair : list) {
            ExpVector expVector = sigPair.sigma.leadingExpVector();
            if (expVector == null) continue;
            boolean bl = false;
            for (ExpVector expVector2 : list2) {
                if (!expVector.multipleOf(expVector2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(sigPair);
        }
        return arrayList;
    }

    @Override
    List<SigPair<C>> pruneS(List<SigPair<C>> list, List<ExpVector> list2, List<SigPoly<C>> list3, List<SigPoly<C>> list4) {
        ArrayList<SigPair<C>> arrayList = new ArrayList<SigPair<C>>(list.size());
        for (SigPair<C> sigPair : list) {
            ExpVector expVector3;
            if (sigPair.sigma.isZERO()) continue;
            ExpVector expVector2 = sigPair.sigma.leadingExpVector();
            boolean bl = false;
            for (ExpVector expVector3 : list2) {
                if (!expVector2.multipleOf(expVector3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (sigPair.pi.sigma.isZERO()) {
                logger.info("pruneS, p.pi.sigma = 0");
                arrayList.add(sigPair);
                continue;
            }
            ExpVector expVector4 = sigPair.pi.poly.leadingExpVector();
            expVector3 = sigPair.pj.poly.leadingExpVector();
            ExpVector expVector5 = expVector4.lcm(expVector3).subtract(expVector4);
            expVector2 = sigPair.pi.sigma.leadingExpVector();
            expVector5 = expVector5.sum(expVector2);
            bl = false;
            for (SigPoly<C> sigPoly : list3) {
                ExpVector expVector6 = sigPoly.sigma.leadingExpVector();
                if (expVector6 == null || !expVector5.multipleOf(expVector6) || sigPoly.sigma.compareTo(sigPair.pi.sigma) <= 0) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(sigPair);
            logger.debug("added p = " + sigPair.sigma);
        }
        return arrayList;
    }

    @Override
    List<ExpVector> initializeSyz(List<GenPolynomial<C>> list, List<SigPoly<C>> list2) {
        ArrayList<ExpVector> arrayList = new ArrayList<ExpVector>();
        for (GenPolynomial<C> genPolynomial : list) {
            if (genPolynomial.isZERO()) continue;
            arrayList.add(genPolynomial.leadingExpVector());
        }
        return arrayList;
    }

    @Override
    void updateSyz(List<ExpVector> list, SigPoly<C> sigPoly) {
        if (sigPoly.poly.isZERO() && !sigPoly.sigma.isZERO()) {
            list.add(sigPoly.sigma.leadingExpVector());
        }
    }
}

