/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ColorPolynomial;
import edu.jas.application.Condition;
import edu.jas.application.OrderedCPairlist;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColoredSystem<C extends GcdRingElem<C>> {
    private static final Logger logger = LogManager.getLogger(ColoredSystem.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final Condition<C> condition;
    public final List<ColorPolynomial<C>> list;
    public final OrderedCPairlist<C> pairlist;

    public ColoredSystem(Condition<C> condition, List<ColorPolynomial<C>> list) {
        this(condition, list, null);
    }

    public ColoredSystem(Condition<C> condition, List<ColorPolynomial<C>> list, OrderedCPairlist<C> orderedCPairlist) {
        this.condition = condition;
        this.list = list;
        this.pairlist = orderedCPairlist;
    }

    public ColoredSystem<C> copy() {
        return new ColoredSystem<C>(this.condition, this.list, this.pairlist.copy());
    }

    public List<ColoredSystem<C>> addToList(List<ColoredSystem<C>> list) {
        ArrayList<ColoredSystem<C>> arrayList = new ArrayList<ColoredSystem<C>>(list.size() + 1);
        boolean bl = false;
        for (ColoredSystem<C> coloredSystem : list) {
            if (this.condition.equals(coloredSystem.condition) && this.list.equals(coloredSystem.list)) {
                logger.info("replaced system = " + coloredSystem.condition);
                arrayList.add(this);
                bl = true;
                continue;
            }
            arrayList.add(coloredSystem);
        }
        if (!bl) {
            arrayList.add(this);
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ColoredSystem: \n");
        if (this.list.size() > 0) {
            stringBuffer.append("polynomial ring : " + this.list.get((int)0).green.ring + "\n");
        } else {
            stringBuffer.append("parameter polynomial ring : " + this.condition.zero.getRing() + "\n");
        }
        stringBuffer.append("conditions == 0 : " + this.getConditionZero() + "\n");
        stringBuffer.append("conditions != 0 : " + this.getConditionNonZero() + "\n");
        if (debug) {
            stringBuffer.append("green coefficients:\n" + this.getGreenCoefficients() + "\n");
            stringBuffer.append("red coefficients:\n" + this.getRedCoefficients() + "\n");
        }
        stringBuffer.append("colored polynomials:\n" + this.list + "\n");
        stringBuffer.append("uncolored polynomials:\n" + this.getPolynomialList() + "\n");
        if (debug) {
            stringBuffer.append("essential polynomials:\n" + this.getEssentialPolynomialList() + "\n");
        }
        if (this.pairlist != null) {
            stringBuffer.append(this.pairlist.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("ColoredSystem: \n");
        if (this.list.size() > 0) {
            stringBuffer.append("polynomial ring : " + this.list.get((int)0).green.ring.toScript() + "\n");
        } else {
            stringBuffer.append("parameter polynomial ring : " + this.condition.zero.getRing().toScript() + "\n");
        }
        stringBuffer.append("conditions == 0 : " + this.getConditionZero().toString() + "\n");
        stringBuffer.append("conditions != 0 : " + this.getConditionNonZero().toString() + "\n");
        if (debug) {
            stringBuffer.append("green coefficients:\n" + this.getGreenCoefficients().toString() + "\n");
            stringBuffer.append("red coefficients:\n" + this.getRedCoefficients().toString() + "\n");
        }
        stringBuffer.append("colored polynomials:\n" + this.list + "\n");
        stringBuffer.append("uncolored polynomials:\n" + this.getPolynomialList() + "\n");
        if (debug) {
            stringBuffer.append("essential polynomials:\n" + this.getEssentialPolynomialList() + "\n");
        }
        if (this.pairlist != null) {
            stringBuffer.append(this.pairlist.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl;
        ColoredSystem coloredSystem = null;
        try {
            coloredSystem = (ColoredSystem)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (coloredSystem == null) {
            return false;
        }
        boolean bl2 = bl = this.condition.equals(coloredSystem.condition) && this.list.equals(coloredSystem.list);
        if (!bl) {
            return bl;
        }
        bl = this.pairlist.equals(coloredSystem.pairlist);
        if (!bl) {
            System.out.println("pairlists not equal " + this.pairlist + ", " + coloredSystem.pairlist);
        }
        return true;
    }

    public int hashCode() {
        int n = this.condition.hashCode();
        n <<= 17;
        return n += this.list.hashCode();
    }

    public List<GenPolynomial<C>> getConditionZero() {
        return this.condition.zero.getList();
    }

    public List<GenPolynomial<C>> getConditionNonZero() {
        return this.condition.nonZero.mset;
    }

    public List<GenPolynomial<C>> getRedCoefficients() {
        HashSet hashSet = new HashSet();
        for (ColorPolynomial<C> colorPolynomial : this.list) {
            hashSet.addAll(colorPolynomial.red.getMap().values());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        return arrayList;
    }

    public List<GenPolynomial<C>> getGreenCoefficients() {
        HashSet hashSet = new HashSet();
        for (ColorPolynomial<C> colorPolynomial : this.list) {
            hashSet.addAll(colorPolynomial.green.getMap().values());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        return arrayList;
    }

    public List<GenPolynomial<GenPolynomial<C>>> getPolynomialList() {
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        for (ColorPolynomial<C> colorPolynomial : this.list) {
            arrayList.add(colorPolynomial.getPolynomial());
        }
        return arrayList;
    }

    public List<GenPolynomial<GenPolynomial<C>>> getEssentialPolynomialList() {
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>();
        for (ColorPolynomial<C> colorPolynomial : this.list) {
            arrayList.add(colorPolynomial.getEssentialPolynomial());
        }
        return arrayList;
    }

    public boolean checkInvariant() {
        if (!this.isDetermined()) {
            return false;
        }
        if (!this.condition.isDetermined(this.list)) {
            return false;
        }
        for (ColorPolynomial<C> colorPolynomial : this.list) {
            if (!colorPolynomial.checkInvariant()) {
                System.out.println("notInvariant " + colorPolynomial);
                System.out.println("condition:   " + this.condition);
                return false;
            }
            for (GenPolynomial genPolynomial : colorPolynomial.green.getMap().values()) {
                if (this.condition.color(genPolynomial) == Condition.Color.GREEN) continue;
                System.out.println("notGreen   " + genPolynomial);
                System.out.println("condition: " + this.condition);
                System.out.println("colors:    " + colorPolynomial);
                return false;
            }
            for (GenPolynomial genPolynomial : colorPolynomial.red.getMap().values()) {
                if (this.condition.color(genPolynomial) == Condition.Color.RED) continue;
                System.out.println("notRed     " + genPolynomial);
                System.out.println("condition: " + this.condition);
                System.out.println("colors:    " + colorPolynomial);
                return false;
            }
            for (GenPolynomial genPolynomial : colorPolynomial.white.getMap().values()) {
                if (this.condition.color(genPolynomial) == Condition.Color.WHITE) continue;
            }
        }
        return true;
    }

    public boolean isDetermined() {
        for (ColorPolynomial<C> colorPolynomial : this.list) {
            if (colorPolynomial.isZERO()) continue;
            if (!colorPolynomial.isDetermined()) {
                System.out.println("not simple determined " + colorPolynomial);
                System.out.println("condition:            " + this.condition);
                return false;
            }
            if (this.condition.isDetermined(colorPolynomial)) continue;
            return false;
        }
        return true;
    }

    public ColoredSystem<C> reDetermine() {
        if (this.condition == null || this.condition.zero.isONE()) {
            return this;
        }
        ArrayList<ColorPolynomial<C>> arrayList = new ArrayList<ColorPolynomial<C>>(this.list.size());
        for (ColorPolynomial<C> colorPolynomial : this.list) {
            ColorPolynomial<C> colorPolynomial2 = this.condition.reDetermine(colorPolynomial);
            arrayList.add(colorPolynomial2);
        }
        return new ColoredSystem<C>(this.condition, arrayList, this.pairlist);
    }
}

