/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractListModel;
import userinterface.graph.Graph;
import userinterface.graph.SeriesSettings;

public class SeriesSettingsList
extends AbstractListModel
implements Observer {
    private Graph graph;
    private HashMap<Integer, Graph.SeriesKey> seriesKeys;

    public SeriesSettingsList(Graph graph) {
        this.graph = graph;
        this.seriesKeys = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getElementAt(int n) {
        Object object = this.graph.getSeriesLock();
        synchronized (object) {
            return this.graph.getGraphSeries(this.seriesKeys.get(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graph.SeriesKey getKeyAt(int n) {
        Object object = this.graph.getSeriesLock();
        synchronized (object) {
            return this.seriesKeys.get(n);
        }
    }

    @Override
    public int getSize() {
        return this.seriesKeys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSeriesList() {
        Object object = this.graph.getSeriesLock();
        synchronized (object) {
            for (Map.Entry<Integer, Graph.SeriesKey> entry : this.seriesKeys.entrySet()) {
                SeriesSettings seriesSettings = this.graph.getGraphSeries(entry.getValue());
                if (seriesSettings == null) continue;
                seriesSettings.deleteObserver(this);
            }
            this.seriesKeys.clear();
            for (Graph.SeriesKey seriesKey : this.graph.getAllSeriesKeys()) {
                this.seriesKeys.put(this.graph.getJFreeChartIndex(seriesKey), seriesKey);
                this.graph.getGraphSeries(seriesKey).updateSeries();
                this.graph.getGraphSeries(seriesKey).addObserver(this);
            }
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    @Override
    public void update(Observable observable, Object object) {
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

