/*
 * Decompiled with CFR 0.152.
 */
package symbolic.model;

import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import prism.PrismComponent;
import prism.PrismException;
import symbolic.comp.ECComputer;
import symbolic.model.ModelTransformation;
import symbolic.model.NondetModel;
import symbolic.model.NondetModelTransformationOperator;
import symbolic.states.StateValues;
import symbolic.states.StateValuesMTBDD;

public class MDPQuotient
implements ModelTransformation<NondetModel, NondetModel> {
    private NondetModel originalModel;
    private NondetModel transformedModel;
    private MDPQuotientOperator transform;
    private JDDNode transformedStatesOfInterest;

    private MDPQuotient(NondetModel nondetModel, NondetModel nondetModel2, MDPQuotientOperator mDPQuotientOperator, JDDNode jDDNode) {
        this.originalModel = nondetModel;
        this.transformedModel = nondetModel2;
        this.transform = mDPQuotientOperator;
        this.transformedStatesOfInterest = jDDNode;
    }

    @Override
    public NondetModel getOriginalModel() {
        return this.originalModel;
    }

    @Override
    public NondetModel getTransformedModel() {
        return this.transformedModel;
    }

    @Override
    public void clear() {
        this.transformedModel.clear();
        this.transform.clear();
        JDD.Deref(this.transformedStatesOfInterest);
    }

    @Override
    public StateValues projectToOriginalModel(StateValues stateValues) throws PrismException {
        StateValuesMTBDD stateValuesMTBDD = stateValues.convertToStateValuesMTBDD();
        JDDNode jDDNode = stateValuesMTBDD.getJDDNode().copy();
        stateValuesMTBDD.clear();
        jDDNode = this.transform.liftFromRepresentatives(jDDNode);
        return new StateValuesMTBDD(jDDNode, this.transform.originalModel);
    }

    public JDDNode mapStateSetToQuotient(JDDNode jDDNode) {
        return this.transform.mapStateSet(jDDNode);
    }

    @Override
    public JDDNode getTransformedStatesOfInterest() {
        return this.transformedStatesOfInterest;
    }

    public static MDPQuotient mecQuotient(PrismComponent prismComponent, NondetModel nondetModel, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        ECComputer eCComputer = ECComputer.createECComputer(prismComponent, nondetModel);
        eCComputer.computeMECStates(jDDNode);
        JDD.Deref(jDDNode);
        return MDPQuotient.transform(prismComponent, nondetModel, eCComputer.getMECStates(), jDDNode2);
    }

    public static MDPQuotient transform(PrismComponent prismComponent, NondetModel nondetModel, List<JDDNode> list, JDDNode jDDNode) throws PrismException {
        MDPQuotientOperator mDPQuotientOperator = new MDPQuotientOperator(prismComponent, nondetModel, list);
        JDDNode jDDNode2 = mDPQuotientOperator.mapStateSet(jDDNode);
        NondetModel nondetModel2 = nondetModel.getTransformed(mDPQuotientOperator);
        return new MDPQuotient(nondetModel, nondetModel2, mDPQuotientOperator, jDDNode2);
    }

    public static class MDPQuotientOperator
    extends NondetModelTransformationOperator {
        private List<JDDNode> equivalentClasses;
        private JDDNode map;
        private JDDNode inEC;
        private JDDNode notInEC;
        private JDDNode representatives = JDD.Constant(0.0);
        private JDDVars actFromStates;
        private JDDNode stateActionsInsideECs;
        private JDDNode newTrans;
        private JDDNode newTrans01;
        private JDDNode ecRemainingSelfLoops = JDD.Constant(0.0);
        private boolean computed = false;
        private PrismComponent parent;
        private boolean verbose = false;

        public MDPQuotientOperator(PrismComponent prismComponent, NondetModel nondetModel, List<JDDNode> list) {
            super(nondetModel);
            this.equivalentClasses = list;
            this.parent = prismComponent;
            this.map = JDD.Constant(0.0);
            this.inEC = JDD.Constant(0.0);
            this.stateActionsInsideECs = JDD.Constant(0.0);
            for (JDDNode jDDNode : list) {
                JDDNode jDDNode2 = JDD.RestrictToFirst(jDDNode.copy(), nondetModel.getAllDDRowVars());
                this.map = JDD.Or(this.map, JDD.And(jDDNode.copy(), JDD.PermuteVariables(jDDNode2.copy(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars())));
                this.inEC = JDD.Or(this.inEC, jDDNode.copy());
                this.representatives = JDD.Or(this.representatives, jDDNode2);
                JDDNode jDDNode3 = JDD.PermuteVariables(jDDNode.copy(), nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars());
                JDDNode jDDNode4 = JDD.And(jDDNode.copy(), nondetModel.getTrans01().copy());
                JDDNode jDDNode5 = JDD.Times(jDDNode4.copy(), jDDNode3.copy());
                if (this.verbose) {
                    JDD.PrintMinterms(prismComponent.getLog(), jDDNode5.copy(), "selfLoop");
                }
                JDDNode jDDNode6 = JDD.ThereExists(jDDNode5, this.originalModel.getAllDDColVars());
                if (this.verbose) {
                    JDD.PrintMinterms(prismComponent.getLog(), jDDNode6.copy(), "stateActionWithSelfLoop");
                }
                JDDNode jDDNode7 = JDD.And(jDDNode6.copy(), jDDNode4.copy());
                if (this.verbose) {
                    JDD.PrintMinterms(prismComponent.getLog(), jDDNode7.copy(), "stateActionElse");
                }
                jDDNode7 = JDD.And(jDDNode7, JDD.Not(jDDNode3.copy()));
                if (this.verbose) {
                    JDD.PrintMinterms(prismComponent.getLog(), jDDNode7.copy(), "stateActionElse (2)");
                }
                jDDNode7 = JDD.ThereExists(jDDNode7, this.originalModel.getAllDDColVars());
                if (this.verbose) {
                    JDD.PrintMinterms(prismComponent.getLog(), jDDNode7.copy(), "stateActionElse (3)");
                }
                JDDNode jDDNode8 = JDD.And(jDDNode6, JDD.Not(jDDNode7));
                if (this.verbose) {
                    JDD.PrintMinterms(prismComponent.getLog(), jDDNode8.copy(), "stateActionOnlySelfLoop");
                }
                this.stateActionsInsideECs = JDD.Or(this.stateActionsInsideECs, jDDNode8);
                JDD.Deref(jDDNode3, jDDNode4);
            }
            this.notInEC = JDD.And(nondetModel.getReach().copy(), JDD.Not(this.inEC.copy()));
            this.map = JDD.ITE(this.notInEC.copy(), JDD.Identity(nondetModel.getAllDDRowVars(), nondetModel.getAllDDColVars()), this.map);
        }

        @Override
        public void clear() {
            for (JDDNode jDDNode : this.equivalentClasses) {
                JDD.Deref(jDDNode);
            }
            JDD.Deref(this.map);
            JDD.Deref(this.inEC);
            JDD.Deref(this.notInEC);
            JDD.Deref(this.representatives);
            JDD.Deref(this.stateActionsInsideECs);
            JDD.Deref(this.ecRemainingSelfLoops);
            if (this.newTrans != null) {
                JDD.Deref(this.newTrans);
            }
            if (this.newTrans01 != null) {
                JDD.Deref(this.newTrans01);
            }
            if (this.actFromStates != null) {
                this.actFromStates.derefAll();
            }
            super.clear();
        }

        @Override
        public int getExtraStateVariableCount() {
            return 0;
        }

        @Override
        public int getExtraActionVariableCount() {
            return this.originalModel.getNumDDRowVars() + 1;
        }

        @Override
        public void hookExtraActionVariableAllocation(JDDVars jDDVars) {
            super.hookExtraActionVariableAllocation(jDDVars);
            this.actFromStates = new JDDVars();
            for (int i = 1; i < jDDVars.n(); ++i) {
                this.actFromStates.addVar(jDDVars.getVar(i).copy());
            }
        }

        public JDDNode getTauVar() {
            return this.extraActionVars.getVar(0).copy();
        }

        public JDDNode tau() {
            return this.getTauVar();
        }

        public JDDNode notTau() {
            JDDNode jDDNode = JDD.Not(this.getTauVar());
            jDDNode = JDD.And(jDDNode, this.actFromStates.allZero());
            return jDDNode;
        }

        private void compute() throws PrismException {
            JDDNode jDDNode;
            JDDNode jDDNode2;
            JDDNode jDDNode3;
            JDDNode jDDNode4;
            JDDNode jDDNode5 = this.originalModel.getTrans().copy();
            if (this.verbose) {
                this.parent.getLog().println("Collapsing target states");
            }
            for (JDDNode jDDNode6 : this.equivalentClasses) {
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode5.copy(), "trans");
                }
                jDDNode4 = JDD.PermuteVariables(jDDNode6.copy(), this.originalModel.getAllDDRowVars(), this.originalModel.getAllDDColVars());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode6.copy(), "EC");
                }
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode4.copy(), "EC'");
                }
                jDDNode3 = JDD.RestrictToFirst(jDDNode6.copy(), this.originalModel.getAllDDRowVars());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode3.copy(), "rep");
                }
                jDDNode2 = JDD.PermuteVariables(jDDNode3.copy(), this.originalModel.getAllDDRowVars(), this.originalModel.getAllDDColVars());
                jDDNode = JDD.Times(jDDNode5.copy(), jDDNode4.copy());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "transToEC");
                }
                jDDNode = JDD.SumAbstract(jDDNode, this.originalModel.getAllDDColVars());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "transToEC (2)");
                }
                jDDNode = JDD.Times(jDDNode, jDDNode2.copy());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "transToEC (3)");
                }
                jDDNode5 = JDD.ITE(jDDNode4, jDDNode, jDDNode5);
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode5.copy(), "trans''");
                }
                JDD.Deref(jDDNode3, jDDNode2);
            }
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode5.copy(), "trans (after collapsing target states)");
            }
            this.newTrans = JDD.Constant(0.0);
            if (this.verbose) {
                this.parent.getLog().println("\nCollapsing from states");
            }
            for (JDDNode jDDNode6 : this.equivalentClasses) {
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode6.copy(), "EC");
                }
                jDDNode4 = JDD.RestrictToFirst(jDDNode6.copy(), this.originalModel.getAllDDRowVars());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode4.copy(), "rep");
                }
                jDDNode3 = JDD.PermuteVariables(jDDNode4.copy(), this.originalModel.getAllDDRowVars(), this.originalModel.getAllDDColVars());
                jDDNode2 = JDD.Times(jDDNode6.copy(), jDDNode5.copy());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "transFromEC");
                }
                jDDNode2 = JDD.PermuteVariables(jDDNode2, this.originalModel.getAllDDRowVars(), this.actFromStates);
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "transFromEC (2)");
                }
                jDDNode2 = JDD.Times(this.tau(), jDDNode4.copy(), jDDNode2);
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "transFromEC (3)");
                }
                jDDNode = JDD.GreaterThan(jDDNode2.copy(), 0.0);
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "transFromEC01");
                }
                JDDNode jDDNode7 = JDD.Times(jDDNode.copy(), jDDNode3.copy());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode7.copy(), "selfLoop");
                }
                JDDNode jDDNode8 = JDD.ThereExists(jDDNode7, this.originalModel.getAllDDColVars());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode8.copy(), "stateActionWithSelfLoop");
                }
                JDDNode jDDNode9 = JDD.And(jDDNode8.copy(), jDDNode.copy());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode9.copy(), "stateActionElse");
                }
                jDDNode9 = JDD.And(jDDNode9, JDD.Not(jDDNode3.copy()));
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode9.copy(), "stateActionElse (2)");
                }
                jDDNode9 = JDD.ThereExists(jDDNode9, this.originalModel.getAllDDColVars());
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode9.copy(), "stateActionElse (3)");
                }
                JDDNode jDDNode10 = JDD.And(jDDNode8, JDD.Not(jDDNode9));
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode10.copy(), "stateActionOnlySelfLoop");
                }
                JDDNode jDDNode11 = JDD.Times(jDDNode, JDD.Not(jDDNode10.copy()));
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode11.copy(), "trans01Removed");
                }
                JDDNode jDDNode12 = JDD.ThereExists(jDDNode11, this.originalModel.getAllDDColVars());
                jDDNode12 = JDD.ThereExists(jDDNode12, this.originalModel.getAllDDNondetVars());
                jDDNode12 = JDD.ThereExists(jDDNode12, this.extraActionVars);
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode12.copy(), "notDeadlocked");
                }
                JDDNode jDDNode13 = JDD.And(jDDNode10.copy(), jDDNode12);
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode13.copy(), "stateActionsToRemove");
                }
                jDDNode2 = JDD.Times(jDDNode2, JDD.Not(jDDNode13.copy()));
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "transFromEC");
                }
                JDDNode jDDNode14 = JDD.And(jDDNode10, JDD.Not(jDDNode13));
                this.ecRemainingSelfLoops = JDD.Or(this.ecRemainingSelfLoops, jDDNode14);
                this.newTrans = JDD.Apply(6, this.newTrans, jDDNode2);
                if (this.verbose) {
                    JDD.PrintMinterms(this.parent.getLog(), this.newTrans.copy(), "newTrans");
                }
                JDD.Deref(jDDNode4, jDDNode3);
            }
            Object object = JDD.Times(jDDNode5.copy(), this.notInEC.copy());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), ((JDDNode)object).copy(), "transUntouched");
            }
            object = JDD.Times((JDDNode)object, this.notTau());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), ((JDDNode)object).copy(), "transUntouched (2)");
            }
            this.newTrans = JDD.Apply(6, this.newTrans, (JDDNode)object);
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), this.newTrans.copy(), "newTrans");
            }
            this.newTrans01 = JDD.GreaterThan(this.newTrans.copy(), 0.0);
            JDD.Deref(jDDNode5);
            this.computed = true;
        }

        public JDDNode mapStateSet(JDDNode jDDNode) {
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "S");
            }
            JDDNode jDDNode2 = JDD.And(jDDNode, this.map.copy());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "mapped");
            }
            jDDNode2 = JDD.ThereExists(jDDNode2, this.originalModel.getAllDDRowVars());
            jDDNode2 = JDD.PermuteVariables(jDDNode2, this.originalModel.getAllDDColVars(), this.originalModel.getAllDDRowVars());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "mapped (result)");
            }
            return jDDNode2;
        }

        @Override
        public JDDNode getTransformedTrans() throws PrismException {
            if (!this.computed) {
                this.compute();
            }
            return this.newTrans.copy();
        }

        @Override
        public JDDNode getTransformedStart() throws PrismException {
            return this.mapStateSet(this.originalModel.getStart().copy());
        }

        @Override
        public JDDNode getTransformedStateReward(JDDNode jDDNode) throws PrismException {
            if (!this.computed) {
                this.compute();
            }
            if (SanityJDD.enabled) {
                SanityJDD.checkIsDDOverVars(jDDNode, this.originalModel.getAllDDRowVars());
            }
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "state rew");
            }
            JDDNode jDDNode2 = JDD.Times(jDDNode.copy(), JDD.Not(this.inEC.copy()));
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "state rew (transformed)");
            }
            return jDDNode2;
        }

        @Override
        public JDDNode getTransformedTransReward(JDDNode jDDNode) throws PrismException {
            if (!this.computed) {
                this.compute();
            }
            if (SanityJDD.enabled) {
                SanityJDD.checkIsDDOverVars(jDDNode, this.originalModel.getAllDDRowVars(), this.originalModel.getAllDDNondetVars(), this.originalModel.getAllDDColVars());
            }
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "trans rew");
            }
            JDDNode jDDNode2 = JDD.Times(jDDNode.copy(), this.inEC.copy());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "rewFromEC (1)");
            }
            jDDNode2 = JDD.PermuteVariables(jDDNode2, this.originalModel.getAllDDRowVars(), this.actFromStates);
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "rewFromEC (2)");
            }
            jDDNode2 = JDD.Times(this.tau(), jDDNode2);
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "rewFromEC (3)");
            }
            jDDNode2 = JDD.PermuteVariables(jDDNode2, this.originalModel.getAllDDColVars(), this.originalModel.getAllDDRowVars());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "rewFromEC (4)");
            }
            jDDNode2 = JDD.Times(jDDNode2, this.map.copy());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "rewFromEC (5)");
            }
            jDDNode2 = JDD.SumAbstract(jDDNode2, this.originalModel.getAllDDRowVars());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "rewFromEC (6)");
            }
            jDDNode2 = JDD.Times(jDDNode2, this.newTrans01.copy());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "rewFromEC (7)");
            }
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), this.ecRemainingSelfLoops.copy(), "ecRemainingSelfLoops");
            }
            jDDNode2 = JDD.Times(jDDNode2, JDD.Not(this.ecRemainingSelfLoops.copy()));
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "rewFromEC (8)");
            }
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "trans rew");
            }
            JDDNode jDDNode3 = JDD.Apply(6, JDD.Times(this.notTau(), jDDNode.copy()), jDDNode2);
            jDDNode3 = JDD.Times(jDDNode3, this.newTrans01.copy());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode3.copy(), "transformedRew");
            }
            return jDDNode3;
        }

        @Override
        public JDDNode getTransformedTransActions() {
            if (this.originalModel.getTransActions() == null) {
                return null;
            }
            JDDNode jDDNode = this.originalModel.getTransActions().copy();
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "transActionsNormal (1)");
            }
            jDDNode = JDD.Times(jDDNode, this.notTau());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode.copy(), "transActionsNormal (2)");
            }
            JDDNode jDDNode2 = this.originalModel.getTransActions().copy();
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "transActionsFromEC (1)");
            }
            jDDNode2 = JDD.PermuteVariables(jDDNode2, this.originalModel.getAllDDRowVars(), this.actFromStates);
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "transActionsFromEC (2)");
            }
            jDDNode2 = JDD.Times(jDDNode2, this.tau());
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode2.copy(), "transActionsFromEC (3)");
            }
            JDDNode jDDNode3 = JDD.Apply(6, jDDNode, jDDNode2);
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode3.copy(), "transformedTransActions");
            }
            jDDNode3 = JDD.Times(jDDNode3, JDD.ThereExists(this.newTrans01.copy(), this.originalModel.getAllDDColVars()));
            if (this.verbose) {
                JDD.PrintMinterms(this.parent.getLog(), jDDNode3.copy(), "transformedTransActions");
            }
            return jDDNode3;
        }

        @Override
        public JDDNode getTransformedLabelStates(JDDNode jDDNode, JDDNode jDDNode2) {
            return JDD.Constant(0.0);
        }

        @Override
        public JDDNode getReachableStates() {
            JDDNode jDDNode = JDD.And(this.inEC.copy(), JDD.Not(this.representatives.copy()));
            JDDNode jDDNode2 = JDD.And(this.originalModel.getReach().copy(), JDD.Not(jDDNode));
            return jDDNode2;
        }

        public JDDNode liftFromRepresentatives(JDDNode jDDNode) {
            JDDNode jDDNode2 = JDD.PermuteVariables(jDDNode, this.originalModel.getAllDDRowVars(), this.originalModel.getAllDDColVars());
            jDDNode2 = JDD.Times(jDDNode2, this.map.copy());
            jDDNode2 = JDD.SumAbstract(jDDNode2, this.originalModel.getAllDDColVars());
            return jDDNode2;
        }
    }
}

