/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.io.FileNotFoundException;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.Result;

public class PrismTest {
    public static void main(String[] stringArray) {
        new PrismTest().go(stringArray);
    }

    public void go(String[] stringArray) {
        try {
            PrismFileLog prismFileLog = new PrismFileLog("stdout");
            Prism prism = new Prism(prismFileLog);
            prism.initialise();
            ModulesFile modulesFile = prism.parseModelFile(new File(stringArray[0]));
            prism.loadPRISMModel(modulesFile);
            PropertiesFile propertiesFile = prism.parsePropertiesString("P=?[F<=0.1 s1=1]");
            Result result = prism.modelCheck(propertiesFile, propertiesFile.getPropertyObject(0));
            System.out.println(result.getResult());
            propertiesFile = prism.parsePropertiesString("P=?[F<=0.1 s1=1]");
            result = prism.modelCheck(propertiesFile, propertiesFile.getPropertyObject(0));
            System.out.println(result.getResult());
            modulesFile = prism.parseModelFile(new File(stringArray[1]));
            prism.loadPRISMModel(modulesFile);
            propertiesFile = prism.parsePropertiesString("P=?[F<=0.1 s1=1]");
            result = prism.modelCheck(propertiesFile, propertiesFile.getPropertyObject(0));
            System.out.println(result.getResult());
            prism.closeDown();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: " + fileNotFoundException.getMessage());
            System.exit(1);
        }
        catch (PrismException prismException) {
            System.out.println("Error: " + prismException.getMessage());
            System.exit(1);
        }
    }
}

