/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import parser.EvaluateContext;
import parser.EvaluateContextState;
import parser.EvaluateContextSubstate;
import parser.State;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.ast.UpdateElement;
import parser.ast.Updates;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class Update
extends ASTElement
implements Iterable<UpdateElement> {
    private ArrayList<UpdateElement> elements = new ArrayList();
    private Updates parent;

    public void addElement(ExpressionIdent expressionIdent, Expression expression) {
        this.elements.add(new UpdateElement(expressionIdent, expression));
    }

    public void addElement(UpdateElement updateElement) {
        this.elements.add(updateElement);
    }

    public void setElement(int n, UpdateElement updateElement) {
        this.elements.set(n, updateElement);
    }

    public void setVar(int n, ExpressionIdent expressionIdent) {
        this.elements.get(n).setVarIdent(expressionIdent);
    }

    public void setExpression(int n, Expression expression) {
        this.elements.get(n).setExpression(expression);
    }

    public void setType(int n, Type type) {
        this.elements.get(n).setType(type);
    }

    public void setVarIndex(int n, int n2) {
        this.elements.get(n).setVarIndex(n2);
    }

    public void setParent(Updates updates) {
        this.parent = updates;
    }

    public int getNumElements() {
        return this.elements.size();
    }

    public UpdateElement getElement(int n) {
        return this.elements.get(n);
    }

    public String getVar(int n) {
        return this.elements.get(n).getVar();
    }

    public Expression getExpression(int n) {
        return this.elements.get(n).getExpression();
    }

    public Type getType(int n) {
        return this.elements.get(n).getType();
    }

    public ExpressionIdent getVarIdent(int n) {
        return this.elements.get(n).getVarIdent();
    }

    public int getVarIndex(int n) {
        return this.elements.get(n).getVarIndex();
    }

    public Updates getParent() {
        return this.parent;
    }

    public void update(State state, State state2, boolean bl, VarList varList) throws PrismLangException {
        EvaluateContextState evaluateContextState = new EvaluateContextState(state);
        evaluateContextState.setEvaluationMode(bl ? EvaluateContext.EvalMode.EXACT : EvaluateContext.EvalMode.FP);
        for (UpdateElement updateElement : this) {
            updateElement.update(evaluateContextState, state2, varList);
        }
    }

    public void updatePartially(State state, State state2, int[] nArray) throws PrismLangException {
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[this.getVarIndex(i)];
            if (n2 == -1) continue;
            state2.setValue(n2, this.getExpression(i).evaluate(new EvaluateContextSubstate(state, nArray)));
        }
    }

    public State checkUpdate(State state, VarList varList) throws PrismLangException {
        State state2 = new State(state);
        for (UpdateElement updateElement : this) {
            updateElement.checkUpdate(state, varList);
        }
        return state2;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public Update deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.elements);
        return this;
    }

    @Override
    public Update clone() {
        Update update = (Update)super.clone();
        update.elements = (ArrayList)this.elements.clone();
        return update;
    }

    @Override
    public Iterator<UpdateElement> iterator() {
        return this.elements.iterator();
    }

    @Override
    public String toString() {
        if (this.elements.size() > 0) {
            return this.elements.stream().map(UpdateElement::toString).collect(Collectors.joining(" & "));
        }
        return "true";
    }
}

