/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionUnaryOp;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionTemporal
extends Expression {
    public static final int P_X = 1;
    public static final int P_U = 2;
    public static final int P_F = 3;
    public static final int P_G = 4;
    public static final int P_W = 5;
    public static final int P_R = 6;
    public static final int R_C = 11;
    public static final int R_I = 12;
    public static final int R_F = 13;
    public static final int R_S = 14;
    public static final String[] opSymbols = new String[]{"", "X", "U", "F", "G", "W", "R", "", "", "", "", "C", "I", "F", "S"};
    protected int op = 0;
    protected Expression operand1 = null;
    protected Expression operand2 = null;
    protected Expression lBound = null;
    protected Expression uBound = null;
    protected boolean lBoundStrict = false;
    protected boolean uBoundStrict = false;
    protected boolean equals = false;

    public ExpressionTemporal() {
    }

    public ExpressionTemporal(int n, Expression expression, Expression expression2) {
        this.op = n;
        this.operand1 = expression;
        this.operand2 = expression2;
    }

    public void setOperator(int n) {
        this.op = n;
    }

    public void setOperand1(Expression expression) {
        this.operand1 = expression;
    }

    public void setOperand2(Expression expression) {
        this.operand2 = expression;
    }

    public void setLowerBound(Expression expression) {
        this.setLowerBound(expression, false);
    }

    public void setLowerBound(Expression expression, boolean bl) {
        this.lBound = expression;
        this.lBoundStrict = bl;
    }

    public void setUpperBound(Expression expression) {
        this.setUpperBound(expression, false);
    }

    public void setUpperBound(Expression expression, boolean bl) {
        this.uBound = expression;
        this.uBoundStrict = bl;
    }

    public void setEqualBounds(Expression expression) {
        this.lBound = expression;
        this.lBoundStrict = false;
        this.uBound = expression;
        this.uBoundStrict = false;
        this.equals = true;
    }

    public void setBoundsFrom(ExpressionTemporal expressionTemporal) {
        this.setLowerBound(expressionTemporal.getLowerBound(), expressionTemporal.lowerBoundIsStrict());
        this.setUpperBound(expressionTemporal.getUpperBound(), expressionTemporal.upperBoundIsStrict());
        this.equals = expressionTemporal.equals;
    }

    public int getOperator() {
        return this.op;
    }

    public String getOperatorSymbol() {
        return opSymbols[this.op];
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    public int getNumOperands() {
        if (this.operand2 == null) {
            return 0;
        }
        return this.operand1 == null ? 1 : 2;
    }

    public boolean hasBounds() {
        return this.lBound != null || this.uBound != null;
    }

    public Expression getLowerBound() {
        return this.lBound;
    }

    public boolean lowerBoundIsStrict() {
        return this.lBoundStrict;
    }

    public Expression getUpperBound() {
        return this.uBound;
    }

    public boolean upperBoundIsStrict() {
        return this.uBoundStrict;
    }

    public boolean getEquals() {
        return this.equals;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a temporal operator without a path");
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Expression.Precedence getPrecedence() {
        switch (this.op) {
            case 1: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return Expression.Precedence.TEMPORAL_UNARY;
            }
            case 2: 
            case 5: 
            case 6: {
                return Expression.Precedence.TEMPORAL_BINARY;
            }
        }
        return null;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionTemporal deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.operand1 = deepCopy.copy(this.operand1);
        this.operand2 = deepCopy.copy(this.operand2);
        this.lBound = deepCopy.copy(this.lBound);
        this.uBound = deepCopy.copy(this.uBound);
        return this;
    }

    @Override
    public ExpressionTemporal clone() {
        return (ExpressionTemporal)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.operand1 != null) {
            stringBuilder.append(Expression.toStringPrecLeq(this.operand1, this));
            stringBuilder.append(" ");
        }
        stringBuilder.append(opSymbols[this.op]);
        if (this.lBound == null) {
            if (this.uBound != null) {
                if (this.op != 12) {
                    stringBuilder.append("<");
                    stringBuilder.append(this.uBoundStrict ? "" : "=");
                } else {
                    stringBuilder.append("=");
                }
                stringBuilder.append(this.uBound);
            }
        } else if (this.uBound == null) {
            stringBuilder.append(">");
            stringBuilder.append(this.lBoundStrict ? "" : "=");
            stringBuilder.append(this.lBound);
        } else if (this.equals) {
            stringBuilder.append("=");
            stringBuilder.append(this.lBound);
        } else {
            stringBuilder.append("[");
            stringBuilder.append(this.lBound);
            stringBuilder.append(",");
            stringBuilder.append(this.uBound);
            stringBuilder.append("]");
        }
        if (this.operand2 != null) {
            stringBuilder.append(" ");
            if (this.operand1 != null) {
                stringBuilder.append(Expression.toStringPrecLeq(this.operand2, this));
            } else {
                stringBuilder.append(Expression.toStringPrecLt(this.operand2, this));
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.equals ? 1231 : 1237);
        n = 31 * n + (this.lBound == null ? 0 : this.lBound.hashCode());
        n = 31 * n + (this.lBoundStrict ? 1231 : 1237);
        n = 31 * n + this.op;
        n = 31 * n + (this.operand1 == null ? 0 : this.operand1.hashCode());
        n = 31 * n + (this.operand2 == null ? 0 : this.operand2.hashCode());
        n = 31 * n + (this.uBound == null ? 0 : this.uBound.hashCode());
        n = 31 * n + (this.uBoundStrict ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionTemporal expressionTemporal = (ExpressionTemporal)object;
        if (this.equals != expressionTemporal.equals) {
            return false;
        }
        if (this.lBound == null ? expressionTemporal.lBound != null : !this.lBound.equals(expressionTemporal.lBound)) {
            return false;
        }
        if (this.lBoundStrict != expressionTemporal.lBoundStrict) {
            return false;
        }
        if (this.op != expressionTemporal.op) {
            return false;
        }
        if (this.operand1 == null ? expressionTemporal.operand1 != null : !this.operand1.equals(expressionTemporal.operand1)) {
            return false;
        }
        if (this.operand2 == null ? expressionTemporal.operand2 != null : !this.operand2.equals(expressionTemporal.operand2)) {
            return false;
        }
        if (this.uBound == null ? expressionTemporal.uBound != null : !this.uBound.equals(expressionTemporal.uBound)) {
            return false;
        }
        return this.uBoundStrict == expressionTemporal.uBoundStrict;
    }

    public Expression convertToUntilForm() throws PrismLangException {
        ExpressionTemporal expressionTemporal = null;
        switch (this.op) {
            case 2: {
                return this;
            }
            case 3: {
                ExpressionLiteral expressionLiteral = Expression.True();
                expressionTemporal = new ExpressionTemporal(2, expressionLiteral, this.operand2);
                expressionTemporal.setBoundsFrom(this);
                return expressionTemporal;
            }
            case 4: {
                ExpressionLiteral expressionLiteral = Expression.True();
                ExpressionUnaryOp expressionUnaryOp = Expression.Not(this.operand2);
                expressionTemporal = new ExpressionTemporal(2, expressionLiteral, expressionUnaryOp);
                expressionTemporal.setBoundsFrom(this);
                return Expression.Not(expressionTemporal);
            }
            case 5: {
                ExpressionBinaryOp expressionBinaryOp = Expression.And(this.operand1, Expression.Not(this.operand2));
                ExpressionBinaryOp expressionBinaryOp2 = Expression.And(Expression.Not(this.operand1), Expression.Not(this.operand2));
                expressionTemporal = new ExpressionTemporal(2, expressionBinaryOp, expressionBinaryOp2);
                expressionTemporal.setBoundsFrom(this);
                return Expression.Not(expressionTemporal);
            }
            case 6: {
                ExpressionUnaryOp expressionUnaryOp = Expression.Not(this.operand1);
                ExpressionUnaryOp expressionUnaryOp2 = Expression.Not(this.operand2);
                expressionTemporal = new ExpressionTemporal(2, expressionUnaryOp, expressionUnaryOp2);
                expressionTemporal.setBoundsFrom(this);
                return Expression.Not(expressionTemporal);
            }
        }
        throw new PrismLangException("Cannot convert " + this.getOperatorSymbol() + " to until form");
    }

    public static boolean isNext(Expression expression) {
        return expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 1;
    }

    public static boolean isUntil(Expression expression) {
        return expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 2;
    }

    public static boolean isWeakUntil(Expression expression) {
        return expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 5;
    }

    public static boolean isRelease(Expression expression) {
        return expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 6;
    }

    public static boolean isFinally(Expression expression) {
        return expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 3;
    }

    public static boolean isGlobally(Expression expression) {
        return expression instanceof ExpressionTemporal && ((ExpressionTemporal)expression).getOperator() == 4;
    }

    public static boolean isGloballyFinally(Expression expression) {
        return ExpressionTemporal.isGlobally(expression) && ExpressionTemporal.isFinally(((ExpressionTemporal)expression).getOperand2());
    }

    public static boolean isFinallyGlobally(Expression expression) {
        return ExpressionTemporal.isFinally(expression) && ExpressionTemporal.isGlobally(((ExpressionTemporal)expression).getOperand2());
    }

    public static ExpressionTemporal Next(Expression expression) {
        return new ExpressionTemporal(1, null, expression);
    }

    public static ExpressionTemporal Finally(Expression expression) {
        return new ExpressionTemporal(3, null, expression);
    }

    public static ExpressionTemporal Globally(Expression expression) {
        return new ExpressionTemporal(4, null, expression);
    }

    public static ExpressionTemporal Globally(Expression expression, Expression expression2) {
        return new ExpressionTemporal(2, expression, expression2);
    }

    public static ExpressionTemporal WeakUntil(Expression expression, Expression expression2) {
        return new ExpressionTemporal(5, expression, expression2);
    }

    public static ExpressionTemporal Release(Expression expression, Expression expression2) {
        return new ExpressionTemporal(6, expression, expression2);
    }
}

