/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.EvaluateContext;
import parser.EvaluateContextConstants;
import parser.EvaluateContextState;
import parser.EvaluateContextSubstate;
import parser.EvaluateContextValues;
import parser.State;
import parser.Token;
import parser.Values;
import parser.ast.ConstantList;
import parser.ast.FormulaList;
import parser.ast.LabelList;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.RenamedModule;
import parser.type.Type;
import parser.visitor.ASTTraverse;
import parser.visitor.ASTVisitor;
import parser.visitor.ComputeProbNesting;
import parser.visitor.DeepCopy;
import parser.visitor.EvaluatePartially;
import parser.visitor.ExpandConstants;
import parser.visitor.ExpandFormulas;
import parser.visitor.ExpandLabels;
import parser.visitor.ExpandPropRefsAndLabels;
import parser.visitor.FindAllActions;
import parser.visitor.FindAllConstants;
import parser.visitor.FindAllFormulas;
import parser.visitor.FindAllObsRefs;
import parser.visitor.FindAllPropRefs;
import parser.visitor.FindAllVars;
import parser.visitor.GetAllConstants;
import parser.visitor.GetAllFormulas;
import parser.visitor.GetAllLabels;
import parser.visitor.GetAllPropRefs;
import parser.visitor.GetAllPropRefsRecursively;
import parser.visitor.GetAllUndefinedConstantsRecursively;
import parser.visitor.GetAllVars;
import parser.visitor.Rename;
import parser.visitor.SemanticCheck;
import parser.visitor.Simplify;
import parser.visitor.ToTreeString;
import parser.visitor.TypeCheck;
import prism.PrismLangException;

public abstract class ASTElement
implements Cloneable {
    protected Type type = null;
    protected int beginLine = -1;
    protected int beginColumn = -1;
    protected int endLine = -1;
    protected int endColumn = -1;

    public void setType(Type type) {
        this.type = type;
    }

    public void setBeginColumn(int n) {
        this.beginColumn = n;
    }

    public void setBeginLine(int n) {
        this.beginLine = n;
    }

    public void setEndColumn(int n) {
        this.endColumn = n;
    }

    public void setEndLine(int n) {
        this.endLine = n;
    }

    public void setPosition(int n, int n2, int n3, int n4) {
        this.beginLine = n;
        this.beginColumn = n2;
        this.endLine = n3;
        this.endColumn = n4;
    }

    public void setPosition(Token token, Token token2) {
        this.beginLine = token.beginLine;
        this.beginColumn = token.beginColumn;
        this.endLine = token2.endLine;
        this.endColumn = token2.endColumn;
    }

    public void setPosition(Token token) {
        this.setPosition(token, token);
    }

    public void setPosition(ASTElement aSTElement, ASTElement aSTElement2) {
        this.beginLine = aSTElement.getBeginLine();
        this.beginColumn = aSTElement.getBeginColumn();
        this.endLine = aSTElement2.getEndLine();
        this.endColumn = aSTElement2.getEndColumn();
    }

    public void setPosition(ASTElement aSTElement) {
        this.setPosition(aSTElement, aSTElement);
    }

    public void clearPosition() {
        this.setPosition(-1, -1, -1, -1);
    }

    public void clearPositionRecursively() {
        try {
            this.accept(new ASTTraverse(){

                @Override
                public void defaultVisitPost(ASTElement aSTElement) throws PrismLangException {
                    ASTElement.this.clearPosition();
                }
            });
        }
        catch (PrismLangException prismLangException) {
            // empty catch block
        }
    }

    public Type getType() {
        if (this.type != null) {
            return this.type;
        }
        try {
            this.typeCheck();
        }
        catch (PrismLangException prismLangException) {
            return null;
        }
        return this.type;
    }

    public Type getTypeIfDefined() {
        return this.type;
    }

    public boolean hasPosition() {
        return this.beginLine != -1;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public String getBeginString() {
        return "line " + this.beginLine + ", column " + this.beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String getEndString() {
        return "line " + this.endLine + ", column " + this.endColumn;
    }

    public abstract Object accept(ASTVisitor var1) throws PrismLangException;

    public abstract String toString();

    public ASTElement deepCopy() {
        try {
            return new DeepCopy().copy(this);
        }
        catch (PrismLangException prismLangException) {
            throw new Error(prismLangException);
        }
    }

    public abstract ASTElement deepCopy(DeepCopy var1) throws PrismLangException;

    public ASTElement clone() {
        try {
            return (ASTElement)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Object#clone is expected to work for Cloneable objects", cloneNotSupportedException);
        }
    }

    public ASTElement findAllFormulas(FormulaList formulaList) throws PrismLangException {
        FindAllFormulas findAllFormulas = new FindAllFormulas(formulaList);
        return (ASTElement)this.accept(findAllFormulas);
    }

    public ASTElement expandFormulas(FormulaList formulaList) throws PrismLangException {
        return this.expandFormulas(formulaList, true);
    }

    public ASTElement expandFormulas(FormulaList formulaList, boolean bl) throws PrismLangException {
        ExpandFormulas expandFormulas = new ExpandFormulas(formulaList, bl);
        return (ASTElement)this.accept(expandFormulas);
    }

    public List<String> getAllFormulas() throws PrismLangException {
        ArrayList<String> arrayList = new ArrayList<String>();
        GetAllFormulas getAllFormulas = new GetAllFormulas(arrayList);
        this.accept(getAllFormulas);
        return arrayList;
    }

    public ASTElement rename(RenamedModule renamedModule) throws PrismLangException {
        Rename rename = new Rename(renamedModule);
        return (ASTElement)this.accept(rename);
    }

    public ASTElement findAllConstants(ConstantList constantList) throws PrismLangException {
        FindAllConstants findAllConstants = new FindAllConstants(constantList);
        return (ASTElement)this.accept(findAllConstants);
    }

    public ASTElement findAllConstants(List<String> list, List<Type> list2) throws PrismLangException {
        FindAllConstants findAllConstants = new FindAllConstants(list, list2);
        return (ASTElement)this.accept(findAllConstants);
    }

    public List<String> getAllConstants() {
        ArrayList<String> arrayList = new ArrayList<String>();
        GetAllConstants getAllConstants = new GetAllConstants(arrayList);
        try {
            this.accept(getAllConstants);
        }
        catch (PrismLangException prismLangException) {
            // empty catch block
        }
        return arrayList;
    }

    public List<String> getAllUndefinedConstantsRecursively(ConstantList constantList, LabelList labelList, PropertiesFile propertiesFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        GetAllUndefinedConstantsRecursively getAllUndefinedConstantsRecursively = new GetAllUndefinedConstantsRecursively(arrayList, constantList, labelList, propertiesFile);
        try {
            this.accept(getAllUndefinedConstantsRecursively);
        }
        catch (PrismLangException prismLangException) {
            // empty catch block
        }
        return arrayList;
    }

    public ASTElement expandConstants(ConstantList constantList) throws PrismLangException {
        return this.expandConstants(constantList, true);
    }

    public ASTElement expandConstants(ConstantList constantList, boolean bl) throws PrismLangException {
        ExpandConstants expandConstants = new ExpandConstants(constantList, bl);
        return (ASTElement)this.accept(expandConstants);
    }

    public ASTElement replaceConstants(Values values) throws PrismLangException {
        return this.evaluatePartially(new EvaluateContextConstants(values));
    }

    public ASTElement findAllVars(List<String> list, List<Type> list2) throws PrismLangException {
        FindAllVars findAllVars = new FindAllVars(list, list2);
        return (ASTElement)this.accept(findAllVars);
    }

    public List<String> getAllVars() throws PrismLangException {
        ArrayList<String> arrayList = new ArrayList<String>();
        GetAllVars getAllVars = new GetAllVars(arrayList);
        this.accept(getAllVars);
        return arrayList;
    }

    public ASTElement replaceVars(Values values) throws PrismLangException {
        return this.evaluatePartially(new EvaluateContextValues(null, values));
    }

    public List<String> getAllLabels() throws PrismLangException {
        ArrayList<String> arrayList = new ArrayList<String>();
        GetAllLabels getAllLabels = new GetAllLabels(arrayList);
        this.accept(getAllLabels);
        return arrayList;
    }

    public ASTElement expandLabels(LabelList labelList) throws PrismLangException {
        ExpandLabels expandLabels = new ExpandLabels(labelList);
        return (ASTElement)this.accept(expandLabels);
    }

    public ASTElement findAllPropRefs(ModulesFile modulesFile, PropertiesFile propertiesFile) throws PrismLangException {
        FindAllPropRefs findAllPropRefs = new FindAllPropRefs(modulesFile, propertiesFile);
        return (ASTElement)this.accept(findAllPropRefs);
    }

    public List<String> getAllPropRefs() throws PrismLangException {
        ArrayList<String> arrayList = new ArrayList<String>();
        GetAllPropRefs getAllPropRefs = new GetAllPropRefs(arrayList);
        this.accept(getAllPropRefs);
        return arrayList;
    }

    public List<String> getAllPropRefsRecursively(PropertiesFile propertiesFile) throws PrismLangException {
        ArrayList<String> arrayList = new ArrayList<String>();
        GetAllPropRefsRecursively getAllPropRefsRecursively = new GetAllPropRefsRecursively(arrayList, propertiesFile);
        this.accept(getAllPropRefsRecursively);
        return arrayList;
    }

    public ASTElement findAllObsRefs(List<String> list, List<Type> list2) throws PrismLangException {
        FindAllObsRefs findAllObsRefs = new FindAllObsRefs(list, list2);
        return (ASTElement)this.accept(findAllObsRefs);
    }

    public ASTElement expandPropRefsAndLabels(PropertiesFile propertiesFile, LabelList labelList) throws PrismLangException {
        ExpandPropRefsAndLabels expandPropRefsAndLabels = new ExpandPropRefsAndLabels(propertiesFile, labelList);
        return (ASTElement)this.accept(expandPropRefsAndLabels);
    }

    public ASTElement findAllActions(List<String> list) throws PrismLangException {
        FindAllActions findAllActions = new FindAllActions(list);
        return (ASTElement)this.accept(findAllActions);
    }

    public void typeCheck(PropertiesFile propertiesFile) throws PrismLangException {
        TypeCheck typeCheck = new TypeCheck(propertiesFile);
        this.accept(typeCheck);
    }

    public void typeCheck() throws PrismLangException {
        TypeCheck typeCheck = new TypeCheck();
        this.accept(typeCheck);
    }

    public void semanticCheck() throws PrismLangException {
        SemanticCheck semanticCheck = new SemanticCheck();
        this.accept(semanticCheck);
    }

    public ASTElement evaluatePartially(EvaluateContext evaluateContext) throws PrismLangException {
        EvaluatePartially evaluatePartially = new EvaluatePartially(evaluateContext);
        return (ASTElement)this.accept(evaluatePartially);
    }

    public ASTElement evaluatePartially(Values values) throws PrismLangException {
        return this.evaluatePartially(new EvaluateContextValues(values, null));
    }

    public ASTElement evaluatePartially(Values values, Values values2) throws PrismLangException {
        return this.evaluatePartially(new EvaluateContextValues(values, values2));
    }

    public ASTElement evaluatePartially(State state) throws PrismLangException {
        return this.evaluatePartially(new EvaluateContextState(state));
    }

    public ASTElement evaluatePartially(Values values, State state) throws PrismLangException {
        return this.evaluatePartially(new EvaluateContextState(values, state));
    }

    public ASTElement evaluatePartially(State state, int[] nArray) throws PrismLangException {
        return this.evaluatePartially(new EvaluateContextSubstate(state, nArray));
    }

    public ASTElement simplify() throws PrismLangException {
        Simplify simplify = new Simplify();
        return (ASTElement)this.accept(simplify);
    }

    public int computeProbNesting() throws PrismLangException {
        ComputeProbNesting computeProbNesting = new ComputeProbNesting();
        this.accept(computeProbNesting);
        return computeProbNesting.getMaxNesting();
    }

    public int computeProbNesting(PropertiesFile propertiesFile) throws PrismLangException {
        ComputeProbNesting computeProbNesting = new ComputeProbNesting(propertiesFile);
        this.accept(computeProbNesting);
        return computeProbNesting.getMaxNesting();
    }

    public String toTreeString() {
        ToTreeString toTreeString = new ToTreeString();
        try {
            this.accept(toTreeString);
        }
        catch (PrismLangException prismLangException) {
            return prismLangException.toString();
        }
        return toTreeString.getString();
    }
}

