/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import param.BigRational;
import param.Function;
import param.Point;
import param.RegionFactory;
import param.RegionValues;
import param.StateValues;

abstract class Region {
    static final int IMPLIES = 1;
    static final int IFF = 2;
    static final int OR = 3;
    static final int AND = 4;
    static final int EQ = 5;
    static final int NE = 6;
    static final int GT = 7;
    static final int GE = 8;
    static final int LT = 9;
    static final int LE = 10;
    static final int PLUS = 11;
    static final int MINUS = 12;
    static final int TIMES = 13;
    static final int DIVIDE = 14;
    static final int FIRST = 15;
    static final int AVG = 16;
    static final int COUNT = 17;
    static final int UMINUS = 18;
    static final int NOT = 19;
    static final int PARENTH = 20;
    static final int FORALL = 21;
    static final int EXISTS = 22;
    static final int POW = 23;
    static final String[] opSymbols = new String[]{"", "=>", "<=>", "|", "&", "=", "!=", ">", ">=", "<", "<=", "+", "-", "*", "/", "1st", "avg", "-", "!", "()", "forall", "exists", "^"};
    protected RegionFactory factory;

    Region() {
    }

    abstract int getDimensions();

    abstract BigRational volume();

    abstract boolean contains(Point var1);

    abstract boolean contains(Region var1);

    abstract RegionValues binaryOp(int var1, StateValues var2, StateValues var3);

    abstract RegionValues ITE(StateValues var1, StateValues var2, StateValues var3);

    abstract ArrayList<Region> split(Function var1);

    abstract ArrayList<Region> split();

    abstract ArrayList<Point> specialPoints();

    abstract Point randomPoint();

    RegionFactory getFactory() {
        return this.factory;
    }

    static int getOp(String string) {
        for (int i = 0; i < opSymbols.length; ++i) {
            if (!string.equals(opSymbols[i])) continue;
            return i;
        }
        throw new RuntimeException("bad operator");
    }

    abstract Region conjunct(Region var1);

    abstract boolean adjacent(Region var1);

    abstract Region glue(Region var1);
}

