/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import java.util.HashMap;
import param.BigRational;
import param.CachedFunction;
import param.Function;
import param.FunctionFactory;
import param.Point;
import parser.ast.Expression;
import prism.PrismException;

final class CachedFunctionFactory
extends FunctionFactory {
    private FunctionFactory context;
    private HashMap<Function, Integer> functionToNumber;
    private ArrayList<Function> functions;
    private ArrayList<CachedFunction> cachedFunctions;
    private int nextFunctionNumber;
    private CachedFunction one;
    private CachedFunction zero;
    private boolean useOpCache;
    private HashMap<OpCacheKey, CachedFunction> addCache;
    private HashMap<OpCacheKey, CachedFunction> multCache;
    private HashMap<CachedFunction, CachedFunction> starCache;

    public CachedFunctionFactory(FunctionFactory functionFactory) {
        super(functionFactory.parameterNames, functionFactory.lowerBounds, functionFactory.upperBounds);
        this.context = functionFactory;
        this.functionToNumber = new HashMap();
        this.cachedFunctions = new ArrayList();
        this.functions = new ArrayList();
        this.nextFunctionNumber = 0;
        this.one = this.makeUnique(functionFactory.getOne());
        this.zero = this.makeUnique(functionFactory.getZero());
        this.addCache = new HashMap();
        this.multCache = new HashMap();
        this.starCache = new HashMap();
        this.useOpCache = true;
    }

    boolean isUseOpCache() {
        return this.useOpCache;
    }

    private CachedFunction makeUnique(Function function) {
        Integer n = this.functionToNumber.get(function);
        if (n != null) {
            return this.cachedFunctions.get(n);
        }
        CachedFunction cachedFunction = new CachedFunction(this, this.nextFunctionNumber);
        this.functionToNumber.put(function, this.nextFunctionNumber);
        this.cachedFunctions.add(cachedFunction);
        this.functions.add(function);
        ++this.nextFunctionNumber;
        return cachedFunction;
    }

    Function getFunction(int n) {
        return this.functions.get(n);
    }

    @Override
    public Function getOne() {
        return this.one;
    }

    @Override
    public Function getZero() {
        return this.zero;
    }

    private Function getFunctionFromCache(Function function) {
        return this.functions.get(((CachedFunction)function).getNumber());
    }

    Function add(Function function, Function function2) {
        Function function3;
        OpCacheKey opCacheKey = null;
        if (this.useOpCache && (function3 = (Function)this.addCache.get(opCacheKey = new OpCacheKey((CachedFunction)function, (CachedFunction)function2))) != null) {
            return function3;
        }
        Function function4 = this.getFunctionFromCache(function);
        Function function5 = this.getFunctionFromCache(function2);
        function3 = this.makeUnique(function4.add(function5));
        if (this.useOpCache) {
            this.addCache.put(opCacheKey, (CachedFunction)function3);
        }
        return function3;
    }

    Function negate(Function function) {
        Function function2 = this.getFunctionFromCache(function);
        return this.makeUnique(function2.negate());
    }

    Function multiply(Function function, Function function2) {
        Function function3;
        OpCacheKey opCacheKey = null;
        if (this.useOpCache && (function3 = (Function)this.multCache.get(opCacheKey = new OpCacheKey((CachedFunction)function, (CachedFunction)function2))) != null) {
            return function3;
        }
        Function function4 = this.getFunctionFromCache(function);
        Function function5 = this.getFunctionFromCache(function2);
        function3 = this.makeUnique(function4.multiply(function5));
        if (this.useOpCache) {
            this.multCache.put(opCacheKey, (CachedFunction)function3);
        }
        return function3;
    }

    Function divide(Function function, Function function2) {
        Function function3 = this.getFunctionFromCache(function);
        Function function4 = this.getFunctionFromCache(function2);
        return this.makeUnique(function3.divide(function4));
    }

    Function pow(Function function, int n) {
        Function function2 = this.getFunctionFromCache(function);
        return this.makeUnique(function2.pow(n));
    }

    Function star(Function function) {
        Function function2;
        if (this.useOpCache && (function2 = (Function)this.starCache.get(function)) != null) {
            return function2;
        }
        Function function3 = this.getFunctionFromCache(function);
        function2 = this.makeUnique(function3.star());
        if (this.useOpCache) {
            this.starCache.put((CachedFunction)function, (CachedFunction)function2);
        }
        return function2;
    }

    Function toConstraint(CachedFunction cachedFunction) {
        return this.getFunctionFromCache(cachedFunction).toConstraint();
    }

    public BigRational evaluate(CachedFunction cachedFunction, Point point, boolean bl) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.evaluate(point, bl);
    }

    public BigRational evaluate(CachedFunction cachedFunction, Point point) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.evaluate(point);
    }

    @Override
    public Function fromBigRational(BigRational bigRational) {
        Function function = this.context.fromBigRational(bigRational);
        return this.makeUnique(function);
    }

    public BigRational asBigRational(CachedFunction cachedFunction) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.asBigRational();
    }

    public Expression asExpression(CachedFunction cachedFunction) throws PrismException {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.asExpression();
    }

    public boolean check(CachedFunction cachedFunction, Point point, boolean bl) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.check(point, bl);
    }

    public boolean isNaN(CachedFunction cachedFunction) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.isNaN();
    }

    public boolean isInf(CachedFunction cachedFunction) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.isInf();
    }

    public boolean isMInf(CachedFunction cachedFunction) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.isMInf();
    }

    public boolean isOne(CachedFunction cachedFunction) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.isOne();
    }

    public boolean isZero(CachedFunction cachedFunction) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.isZero();
    }

    public boolean isConstant(CachedFunction cachedFunction) {
        Function function = this.getFunctionFromCache(cachedFunction);
        return function.isConstant();
    }

    @Override
    public Function getNaN() {
        return this.makeUnique(this.context.getNaN());
    }

    @Override
    public Function getInf() {
        return this.makeUnique(this.context.getInf());
    }

    @Override
    public Function getMInf() {
        return this.makeUnique(this.context.getMInf());
    }

    @Override
    public Function getVar(int n) {
        return this.makeUnique(this.context.getVar(n));
    }

    private class OpCacheKey {
        CachedFunction first;
        CachedFunction second;

        public OpCacheKey(CachedFunction cachedFunction, CachedFunction cachedFunction2) {
            if (cachedFunction2.getNumber() > cachedFunction.getNumber()) {
                CachedFunction cachedFunction3 = cachedFunction;
                cachedFunction = cachedFunction2;
                cachedFunction2 = cachedFunction3;
            }
            this.first = cachedFunction;
            this.second = cachedFunction2;
        }

        public boolean equals(Object object) {
            OpCacheKey opCacheKey = (OpCacheKey)object;
            return this.first == opCacheKey.first && this.second == opCacheKey.second;
        }

        public int hashCode() {
            int n = this.first.getNumber();
            n = this.second.getNumber() + (n << 6) + (n << 16) - n;
            return n;
        }
    }
}

