/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import jltl2ba.MyBitSet;
import jltl2dstar.RabinAcceptance;
import jltl2dstar.SafraTree;

public class RabinSignature
implements Comparable<RabinSignature> {
    private MyBitSet _L;
    private MyBitSet _U;
    private int _size;

    public RabinSignature(int n) {
        this._size = n;
        this._L = new MyBitSet(n);
        this._U = new MyBitSet(n);
    }

    public RabinSignature(RabinSignature rabinSignature) {
        this._L = (MyBitSet)rabinSignature._L.clone();
        this._U = (MyBitSet)rabinSignature._U.clone();
        this._size = rabinSignature._size;
    }

    public RabinSignature(MyBitSet myBitSet, MyBitSet myBitSet2, int n) {
        this._L = myBitSet;
        this._U = myBitSet2;
        this._size = n;
    }

    public <Tree extends SafraTree> RabinSignature(Tree Tree2) {
        this(0);
        Tree2.generateAcceptance(this);
    }

    public void clear() {
        this._L.clear();
        this._U.clear();
    }

    public MyBitSet getL() {
        return this._L;
    }

    public MyBitSet getU() {
        return this._U;
    }

    public void setL(int n, boolean bl) {
        this._L.set(n, bl);
    }

    public void setU(int n, boolean bl) {
        this._U.set(n, bl);
    }

    public void setColor(int n, RabinAcceptance.RabinColor rabinColor) {
        switch (rabinColor) {
            case RABIN_RED: {
                this._U.set(n, true);
                this._L.set(n, false);
                break;
            }
            case RABIN_GREEN: {
                this._U.set(n, false);
                this._L.set(n, true);
                break;
            }
            case RABIN_WHITE: {
                this._U.set(n, false);
                this._L.set(n, false);
            }
        }
    }

    public RabinAcceptance.RabinColor getColor(int n) {
        return this._U.get(n) ? RabinAcceptance.RabinColor.RABIN_RED : (this._L.get(n) ? RabinAcceptance.RabinColor.RABIN_GREEN : RabinAcceptance.RabinColor.RABIN_WHITE);
    }

    public String toString() {
        Object object = "{";
        block4: for (int i = 0; i < this.size(); ++i) {
            switch (this.getColor(i)) {
                case RABIN_RED: {
                    object = (String)object + "-" + i;
                    continue block4;
                }
                case RABIN_GREEN: {
                    object = (String)object + "+" + i;
                    continue block4;
                }
            }
        }
        object = (String)object + "}";
        return object;
    }

    public boolean equals(RabinSignature rabinSignature) {
        return this._L.equals(rabinSignature.getL()) && this._U.equals(rabinSignature.getU());
    }

    public boolean equals(Object object) {
        return object instanceof RabinSignature && this.equals((RabinSignature)object);
    }

    @Override
    public int compareTo(RabinSignature rabinSignature) {
        int n = this._L.compareTo(rabinSignature.getL());
        if (n != 0) {
            return n;
        }
        return this._U.compareTo(rabinSignature.getU());
    }

    public int getSize() {
        return this._size;
    }

    public int size() {
        return this._size;
    }

    public void setSize(int n) {
        this._size = n;
    }

    public void maxMerge(RabinSignature rabinSignature) {
        for (int i = 0; i < this._size; ++i) {
            if (this.getColor(i).compareTo(rabinSignature.getColor(i)) >= 0) continue;
            this.setColor(i, rabinSignature.getColor(i));
        }
    }
}

