/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.IteratorTools;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.NondetModel;
import explicit.PartiallyObservableModel;
import explicit.PredecessorRelation;
import explicit.StateValues;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decorator;
import explicit.graphviz.MarkStateSetDecorator;
import io.DotExporter;
import io.ModelExportOptions;
import io.PrismExplicitExporter;
import java.io.File;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.IntPredicate;
import parser.State;
import parser.Values;
import parser.VarList;
import prism.Evaluator;
import prism.Prism;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;
import prism.PrismUtils;

public interface Model<Value>
extends prism.Model<Value> {
    public Iterable<Integer> getInitialStates();

    public int getFirstInitialState();

    public boolean isInitialState(int var1);

    public int getNumDeadlockStates();

    public Iterable<Integer> getDeadlockStates();

    public StateValues getDeadlockStatesList();

    public int getFirstDeadlockState();

    public boolean isDeadlockState(int var1);

    public List<State> getStatesList();

    public VarList getVarList();

    public Values getConstantValues();

    public BitSet getLabelStates(String var1);

    public Set<String> getLabels();

    public boolean hasLabel(String var1);

    default public Map<String, BitSet> getLabelToStatesMap() {
        TreeMap<String, BitSet> treeMap = new TreeMap<String, BitSet>();
        for (String string : this.getLabels()) {
            treeMap.put(string, this.getLabelStates(string));
        }
        return treeMap;
    }

    @Override
    default public int getNumTransitions() {
        int n = this.getNumStates();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.getNumTransitions(i);
        }
        return n2;
    }

    default public int getNumTransitions(int n) {
        return Math.toIntExact(IteratorTools.count(this.getSuccessorsIterator(n)));
    }

    default public long getNumTransitions(PrimitiveIterator.OfInt ofInt) {
        long l = 0L;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            l += (long)this.getNumTransitions(n);
        }
        return l;
    }

    default public Iterator<Integer> getSuccessorsIterator(int n) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        return successorsIterator.distinct();
    }

    public SuccessorsIterator getSuccessors(int var1);

    default public boolean isSuccessor(int n, int n2) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    default public boolean allSuccessorsInSet(int n, BitSet bitSet) {
        return this.allSuccessorsMatch(n, bitSet::get);
    }

    default public boolean someSuccessorsInSet(int n, BitSet bitSet) {
        return this.someSuccessorsMatch(n, bitSet::get);
    }

    default public boolean allSuccessorsMatch(int n, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (intPredicate.test(n2)) continue;
            return false;
        }
        return true;
    }

    default public boolean someSuccessorsMatch(int n, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (!intPredicate.test(n2)) continue;
            return true;
        }
        return false;
    }

    default public boolean prob0step(int n, BitSet bitSet) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (!bitSet.get(n2)) continue;
            return true;
        }
        return false;
    }

    default public void prob0step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            bitSet3.set(n, this.prob0step(n, bitSet2));
        }
    }

    default public boolean prob1step(int n, BitSet bitSet, BitSet bitSet2) {
        boolean bl = true;
        boolean bl2 = false;
        SuccessorsIterator successorsIterator = this.getSuccessors(n);
        while (successorsIterator.hasNext()) {
            int n2 = successorsIterator.nextInt();
            if (!bitSet.get(n2)) {
                bl = false;
                break;
            }
            bl2 = bl2 || bitSet2.get(n2);
        }
        return bl && bl2;
    }

    default public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            bitSet4.set(n, this.prob1step(n, bitSet2, bitSet3));
        }
    }

    public void findDeadlocks(boolean var1) throws PrismException;

    public void checkForDeadlocks() throws PrismException;

    public void checkForDeadlocks(BitSet var1) throws PrismException;

    default public void exportToPrismExplicit(String string) throws PrismException {
        this.exportToPrismExplicit(string, 16);
    }

    default public void exportToPrismExplicit(String string, int n) throws PrismException {
        this.exportToPrismExplicitTra(string + ".tra", n);
    }

    default public void exportToPrismExplicitTra(PrismLog prismLog, ModelExportOptions modelExportOptions) throws PrismException {
        new PrismExplicitExporter(modelExportOptions).exportTransitions(this, prismLog);
    }

    default public void exportToPrismExplicitTra(PrismLog prismLog, int n) throws PrismException {
        this.exportToPrismExplicitTra(prismLog, new ModelExportOptions().setModelPrecision(n));
    }

    default public void exportToPrismExplicitTra(PrismLog prismLog) throws PrismException {
        this.exportToPrismExplicitTra(prismLog, new ModelExportOptions());
    }

    default public void exportToPrismExplicitTra(String string) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToPrismExplicitTra(prismFileLog);
        }
    }

    default public void exportToPrismExplicitTra(String string, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToPrismExplicitTra((PrismLog)prismFileLog, n);
        }
    }

    default public void exportToPrismExplicitTra(File file) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(file.getPath());){
            this.exportToPrismExplicitTra(prismFileLog);
        }
    }

    default public void exportToPrismExplicitTra(File file, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(file.getPath());){
            this.exportToPrismExplicitTra((PrismLog)prismFileLog, n);
        }
    }

    default public void exportToDotFile(PrismLog prismLog, ModelExportOptions modelExportOptions, Iterable<Decorator> iterable) throws PrismException {
        new DotExporter(modelExportOptions).exportModel(this, prismLog, iterable);
    }

    default public void exportToDotFile(PrismLog prismLog, ModelExportOptions modelExportOptions) throws PrismException {
        new DotExporter(modelExportOptions).exportModel(this, prismLog, null);
    }

    default public void exportToDotFile(PrismLog prismLog) throws PrismException {
        this.exportToDotFile(prismLog, new ModelExportOptions());
    }

    default public void exportToDotFile(PrismLog prismLog, int n) throws PrismException {
        this.exportToDotFile(prismLog, new ModelExportOptions().setModelPrecision(n));
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet) throws PrismException {
        Set<Decorator> set = bitSet == null ? null : Collections.singleton(new MarkStateSetDecorator(bitSet));
        this.exportToDotFile(prismLog, new ModelExportOptions(), set);
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet, int n) throws PrismException {
        Set<Decorator> set = bitSet == null ? null : Collections.singleton(new MarkStateSetDecorator(bitSet));
        this.exportToDotFile(prismLog, new ModelExportOptions().setModelPrecision(n), set);
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet, boolean bl) throws PrismException {
        Set<Decorator> set = bitSet == null ? null : Collections.singleton(new MarkStateSetDecorator(bitSet));
        this.exportToDotFile(prismLog, new ModelExportOptions().setShowStates(bl), set);
    }

    default public void exportToDotFile(PrismLog prismLog, BitSet bitSet, boolean bl, int n) throws PrismException {
        Set<Decorator> set = bitSet == null ? null : Collections.singleton(new MarkStateSetDecorator(bitSet));
        this.exportToDotFile(prismLog, new ModelExportOptions().setShowStates(bl).setModelPrecision(n), set);
    }

    default public void exportToDotFile(PrismLog prismLog, Iterable<Decorator> iterable) throws PrismException {
        this.exportToDotFile(prismLog, new ModelExportOptions(), iterable);
    }

    default public void exportToDotFile(PrismLog prismLog, Iterable<Decorator> iterable, int n) throws PrismException {
        this.exportToDotFile(prismLog, new ModelExportOptions().setModelPrecision(n), iterable);
    }

    default public void exportToDotFile(String string) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile(prismFileLog);
        }
    }

    default public void exportToDotFile(String string, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, n);
        }
    }

    default public void exportToDotFile(String string, BitSet bitSet) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, bitSet);
        }
    }

    default public void exportToDotFile(String string, BitSet bitSet, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, bitSet, n);
        }
    }

    default public void exportToDotFile(String string, Iterable<Decorator> iterable) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, iterable);
        }
    }

    default public void exportToDotFile(String string, Iterable<Decorator> iterable, int n) throws PrismException {
        try (PrismFileLog prismFileLog = PrismFileLog.create(string);){
            this.exportToDotFile((PrismLog)prismFileLog, iterable, n);
        }
    }

    @Deprecated
    default public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable) {
    }

    @Deprecated
    default public void exportTransitionsToDotFile(int n, PrismLog prismLog, Iterable<Decorator> iterable, int n2) {
    }

    default public void exportToPrismLanguage(String string) throws PrismException {
        this.exportToPrismLanguage(string, 16);
    }

    public void exportToPrismLanguage(String var1, int var2) throws PrismException;

    default public void exportStates(VarList varList, PrismLog prismLog, ModelExportOptions modelExportOptions) throws PrismException {
        new PrismExplicitExporter(modelExportOptions).exportStates(this, varList, prismLog);
    }

    @Deprecated
    default public void exportStates(int n, VarList varList, PrismLog prismLog) throws PrismException {
        this.exportStates(varList, prismLog, Prism.convertExportType(n));
    }

    default public String infoString() {
        int n = this.getNumStates();
        Object object = "";
        object = (String)object + n + " states (" + this.getNumInitialStates() + " initial)";
        if (this instanceof PartiallyObservableModel) {
            object = (String)object + ", " + ((PartiallyObservableModel)this).getNumObservations() + " observables";
            object = (String)object + ", " + ((PartiallyObservableModel)this).getNumUnobservations() + " unobservables";
        }
        object = (String)object + ", " + this.getNumTransitions() + " transitions";
        if (this instanceof NondetModel) {
            object = (String)object + ", " + ((NondetModel)this).getNumChoices() + " choices";
            object = (String)object + ", dist max/avg = " + ((NondetModel)this).getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)((NondetModel)this).getNumChoices() / (double)n);
        }
        return object;
    }

    default public String infoStringTable() {
        int n = this.getNumStates();
        Object object = "";
        object = (String)object + "States:      " + n + " (" + this.getNumInitialStates() + " initial)\n";
        if (this instanceof PartiallyObservableModel) {
            object = (String)object + "Obs/unobs:   " + ((PartiallyObservableModel)this).getNumObservations() + "/" + ((PartiallyObservableModel)this).getNumUnobservations() + "\n";
        }
        object = (String)object + "Transitions: " + this.getNumTransitions() + "\n";
        if (this instanceof NondetModel) {
            object = (String)object + "Choices:     " + ((NondetModel)this).getNumChoices() + "\n";
            object = (String)object + "Max/avg:     " + ((NondetModel)this).getMaxNumChoices() + "/" + PrismUtils.formatDouble2dp((double)((NondetModel)this).getNumChoices() / (double)n) + "\n";
        }
        return object;
    }

    public boolean hasStoredPredecessorRelation();

    public PredecessorRelation getPredecessorRelation(PrismComponent var1, boolean var2);

    public void clearPredecessorRelation();

    default public Evaluator<Value> getEvaluator() {
        return Evaluator.forDouble();
    }
}

