/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.ChainedIterator;
import common.iterable.FunctionalIterable;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.FunctionalPrimitiveIterator;
import common.iterable.PrimitiveIterable;
import common.iterable.Reducible;
import java.util.Objects;

public abstract class ChainedIterable<E, I extends Iterable<E>>
implements FunctionalIterable<E> {
    protected final FunctionalIterable<? extends I> iterables;

    public ChainedIterable(Iterable<? extends I> iterable) {
        Objects.requireNonNull(iterable);
        this.iterables = Reducible.extend(iterable);
    }

    public static class OfLong
    extends ChainedIterable<Long, PrimitiveIterable.OfLong>
    implements FunctionalPrimitiveIterable.OfLong {
        public OfLong(Iterable<? extends PrimitiveIterable.OfLong> iterable) {
            super(iterable);
        }

        @Override
        public FunctionalPrimitiveIterator.OfLong iterator() {
            return new ChainedIterator.OfLong(this.iterables.map(PrimitiveIterable.OfLong::iterator).iterator());
        }
    }

    public static class OfInt
    extends ChainedIterable<Integer, PrimitiveIterable.OfInt>
    implements FunctionalPrimitiveIterable.OfInt {
        public OfInt(Iterable<? extends PrimitiveIterable.OfInt> iterable) {
            super(iterable);
        }

        @Override
        public FunctionalPrimitiveIterator.OfInt iterator() {
            return new ChainedIterator.OfInt(this.iterables.map(PrimitiveIterable.OfInt::iterator).iterator());
        }
    }

    public static class OfDouble
    extends ChainedIterable<Double, PrimitiveIterable.OfDouble>
    implements FunctionalPrimitiveIterable.OfDouble {
        public OfDouble(Iterable<? extends PrimitiveIterable.OfDouble> iterable) {
            super(iterable);
        }

        @Override
        public FunctionalPrimitiveIterator.OfDouble iterator() {
            return new ChainedIterator.OfDouble(this.iterables.map(PrimitiveIterable.OfDouble::iterator).iterator());
        }
    }

    public static class Of<E>
    extends ChainedIterable<E, Iterable<E>> {
        public Of(Iterable<? extends Iterable<? extends E>> iterable) {
            super(iterable);
        }

        @Override
        public FunctionalIterator<E> iterator() {
            return new ChainedIterator.Of(this.iterables.map(Iterable::iterator).iterator());
        }
    }
}

