/*
 * Decompiled with CFR 0.152.
 */
package automata;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jltl2ba.APElement;
import jltl2ba.APElementIterator;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismPrintStreamLog;

public class DA<Symbol, Acceptance extends AcceptanceOmega> {
    private List<String> apList = null;
    private int size;
    private int start;
    private List<List<Edge>> edges;
    private Acceptance acceptance;

    public DA() {
        this(0);
    }

    public DA(int n) {
        this.size = n;
        this.start = -1;
        this.edges = new ArrayList<List<Edge>>(n);
        for (int i = 0; i < n; ++i) {
            this.edges.add(new ArrayList());
        }
    }

    public void setAcceptance(Acceptance Acceptance) {
        this.acceptance = Acceptance;
    }

    public Acceptance getAcceptance() {
        return this.acceptance;
    }

    public void setAPList(List<String> list) {
        this.apList = list;
    }

    public List<String> getAPList() {
        return this.apList;
    }

    public int addState() {
        this.edges.add(new ArrayList());
        ++this.size;
        return this.size - 1;
    }

    public void setStartState(int n) {
        this.start = n;
    }

    public boolean hasEdge(int n, Symbol Symbol) {
        for (Edge edge : this.edges.get(n)) {
            if (!edge.label.equals(Symbol)) continue;
            return true;
        }
        return false;
    }

    public void addEdge(int n, Symbol Symbol, int n2) {
        this.edges.get(n).add(new Edge(Symbol, n2));
    }

    public int size() {
        return this.size;
    }

    public int getStartState() {
        return this.start;
    }

    public int getNumEdges(int n) {
        return this.edges.get(n).size();
    }

    public int getEdgeDest(int n, int n2) {
        return this.edges.get(n).get(n2).dest;
    }

    public Symbol getEdgeLabel(int n, int n2) {
        return (Symbol)this.edges.get(n).get(n2).label;
    }

    public int getEdgeDestByLabel(int n, Symbol Symbol) {
        for (Edge edge : this.edges.get(n)) {
            if (!edge.label.equals(Symbol)) continue;
            return edge.dest;
        }
        return -1;
    }

    public void printDot(PrintStream printStream) throws PrismException {
        this.printDot(new PrismPrintStreamLog(printStream));
    }

    public void printDot(PrismLog prismLog) throws PrismException {
        int n;
        prismLog.println("digraph model {");
        for (n = 0; n < this.size; ++n) {
            prismLog.print("\t" + n + " [label=\"" + n + " [");
            prismLog.print(this.acceptance.getSignatureForState(n));
            prismLog.print("]\", shape=");
            if (n == this.start) {
                prismLog.println("doublecircle]");
                continue;
            }
            prismLog.println("ellipse]");
        }
        for (n = 0; n < this.size; ++n) {
            for (Edge edge : this.edges.get(n)) {
                prismLog.println("\t" + n + " -> " + edge.dest + " [label=\"" + String.valueOf(edge.label) + "\"]");
            }
        }
        prismLog.println("}");
    }

    /*
     * WARNING - void declaration
     */
    public static void printLtl2dstar(DA<BitSet, AcceptanceRabin> dA, PrintStream printStream) throws PrismException {
        AcceptanceRabin acceptanceRabin = dA.getAcceptance();
        if (dA.getStartState() < 0) {
            throw new PrismException("No start state in DA!");
        }
        printStream.println("DRA v2 explicit");
        printStream.println("States: " + dA.size());
        printStream.println("Acceptance-Pairs: " + acceptanceRabin.size());
        printStream.println("Start: " + dA.getStartState());
        printStream.print("AP: " + dA.getAPList().size());
        for (String object : dA.getAPList()) {
            printStream.print(" \"" + object + "\"");
        }
        printStream.println();
        printStream.println("---");
        for (int i = 0; i < dA.size(); ++i) {
            void var4_8;
            printStream.println("State: " + i);
            printStream.print("Acc-Sig:");
            boolean bl = false;
            while (var4_8 < acceptanceRabin.size()) {
                if (((AcceptanceRabin.RabinPair)acceptanceRabin.get((int)var4_8)).getL().get(i)) {
                    printStream.print(" -" + (int)var4_8);
                } else if (((AcceptanceRabin.RabinPair)acceptanceRabin.get((int)var4_8)).getK().get(i)) {
                    printStream.print(" +" + (int)var4_8);
                }
                ++var4_8;
            }
            printStream.println();
            APElementIterator aPElementIterator = new APElementIterator(dA.apList.size());
            while (aPElementIterator.hasNext()) {
                APElement aPElement = aPElementIterator.next();
                printStream.println(dA.getEdgeDestByLabel(i, aPElement));
            }
        }
    }

    public void printHOA(PrintStream printStream) throws PrismException {
        printStream.println("HOA: v1");
        printStream.println("States: " + this.size());
        printStream.print("AP: " + this.apList.size());
        for (String object : this.apList) {
            printStream.print(" \"" + object + "\"");
        }
        printStream.println();
        printStream.println("Start: " + this.start);
        this.acceptance.outputHOAHeader(printStream);
        printStream.println("properties: trans-labels explicit-labels state-acc no-univ-branch deterministic");
        printStream.println("--BODY--");
        for (int i = 0; i < this.size(); ++i) {
            printStream.print("State: " + i + " ");
            printStream.println(this.acceptance.getSignatureForStateHOA(i));
            for (Edge edge : this.edges.get(i)) {
                Object object = edge.label;
                if (!(object instanceof BitSet)) {
                    throw new PrismNotSupportedException("Can not print automaton with " + String.valueOf(object.getClass()) + " labels");
                }
                String string = "[" + APElement.toStringHOA((BitSet)object, this.apList.size()) + "]";
                printStream.print(string);
                printStream.print(" ");
                printStream.println(edge.dest);
            }
        }
        printStream.println("--END--");
    }

    public void print(PrismLog prismLog, String string) throws PrismException {
        switch (string) {
            case "txt": {
                prismLog.println(this.toString());
                break;
            }
            case "dot": {
                this.printDot(prismLog);
                break;
            }
            default: {
                prismLog.println(this.toString());
            }
        }
    }

    public void print(PrintStream printStream, String string) throws PrismException {
        switch (string) {
            case "txt": {
                printStream.println(this.toString());
                break;
            }
            case "dot": {
                this.printDot(printStream);
                break;
            }
            case "hoa": {
                this.printHOA(printStream);
                break;
            }
            default: {
                printStream.println(this.toString());
            }
        }
    }

    public String toString() {
        Object object = "";
        object = (String)object + this.size + " states (start " + this.start + ")";
        if (this.apList != null) {
            object = (String)object + ", " + this.apList.size() + " labels (" + String.valueOf(this.apList) + ")";
        }
        object = (String)object + ":";
        for (int i = 0; i < this.size; ++i) {
            for (Edge edge : this.edges.get(i)) {
                object = (String)object + " " + i + "-" + String.valueOf(edge.label) + "->" + edge.dest;
            }
        }
        object = (String)object + "; " + String.valueOf((Object)this.acceptance.getType()) + " acceptance: ";
        object = (String)object + String.valueOf(this.acceptance);
        return object;
    }

    public String getAutomataType() {
        return "D" + this.acceptance.getType().getNameAbbreviated() + "A";
    }

    public static void switchAcceptance(DA dA, AcceptanceOmega acceptanceOmega) {
        dA.acceptance = acceptanceOmega;
    }

    public void checkForCanonicalAPs(int n) throws PrismException {
        BitSet bitSet = new BitSet();
        for (String string : this.apList) {
            if (!string.substring(0, 1).equals("L")) {
                throw new PrismException("In deterministic automaton, unexpected atomic proposition " + string + ", expected L0, L1, ...");
            }
            try {
                int n2 = Integer.parseInt(string.substring(1));
                if (bitSet.get(n2)) {
                    throw new PrismException("In deterministic automaton, duplicate atomic proposition " + string);
                }
                if (n2 < 0) {
                    throw new PrismException("In deterministic automaton, unexpected atomic proposition " + string + ", expected L0, L1, ...");
                }
                if (n2 >= n) {
                    throw new PrismException("In deterministic automaton, unexpected atomic proposition " + string + ", expected highest index to be " + (n - 1));
                }
                bitSet.set(n2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PrismException("In deterministic automaton, unexpected atomic proposition " + string + ", expected L0, L1, ...");
            }
        }
    }

    class Edge {
        private Symbol label;
        private int dest;

        public Edge(Symbol Symbol, int n) {
            this.label = Symbol;
            this.dest = n;
        }
    }
}

