/*
 * Decompiled with CFR 0.152.
 */
package userinterface.simulator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import userinterface.GUIPrism;
import userinterface.simulator.GUISimulator;

public class GUITimeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private double time;
    private boolean cancelled;
    private static double lastTime = 1.0;
    private JPanel allPanel;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel inputLabel;
    private JButton okayButton;
    private JTextField timeInputField;
    private JPanel timeInputPanel;
    private JPanel topPanel;
    private JLabel warningLabel;

    private GUITimeDialog(GUIPrism gUIPrism, GUISimulator gUISimulator) {
        super(gUIPrism, "Provide a time", true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        this.time = lastTime;
        this.cancelled = false;
        this.timeInputField.setText("" + this.time);
        this.warningLabel.setIcon(GUIPrism.getIconFromImage("smallError.png"));
        this.warningLabel.setVisible(false);
        this.timeInputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                try {
                    Double.parseDouble(GUITimeDialog.this.timeInputField.getText());
                    GUITimeDialog.this.warningLabel.setVisible(false);
                    GUITimeDialog.this.okayButton.setEnabled(true);
                }
                catch (NumberFormatException numberFormatException) {
                    GUITimeDialog.this.warningLabel.setVisible(true);
                    GUITimeDialog.this.okayButton.setEnabled(false);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        super.setBounds(new Rectangle(550, 300));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void initComponents() {
        this.allPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.warningLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.topPanel = new JPanel();
        this.timeInputPanel = new JPanel();
        this.inputLabel = new JLabel();
        this.timeInputField = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUITimeDialog.this.closeDialog(windowEvent);
            }
        });
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.bottomPanel.setLayout(new BorderLayout());
        this.warningLabel.setText("Please enter a valid positive double");
        this.warningLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.bottomPanel.add((Component)this.warningLabel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUITimeDialog.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUITimeDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.bottomPanel.add((Component)this.buttonPanel, "East");
        this.allPanel.add((Component)this.bottomPanel, "South");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(BorderFactory.createTitledBorder("Time spent in state"));
        this.timeInputPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.timeInputPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.inputLabel.setText("Provide a time:");
        this.timeInputPanel.add(this.inputLabel);
        this.timeInputField.setText("1.0");
        this.timeInputPanel.add(this.timeInputField);
        this.topPanel.add((Component)this.timeInputPanel, "North");
        this.allPanel.add((Component)this.topPanel, "Center");
        this.getContentPane().add((Component)this.allPanel, "Center");
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.time = Double.parseDouble(this.timeInputField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.cancelled = true;
        }
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public double getTime() {
        return this.time;
    }

    public static double askTime(GUIPrism gUIPrism, GUISimulator gUISimulator) {
        GUITimeDialog gUITimeDialog = new GUITimeDialog(gUIPrism, gUISimulator);
        if (gUITimeDialog.isCancelled()) {
            return -1.0;
        }
        lastTime = gUITimeDialog.time;
        return gUITimeDialog.time;
    }
}

