/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import parser.type.Type;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import prism.DefinedConstant;
import userinterface.properties.GUIGraphPicker;

public class GraphConstantLine
extends JPanel {
    public static final String SINGLE_DEFAULT = "0";
    public static final String RANGE_START_DEFAULT = "0";
    public static final String RANGE_END_DEFAULT = "1";
    public static final String STEP_DEFAULT = "1";
    private DefinedConstant dc;
    private GUIGraphPicker parent;
    private Type type;
    private JComboBox boolSingleValueCombo;
    private ButtonGroup choiceButtonGroup;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel nameLabel;
    private JPanel sizerPanel;
    private JLabel typeLabel;
    private JComboBox valuePicker;

    public GraphConstantLine(DefinedConstant definedConstant, GUIGraphPicker gUIGraphPicker) {
        this.dc = definedConstant;
        this.parent = gUIGraphPicker;
        this.initComponents();
        this.valuePicker.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof Double) {
                    this.setComponentOrientation(jList.getComponentOrientation());
                    if (bl) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(jList.getBackground());
                        this.setForeground(jList.getForeground());
                    }
                    if (object instanceof Icon) {
                        this.setIcon((Icon)object);
                        this.setText("");
                    } else {
                        this.setIcon(null);
                        Double d = (Double)object;
                        NumberFormat numberFormat = DecimalFormat.getInstance(Locale.UK);
                        numberFormat.setMaximumFractionDigits(6);
                        String string = numberFormat.format(d);
                        this.setText(object == null ? "" : string);
                    }
                    this.setEnabled(jList.isEnabled());
                    this.setFont(jList.getFont());
                    this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
                    return this;
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.setBorder(new BottomBorder());
        this.setConstName(definedConstant.getName());
        this.setConstType(definedConstant.getType());
        this.init();
    }

    private void init() {
        this.valuePicker.addItem("All series");
        for (int i = 0; i < this.dc.getNumSteps(); ++i) {
            this.valuePicker.addItem(this.dc.getValue(i));
        }
    }

    public void setConstName(String string) {
        this.nameLabel.setText(string);
    }

    public void setConstType(Type type) {
        this.type = type;
        if (type instanceof TypeDouble) {
            this.typeLabel.setText("double");
        } else if (type instanceof TypeInt) {
            this.typeLabel.setText("int");
        } else {
            this.typeLabel.setText("unknown");
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.nameLabel.setEnabled(bl);
        this.typeLabel.setEnabled(bl);
        this.valuePicker.setEnabled(bl);
        if (bl) {
            this.setBackground(Color.white);
            this.jPanel1.setBackground(Color.white);
            this.jPanel2.setBackground(Color.white);
            this.jPanel3.setBackground(Color.white);
        } else {
            this.setBackground(Color.lightGray);
            this.jPanel1.setBackground(Color.lightGray);
            this.jPanel2.setBackground(Color.lightGray);
            this.jPanel3.setBackground(Color.lightGray);
        }
    }

    @Override
    public String getName() {
        return this.nameLabel.getText();
    }

    public Object getSelectedValue() {
        return this.valuePicker.getSelectedItem();
    }

    public DefinedConstant getDC() {
        return this.dc;
    }

    private void initComponents() {
        this.choiceButtonGroup = new ButtonGroup();
        this.boolSingleValueCombo = new JComboBox();
        this.sizerPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.nameLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.typeLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.valuePicker = new JComboBox();
        this.boolSingleValueCombo.setBackground(new Color(255, 255, 255));
        this.boolSingleValueCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"true", "false"}));
        this.boolSingleValueCombo.setMinimumSize(new Dimension(4, 19));
        this.boolSingleValueCombo.setPreferredSize(new Dimension(4, 19));
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.setPreferredSize(new Dimension(300, 26));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.nameLabel.setText("a");
        this.nameLabel.setPreferredSize(new Dimension(30, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.jPanel2.setBackground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.typeLabel.setText("double");
        this.typeLabel.setPreferredSize(new Dimension(50, 15));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.typeLabel, gridBagConstraints);
        this.jPanel3.setBackground(new Color(255, 255, 255));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.valuePicker.setBackground(new Color(255, 255, 255));
        this.valuePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphConstantLine.this.valuePickerActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.7;
        this.add((Component)this.valuePicker, gridBagConstraints);
    }

    private void valuePickerActionPerformed(ActionEvent actionEvent) {
        this.parent.resetAutoSeriesName();
    }

    class BottomBorder
    implements Border {
        BottomBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
    }
}

