/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import userinterface.GUIPlugin;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.pepaModel.GUIPepaModelEditor;
import userinterface.util.GUIComputationEvent;

public class LoadPEPAModelThread
extends Thread {
    private GUIMultiModelHandler handler;
    private GUIModelEditor edit;
    private File f;
    private boolean reload;
    private GUIPlugin plug;
    private GUIPepaModelEditor pepaEdit;
    private boolean replace;
    private Exception ex;

    public LoadPEPAModelThread(GUIMultiModelHandler gUIMultiModelHandler, GUIModelEditor gUIModelEditor, File file, boolean bl) {
        this.handler = gUIMultiModelHandler;
        this.edit = gUIModelEditor;
        this.f = file;
        this.reload = bl;
        this.plug = gUIMultiModelHandler.getGUIPlugin();
        this.replace = false;
        this.ex = null;
    }

    @Override
    public void run() {
        if (this.edit instanceof GUIPepaModelEditor) {
            this.pepaEdit = (GUIPepaModelEditor)this.edit;
            this.replace = false;
        } else {
            this.pepaEdit = new GUIPepaModelEditor(this.handler);
            this.replace = true;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        LoadPEPAModelThread.this.plug.startProgress();
                        LoadPEPAModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, LoadPEPAModelThread.this.plug));
                        LoadPEPAModelThread.this.plug.setTaskBarText("Loading model...");
                        LoadPEPAModelThread.this.pepaEdit.read(new FileReader(LoadPEPAModelThread.this.f), LoadPEPAModelThread.this.f);
                    }
                    catch (IOException iOException) {
                        LoadPEPAModelThread.this.ex = iOException;
                    }
                }
            });
            if (this.ex != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        LoadPEPAModelThread.this.plug.stopProgress();
                        LoadPEPAModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, LoadPEPAModelThread.this.plug));
                        LoadPEPAModelThread.this.plug.setTaskBarText("Loading model... error.");
                        LoadPEPAModelThread.this.plug.error("Could not open file \"" + String.valueOf(LoadPEPAModelThread.this.f) + "\"");
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LoadPEPAModelThread.this.plug.stopProgress();
                    LoadPEPAModelThread.this.plug.setTaskBarText("Loading model... done.");
                    LoadPEPAModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, LoadPEPAModelThread.this.plug));
                    if (!LoadPEPAModelThread.this.reload) {
                        LoadPEPAModelThread.this.handler.pepaModelLoaded(LoadPEPAModelThread.this.pepaEdit, LoadPEPAModelThread.this.f, LoadPEPAModelThread.this.replace);
                    } else {
                        LoadPEPAModelThread.this.handler.pepaModelReLoaded(LoadPEPAModelThread.this.f);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

