/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import prism.PrismLangException;
import prism.PrismSettings;
import prism.PrismSettingsListener;
import userinterface.GUIPrism;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIMultiModel;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.GUITextModelEditorGutter;
import userinterface.model.PepaEditorKit;
import userinterface.model.PrismEditorKit;
import userinterface.util.GUIEvent;
import userinterface.util.GUIUndoManager;

public class GUITextModelEditor
extends GUIModelEditor
implements DocumentListener,
MouseListener {
    private GUIMultiModelHandler handler;
    private JEditorPane editor;
    private DefaultHighlighter.DefaultHighlightPainter errorHighlightPainter;
    private GUIUndoManager undoManager;
    private JScrollPane editorScrollPane;
    private GUITextModelEditorGutter gutter;
    private boolean showLineNumbersSetting = true;
    private JPopupMenu contextPopup;
    private Action actionSearch;
    private Action actionJumpToError;
    private Action insertDTMC;
    private Action insertCTMC;
    private Action insertMDP;
    private PrismLangException parseError;
    private Object parseErrorHighlightKey;
    MouseListener editorMouseListener = new MouseListener(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    };

    public GUITextModelEditor(String string, GUIMultiModelHandler gUIMultiModelHandler) {
        this.handler = gUIMultiModelHandler;
        this.setLayout(new BorderLayout());
        this.editor = new JEditorPane(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                if (GUITextModelEditor.this.parseError != null) {
                    try {
                        int n = this.viewToModel(new Point(mouseEvent.getX(), mouseEvent.getY()));
                        int n2 = GUITextModelEditor.this.computeDocumentOffset(GUITextModelEditor.this.parseError.getBeginLine(), GUITextModelEditor.this.parseError.getBeginColumn());
                        int n3 = GUITextModelEditor.this.computeDocumentOffset(GUITextModelEditor.this.parseError.getEndLine(), GUITextModelEditor.this.parseError.getEndColumn()) + 1;
                        if (n >= n2 && n <= n3) {
                            return GUITextModelEditor.this.parseError.getMessage();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
        this.editor.setToolTipText("dummy");
        this.editor.setEditorKitForContentType("text/prism", new PrismEditorKit(gUIMultiModelHandler));
        this.editor.setEditorKitForContentType("text/pepa", new PepaEditorKit(gUIMultiModelHandler));
        this.editor.setContentType("text/prism");
        this.editor.setBackground(Color.white);
        this.editor.addMouseListener(this.editorMouseListener);
        this.editor.setEditable(true);
        this.editor.setText(string);
        this.editor.getDocument().addDocumentListener(this);
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                GUITextModelEditor.this.handler.getGUIPlugin().getSelectionChangeHandler().notifyListeners(new GUIEvent(1));
            }
        });
        this.editor.getDocument().putProperty("tabSize", 4);
        this.editor.addMouseListener(this);
        this.errorHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 192, 192));
        this.undoManager = new GUIUndoManager(GUIPrism.getGUI());
        this.undoManager.setLimit(200);
        this.editorScrollPane = new JScrollPane(this.editor);
        this.add((Component)this.editorScrollPane, "Center");
        this.gutter = new GUITextModelEditorGutter(this.editor);
        this.showLineNumbersSetting = gUIMultiModelHandler.getGUIPlugin().getPrism().getSettings().getBoolean("model.prismEditor.lineNumbers");
        if (this.showLineNumbersSetting) {
            this.editorScrollPane.setRowHeaderView(this.gutter);
        }
        gUIMultiModelHandler.getGUIPlugin().getPrism().getSettings().addSettingsListener(new PrismSettingsListener(){

            @Override
            public void notifySettings(PrismSettings prismSettings) {
                if (prismSettings.getBoolean("model.prismEditor.lineNumbers") != GUITextModelEditor.this.showLineNumbersSetting) {
                    GUITextModelEditor.this.showLineNumbersSetting = !GUITextModelEditor.this.showLineNumbersSetting;
                    if (GUITextModelEditor.this.showLineNumbersSetting) {
                        GUITextModelEditor.this.editorScrollPane.setRowHeaderView(GUITextModelEditor.this.gutter);
                    } else {
                        GUITextModelEditor.this.editorScrollPane.setRowHeaderView(null);
                    }
                }
            }
        });
        this.initActions();
        this.initContextMenu();
        InputMap inputMap = this.editor.getInputMap();
        inputMap.clear();
        inputMap.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "prism_undo");
        inputMap.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "prism_undo");
        inputMap.put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "prism_redo");
        inputMap.put(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "prism_selectall");
        inputMap.put(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "prism_delete");
        inputMap.put(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "prism_cut");
        inputMap.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1), "prism_redo");
        inputMap.put(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "prism_paste");
        inputMap.put(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "prism_jumperr");
        ActionMap actionMap = this.editor.getActionMap();
        actionMap.put("prism_undo", GUIPrism.getClipboardPlugin().getUndoAction());
        actionMap.put("prism_redo", GUIPrism.getClipboardPlugin().getRedoAction());
        actionMap.put("prism_selectall", GUIPrism.getClipboardPlugin().getSelectAllAction());
        actionMap.put("prism_cut", GUIPrism.getClipboardPlugin().getCutAction());
        actionMap.put("prism_copy", GUIPrism.getClipboardPlugin().getCopyAction());
        actionMap.put("prism_paste", GUIPrism.getClipboardPlugin().getPasteAction());
        actionMap.put("prism_delete", GUIPrism.getClipboardPlugin().getDeleteAction());
        actionMap.put("prism_jumperr", this.actionJumpToError);
        this.editor.getDocument().addUndoableEditListener(this.undoManager);
        this.editor.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                System.out.println("adding undo edit");
            }
        });
    }

    private void initActions() {
        this.actionJumpToError = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUITextModelEditor.this.jumpToError();
            }
        };
        this.actionJumpToError.putValue("Name", "Jump to error");
        this.actionJumpToError.putValue("SmallIcon", GUIPrism.getIconFromImage("tinyError.png"));
        this.actionJumpToError.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.actionSearch = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.actionSearch.putValue("LongDescription", "Opens a find and replace dialog.");
        this.actionSearch.putValue("Name", "Find/Replace");
        this.insertDTMC = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUITextModelEditor.this.editor.getCaretPosition();
                try {
                    GUITextModelEditor.this.editor.getDocument().insertString(n, "dtmc", new SimpleAttributeSet());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        };
        this.insertDTMC.putValue("LongDescription", "Marks this model as a \"Discrete-Time Markov Chain\"");
        this.insertDTMC.putValue("Name", "Probabilistic (DTMC)");
        this.insertCTMC = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUITextModelEditor.this.editor.getCaretPosition();
                try {
                    GUITextModelEditor.this.editor.getDocument().insertString(n, "ctmc", new SimpleAttributeSet());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        };
        this.insertCTMC.putValue("LongDescription", "Marks this model as a \"Continous-Time Markov Chain\"");
        this.insertCTMC.putValue("Name", "Stochastic (CTMC)");
        this.insertMDP = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUITextModelEditor.this.editor.getCaretPosition();
                try {
                    GUITextModelEditor.this.editor.getDocument().insertString(n, "mdp", new SimpleAttributeSet());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        };
        this.insertMDP.putValue("LongDescription", "Marks this model as a \"Markov Decision Process\"");
        this.insertMDP.putValue("Name", "Non-deterministic (MDP)");
    }

    private void initContextMenu() {
        this.contextPopup = new JPopupMenu();
        this.contextPopup.add(GUIPrism.getClipboardPlugin().getUndoAction());
        this.contextPopup.add(GUIPrism.getClipboardPlugin().getRedoAction());
        this.contextPopup.add(new JSeparator());
        this.contextPopup.add(GUIPrism.getClipboardPlugin().getCutAction());
        this.contextPopup.add(GUIPrism.getClipboardPlugin().getCopyAction());
        this.contextPopup.add(GUIPrism.getClipboardPlugin().getPasteAction());
        this.contextPopup.add(GUIPrism.getClipboardPlugin().getDeleteAction());
        this.contextPopup.add(new JSeparator());
        this.contextPopup.add(GUIPrism.getClipboardPlugin().getSelectAllAction());
        this.contextPopup.add(new JSeparator());
        this.contextPopup.add(((GUIMultiModel)this.handler.getGUIPlugin()).getParseModel());
        this.contextPopup.add(((GUIMultiModel)this.handler.getGUIPlugin()).getBuildModel());
        this.contextPopup.add(new JSeparator());
        this.contextPopup.add(((GUIMultiModel)this.handler.getGUIPlugin()).getExportMenu());
        this.contextPopup.add(((GUIMultiModel)this.handler.getGUIPlugin()).getViewMenu());
        this.contextPopup.add(((GUIMultiModel)this.handler.getGUIPlugin()).getComputeMenu());
        this.contextPopup.add(((GUIMultiModel)this.handler.getGUIPlugin()).getComputeExportMenu());
        if (this.editor.getContentType().equals("text/prism")) {
            JMenu jMenu = new JMenu("Insert elements");
            JMenu jMenu2 = new JMenu("Model type");
            jMenu.add(jMenu2);
            JMenu jMenu3 = new JMenu("Module");
            jMenu.add(jMenu3);
            JMenu jMenu4 = new JMenu("Variable");
            jMenu.add(jMenu4);
            jMenu2.add(this.insertDTMC);
            jMenu2.add(this.insertCTMC);
            jMenu2.add(this.insertMDP);
        }
    }

    public void setContentType(String string) {
        this.editor.setContentType(string);
    }

    public void read(Reader reader, Object object) throws IOException {
        this.editor.getDocument().removeUndoableEditListener(this.undoManager);
        this.editor.read(reader, object);
        this.editor.getDocument().addDocumentListener(this);
        this.editor.getDocument().addUndoableEditListener(this.undoManager);
    }

    public void setText(String string) {
        this.editor.setText(string);
    }

    public void write(Writer writer) throws IOException {
        this.editor.write(writer);
    }

    public String getTextString() {
        return this.editor.getText();
    }

    @Override
    public void newModel() {
        try {
            this.read(new StringReader(""), "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.handler != null) {
            this.handler.hasModified(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.handler != null) {
            this.handler.hasModified(true);
        }
    }

    @Override
    public String getParseText() {
        return this.editor.getText();
    }

    @Override
    public void undo() {
        try {
            this.undoManager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    @Override
    public void redo() {
        try {
            this.undoManager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    @Override
    public void copy() {
        this.editor.copy();
    }

    @Override
    public void cut() {
        this.editor.cut();
    }

    @Override
    public void paste() {
        this.editor.paste();
    }

    @Override
    public void delete() {
        try {
            this.editor.getDocument().remove(this.editor.getSelectionStart(), this.editor.getSelectionEnd() - this.editor.getSelectionStart());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void selectAll() {
        this.editor.selectAll();
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }

    public void setEditable(boolean bl) {
        this.editor.setEditable(bl);
    }

    public void setEditorFont(Font font) {
        this.editor.setFont(font);
    }

    public void setEditorBackground(Color color) {
        this.editor.setBackground(color);
    }

    public JEditorPane getEditorPane() {
        return this.editor;
    }

    public void mouseTriggered(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.actionJumpToError.setEnabled(this.parseError != null && this.parseError.hasLineNumbers());
            ((GUIMultiModel)this.handler.getGUIPlugin()).doEnables();
            this.contextPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseTriggered(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseTriggered(mouseEvent);
    }

    public void jumpToError() {
        if (this.parseError != null && this.parseError.hasLineNumbers()) {
            try {
                int n = this.computeDocumentOffset(this.parseError.getBeginLine(), this.parseError.getBeginColumn());
                this.editor.setCaretPosition(n);
                Rectangle rectangle = this.editor.modelToView(n);
                int n2 = (this.editor.getVisibleRect().height - rectangle.height) / 2;
                Rectangle rectangle2 = new Rectangle(0, rectangle.y - n2, this.editor.getVisibleRect().width, rectangle.height + 2 * n2);
                this.editor.scrollRectToVisible(rectangle2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void refreshErrorDisplay() {
        if (this.parseErrorHighlightKey != null) {
            this.editor.getHighlighter().removeHighlight(this.parseErrorHighlightKey);
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        if (this.parseError != null && this.parseError.hasLineNumbers()) {
            String string = this.parseError.getMessage();
            hashMap.put(this.parseError.getBeginLine(), string);
        }
        this.gutter.setParseErrors(hashMap);
        if (this.parseError != null && this.parseError.hasLineNumbers()) {
            try {
                this.parseErrorHighlightKey = this.editor.getHighlighter().addHighlight(this.computeDocumentOffset(this.parseError.getBeginLine(), this.parseError.getBeginColumn()), this.computeDocumentOffset(this.parseError.getEndLine(), this.parseError.getEndColumn()) + 1, this.errorHighlightPainter);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public int computeDocumentOffset(int n, int n2) throws BadLocationException {
        if (n < 0 || n2 < 0) {
            throw new BadLocationException("Negative line/col", -1);
        }
        Element element = this.editor.getDocument().getDefaultRootElement().getElement(n - 1);
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        String string = this.editor.getDocument().getText(n3, n4 - n3);
        int n5 = 1;
        int n6 = 0;
        while (n5 < n2) {
            if (n6 < string.length() && string.charAt(n6) == '\t') {
                n5 += 8;
                ++n6;
                continue;
            }
            ++n5;
            ++n6;
        }
        return n3 + n6;
    }

    @Override
    public void modelParseFailed(PrismLangException prismLangException, boolean bl) {
        this.parseError = prismLangException;
        this.refreshErrorDisplay();
        if (!bl) {
            this.jumpToError();
        }
    }

    @Override
    public void modelParseSuccessful() {
        this.parseError = null;
        this.refreshErrorDisplay();
    }

    @Override
    public GUIUndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public boolean canDoClipBoardAction(Action action) {
        if (action == GUIPrism.getClipboardPlugin().getPasteAction()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            return clipboard.getContents(null) != null;
        }
        if (action == GUIPrism.getClipboardPlugin().getCutAction() || action == GUIPrism.getClipboardPlugin().getCopyAction() || action == GUIPrism.getClipboardPlugin().getDeleteAction()) {
            return this.editor.getSelectedText() != null;
        }
        if (action == GUIPrism.getClipboardPlugin().getSelectAllAction()) {
            return true;
        }
        return this.handler.canDoClipBoardAction(action);
    }
}

