/*
 * Decompiled with CFR 0.152.
 */
package prism;

import cex.CexPathAsBDDs;
import com.martiansoftware.nailgun.NGExitException;
import com.martiansoftware.nailgun.NGServer;
import common.StackTraceHelper;
import common.Timeout;
import csv.CsvFormatException;
import io.ModelExportFormat;
import io.ModelExportOptions;
import io.ModelExportTask;
import io.PrismExplicitImporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jdd.DebugJDD;
import jdd.JDD;
import parser.Values;
import parser.ast.Expression;
import parser.ast.ExpressionReward;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismModelListener;
import prism.PrismNative;
import prism.PrismNotSupportedException;
import prism.PrismSettings;
import prism.PrismUtils;
import prism.Result;
import prism.ResultsCollection;
import prism.ResultsExporter;
import prism.ResultsImporter;
import prism.UndefinedConstants;
import simulator.GenerateSimulationPath;
import simulator.method.ACIconfidence;
import simulator.method.ACIiterations;
import simulator.method.ACIwidth;
import simulator.method.APMCapproximation;
import simulator.method.APMCconfidence;
import simulator.method.APMCiterations;
import simulator.method.CIconfidence;
import simulator.method.CIiterations;
import simulator.method.CIwidth;
import simulator.method.SPRTMethod;
import simulator.method.SimulationMethod;
import strat.StrategyExportOptions;

public class PrismCL
implements PrismModelListener {
    private boolean importpepa = false;
    private boolean importprismpp = false;
    private boolean importinitdist = false;
    private boolean importresults = false;
    private boolean steadystate = false;
    private boolean dotransient = false;
    private boolean exportprism = false;
    private boolean exportprismconst = false;
    private boolean exportmodeldotview = false;
    private boolean exportsccs = false;
    private boolean exportbsccs = false;
    private boolean exportmecs = false;
    private boolean exportresults = false;
    private ResultsExporter.ResultsExportShape exportShape = ResultsExporter.ResultsExportShape.LIST_PLAIN;
    private boolean exportvector = false;
    private int exportType = 1;
    private boolean exportstrat = false;
    private boolean simulate = false;
    private boolean simpath = false;
    private boolean param = false;
    private ModelType typeOverride = null;
    private boolean orderingOverride = false;
    private boolean explicitbuild = false;
    private boolean explicitbuildtest = false;
    private boolean nobuild = false;
    private boolean test = false;
    private boolean testExitsOnFail = true;
    private List<ModelExportTask> modelExportTasks = new ArrayList<ModelExportTask>();
    private ModelExportOptions modelExportOptionsGlobal = new ModelExportOptions();
    private List<ModelImportSource> modelImportSources = new ArrayList<ModelImportSource>();
    private List<Object> propertyIndices = null;
    private String propertyString = "";
    private String constSwitch = null;
    private String simpathDetails = null;
    private String prismppParams = null;
    private String paramSwitch = null;
    private String mainLogFilename = "stdout";
    private String settingsFilename = null;
    private String modelFilename = null;
    private String importInitDistFilename = null;
    private String importResultsFilename = null;
    private String importModelWarning = null;
    private String propertiesFilename = null;
    private String exportPrismFilename = null;
    private String exportPrismConstFilename = null;
    private String exportSCCsFilename = null;
    private String exportBSCCsFilename = null;
    private String exportMECsFilename = null;
    private String exportResultsFilename = null;
    private String exportVectorFilename = null;
    private String exportSteadyStateFilename = null;
    private String exportTransientFilename = null;
    private String exportStratFilename = null;
    private String simpathFilename = null;
    private PrismLog mainLog = null;
    private Prism prism = null;
    private ModulesFile modulesFile = null;
    private PropertiesFile propertiesFile = null;
    boolean modelBuildFail = false;
    Exception modelBuildException = null;
    private int numPropertiesToCheck = 0;
    private List<Property> propertiesToCheck = null;
    private UndefinedConstants[] undefinedConstants;
    private UndefinedConstants undefinedMFConstants;
    private Values definedMFConstants;
    private Values definedPFConstants;
    private ResultsCollection[] results = null;
    private String transientTime;
    private String simMethodName = null;
    private double simApprox;
    private double simConfidence;
    private int simNumSamples;
    private double simWidth;
    private int reqIterToConclude;
    private double simMaxReward;
    private long simMaxPath;
    private boolean simApproxGiven = false;
    private boolean simConfidenceGiven = false;
    private boolean simNumSamplesGiven = false;
    private boolean simWidthGiven = false;
    private boolean reqIterToConcludeGiven = false;
    private boolean simMaxRewardGiven = false;
    private boolean simMaxPathGiven = false;
    private boolean simManual = false;
    private SimulationMethod simMethod = null;
    private StrategyExportOptions exportStratOptions = null;
    private String[] paramLowerBounds = null;
    private String[] paramUpperBounds = null;
    private String[] paramNames = null;
    private boolean exactConstants = false;

    public void go(String[] stringArray) {
        try {
            this.run(stringArray);
        }
        catch (JDD.CuddOutOfMemoryException cuddOutOfMemoryException) {
            this.mainLog.println("\nCUDD internal error detected, from the following stack trace:");
            for (StackTraceElement stackTraceElement : cuddOutOfMemoryException.getStackTrace()) {
                this.mainLog.print("  ");
                this.mainLog.println(stackTraceElement);
            }
            this.errorAndExit(cuddOutOfMemoryException.getMessage() + ".\nTip: Try using the -cuddmaxmem switch to increase the memory available to CUDD");
        }
        catch (NGExitException nGExitException) {
            throw nGExitException;
        }
        catch (Exception | StackOverflowError throwable) {
            this.mainLog.println();
            if (throwable instanceof StackOverflowError) {
                this.mainLog.println(throwable.toString());
                this.mainLog.println(StackTraceHelper.asString(throwable, 25));
                this.mainLog.println("Try increasing the value of the Java stack size (via the -javastack argument).");
            } else {
                this.mainLog.print(throwable.toString() + "\n" + StackTraceHelper.asString(throwable, 0));
            }
            this.errorAndExit("Caught unhandled exception, aborting...");
        }
    }

    public void run(String[] stringArray) {
        int n;
        this.initialise(stringArray);
        if (this.importresults) {
            this.importResults();
            if (this.exportresults) {
                this.exportResults();
            }
            this.closeDown();
            return;
        }
        this.doParsing();
        this.sortProperties();
        this.exactConstants = this.param || this.prism.getSettings().getBoolean("prism.exact.enabled");
        try {
            this.undefinedMFConstants = this.modelExportTasks.stream().anyMatch(ModelExportTask::extraLabelsUsed) ? new UndefinedConstants(this.modulesFile, this.propertiesFile, true) : new UndefinedConstants(this.modulesFile, null);
            this.undefinedMFConstants.setExactMode(this.exactConstants);
            this.undefinedConstants = new UndefinedConstants[this.numPropertiesToCheck];
            for (n = 0; n < this.numPropertiesToCheck; ++n) {
                this.undefinedConstants[n] = new UndefinedConstants(this.modulesFile, this.propertiesFile, this.propertiesToCheck.get(n));
                this.undefinedConstants[n].setExactMode(this.exactConstants);
            }
            if (this.param) {
                this.undefinedMFConstants.removeConstants(this.paramNames);
                for (n = 0; n < this.numPropertiesToCheck; ++n) {
                    this.undefinedConstants[n].removeConstants(this.paramNames);
                }
            }
            this.undefinedMFConstants.defineUsingConstSwitch(this.constSwitch);
            for (n = 0; n < this.numPropertiesToCheck; ++n) {
                this.undefinedConstants[n].defineUsingConstSwitch(this.constSwitch);
            }
        }
        catch (PrismException prismException) {
            this.errorAndExit(prismException.getMessage());
        }
        if (this.param) {
            this.prism.setParametric(this.paramNames, this.paramLowerBounds, this.paramUpperBounds);
        }
        if (this.prism.getSettings().getChoice("prism.exportAdv") != 1) {
            if (this.prism.getModelType() == ModelType.MDP && this.prism.getCurrentEngine() == Prism.PrismEngine.EXPLICIT) {
                this.errorAndExit("The -exportadv functionality does not work for the explicit engine; use -exportstrat instead");
            }
            if (this.prism.getModelType().partiallyObservable() || this.prism.getModelType().uncertain()) {
                this.errorAndExit("The -exportadv functionality does not work for the explicit engine; use -exportstrat instead");
            }
        }
        this.results = new ResultsCollection[this.numPropertiesToCheck];
        for (n = 0; n < this.numPropertiesToCheck; ++n) {
            this.results[n] = new ResultsCollection(this.undefinedConstants[n], this.propertiesToCheck.get(n).getExpression().getResultName());
        }
        for (n = 0; n < this.undefinedMFConstants.getNumModelIterations(); ++n) {
            Object object;
            int n2;
            try {
                this.definedMFConstants = this.undefinedMFConstants.getMFConstantValues();
                this.prism.setPRISMModelConstants(this.definedMFConstants, this.exactConstants);
            }
            catch (PrismException prismException) {
                this.error(prismException.getMessage());
                for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                    this.results[n2].setMultipleErrors(this.definedMFConstants, null, prismException);
                }
                this.undefinedMFConstants.iterateModel();
                for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                    this.undefinedConstants[n2].iterateModel();
                }
                continue;
            }
            this.modelBuildFail = false;
            if (this.simpath) {
                try {
                    if (!this.simMaxPathGiven) {
                        this.simMaxPath = this.prism.getSettings().getLong("simulator.defaultMaxPath");
                    }
                    object = this.simpathFilename.equals("stdout") ? null : new File(this.simpathFilename);
                    this.prism.generateSimulationPath(this.simpathDetails, this.simMaxPath, (File)object);
                }
                catch (PrismException prismException) {
                    this.error(prismException.getMessage());
                }
                this.undefinedMFConstants.iterateModel();
                for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                    this.undefinedConstants[n2].iterateModel();
                }
            }
            try {
                this.doExports();
            }
            catch (PrismException prismException) {
                this.error(prismException);
            }
            if (this.modelBuildFail) continue;
            this.doSteadyState();
            if (this.modelBuildFail) continue;
            this.doTransient();
            if (this.modelBuildFail) continue;
            for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                block56: {
                    if (this.simulate && this.undefinedConstants[n2].getNumPropertyIterations() > 1) {
                        try {
                            this.simMethod = this.processSimulationOptions(this.propertiesToCheck.get(n2).getExpression());
                            this.prism.modelCheckSimulatorExperiment(this.propertiesFile, this.undefinedConstants[n2], this.results[n2], this.propertiesToCheck.get(n2).getExpression(), null, this.simMaxPath, this.simMethod);
                            break block56;
                        }
                        catch (PrismException prismException) {
                            this.error(prismException.getMessage());
                            this.results[n2].setMultipleErrors(this.definedMFConstants, null, prismException);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            break block56;
                        }
                    }
                    for (int i = 0; i < this.undefinedConstants[n2].getNumPropertyIterations(); ++i) {
                        Result result;
                        try {
                            if (this.propertiesFile != null) {
                                this.definedPFConstants = this.undefinedConstants[n2].getPFConstantValues();
                                this.propertiesFile.setSomeUndefinedConstants(this.definedPFConstants, this.exactConstants);
                            }
                            if (!this.simulate) {
                                result = this.prism.modelCheck(this.propertiesFile, this.propertiesToCheck.get(n2));
                            } else {
                                this.simMethod = this.processSimulationOptions(this.propertiesToCheck.get(n2).getExpression());
                                result = this.prism.modelCheckSimulator(this.propertiesFile, this.propertiesToCheck.get(n2).getExpression(), this.definedPFConstants, null, this.simMaxPath, this.simMethod);
                                this.simMethod.reset();
                            }
                        }
                        catch (PrismException prismException) {
                            this.error(prismException.getMessage(), true);
                            result = new Result(prismException);
                        }
                        if (this.modelBuildFail) {
                            this.results[n2].setMultipleErrors(this.definedMFConstants, null, this.modelBuildException);
                            if (!this.test) break;
                            this.doResultTest(this.propertiesToCheck.get(n2), new Result(this.modelBuildException), this.prism.getModelInfo().getConstantValues(), this.propertiesFile.getConstantValues());
                            break;
                        }
                        this.results[n2].setResult(this.definedMFConstants, this.definedPFConstants, result.getResult());
                        object = result.getCounterexample();
                        if (object != null) {
                            this.mainLog.println("\nCounterexample/witness:");
                            this.mainLog.println(object);
                            if (object instanceof CexPathAsBDDs) {
                                ((CexPathAsBDDs)object).clear();
                            }
                        }
                        if (this.exportstrat && result.getStrategy() != null) {
                            try {
                                this.prism.exportStrategy(result.getStrategy(), this.exportStratOptions, this.exportStratFilename.equals("stdout") ? null : new File(this.exportStratFilename));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                this.error("Couldn't open file \"" + this.exportStratFilename + "\" for output");
                            }
                            catch (PrismException prismException) {
                                this.error(prismException.getMessage());
                            }
                        }
                        if (this.exportvector && result.getVector() != null) {
                            PrismLog prismLog;
                            this.mainLog.print("\nExporting vector of results for all states ");
                            this.mainLog.println((String)(this.exportVectorFilename.equals("stdout") ? "below:" : "to file \"" + this.exportVectorFilename + "\"..."));
                            boolean bl = this.exportVectorFilename.equals("stdout");
                            PrismLog prismLog2 = prismLog = bl ? this.prism.getMainLog() : new PrismFileLog(this.exportVectorFilename);
                            if (!prismLog.ready()) {
                                this.errorAndExit("Couldn't open file \"" + this.exportVectorFilename + "\" for output");
                            }
                            try {
                                result.getVector().print(prismLog, false, false, bl, bl);
                            }
                            catch (PrismException prismException) {
                                this.error(prismException.getMessage());
                            }
                            result.getVector().clear();
                            if (!bl) {
                                prismLog.close();
                            }
                        }
                        if (this.test) {
                            this.doResultTest(this.propertiesToCheck.get(n2), result, this.prism.getModelInfo().getConstantValues(), this.propertiesFile.getConstantValues());
                        }
                        this.undefinedConstants[n2].iterateProperty();
                    }
                }
                if (!this.modelBuildFail) continue;
                ++n2;
                while (n2 < this.numPropertiesToCheck) {
                    this.results[n2].setMultipleErrors(this.definedMFConstants, null, this.modelBuildException);
                    if (this.test) {
                        this.doResultTest(this.propertiesToCheck.get(n2), new Result(this.modelBuildException), this.prism.getModelInfo().getConstantValues(), this.propertiesFile.getConstantValues());
                    }
                    ++n2;
                }
                break;
            }
            if (!(this.propertiesToCheck.size() != 0 || this.steadystate || this.dotransient || this.simpath || this.nobuild || !this.prism.modelCanBeBuilt() || this.prism.someModelIsBuilt())) {
                try {
                    this.prism.buildModel();
                }
                catch (PrismException prismException) {
                    this.error(prismException.getMessage());
                }
            }
            this.undefinedMFConstants.iterateModel();
            for (n2 = 0; n2 < this.numPropertiesToCheck; ++n2) {
                this.undefinedConstants[n2].iterateModel();
            }
        }
        if (this.exportresults) {
            this.exportResults();
        }
        this.closeDown();
    }

    protected void importResults() {
        this.mainLog.print("\nImporting results from dataframe in " + this.importResultsFilename + "\"...");
        try {
            this.propertiesToCheck = new ArrayList<Property>();
            ArrayList<ResultsCollection> arrayList = new ArrayList<ResultsCollection>();
            FileReader fileReader = new FileReader(new File(this.importResultsFilename));
            ResultsImporter resultsImporter = new ResultsImporter(new BufferedReader(fileReader));
            for (Map.Entry entry : resultsImporter) {
                this.propertiesToCheck.add((Property)entry.getKey());
                arrayList.add(((ResultsImporter.RawResultsCollection)entry.getValue()).toResultsCollection());
            }
            this.results = arrayList.toArray(new ResultsCollection[0]);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorAndExit("Could not import results: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.errorAndExit("Could not read results file: " + iOException.getMessage());
        }
        catch (CsvFormatException csvFormatException) {
            this.errorAndExit("Malformatted CSV results file: " + csvFormatException.getMessage());
        }
        catch (PrismLangException prismLangException) {
            this.errorAndExit("Syntax error in results file: " + prismLangException.getMessage());
        }
    }

    protected void exportResults() {
        this.mainLog.print("\nExporting results as " + this.exportShape.fullName);
        this.mainLog.println((String)(this.exportResultsFilename.equals("stdout") ? " below:\n" : " to file \"" + this.exportResultsFilename + "\"..."));
        try {
            PrintWriter printWriter;
            if (this.exportResultsFilename.equals("stdout")) {
                printWriter = new PrintWriter(System.out);
                this.exportShape.getExporter().printResults(Arrays.asList(this.results), this.propertiesToCheck, printWriter);
            } else {
                printWriter = new PrintWriter(this.exportResultsFilename);
                this.exportShape.getExporter().printResults(Arrays.asList(this.results), this.propertiesToCheck, printWriter);
                printWriter.close();
            }
            if (printWriter.checkError()) {
                this.errorAndExit("Could not export results: unknown IO exception");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorAndExit("Could not export results: " + fileNotFoundException.getMessage());
        }
    }

    private void initialise(String[] stringArray) {
        try {
            this.mainLog = new PrismFileLog("stdout");
            this.prism = new Prism(this.mainLog);
            this.prism.addModelListener(this);
            this.parseArguments(stringArray);
            if (this.settingsFilename != null) {
                this.prism.loadUserSettingsFile(new File(this.settingsFilename));
            }
            this.prism.initialise();
            this.printArguments(stringArray);
            this.processOptions();
        }
        catch (PrismException prismException) {
            this.errorAndExit(prismException.getMessage());
        }
    }

    private void doParsing() {
        String[] stringArray;
        Object var2_1 = null;
        Object var3_2 = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        try {
            if (this.importModelWarning != null) {
                this.mainLog.printWarning(this.importModelWarning);
            }
            if (this.importpepa) {
                this.modulesFile = this.prism.importPepaFile(new File(this.modelFilename));
                this.prism.loadPRISMModel(this.modulesFile);
            } else if (this.importprismpp) {
                stringArray = ("? " + this.prismppParams).split(" ");
                this.modulesFile = this.prism.importPrismPreprocFile(new File(this.modelFilename), stringArray);
                this.prism.loadPRISMModel(this.modulesFile);
            } else if (!this.modelImportSources.isEmpty()) {
                this.sortModelImports();
            } else {
                this.modulesFile = this.prism.parseModelFile(new File(this.modelFilename), this.typeOverride);
                this.prism.loadPRISMModel(this.modulesFile);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorAndExit("File \"" + this.modelFilename + "\" not found");
        }
        catch (PrismException prismException) {
            this.errorAndExit(prismException.getMessage());
        }
        if (this.exportprism) {
            try {
                stringArray = this.exportPrismFilename.equals("stdout") ? null : new File(this.exportPrismFilename);
                this.prism.exportPRISMModel((File)stringArray);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportPrismFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException);
            }
        }
        try {
            if (this.propertiesFilename != null) {
                this.mainLog.print("\nParsing properties file \"" + this.propertiesFilename + "\"...\n");
                this.propertiesFile = this.prism.parsePropertiesFile(new File(this.propertiesFilename));
            } else {
                this.propertiesFile = !this.propertyString.equals("") ? this.prism.parsePropertiesString(this.propertyString) : null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.errorAndExit("File \"" + this.propertiesFilename + "\" not found");
        }
        catch (PrismException prismException) {
            this.errorAndExit(prismException.getMessage());
        }
        if (this.propertiesFile != null) {
            this.mainLog.print("\n" + this.propertiesFile.getNumProperties());
            this.mainLog.print(" propert" + (this.propertiesFile.getNumProperties() == 1 ? "y" : "ies") + ":\n");
            for (int i = 0; i < this.propertiesFile.getNumProperties(); ++i) {
                this.mainLog.println("(" + (i + 1) + ") " + String.valueOf(this.propertiesFile.getPropertyObject(i)));
            }
        }
    }

    private void sortModelImports() throws PrismException {
        int n = (int)this.modelImportSources.stream().filter(modelImportSource -> ((ModelImportSource)modelImportSource).entity == ModelExportTask.ModelExportEntity.MODEL).count();
        if (n < 1) {
            throw new PrismException("No transitions specified for model import");
        }
        if (n > 1) {
            throw new PrismException("Multiple model imports provided");
        }
        ModelImportSource modelImportSource2 = this.modelImportSources.stream().filter(modelImportSource -> ((ModelImportSource)modelImportSource).entity == ModelExportTask.ModelExportEntity.MODEL).findFirst().get();
        switch (modelImportSource2.format) {
            case EXPLICIT: {
                if (!this.modelImportSources.stream().allMatch(modelImportSource -> ((ModelImportSource)modelImportSource).format == ModelExportFormat.EXPLICIT)) {
                    throw new PrismException("Mixed formats for model import");
                }
                PrismExplicitImporter prismExplicitImporter = new PrismExplicitImporter(modelImportSource2.file, this.typeOverride);
                block12: for (ModelImportSource modelImportSource3 : this.modelImportSources) {
                    switch (modelImportSource3.entity) {
                        case MODEL: {
                            continue block12;
                        }
                        case STATES: {
                            if (prismExplicitImporter.getStatesFile() != null) {
                                throw new PrismException("Multiple state files provided for model import");
                            }
                            prismExplicitImporter.setStatesFile(modelImportSource3.file);
                            continue block12;
                        }
                        case OBSERVATIONS: {
                            if (prismExplicitImporter.getObservationsFile() != null) {
                                throw new PrismException("Multiple observation files provided for model import");
                            }
                            prismExplicitImporter.setObservationsFile(modelImportSource3.file);
                            continue block12;
                        }
                        case LABELS: {
                            if (prismExplicitImporter.getLabelsFile() != null) {
                                throw new PrismException("Multiple label files provided for model import");
                            }
                            prismExplicitImporter.setLabelsFile(modelImportSource3.file);
                            continue block12;
                        }
                        case STATE_REWARDS: {
                            prismExplicitImporter.addStateRewardsFile(modelImportSource3.file);
                            continue block12;
                        }
                        case TRANSITION_REWARDS: {
                            prismExplicitImporter.addTransitionRewardsFile(modelImportSource3.file);
                            continue block12;
                        }
                    }
                    throw new PrismException("Unknown model import entity");
                }
                this.prism.loadModelFromExplicitFiles(prismExplicitImporter);
                break;
            }
            case UMB: {
                if (this.modelImportSources.size() > 1) {
                    throw new PrismException("Conflicting files provided for model import");
                }
                this.prism.loadModelFromUMBFile(modelImportSource2.file);
                break;
            }
            default: {
                throw new PrismException("Unknown model import format " + String.valueOf((Object)modelImportSource2.format));
            }
        }
    }

    private void sortProperties() {
        this.propertiesToCheck = new ArrayList<Property>();
        if (this.propertiesFile == null) {
            if (this.propertyIndices != null && !this.propertyIndices.isEmpty()) {
                this.errorAndExit("There is not a property \"" + String.valueOf(this.propertyIndices.get(0)) + "\" to check");
            }
            this.numPropertiesToCheck = 0;
        } else if (this.propertyIndices == null) {
            this.numPropertiesToCheck = this.propertiesFile.getNumProperties();
            for (int i = 0; i < this.numPropertiesToCheck; ++i) {
                this.propertiesToCheck.add(this.propertiesFile.getPropertyObject(i));
            }
        } else {
            for (Object object : this.propertyIndices) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    if (n <= 0 || n > this.propertiesFile.getNumProperties()) {
                        this.errorAndExit("There is not a property " + n + " to verify");
                    }
                    ++this.numPropertiesToCheck;
                    this.propertiesToCheck.add(this.propertiesFile.getPropertyObject(n - 1));
                    continue;
                }
                if (object instanceof String) {
                    Property property = this.propertiesFile.getPropertyObjectByName((String)object);
                    if (property == null) {
                        this.errorAndExit("There is not a property \"" + String.valueOf(object) + "\" to check");
                    }
                    ++this.numPropertiesToCheck;
                    this.propertiesToCheck.add(property);
                    continue;
                }
                this.errorAndExit("There is not a property " + String.valueOf(object) + " to check");
            }
        }
    }

    private void doExports() throws PrismException {
        Object object;
        if (this.exportprismconst) {
            try {
                object = this.exportPrismConstFilename.equals("stdout") ? null : new File(this.exportPrismConstFilename);
                this.prism.exportPRISMModelWithExpandedConstants((File)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportPrismConstFilename + "\" for output");
            }
            catch (PrismException prismException) {
                this.error(prismException);
            }
        }
        for (ModelExportTask object2 : this.modelExportTasks) {
            object2.getExportOptions().apply(this.modelExportOptionsGlobal);
            if (!object2.extraLabelsUsed()) continue;
            this.definedPFConstants = this.undefinedMFConstants.getPFConstantValues();
            this.propertiesFile.setSomeUndefinedConstants(this.definedPFConstants, this.exactConstants);
            object2.setExtraLabelsSource(this.propertiesFile);
        }
        if (!this.modelExportTasks.isEmpty()) {
            this.prism.exportBuiltModelTasks(this.modelExportTasks);
        }
        if (this.exportmodeldotview) {
            try {
                object = File.createTempFile("prism-dot-", ".dot", null);
                File file = File.createTempFile("prism-dot-", ".dot.pdf", null);
                this.prism.exportBuiltModelTransitions((File)object, new ModelExportOptions().setFormat(ModelExportFormat.DOT).setShowStates(true).setShowObservations(true));
                new ProcessBuilder("dot", "-Tpdf", "-o", file.getPath(), ((File)object).getPath()).start().waitFor();
                new ProcessBuilder("open", file.getPath()).start();
            }
            catch (IOException | InterruptedException exception) {
                this.error("Problem generating dot file: " + exception.getMessage());
            }
        }
        if (this.exportsccs) {
            try {
                object = this.exportSCCsFilename.equals("stdout") ? null : new File(this.exportSCCsFilename);
                this.prism.exportSCCsToFile(this.exportType, (File)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportSCCsFilename + "\" for output");
            }
        }
        if (this.exportbsccs) {
            try {
                object = this.exportBSCCsFilename.equals("stdout") ? null : new File(this.exportBSCCsFilename);
                this.prism.exportBSCCsToFile(this.exportType, (File)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportBSCCsFilename + "\" for output");
            }
        }
        if (this.exportmecs) {
            try {
                object = this.exportMECsFilename.equals("stdout") ? null : new File(this.exportMECsFilename);
                this.prism.exportMECsToFile(this.exportType, (File)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error("Couldn't open file \"" + this.exportMECsFilename + "\" for output");
            }
        }
    }

    private void doSteadyState() {
        File file = null;
        if (this.steadystate) {
            try {
                file = this.exportSteadyStateFilename == null || this.exportSteadyStateFilename.equals("stdout") ? null : new File(this.exportSteadyStateFilename);
                this.prism.exportSteadyStateProbabilities(file, Prism.convertExportType(this.exportType), this.importinitdist ? new File(this.importInitDistFilename) : null);
            }
            catch (PrismException prismException) {
                this.error(prismException);
            }
        }
    }

    private void doTransient() {
        File file = null;
        if (this.dotransient) {
            try {
                file = this.exportTransientFilename == null || this.exportTransientFilename.equals("stdout") ? null : new File(this.exportTransientFilename);
                this.prism.exportTransientProbabilities(this.transientTime, file, Prism.convertExportType(this.exportType), this.importinitdist ? new File(this.importInitDistFilename) : null);
            }
            catch (PrismException prismException) {
                this.error(prismException);
            }
        }
    }

    private void doResultTest(Property property, Result result, Values values, Values values2) {
        block5: {
            try {
                List<String> list;
                Values values3 = new Values(values, values2);
                List<String> list2 = list = this.param ? Arrays.asList(this.paramNames) : Collections.emptyList();
                if (property.checkAgainstExpectedResult(result, values3, list)) {
                    this.mainLog.println("Testing result: PASS");
                } else {
                    this.mainLog.println("Testing result: NOT TESTED");
                }
            }
            catch (PrismNotSupportedException prismNotSupportedException) {
                this.mainLog.println("Testing result: UNSUPPORTED: " + prismNotSupportedException.getMessage());
            }
            catch (PrismException prismException) {
                this.mainLog.println("Testing result: FAIL: " + prismException.getMessage());
                if (!this.testExitsOnFail) break block5;
                this.errorAndExit("Testing failed");
            }
        }
    }

    private void closeDown() {
        this.prism.closeDown(true);
        int n = this.mainLog.getNumberOfWarnings();
        if (n > 0) {
            this.mainLog.printSeparator();
            this.mainLog.print("\nNote: There ");
            if (n == 1) {
                this.mainLog.print("was 1 warning");
            } else {
                this.mainLog.print("were " + n + " warnings");
            }
            this.mainLog.println(" during computation.");
        }
        this.mainLog.println();
        this.mainLog.close();
    }

    private void setTimeout(final int n) {
        Timeout.setTimeout(n, new Runnable(){

            @Override
            public void run() {
                PrismCL.this.mainLog.println("\nError: Timeout (after " + n + " seconds).");
                PrismCL.this.mainLog.flush();
                System.exit(1);
            }
        });
    }

    @Override
    public void notifyModelBuildSuccessful() {
    }

    @Override
    public void notifyModelBuildFailed(PrismException prismException) {
        this.modelBuildFail = true;
        this.modelBuildException = prismException;
    }

    private void parseArguments(String[] stringArray) throws PrismException {
        this.constSwitch = "";
        this.paramSwitch = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '-') {
                String string;
                String string2 = stringArray[i].substring(1);
                if (string2.length() == 0) {
                    this.errorAndExit("Invalid empty switch");
                }
                if (string2.charAt(0) == '-') {
                    string2 = string2.substring(1);
                }
                if (string2.equals("help") || string2.equals("?")) {
                    if (i < stringArray.length - 1) {
                        this.printHelpSwitch(stringArray[++i]);
                    } else {
                        this.printHelp();
                    }
                    this.exit();
                    continue;
                }
                if (string2.equals("javamaxmem") || string2.equals("javastack") || string2.equals("javaparams")) {
                    ++i;
                    continue;
                }
                if (string2.equals("timeout")) {
                    if (i < stringArray.length - 1) {
                        int n;
                        if ((n = PrismUtils.convertTimeStringtoSeconds(stringArray[++i])) < 0) {
                            this.errorAndExit("Negative timeout value \"" + n + "\" for -" + string2 + " switch");
                        }
                        if (n <= 0) continue;
                        this.setTimeout(n);
                        continue;
                    }
                    this.errorAndExit("Missing timeout value for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("version")) {
                    this.printVersion();
                    this.exit();
                    continue;
                }
                if (string2.equals("dir")) {
                    if (i < stringArray.length - 1) {
                        String string3;
                        if (PrismNative.setWorkingDirectory(string3 = stringArray[++i]) == 0) continue;
                        this.errorAndExit("Could not change working directory to " + string3);
                        continue;
                    }
                    this.errorAndExit("No property specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("settings")) {
                    if (i < stringArray.length - 1) {
                        this.settingsFilename = stringArray[++i].trim();
                        continue;
                    }
                    this.errorAndExit("Incomplete -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("keywords")) {
                    this.printListOfKeywords();
                    this.exit();
                    continue;
                }
                if (string2.equals("pf") || string2.equals("pctl") || string2.equals("csl")) {
                    if (i < stringArray.length - 1) {
                        this.propertyString = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No property specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("prop") || string2.equals("property")) {
                    if (i < stringArray.length - 1) {
                        String[] stringArray2 = stringArray[++i].trim().split(",");
                        this.propertyIndices = new ArrayList<Object>();
                        for (String string3 : stringArray2) {
                            if (string3.isEmpty()) continue;
                            try {
                                this.propertyIndices.add(Integer.parseInt(string3));
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.propertyIndices.add(string3);
                            }
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("const")) {
                    if (i < stringArray.length - 1) {
                        if ("".equals(this.constSwitch)) {
                            this.constSwitch = stringArray[++i].trim();
                            continue;
                        }
                        this.constSwitch = this.constSwitch + "," + stringArray[++i].trim();
                        continue;
                    }
                    this.errorAndExit("Incomplete -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("param")) {
                    this.param = true;
                    if (i < stringArray.length - 1) {
                        if ("".equals(this.paramSwitch)) {
                            this.paramSwitch = stringArray[++i].trim();
                            continue;
                        }
                        this.paramSwitch = this.paramSwitch + "," + stringArray[++i].trim();
                        continue;
                    }
                    this.errorAndExit("Incomplete -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("steadystate") || string2.equals("ss")) {
                    this.steadystate = true;
                    continue;
                }
                if (string2.equals("transient") || string2.equals("tr")) {
                    if (i < stringArray.length - 1) {
                        this.dotransient = true;
                        this.transientTime = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simpath")) {
                    if (i < stringArray.length - 2) {
                        this.simpath = true;
                        this.simpathDetails = stringArray[++i];
                        this.simpathFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("The -" + string2 + " switch requires two arguments (path details, filename)");
                    continue;
                }
                if (string2.equals("nobuild")) {
                    this.nobuild = true;
                    continue;
                }
                if (string2.equals("test")) {
                    this.test = true;
                    continue;
                }
                if (string2.equals("testall")) {
                    this.test = true;
                    this.testExitsOnFail = false;
                    continue;
                }
                if (string2.equals("test:umb")) {
                    this.prism.setTestUMB(true);
                    continue;
                }
                if (string2.equals("dddebug")) {
                    DebugJDD.enable();
                    continue;
                }
                if (string2.equals("ddtraceall")) {
                    DebugJDD.traceAll = true;
                    continue;
                }
                if (string2.equals("ddtracefollowcopies")) {
                    DebugJDD.traceFollowCopies = true;
                    continue;
                }
                if (string2.equals("dddebugwarnfatal")) {
                    DebugJDD.warningsAreFatal = true;
                    continue;
                }
                if (string2.equals("dddebugwarnoff")) {
                    DebugJDD.warningsOff = true;
                    continue;
                }
                if (string2.equals("ddtrace")) {
                    if (i < stringArray.length - 1) {
                        String string5 = stringArray[++i];
                        try {
                            int n = Integer.parseInt(string5);
                            DebugJDD.enableTracingForID(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("The -" + string2 + " switch requires an integer argument (JDDNode ID)");
                        }
                        continue;
                    }
                    this.errorAndExit("The -" + string2 + " switch requires an additional argument (JDDNode ID)");
                    continue;
                }
                if (string2.equals("importpepa")) {
                    this.importpepa = true;
                    continue;
                }
                if (string2.equals("importprismpp")) {
                    if (i < stringArray.length - 1) {
                        this.importprismpp = true;
                        this.prismppParams = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No parameters specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importmodel")) {
                    if (i < stringArray.length - 1) {
                        this.processImportModelSwitch(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file/options specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importtrans")) {
                    if (i < stringArray.length - 1) {
                        this.modelFilename = stringArray[++i];
                        this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.MODEL, ModelExportFormat.EXPLICIT, new File(this.modelFilename)));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importstates")) {
                    if (i < stringArray.length - 1) {
                        this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.STATES, ModelExportFormat.EXPLICIT, new File(stringArray[++i])));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importobs")) {
                    if (i < stringArray.length - 1) {
                        this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.OBSERVATIONS, ModelExportFormat.EXPLICIT, new File(stringArray[++i])));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importlabels")) {
                    if (i < stringArray.length - 1) {
                        this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.LABELS, ModelExportFormat.EXPLICIT, new File(stringArray[++i])));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importstaterewards")) {
                    if (i < stringArray.length - 1) {
                        this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.STATE_REWARDS, ModelExportFormat.EXPLICIT, new File(stringArray[++i])));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importtransrewards")) {
                    if (i < stringArray.length - 1) {
                        this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, ModelExportFormat.EXPLICIT, new File(stringArray[++i])));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importinitdist")) {
                    if (i < stringArray.length - 1) {
                        this.importinitdist = true;
                        this.importInitDistFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("importresults")) {
                    if (i < stringArray.length - 1) {
                        this.importresults = true;
                        this.modelFilename = "no-model-file.prism";
                        this.importResultsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("dtmc")) {
                    this.typeOverride = ModelType.DTMC;
                    continue;
                }
                if (string2.equals("mdp")) {
                    this.typeOverride = ModelType.MDP;
                    continue;
                }
                if (string2.equals("ctmc")) {
                    this.typeOverride = ModelType.CTMC;
                    continue;
                }
                if (string2.equals("exportprism")) {
                    if (i < stringArray.length - 1) {
                        this.exportprism = true;
                        this.exportPrismFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprismconst")) {
                    if (i < stringArray.length - 1) {
                        this.exportprismconst = true;
                        this.exportPrismConstFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportresults")) {
                    if (i < stringArray.length - 1) {
                        String[] stringArray3;
                        this.exportresults = true;
                        if ((stringArray3 = PrismCL.splitFilesAndOptions(string = stringArray[++i]))[1].length() == 0 && stringArray3[0].indexOf(44) > -1) {
                            int n = stringArray3[0].indexOf(44);
                            stringArray3[1] = stringArray3[0].substring(n + 1);
                            stringArray3[0] = stringArray3[0].substring(0, n);
                        }
                        this.exportResultsFilename = stringArray3[0];
                        String[] stringArray4 = stringArray3[1].split(",");
                        this.exportShape = ResultsExporter.ResultsExportShape.LIST_PLAIN;
                        for (int j = 0; j < stringArray4.length; ++j) {
                            if (stringArray4[j].equals("")) continue;
                            if (stringArray4[j].equals("csv")) {
                                this.exportShape = this.exportShape.isMatrix ? ResultsExporter.ResultsExportShape.MATRIX_CSV : ResultsExporter.ResultsExportShape.LIST_CSV;
                                continue;
                            }
                            if (stringArray4[j].equals("matrix")) {
                                switch (this.exportShape) {
                                    case LIST_PLAIN: {
                                        this.exportShape = ResultsExporter.ResultsExportShape.MATRIX_PLAIN;
                                        break;
                                    }
                                    case LIST_CSV: {
                                        this.exportShape = ResultsExporter.ResultsExportShape.MATRIX_CSV;
                                        break;
                                    }
                                }
                                continue;
                            }
                            if (stringArray4[j].equals("dataframe")) {
                                this.exportShape = ResultsExporter.ResultsExportShape.DATA_FRAME;
                                continue;
                            }
                            if (stringArray4[j].equals("comment")) {
                                this.exportShape = ResultsExporter.ResultsExportShape.COMMENT;
                                continue;
                            }
                            this.errorAndExit("Unknown option \"" + stringArray4[j] + "\" for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No file/options specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportvector")) {
                    if (i < stringArray.length - 1) {
                        this.exportvector = true;
                        this.exportVectorFilename = stringArray[++i];
                        this.prism.setStoreVector(true);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportmodel")) {
                    if (i < stringArray.length - 1) {
                        this.processExportModelSwitch(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file/options specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exporttrans")) {
                    if (i < stringArray.length - 1) {
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.MODEL, stringArray[++i]));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportstaterewards")) {
                    if (i < stringArray.length - 1) {
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.STATE_REWARDS, stringArray[++i]));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exporttransrewards")) {
                    if (i < stringArray.length - 1) {
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, stringArray[++i]));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportrewards")) {
                    if (i < stringArray.length - 2) {
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.STATE_REWARDS, stringArray[++i]));
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, stringArray[++i]));
                        continue;
                    }
                    this.errorAndExit("Two files must be specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportstates")) {
                    if (i < stringArray.length - 1) {
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.STATES, stringArray[++i]));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportobs")) {
                    if (i < stringArray.length - 1) {
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.OBSERVATIONS, stringArray[++i]));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportlabels")) {
                    if (i < stringArray.length - 1) {
                        this.processExportLabelsSwitch(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportproplabels")) {
                    if (i < stringArray.length - 1) {
                        this.processExportPropLabelsSwitch(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportmatlab")) {
                    this.exportType = 2;
                    this.modelExportOptionsGlobal.setFormat(ModelExportFormat.MATLAB);
                    continue;
                }
                if (string2.equals("exportmrmc")) {
                    this.errorAndExit("Export to MRMC format no longer supported");
                    continue;
                }
                if (string2.equals("exportrows")) {
                    this.exportType = 5;
                    this.modelExportOptionsGlobal.setExplicitRows(true);
                    continue;
                }
                if (string2.equals("exportordered") || string2.equals("ordered")) continue;
                if (string2.equals("exportunordered") || string2.equals("unordered")) {
                    this.errorAndExit("Switch -" + string2 + " is no longer supported");
                    continue;
                }
                if (string2.equals("exporttransdot")) {
                    if (i < stringArray.length - 1) {
                        ModelExportOptions modelExportOptions = new ModelExportOptions().setFormat(ModelExportFormat.DOT).setShowStates(false).setShowObservations(false);
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.MODEL, stringArray[++i], modelExportOptions));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exporttransdotstates")) {
                    if (i < stringArray.length - 1) {
                        ModelExportOptions modelExportOptions = new ModelExportOptions().setFormat(ModelExportFormat.DOT).setShowStates(true).setShowObservations(true);
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.MODEL, stringArray[++i], modelExportOptions));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportdot")) {
                    if (i < stringArray.length - 1) {
                        ModelExportOptions modelExportOptions = new ModelExportOptions().setFormat(ModelExportFormat.DD_DOT);
                        this.modelExportTasks.add(new ModelExportTask(ModelExportTask.ModelExportEntity.MODEL, stringArray[++i], modelExportOptions));
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportsccs")) {
                    if (i < stringArray.length - 1) {
                        this.exportsccs = true;
                        this.exportSCCsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportbsccs")) {
                    if (i < stringArray.length - 1) {
                        this.exportbsccs = true;
                        this.exportBSCCsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportmecs")) {
                    if (i < stringArray.length - 1) {
                        this.exportmecs = true;
                        this.exportMECsFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportsteadystate") || string2.equals("exportss")) {
                    if (i < stringArray.length - 1) {
                        this.exportSteadyStateFilename = stringArray[++i];
                    } else {
                        this.errorAndExit("No file specified for -" + string2 + " switch");
                    }
                    this.steadystate = true;
                    continue;
                }
                if (string2.equals("exporttransient") || string2.equals("exporttr")) {
                    if (i < stringArray.length - 1) {
                        this.exportTransientFilename = stringArray[++i];
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportstrat")) {
                    if (i < stringArray.length - 1) {
                        this.processExportStratSwitch(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file/options specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportdigital")) {
                    if (i < stringArray.length - 1) {
                        String string6;
                        File file = (string6 = stringArray[++i]).equals("stdout") ? null : new File(string6);
                        this.prism.setExportDigital(true);
                        this.prism.setExportDigitalFile(file);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exporttarget")) {
                    if (i < stringArray.length - 1) {
                        this.prism.setExportTarget(true);
                        this.prism.setExportTargetFilename(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprodtrans")) {
                    if (i < stringArray.length - 1) {
                        this.prism.setExportProductTrans(true);
                        this.prism.setExportProductTransFilename(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprodstates")) {
                    if (i < stringArray.length - 1) {
                        this.prism.setExportProductStates(true);
                        this.prism.setExportProductStatesFilename(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportprodvector")) {
                    if (i < stringArray.length - 1) {
                        this.prism.setExportProductVector(true);
                        this.prism.setExportProductVectorFilename(stringArray[++i]);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("sim")) {
                    this.simulate = true;
                    continue;
                }
                if (string2.equals("simmethod")) {
                    if (i < stringArray.length - 1) {
                        if ((string = stringArray[++i]).equals("ci") || string.equals("aci") || string.equals("apmc") || string.equals("sprt")) {
                            this.simMethodName = string;
                            continue;
                        }
                        this.errorAndExit("Unrecognised option for -" + string2 + " switch (options are: ci, aci, apmc, sprt)");
                        continue;
                    }
                    this.errorAndExit("No parameter specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simsamples")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simNumSamples = Integer.parseInt(stringArray[++i]);
                            if (this.simNumSamples <= 0) {
                                throw new NumberFormatException("");
                            }
                            this.simNumSamplesGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simconf")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simConfidence = Double.parseDouble(stringArray[++i]);
                            if (this.simConfidence <= 0.0 || this.simConfidence >= 1.0) {
                                throw new NumberFormatException("");
                            }
                            this.simConfidenceGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simwidth")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simWidth = Double.parseDouble(stringArray[++i]);
                            if (this.simWidth <= 0.0) {
                                throw new NumberFormatException("");
                            }
                            this.simWidthGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simapprox")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simApprox = Double.parseDouble(stringArray[++i]);
                            if (this.simApprox <= 0.0) {
                                throw new NumberFormatException("");
                            }
                            this.simApproxGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simmanual")) {
                    this.simManual = true;
                    continue;
                }
                if (string2.equals("simvar")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.reqIterToConclude = Integer.parseInt(stringArray[++i]);
                            if (this.reqIterToConclude <= 0) {
                                throw new NumberFormatException("");
                            }
                            this.reqIterToConcludeGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simmaxrwd")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simMaxReward = Double.parseDouble(stringArray[++i]);
                            if (this.simMaxReward <= 0.0) {
                                throw new NumberFormatException("");
                            }
                            this.simMaxRewardGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("simpathlen")) {
                    if (i < stringArray.length - 1) {
                        try {
                            this.simMaxPath = Long.parseLong(stringArray[++i]);
                            if (this.simMaxPath <= 0L) {
                                throw new NumberFormatException("");
                            }
                            this.simMaxPathGiven = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.errorAndExit("Invalid value for -" + string2 + " switch");
                        }
                        continue;
                    }
                    this.errorAndExit("No value specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("zerorewardcheck")) {
                    this.prism.setCheckZeroLoops(true);
                    continue;
                }
                if (string2.equals("explicitbuild")) {
                    this.explicitbuild = true;
                    continue;
                }
                if (string2.equals("explicitbuildtest")) {
                    this.explicitbuildtest = true;
                    continue;
                }
                if (string2.equals("mainlog")) {
                    if (i < stringArray.length - 1) {
                        this.mainLogFilename = stringArray[++i];
                        PrismFileLog prismFileLog = new PrismFileLog(this.mainLogFilename);
                        if (!((PrismLog)prismFileLog).ready()) {
                            this.errorAndExit("Couldn't open log file \"" + this.mainLogFilename + "\"");
                        }
                        this.mainLog = prismFileLog;
                        this.prism.setMainLog(this.mainLog);
                        continue;
                    }
                    this.errorAndExit("No file specified for -" + string2 + " switch");
                    continue;
                }
                if (string2.equals("exportmodeldotview")) {
                    this.exportmodeldotview = true;
                    continue;
                }
                if (string2.equals("c1")) {
                    this.prism.setConstruction(1);
                    continue;
                }
                if (string2.equals("c2")) {
                    this.prism.setConstruction(2);
                    continue;
                }
                if (string2.equals("c3")) {
                    this.prism.setConstruction(3);
                    continue;
                }
                if (string2.equals("o1")) {
                    this.prism.setOrdering(1);
                    this.orderingOverride = true;
                    continue;
                }
                if (string2.equals("o2")) continue;
                if (string2.equals("o2")) {
                    this.prism.setOrdering(2);
                    this.orderingOverride = true;
                    continue;
                }
                if (string2.equals("o2")) continue;
                if (string2.equals("noreach")) {
                    this.prism.setDoReach(false);
                    continue;
                }
                if (string2.equals("nobscc")) {
                    this.prism.setBSCCComp(false);
                    continue;
                }
                if (string2.equals("frontier")) {
                    this.prism.setReachMethod(Prism.REACH_FRONTIER);
                    continue;
                }
                if (string2.equals("bfs")) {
                    this.prism.setReachMethod(Prism.REACH_BFS);
                    continue;
                }
                if (string2.equals("bisim")) {
                    this.prism.setDoBisim(true);
                    continue;
                }
                i = this.prism.getSettings().setFromCommandLineSwitch(stringArray, i) - 1;
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        this.processFileNames(arrayList);
    }

    private void processFileNames(List<String> list) throws PrismException {
        if (list.size() > 2) {
            this.errorAndExit("Invalid argument syntax");
        }
        if (!this.modelImportSources.isEmpty()) {
            if (list.size() > 1) {
                this.errorAndExit("Two models provided (" + list.get(0) + ", " + this.modelFilename + ")");
            } else if (list.size() == 1) {
                this.propertiesFilename = list.get(0);
            }
        } else {
            if (list.size() > 0) {
                this.modelFilename = list.get(0);
                if (this.modelFilename.endsWith(".all")) {
                    this.processImportModelSwitch(this.modelFilename);
                }
            }
            if (list.size() > 1) {
                this.propertiesFilename = list.get(1);
            }
        }
    }

    private void processImportModelSwitch(String string) throws PrismException {
        String[] stringArray = PrismCL.splitFilesAndOptions(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = string2.lastIndexOf(46);
        String string4 = n == -1 ? string2 : string2.substring(0, n);
        String string5 = n == -1 ? "" : string2.substring(n + 1);
        String[] stringArray2 = string5.split(",");
        this.importModelWarning = null;
        String[] stringArray3 = stringArray2;
        int n2 = stringArray3.length;
        for (int i = 0; i < n2; ++i) {
            String string6 = stringArray3[i];
            if (string6.equals("all")) {
                this.modelFilename = string4 + ".tra";
                this.addModelImport(ModelExportTask.ModelExportEntity.MODEL, string4 + ".tra", false);
                this.addModelImport(ModelExportTask.ModelExportEntity.STATES, string4 + ".sta", false);
                this.addModelImport(ModelExportTask.ModelExportEntity.OBSERVATIONS, string4 + ".obs", false);
                this.addModelImport(ModelExportTask.ModelExportEntity.LABELS, string4 + ".lab", false);
                this.addStateRewardImports(string4, false);
                this.addTransitionRewardImports(string4, false);
                continue;
            }
            if (string6.equals("tra")) {
                this.modelFilename = string4 + ".tra";
                this.addModelImport(ModelExportTask.ModelExportEntity.MODEL, string4 + ".tra", true);
                continue;
            }
            if (string6.equals("sta")) {
                this.addModelImport(ModelExportTask.ModelExportEntity.STATES, string4 + ".sta", true);
                continue;
            }
            if (string6.equals("obs")) {
                this.addModelImport(ModelExportTask.ModelExportEntity.OBSERVATIONS, string4 + ".obs", true);
                continue;
            }
            if (string6.equals("lab")) {
                this.addModelImport(ModelExportTask.ModelExportEntity.LABELS, string4 + ".lab", true);
                continue;
            }
            if (string6.equals("srew")) {
                this.addStateRewardImports(string4, true);
                continue;
            }
            if (string6.equals("trew")) {
                this.addTransitionRewardImports(string4, true);
                continue;
            }
            if (string6.equals("umb")) {
                this.modelFilename = string4 + ".umb";
                this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.MODEL, ModelExportFormat.UMB, new File(string4 + ".umb")));
                continue;
            }
            this.modelFilename = string4 + (String)(string6.isEmpty() ? "" : "." + string6);
            this.addModelImport(ModelExportTask.ModelExportEntity.MODEL, this.modelFilename, true);
        }
        for (String string7 : stringArray3 = string3.split(",")) {
            if (string7.equals("")) continue;
            if (string7.startsWith("format")) {
                if (!string7.startsWith("format=")) {
                    throw new PrismException("No value provided for \"format\" option of -importmodel");
                }
                String string8 = string7.substring(7);
                ModelExportFormat modelExportFormat = null;
                switch (string8) {
                    case "explicit": {
                        modelExportFormat = ModelExportFormat.EXPLICIT;
                        break;
                    }
                    case "umb": {
                        modelExportFormat = ModelExportFormat.UMB;
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown value \"" + string8 + "\" provided for \"format\" option of -importmodel");
                    }
                }
                for (ModelImportSource modelImportSource : this.modelImportSources) {
                    modelImportSource.format = modelExportFormat;
                }
                continue;
            }
            throw new PrismException("Unknown option \"" + string7 + "\" for -importmodel switch");
        }
    }

    private void addModelImport(ModelExportTask.ModelExportEntity modelExportEntity, String string, boolean bl) {
        if (bl || new File(string).exists()) {
            this.modelImportSources.add(new ModelImportSource(modelExportEntity, ModelExportFormat.EXPLICIT, new File(string)));
        }
    }

    private void addStateRewardImports(String string, boolean bl) {
        boolean bl2 = false;
        if (new File(string + ".srew").exists()) {
            this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.STATE_REWARDS, ModelExportFormat.EXPLICIT, new File(string + ".srew")));
            bl2 = true;
        } else {
            int n = 1;
            while (new File(string + String.valueOf(n) + ".srew").exists()) {
                this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.STATE_REWARDS, ModelExportFormat.EXPLICIT, new File(string + String.valueOf(n) + ".srew")));
                bl2 = true;
                ++n;
            }
        }
        if (bl && !bl2) {
            this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.STATE_REWARDS, ModelExportFormat.EXPLICIT, new File(string + ".srew")));
        }
    }

    private void addTransitionRewardImports(String string, boolean bl) {
        boolean bl2 = false;
        if (new File(string + ".trew").exists()) {
            this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, ModelExportFormat.EXPLICIT, new File(string + ".trew")));
            bl2 = true;
        } else {
            int n = 1;
            while (new File(string + String.valueOf(n) + ".trew").exists()) {
                this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, ModelExportFormat.EXPLICIT, new File(string + String.valueOf(n) + ".trew")));
                bl2 = true;
                ++n;
            }
        }
        if (bl && !bl2) {
            this.modelImportSources.add(new ModelImportSource(ModelExportTask.ModelExportEntity.TRANSITION_REWARDS, ModelExportFormat.EXPLICIT, new File(string + ".trew")));
        }
    }

    private void processExportLabelsSwitch(String string) throws PrismException {
        String[] stringArray;
        String[] stringArray2 = PrismCL.splitFilesAndOptions(string);
        ModelExportTask modelExportTask = new ModelExportTask(ModelExportTask.ModelExportEntity.LABELS, stringArray2[0]);
        for (String string2 : stringArray = stringArray2[1].split(",")) {
            if (string2.equals("")) continue;
            if (string2.equals("matlab")) {
                modelExportTask.getExportOptions().setFormat(ModelExportFormat.MATLAB);
                continue;
            }
            if (string2.equals("proplabels")) {
                modelExportTask.setLabelExportSet(ModelExportTask.LabelExportSet.ALL);
                continue;
            }
            throw new PrismException("Unknown option \"" + string2 + "\" for -exportlabels switch");
        }
        this.modelExportTasks.add(modelExportTask);
    }

    private void processExportPropLabelsSwitch(String string) throws PrismException {
        String[] stringArray;
        String[] stringArray2 = PrismCL.splitFilesAndOptions(string);
        ModelExportTask modelExportTask = new ModelExportTask(ModelExportTask.ModelExportEntity.LABELS, stringArray2[0]);
        modelExportTask.setLabelExportSet(ModelExportTask.LabelExportSet.EXTRA);
        for (String string2 : stringArray = stringArray2[1].split(",")) {
            if (string2.equals("")) continue;
            if (string2.equals("matlab")) {
                modelExportTask.getExportOptions().setFormat(ModelExportFormat.MATLAB);
                continue;
            }
            throw new PrismException("Unknown option \"" + string2 + "\" for -exportproplabels switch");
        }
        this.modelExportTasks.add(modelExportTask);
    }

    private void processExportModelSwitch(String string) throws PrismException {
        String[] stringArray = PrismCL.splitFilesAndOptions(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = string2.lastIndexOf(46);
        String string4 = n == -1 ? string2 : string2.substring(0, n);
        String string5 = n == -1 ? "" : string2.substring(n + 1);
        String[] stringArray2 = string5.split(",");
        ArrayList<ModelExportTask> arrayList = new ArrayList<ModelExportTask>();
        for (String string6 : stringArray2) {
            if (string6.equals("all")) {
                arrayList.add(ModelExportTask.fromFilename(string4, "tra"));
                arrayList.add(ModelExportTask.fromFilename(string4, "srew"));
                arrayList.add(ModelExportTask.fromFilename(string4, "trew"));
                arrayList.add(ModelExportTask.fromFilename(string4, "sta"));
                arrayList.add(ModelExportTask.fromFilename(string4, "obs"));
                arrayList.add(ModelExportTask.fromFilename(string4, "lab"));
                continue;
            }
            if (string6.equals("rew")) {
                arrayList.add(ModelExportTask.fromFilename(string4, "srew"));
                arrayList.add(ModelExportTask.fromFilename(string4, "trew"));
                continue;
            }
            arrayList.add(ModelExportTask.fromFilename(string4, string6));
        }
        ModelExportOptions modelExportOptions = new ModelExportOptions();
        String[] stringArray3 = string3.split(",");
        for (String string7 : stringArray3) {
            Object object;
            if (string7.equals("")) continue;
            if (string7.startsWith("format")) {
                if (!string7.startsWith("format=")) {
                    throw new PrismException("No value provided for \"format\" option of -exportmodel");
                }
                switch (object = string7.substring(7)) {
                    case "explicit": {
                        modelExportOptions.setFormat(ModelExportFormat.EXPLICIT);
                        break;
                    }
                    case "matlab": {
                        modelExportOptions.setFormat(ModelExportFormat.MATLAB);
                        break;
                    }
                    case "dot": {
                        modelExportOptions.setFormat(ModelExportFormat.DOT);
                        break;
                    }
                    case "drn": {
                        modelExportOptions.setFormat(ModelExportFormat.DRN);
                        break;
                    }
                    case "umb": {
                        modelExportOptions.setFormat(ModelExportFormat.UMB);
                        break;
                    }
                    default: {
                        throw new PrismException("Unknown value \"" + (String)object + "\" provided for \"format\" option of -exportmodel");
                    }
                }
                continue;
            }
            if (string7.equals("matlab")) {
                modelExportOptions.setFormat(ModelExportFormat.MATLAB);
                this.exportType = 2;
                continue;
            }
            if (string7.equals("rows")) {
                modelExportOptions.setExplicitRows(true);
                this.exportType = 5;
                continue;
            }
            if (string7.equals("text")) {
                modelExportOptions.setBinaryAsText(true);
                continue;
            }
            if (string7.equals("proplabels")) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Object object2 = (ModelExportTask)object.next();
                    if (((ModelExportTask)object2).getEntity() != ModelExportTask.ModelExportEntity.LABELS) continue;
                    ((ModelExportTask)object2).setLabelExportSet(ModelExportTask.LabelExportSet.ALL);
                }
                continue;
            }
            String string8 = "labels";
            if (string7.startsWith("labels")) {
                if (!string7.startsWith(string8 + "=")) {
                    throw new PrismException("No value provided for \"" + string8 + "\" option of -exportmodel");
                }
                object = string7.substring(string8.length() + 1);
                if (((String)object).equals("true")) {
                    modelExportOptions.setShowLabels(true);
                    continue;
                }
                if (((String)object).equals("false")) {
                    modelExportOptions.setShowLabels(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + (String)object + "\" provided for \"" + string8 + "\" option of -exportmodel");
            }
            string8 = "rewards";
            if (string7.startsWith("rewards")) {
                if (!string7.startsWith(string8 + "=")) {
                    throw new PrismException("No value provided for \"" + string8 + "\" option of -exportmodel");
                }
                object = string7.substring(string8.length() + 1);
                if (((String)object).equals("true")) {
                    modelExportOptions.setShowRewards(true);
                    continue;
                }
                if (((String)object).equals("false")) {
                    modelExportOptions.setShowRewards(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + (String)object + "\" provided for \"" + string8 + "\" option of -exportmodel");
            }
            string8 = "states";
            if (string7.startsWith("states")) {
                if (!string7.startsWith(string8 + "=")) {
                    throw new PrismException("No value provided for \"" + string8 + "\" option of -exportmodel");
                }
                object = string7.substring(string8.length() + 1);
                if (((String)object).equals("true")) {
                    modelExportOptions.setShowStates(true);
                    continue;
                }
                if (((String)object).equals("false")) {
                    modelExportOptions.setShowStates(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + (String)object + "\" provided for \"" + string8 + "\" option of -exportmodel");
            }
            string8 = "obs";
            if (string7.startsWith("obs")) {
                if (!string7.startsWith(string8 + "=")) {
                    throw new PrismException("No value provided for \"" + string8 + "\" option of -exportmodel");
                }
                object = string7.substring(string8.length() + 1);
                if (((String)object).equals("true")) {
                    modelExportOptions.setShowObservations(true);
                    continue;
                }
                if (((String)object).equals("false")) {
                    modelExportOptions.setShowObservations(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + (String)object + "\" provided for \"" + string8 + "\" option of -exportmodel");
            }
            string8 = "actions";
            if (string7.startsWith("actions")) {
                if (!string7.startsWith(string8 + "=")) {
                    throw new PrismException("No value provided for \"" + string8 + "\" option of -exportmodel");
                }
                object = string7.substring(string8.length() + 1);
                if (((String)object).equals("true")) {
                    modelExportOptions.setShowActions(true);
                    continue;
                }
                if (((String)object).equals("false")) {
                    modelExportOptions.setShowActions(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + (String)object + "\" provided for \"" + string8 + "\" option of -exportmodel");
            }
            string8 = "headers";
            if (string7.startsWith("headers")) {
                if (!string7.startsWith(string8 + "=")) {
                    throw new PrismException("No value provided for \"" + string8 + "\" option of -exportmodel");
                }
                object = string7.substring(string8.length() + 1);
                if (((String)object).equals("true")) {
                    modelExportOptions.setPrintHeaders(true);
                    continue;
                }
                if (((String)object).equals("false")) {
                    modelExportOptions.setPrintHeaders(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + (String)object + "\" provided for \"" + string8 + "\" option of -exportmodel");
            }
            string8 = "precision";
            if (string7.startsWith("precision")) {
                if (!string7.startsWith(string8 + "=")) {
                    throw new PrismException("No value provided for \"" + string8 + "\" option of -exportmodel");
                }
                object = string7.substring(string8.length() + 1);
                try {
                    int n2 = Integer.parseInt((String)object);
                    if (!PrismSettings.RANGE_EXPORT_DOUBLE_PRECISION.contains(n2)) {
                        throw new NumberFormatException("");
                    }
                    modelExportOptions.setModelPrecision(n2);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PrismException("Invalid value \"" + (String)object + "\" provided for \"" + string8 + "\" option of -exportmodel");
                }
            }
            string8 = "zip";
            if (string7.startsWith("zip")) {
                if (!string7.startsWith(string8 + "=")) {
                    throw new PrismException("No value provided for \"" + string8 + "\" option of -exportmodel");
                }
                object = string7.substring(string8.length() + 1);
                if (((String)object).equals("true")) {
                    modelExportOptions.setZipped(true);
                    continue;
                }
                if (((String)object).equals("false")) {
                    modelExportOptions.setZipped(false);
                    continue;
                }
                if (((String)object).equals("gzip") || ((String)object).equals("gz")) {
                    modelExportOptions.setZipped(true).setCompressionFormat(ModelExportOptions.CompressionFormat.GZIP);
                    continue;
                }
                if (((String)object).equals("xz")) {
                    modelExportOptions.setZipped(true).setCompressionFormat(ModelExportOptions.CompressionFormat.XZ);
                    continue;
                }
                throw new PrismException("Unknown value \"" + (String)object + "\" provided for \"" + string8 + "\" option of -exportmodel");
            }
            throw new PrismException("Unknown option \"" + string7 + "\" for -exportmodel switch");
        }
        for (ModelExportTask modelExportTask : arrayList) {
            modelExportTask.getExportOptions().apply(modelExportOptions);
        }
        this.modelExportTasks.addAll(arrayList);
    }

    private void processExportStratSwitch(String string) throws PrismException {
        String[] stringArray;
        String[] stringArray2 = PrismCL.splitFilesAndOptions(string);
        String string2 = stringArray2[0];
        String string3 = stringArray2[1];
        this.exportstrat = true;
        this.exportStratFilename = string2;
        this.exportStratOptions = new StrategyExportOptions();
        this.prism.setGenStrat(true);
        if (this.exportStratFilename.endsWith("tra")) {
            this.exportStratOptions.setType(StrategyExportOptions.StrategyExportType.INDUCED_MODEL);
        } else if (this.exportStratFilename.endsWith("dot")) {
            this.exportStratOptions.setType(StrategyExportOptions.StrategyExportType.DOT_FILE);
        } else {
            this.exportStratOptions.setType(StrategyExportOptions.StrategyExportType.ACTIONS);
        }
        for (String string4 : stringArray = string3.split(",")) {
            String string5;
            if (string4.equals("")) continue;
            if (string4.startsWith("type")) {
                if (!string4.startsWith("type=")) {
                    throw new PrismException("No value provided for \"type\" option of -exportstrat");
                }
                string5 = string4.substring(5);
                if (string5.equals("actions")) {
                    this.exportStratOptions.setType(StrategyExportOptions.StrategyExportType.ACTIONS);
                    continue;
                }
                if (string5.equals("indices")) {
                    this.exportStratOptions.setType(StrategyExportOptions.StrategyExportType.INDICES);
                    continue;
                }
                if (string5.equals("model") || string5.equals("induced")) {
                    this.exportStratOptions.setType(StrategyExportOptions.StrategyExportType.INDUCED_MODEL);
                    continue;
                }
                if (string5.equals("dot")) {
                    this.exportStratOptions.setType(StrategyExportOptions.StrategyExportType.DOT_FILE);
                    continue;
                }
                throw new PrismException("Unknown value \"" + string5 + "\" provided for \"type\" option of -exportstrat");
            }
            if (string4.startsWith("mode")) {
                if (!string4.startsWith("mode=")) {
                    throw new PrismException("No value provided for \"mode\" option of -exportstrat");
                }
                string5 = string4.substring(5);
                if (string5.equals("restrict")) {
                    this.exportStratOptions.setMode(StrategyExportOptions.InducedModelMode.RESTRICT);
                    continue;
                }
                if (string5.equals("reduce")) {
                    this.exportStratOptions.setMode(StrategyExportOptions.InducedModelMode.REDUCE);
                    continue;
                }
                throw new PrismException("Unknown value \"" + string5 + "\" provided for \"mode\" option of -exportstrat");
            }
            if (string4.startsWith("reach")) {
                if (!string4.startsWith("reach=")) {
                    throw new PrismException("No value provided for \"reach\" option of -exportstrat");
                }
                string5 = string4.substring(6);
                if (string5.equals("true")) {
                    this.exportStratOptions.setReachOnly(true);
                    continue;
                }
                if (string5.equals("false")) {
                    this.exportStratOptions.setReachOnly(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + string5 + "\" provided for \"reach\" option of -exportstrat");
            }
            if (string4.startsWith("states")) {
                if (!string4.startsWith("states=")) {
                    throw new PrismException("No value provided for \"states\" option of -exportstrat");
                }
                string5 = string4.substring(7);
                if (string5.equals("true")) {
                    this.exportStratOptions.setShowStates(true);
                    continue;
                }
                if (string5.equals("false")) {
                    this.exportStratOptions.setShowStates(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + string5 + "\" provided for \"reach\" option of -exportstrat");
            }
            if (string4.startsWith("obs")) {
                if (!string4.startsWith("obs=")) {
                    throw new PrismException("No value provided for \"obs\" option of -exportstrat");
                }
                string5 = string4.substring(4);
                if (string5.equals("true")) {
                    this.exportStratOptions.setMergeObservations(true);
                    continue;
                }
                if (string5.equals("false")) {
                    this.exportStratOptions.setMergeObservations(false);
                    continue;
                }
                throw new PrismException("Unknown value \"" + string5 + "\" provided for \"reach\" option of -exportstrat");
            }
            throw new PrismException("Unknown option \"" + string4 + "\" for -exportstrat switch");
        }
    }

    private static String[] splitFilesAndOptions(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(58);
        while (string.length() > n + 1 && string.charAt(n + 1) == '\\') {
            n = string.indexOf(58, n + 1);
        }
        if (n != -1) {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        } else {
            stringArray[0] = string;
            stringArray[1] = "";
        }
        return stringArray;
    }

    public void printArguments(String[] stringArray) {
        this.mainLog.print("Command line: prism");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            string = PrismCL.shellQuoteSingleIfNecessary(string);
            this.mainLog.print(" " + string);
        }
        this.mainLog.println();
    }

    public static String shellQuoteSingleIfNecessary(String object) {
        if (((String)object).isEmpty()) {
            return "''";
        }
        if (((String)object).matches(".*[^_a-zA-Z0-9\\./\\-=].*")) {
            object = ((String)object).replace("'", "'\\''");
            object = "'" + (String)object + "'";
        }
        return object;
    }

    private void processOptions() throws PrismException {
        Object object;
        int n;
        if (this.modelFilename == null) {
            this.mainLog.println("Usage: " + Prism.getCommandLineName() + " [options] <model-file> [<properties-file>] [more-options]");
            this.mainLog.println("\nFor more information, type: prism -help");
            this.exit();
        }
        if (this.prism.getEngine() == 1 && !this.orderingOverride) {
            try {
                this.prism.setOrdering(2);
            }
            catch (PrismException prismException) {
                // empty catch block
            }
        }
        if (this.prism.getExplicit()) {
            this.explicitbuild = false;
        }
        if (this.prism.getEngine() == 1 && !this.test) {
            n = this.prism.getLinEqMethod();
            if (n == 3 || n == 4 || n == 5 || n == 6) {
                this.errorAndExit("Gauss-Seidel and its variants are currently not supported by the MTBDD engine");
            }
            if (n == 8 || n == 9 || n == 10 || n == 11) {
                this.errorAndExit("SOR and its variants are currently not supported by the MTBDD engine");
            }
        } else if (!(this.prism.getEngine() != 2 || this.test || (n = this.prism.getLinEqMethod()) != 5 && n != 6 && n != 10 && n != 11)) {
            this.errorAndExit("Pseudo Gauss-Seidel/SOR methods are currently not supported by the sparse engine");
        }
        if (this.param) {
            object = this.paramSwitch.split(",");
            this.paramNames = new String[((String[])object).length];
            this.paramLowerBounds = new String[((Object)object).length];
            this.paramUpperBounds = new String[((Object)object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (!((String)object[i]).contains("=")) {
                    this.paramNames[i] = object[i];
                    this.paramLowerBounds[i] = "0";
                    this.paramUpperBounds[i] = "1";
                    continue;
                }
                String[] stringArray = ((String)object[i]).split("=");
                this.paramNames[i] = stringArray[0];
                stringArray[1] = stringArray[1].trim();
                String[] stringArray2 = stringArray[1].split(":");
                if (stringArray2.length != 2) {
                    throw new PrismException("Invalid range \"" + stringArray[1] + "\" for parameter " + this.paramNames[i]);
                }
                this.paramLowerBounds[i] = stringArray2[0].trim();
                this.paramUpperBounds[i] = stringArray2[1].trim();
            }
        }
        if (!this.modelExportTasks.isEmpty()) {
            object = this.modelFilename;
            if (((String)object).lastIndexOf(46) > -1) {
                object = this.modelFilename.substring(0, ((String)object).lastIndexOf(46));
            }
            for (ModelExportTask modelExportTask : this.modelExportTasks) {
                modelExportTask.replaceEmptyFileBasename((String)object);
            }
        }
    }

    private SimulationMethod processSimulationOptions(Expression expression) throws PrismException {
        SimulationMethod simulationMethod = null;
        boolean bl = expression instanceof ExpressionReward;
        boolean bl2 = Expression.isQuantitative(expression);
        if (!this.simApproxGiven) {
            this.simApprox = this.prism.getSettings().getDouble("simulator.defaultApprox");
        }
        if (!this.simConfidenceGiven) {
            this.simConfidence = this.prism.getSettings().getDouble("simulator.defaultConfidence");
        }
        if (!this.simNumSamplesGiven) {
            this.simNumSamples = this.prism.getSettings().getInteger("simulator.defaultNumSamples");
        }
        if (!this.simWidthGiven) {
            this.simWidth = this.prism.getSettings().getDouble("simulator.defaultWidth");
        }
        if (!this.reqIterToConcludeGiven) {
            this.reqIterToConclude = this.prism.getSettings().getInteger("simulator.decide");
        }
        if (!this.simMaxRewardGiven) {
            this.simMaxReward = this.prism.getSettings().getDouble("simulator.maxReward");
        }
        if (!this.simMaxPathGiven) {
            this.simMaxPath = this.prism.getSettings().getLong("simulator.defaultMaxPath");
        }
        if (this.simMethodName == null) {
            String string = this.simMethodName = bl2 ? "ci" : "sprt";
        }
        if (this.simMethodName.equals("ci")) {
            if (this.simWidthGiven && this.simConfidenceGiven && this.simNumSamplesGiven) {
                throw new PrismException("Cannot specify all three parameters (width/confidence/samples) for CI method");
            }
            simulationMethod = !this.simWidthGiven ? new CIwidth(this.simConfidence, this.simNumSamples) : (!this.simNumSamplesGiven ? (this.simManual ? new CIiterations(this.simConfidence, this.simWidth, this.reqIterToConclude) : (bl ? new CIiterations(this.simConfidence, this.simWidth, this.simMaxReward) : new CIiterations(this.simConfidence, this.simWidth))) : new CIconfidence(this.simWidth, this.simNumSamples));
            if (this.simApproxGiven) {
                this.mainLog.printWarning("Option -simapprox is not used for the CI method and is being ignored");
            }
        } else if (this.simMethodName.equals("aci")) {
            if (this.simWidthGiven && this.simConfidenceGiven && this.simNumSamplesGiven) {
                throw new PrismException("Cannot specify all three parameters (width/confidence/samples) for ACI method");
            }
            simulationMethod = !this.simWidthGiven ? new ACIwidth(this.simConfidence, this.simNumSamples) : (!this.simNumSamplesGiven ? (this.simManual ? new ACIiterations(this.simConfidence, this.simWidth, this.reqIterToConclude) : (bl ? new ACIiterations(this.simConfidence, this.simWidth, this.simMaxReward) : new CIiterations(this.simConfidence, this.simWidth))) : new ACIconfidence(this.simWidth, this.simNumSamples));
            if (this.simApproxGiven) {
                this.mainLog.printWarning("Option -simapprox is not used for the ACI method and is being ignored");
            }
        } else if (this.simMethodName.equals("apmc")) {
            if (bl) {
                throw new PrismException("Cannot use the APMC method on reward properties; try CI (switch -simci) instead");
            }
            if (this.simApproxGiven && this.simConfidenceGiven && this.simNumSamplesGiven) {
                throw new PrismException("Cannot specify all three parameters (approximation/confidence/samples) for APMC method");
            }
            simulationMethod = !this.simApproxGiven ? new APMCapproximation(this.simConfidence, this.simNumSamples) : (!this.simNumSamplesGiven ? new APMCiterations(this.simConfidence, this.simApprox) : new APMCconfidence(this.simApprox, this.simNumSamples));
            if (this.simWidthGiven) {
                this.mainLog.printWarning("Option -simwidth is not used for the APMC method and is being ignored");
            }
        } else if (this.simMethodName.equals("sprt")) {
            if (bl2) {
                throw new PrismException("Cannot use SPRT on a quantitative (=?) property");
            }
            simulationMethod = new SPRTMethod(this.simConfidence, this.simConfidence, this.simWidth);
            if (this.simApproxGiven) {
                this.mainLog.printWarning("Option -simapprox is not used for the SPRT method and is being ignored");
            }
            if (this.simNumSamplesGiven) {
                this.mainLog.printWarning("Option -simsamples is not used for the SPRT method and is being ignored");
            }
        } else {
            throw new PrismException("Unknown simulation method \"" + this.simMethodName + "\"");
        }
        return simulationMethod;
    }

    private void printHelp() {
        this.mainLog.println("Usage: " + Prism.getCommandLineName() + " [options] <model-file> [<properties-file>] [more-options]");
        this.mainLog.println();
        this.mainLog.println("Options:");
        this.mainLog.println("========");
        this.mainLog.println();
        this.mainLog.println("-help .......................... Display this help message");
        this.mainLog.println("-version ....................... Display PRISM version info");
        this.mainLog.println("-javaversion ................... Display Java version info");
        this.mainLog.println("-dir <dir> ..................... Set current working directory");
        this.mainLog.println("-settings <file>................ Load settings from <file>");
        this.mainLog.println();
        this.mainLog.println("-pf <props> (or -pctl or -csl) . Model check properties <props>");
        this.mainLog.println("-property <refs> (or -prop) .... Only model check properties included in list <refs> of indices/names");
        this.mainLog.println("-const <vals> .................. Define constant values as <vals> (e.g. for experiments)");
        this.mainLog.println("-steadystate (or -ss) .......... Compute steady-state probabilities (D/CTMCs only)");
        this.mainLog.println("-transient <x> (or -tr <x>) .... Compute transient probabilities for time (or time range) <x> (D/CTMCs only)");
        this.mainLog.println("-simpath <options> <file>....... Generate a random path with the simulator");
        this.mainLog.println("-nobuild ....................... Skip model construction (just do parse/export)");
        this.mainLog.println("-test .......................... Enable \"test\" mode");
        this.mainLog.println("-testall ....................... Enable \"test\" mode, but don't exit on error");
        this.mainLog.println("-javamaxmem <x>................. Set the maximum heap size for Java, e.g. 500m, 4g [default: 1g]");
        this.mainLog.println("-javastack <x> ................. Set the Java stack size [default: 4m]");
        this.mainLog.println("-javaparams <x>................. Pass additional command-line arguments to Java");
        this.mainLog.println("-timeout <n> ................... Exit after a time-out of <n> seconds if not already terminated");
        this.mainLog.println("-ng ............................ Run PRISM in Nailgun server mode; subsequent calls are then made via \"ngprism\"");
        this.mainLog.println();
        this.mainLog.println("IMPORTS:");
        this.mainLog.println("-importpepa .................... Model description is in PEPA, not the PRISM language");
        this.mainLog.println("-importmodel <files> ........... Import the model directly from text file(s)");
        this.mainLog.println("-importtrans <file> ............ Import the transition matrix directly from a text file");
        this.mainLog.println("-importstates <file>............ Import the list of states directly from a text file");
        this.mainLog.println("-importobs <file>............... Import the list of observations directly from a text file");
        this.mainLog.println("-importlabels <file>............ Import the list of labels directly from a text file");
        this.mainLog.println("-importstaterewards <file>...... Import the state rewards directly from a text file");
        this.mainLog.println("-importtransrewards <file>...... Import the transition rewards directly from a text file");
        this.mainLog.println("-importinitdist <file>.......... Specify initial probability distribution for transient/steady-state analysis");
        this.mainLog.println("-dtmc .......................... Force imported/built model to be a DTMC");
        this.mainLog.println("-ctmc .......................... Force imported/built model to be a CTMC");
        this.mainLog.println("-mdp ........................... Force imported/built model to be an MDP");
        this.mainLog.println("-importresults <file> .......... Import results from a data frame stored in CSV file");
        this.mainLog.println();
        this.mainLog.println("EXPORTS:");
        this.mainLog.println("-exportresults <file[:options]>  Export the results of model checking to a file");
        this.mainLog.println("-exportvector <file>  .......... Export results of model checking for all states to a file");
        this.mainLog.println("-exportmodel <files[:options]> . Export the built model to file(s)");
        this.mainLog.println("-exporttrans <file> ............ Export the transition matrix to a file");
        this.mainLog.println("-exportstaterewards <file> ..... Export the state rewards vector to a file");
        this.mainLog.println("-exporttransrewards <file> ..... Export the transition rewards matrix to a file");
        this.mainLog.println("-exportrewards <file1> <file2>.. Export state/transition rewards to files 1/2");
        this.mainLog.println("-exportstates <file> ........... Export the list of reachable states to a file");
        this.mainLog.println("-exportobs <file> .............. Export the list of observations to a file");
        this.mainLog.println("-exportlabels <file[:options]> . Export the list of labels and satisfying states to a file");
        this.mainLog.println("-exportproplabels <file[:opt]> . Export the list of labels and satisfying states from the properties file to a file");
        this.mainLog.println("-exportstrat <file[:options]> .. Generate and export a strategy to a file");
        this.mainLog.println("-exportmatlab .................. When exporting matrices/vectors/labels/etc., use Matlab format");
        this.mainLog.println("-exportrows .................... When exporting matrices, put a whole row on one line");
        this.mainLog.println("-exporttransdot <file> ......... Export the transition matrix graph to a dot file");
        this.mainLog.println("-exporttransdotstates <file> ... Export the transition matrix graph to a dot file, with state info");
        this.mainLog.println("-exportdot <file> .............. Export the transition matrix MTBDD to a dot file");
        this.mainLog.println("-exportsccs <file> ............. Compute and export all SCCs of the model");
        this.mainLog.println("-exportbsccs <file> ............ Compute and export all BSCCs of the model");
        this.mainLog.println("-exportmecs <file> ............. Compute and export all maximal end components (MDPs only)");
        this.mainLog.println("-exportsteadystate <file> ...... Export steady-state probabilities to a file");
        this.mainLog.println("-exporttransient <file> ........ Export transient probabilities to a file");
        this.mainLog.println("-exportprism <file> ............ Export final PRISM model to a file");
        this.mainLog.println("-exportprismconst <file> ....... Export final PRISM model with expanded constants to a file");
        PrismSettings.printHelp(this.mainLog);
        this.mainLog.println();
        this.mainLog.println("SIMULATION OPTIONS:");
        this.mainLog.println("-sim ........................... Use the PRISM simulator to approximate results of model checking");
        this.mainLog.println("-simmethod <name> .............. Specify the method for approximate model checking (ci, aci, apmc, sprt)");
        this.mainLog.println("-simsamples <n> ................ Set the number of samples for the simulator (CI/ACI/APMC methods)");
        this.mainLog.println("-simconf <x> ................... Set the confidence parameter for the simulator (CI/ACI/APMC methods)");
        this.mainLog.println("-simwidth <x> .................. Set the interval width for the simulator (CI/ACI methods)");
        this.mainLog.println("-simapprox <x> ................. Set the approximation parameter for the simulator (APMC method)");
        this.mainLog.println("-simmanual ..................... Do not use the automated way of deciding whether the variance is null or not");
        this.mainLog.println("-simvar <n> .................... Set the minimum number of samples to know the variance is null or not");
        this.mainLog.println("-simmaxrwd <x> ................. Set the maximum reward -- useful to display the CI/ACI methods progress");
        this.mainLog.println("-simpathlen <n> ................ Set the maximum path length for the simulator");
        this.mainLog.println();
        this.mainLog.println("You can also use \"prism -help xxx\" for help on some switches -xxx with non-obvious syntax.");
    }

    private void printHelpSwitch(String string) {
        if (string.charAt(0) == '-') {
            string = string.substring(1);
        }
        if (string.equals("const")) {
            this.mainLog.println("Switch: -const <vals>\n");
            this.mainLog.println("<vals> is a comma-separated list of values or value ranges for undefined constants");
            this.mainLog.println("in the model or properties (i.e. those declared without values, such as \"const int a;\").");
            this.mainLog.println("You can either specify a single value (a=1), a range (a=1:10) or a range with a step (a=1:2:50).");
            this.mainLog.println("For convenience, constant definutions can also be split across multiple -const switches.");
            this.mainLog.println("\nExamples:");
            this.mainLog.println(" -const a=1,b=5.6,c=true");
            this.mainLog.println(" -const a=1:10,b=5.6");
            this.mainLog.println(" -const a=1:2:50,b=5.6");
            this.mainLog.println(" -const a=1:2:50 -const b=5.6");
        } else if (string.equals("simpath")) {
            this.mainLog.println("Switch: -simpath <options> <file>\n");
            this.mainLog.println("Generate a random path with the simulator and export it to <file> (or to the screen if <file>=\"stdout\").");
            this.mainLog.println("<options> is a comma-separated list of options taken from:");
            GenerateSimulationPath.printOptions(this.mainLog);
        } else if (string.equals("importmodel")) {
            this.mainLog.println("Switch: -importmodel <files>[:options]\n");
            this.mainLog.println("Import the model directly from one or more file(s).");
            this.mainLog.println("Use a list of file extensions to indicate which files should be read, e.g.:");
            this.mainLog.println("\n -importmodel in.tra,sta\n");
            this.mainLog.println("Possible extensions are: .tra, .sta, .obs, .lab, .srew, .trew, .umb");
            this.mainLog.println("Use extension .all to import all explicit files (.tra/sta/obs/lab/srew/trew), e.g.:");
            this.mainLog.println("\n -importmodel in.all\n");
            this.mainLog.println("If provided, <options> is a comma-separated list of options taken from:");
            this.mainLog.println(" * format (=explicit/umb) - model import format");
        } else if (string.equals("importresults")) {
            this.mainLog.println("Switch: -importresults <file>\n");
            this.mainLog.println("Import results from a data frame stored as comma-separated values in <file>.");
        } else if (string.equals("exportresults")) {
            this.mainLog.println("Switch: -exportresults <file[:options]>\n");
            this.mainLog.println("Exports the results of model checking to <file> (or to the screen if <file>=\"stdout\").");
            this.mainLog.println("The default behaviour is to export a list of results in text form, using tabs to separate items.");
            this.mainLog.println("If provided, <options> is a comma-separated list of options taken from:");
            this.mainLog.println(" * csv - Export results as comma-separated values");
            this.mainLog.println(" * matrix - Export results as one or more 2D matrices (e.g. for surface plots)");
            this.mainLog.println(" * dataframe - Export results as dataframe in comma-separated values)");
            this.mainLog.println(" * comment - Export results in comment format for regression testing)");
        } else if (string.equals("exportlabels")) {
            this.mainLog.println("Switch: -exportlabels <files[:options]>\n");
            this.mainLog.println("Export the list of labels and satisfying states to a file (or to the screen if <file>=\"stdout\").");
            this.mainLog.println();
            this.mainLog.println("If provided, <options> is a comma-separated list of options taken from:");
            this.mainLog.println(" * matlab - export data in Matlab format");
            this.mainLog.println(" * proplabels - export labels from a properties file into the same file, too");
        } else if (string.equals("exportproplabels")) {
            this.mainLog.println("Switch: -exportproplabels <files[:options]>\n");
            this.mainLog.println("Export the list of labels and satisfying states from the properties file to a file (or to the screen if <file>=\"stdout\").");
            this.mainLog.println();
            this.mainLog.println("If provided, <options> is a comma-separated list of options taken from:");
            this.mainLog.println(" * matlab - export data in Matlab format");
        } else if (string.equals("exportmodel")) {
            this.mainLog.println("Switch: -exportmodel <files[:options]>\n");
            this.mainLog.println("Export the built model to file(s) (or to the screen if <file>=\"stdout\").");
            this.mainLog.println("Use a list of file extensions to indicate which files should be generated, e.g.:");
            this.mainLog.println("\n -exportmodel out.tra,sta\n");
            this.mainLog.println("\n -exportmodel out.umb\n");
            this.mainLog.println("Possible extensions are: .tra, .srew, .trew, .lab, .sta, .obs, .dot, .umb, .drn");
            this.mainLog.println("Use extension .all to export all explicit files (.tra/srew/trew/lab/sta/obs), e.g.:");
            this.mainLog.println("\n -exportmodel out.all\n");
            this.mainLog.println("Omit the file basename to use the basename of the model file, e.g.:");
            this.mainLog.println("\n -exportmodel .all\n");
            this.mainLog.println("Use extension .rew to export both .srew/.trew files");
            this.mainLog.println();
            this.mainLog.println("If provided, <options> is a comma-separated list of options taken from:");
            this.mainLog.println(" * format (=explicit/matlab/dot/drn/umb) - model export format");
            this.mainLog.println(" * rewards (=true/false) - whether to include rewards");
            this.mainLog.println(" * labels (=true/false) - whether to include labels");
            this.mainLog.println(" * states (=true/false) - whether to include state definitions");
            this.mainLog.println(" * obs (=true/false) - whether to include observation definitions");
            this.mainLog.println(" * actions (=true/false) - whether to include actions on choices/transitions");
            this.mainLog.println(" * precision (=<n>) - use <n> significant figures for floating point values (in text)");
            this.mainLog.println(" * zip (=true/false) - whether to zip UMB files");
            this.mainLog.println(" * text - show binary formats in textual form ");
            this.mainLog.println(" * matlab - same as format=matlab");
            this.mainLog.println("For the explicit files format:");
            this.mainLog.println(" * rows - export matrices with one row/distribution on each line");
            this.mainLog.println(" * proplabels - also export labels from a properties file into the same file, too");
            this.mainLog.println(" * headers (=true/false) - include headers in explicit (reward) files");
        } else if (string.equals("exportstrat")) {
            this.mainLog.println("Switch: -exportstrat <file[:options]>\n");
            this.mainLog.println("Generate and export a strategy to a file (or to the screen if <file>=\"stdout\").");
            this.mainLog.println("Use file extension .tra or .dot to export as an induced model or Dot file, respectively.");
            this.mainLog.println("If provided, <options> is a comma-separated list of options taken from:");
            this.mainLog.println(" * type (=actions/induced/dot) - type of strategy export");
            this.mainLog.println(" * mode (=restrict/reduce) - mode to use for building induced model (or Dot file)");
            this.mainLog.println(" * reach (=true/false) - whether to restrict the strategy to its reachable states");
            this.mainLog.println(" * states (=true/false) - whether to show states, rather than state indices, for actions lists or Dot files");
            this.mainLog.println(" * obs (=true/false) - for partially observable models, whether to merge observationally equivalent states");
        } else {
            if (PrismSettings.printHelpSwitch(this.mainLog, string)) {
                return;
            }
            this.mainLog.println("Sorry - no help available for switch -" + string);
        }
    }

    private void printVersion() {
        this.mainLog.println(Prism.getToolName() + " version " + Prism.getVersion());
    }

    private void printListOfKeywords() {
        List<String> list = Prism.getListOfKeywords();
        this.mainLog.print("PRISM keywords:");
        for (String string : list) {
            this.mainLog.print(" " + string);
        }
        this.mainLog.println();
    }

    private void error(PrismException prismException) {
        this.error(prismException.getMessage(), prismException instanceof PrismNotSupportedException);
    }

    private void error(String string) {
        this.error(string, false);
    }

    private void error(String string, boolean bl) {
        if (this.test && this.testExitsOnFail && !bl) {
            this.errorAndExit(string);
        }
        this.mainLog.println("\nError: " + string + ".");
        this.mainLog.flush();
    }

    private void errorAndExit(String string) {
        this.prism.closeDown(false);
        this.mainLog.println("\nError: " + string + ".");
        this.mainLog.flush();
        System.exit(1);
    }

    private void exit() {
        this.prism.closeDown(true);
        System.exit(0);
    }

    private void exit(int n) {
        this.prism.closeDown(true);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0 || !"-ng".equals(stringArray[0])) {
            new PrismCL().go(stringArray);
        } else {
            try {
                System.out.println("Starting PRISM-Nailgun server...");
                NGServer.main((String[])new String[0]);
            }
            catch (NumberFormatException | UnknownHostException exception) {
                System.out.println("Failed to launch Nailgun server: " + String.valueOf(exception));
            }
        }
    }

    private class ModelImportSource {
        private ModelExportTask.ModelExportEntity entity;
        private ModelExportFormat format;
        private File file;

        public ModelImportSource(ModelExportTask.ModelExportEntity modelExportEntity, ModelExportFormat modelExportFormat, File file) {
            this.entity = modelExportEntity;
            this.format = modelExportFormat;
            this.file = file;
        }
    }
}

