/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.EvaluateContext;
import parser.State;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionIdent;
import parser.type.Type;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class UpdateElement
extends ASTElement {
    private String var;
    private Expression expr;
    private Type type;
    private ExpressionIdent ident;
    private int index;

    public UpdateElement(ExpressionIdent expressionIdent, Expression expression) {
        this.var = expressionIdent.getName();
        this.expr = expression;
        this.type = null;
        this.ident = expressionIdent;
        this.index = -1;
    }

    public UpdateElement(UpdateElement updateElement) {
        this.var = updateElement.var;
        this.expr = updateElement.expr;
        this.type = updateElement.type;
        this.ident = updateElement.ident;
        this.index = updateElement.index;
    }

    public String getVar() {
        return this.var;
    }

    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public ExpressionIdent getVarIdent() {
        return this.ident;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public int getVarIndex() {
        return this.index;
    }

    public void setExpression(Expression expression) {
        this.expr = expression;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    public void setVarIdent(ExpressionIdent expressionIdent) {
        this.ident = expressionIdent;
        this.var = expressionIdent.getName();
    }

    public void setVarIndex(int n) {
        this.index = n;
    }

    public void update(EvaluateContext evaluateContext, State state, VarList varList) throws PrismLangException {
        Object object = this.getType().castValueTo(this.expr.evaluate(evaluateContext));
        state.setValue(this.index, object);
    }

    public void checkUpdate(State state, VarList varList) throws PrismLangException {
        int n = varList.encodeToInt(this.index, this.expr.evaluate(state));
        if (n < varList.getLow(this.index) || n > varList.getHigh(this.index)) {
            throw new PrismLangException("Value of variable " + this.var + " overflows", this.expr);
        }
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public UpdateElement deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.ident = deepCopy.copy(this.ident);
        this.expr = deepCopy.copy(this.expr);
        return this;
    }

    @Override
    public UpdateElement clone() {
        return (UpdateElement)super.clone();
    }

    @Override
    public String toString() {
        return "(" + this.getVar() + "'=" + String.valueOf(this.getExpression()) + ")";
    }
}

