/*
 * Decompiled with CFR 0.152.
 */
package param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import param.Function;
import param.MutablePMC;
import param.Partition;

abstract class Lumper {
    protected MutablePMC origPmc;
    protected MutablePMC optPmc;
    protected Partition partition;
    protected HashMap<HashSet<Integer>, Integer> blockToNumber;
    protected ArrayList<HashSet<Integer>> blocks;
    protected int[] originalToOptimised;

    Lumper(MutablePMC mutablePMC) {
        this.origPmc = mutablePMC;
        this.partition = new Partition(mutablePMC);
        this.createInitialPartition();
        this.lump();
        this.mapBlocksToNumber();
        this.buildQuotient();
    }

    protected Lumper() {
    }

    protected void createInitialPartition() {
        HashSet<Integer> hashSet = this.partition.nextChangeableBlock();
        if (!this.origPmc.isUseRewards()) {
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            HashSet<Integer> hashSet3 = new HashSet<Integer>();
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                int n = object.next();
                if (this.origPmc.isTargetState(n)) {
                    hashSet3.add(n);
                    continue;
                }
                hashSet2.add(n);
            }
            object = new ArrayList();
            if (hashSet2.size() != 0) {
                ((ArrayList)object).add(hashSet2);
            }
            if (hashSet3.size() != 0) {
                ((ArrayList)object).add(hashSet3);
            }
            this.partition.addBlocks((ArrayList<HashSet<Integer>>)object);
        } else {
            HashMap<RewardEntry, HashSet<Integer>> hashMap = new HashMap<RewardEntry, HashSet<Integer>>();
            Object object = hashSet.iterator();
            while (object.hasNext()) {
                RewardEntry rewardEntry;
                HashSet<Integer> hashSet4;
                int n = object.next();
                Object object2 = this.origPmc.getReward(n);
                Function function = null;
                if (this.origPmc.isUseTime()) {
                    function = this.origPmc.getTime(n);
                }
                if ((hashSet4 = (HashSet<Integer>)hashMap.get(rewardEntry = new RewardEntry((Function)object2, function))) == null) {
                    hashSet4 = new HashSet<Integer>();
                    hashMap.put(rewardEntry, hashSet4);
                }
                hashSet4.add(n);
            }
            object = new ArrayList();
            for (Object object2 : hashMap.values()) {
                if (((HashSet)object2).size() == 0) continue;
                ((ArrayList)object).add(object2);
            }
            this.partition.addBlocks((ArrayList<HashSet<Integer>>)object);
        }
        this.partition.markAllBlocksAsNew();
    }

    MutablePMC getQuotient() {
        return this.optPmc;
    }

    protected void mapBlocksToNumber() {
        this.blocks = this.partition.getAllBlocks();
        this.blockToNumber = new HashMap();
        this.originalToOptimised = new int[this.origPmc.getNumStates()];
        int n = 0;
        for (HashSet<Integer> hashSet : this.blocks) {
            this.blockToNumber.put(hashSet, n);
            for (int n2 : hashSet) {
                this.originalToOptimised[n2] = n;
            }
            ++n;
        }
    }

    int[] getOriginalToOptimised() {
        return this.originalToOptimised;
    }

    protected void lump() {
        ArrayList<HashSet<Integer>> arrayList = new ArrayList<HashSet<Integer>>();
        while (this.partition.mayChange()) {
            arrayList.clear();
            HashSet<Integer> hashSet = this.partition.nextChangeableBlock();
            this.refineBlock(hashSet, arrayList);
            this.partition.addBlocks(arrayList);
        }
    }

    protected abstract void refineBlock(HashSet<Integer> var1, ArrayList<HashSet<Integer>> var2);

    protected abstract void buildQuotient();

    class RewardEntry {
        final Function reward;
        final Function time;

        RewardEntry(Function function, Function function2) {
            this.reward = function;
            this.time = function2;
        }

        public int hashCode() {
            int n = this.reward.hashCode() << 13;
            if (this.time != null) {
                n |= this.time.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RewardEntry)) {
                return false;
            }
            RewardEntry rewardEntry = (RewardEntry)object;
            if (!this.reward.equals(rewardEntry.reward)) {
                return false;
            }
            if (this.time == null != (rewardEntry.time == null)) {
                return false;
            }
            return this.time == null || this.time.equals(rewardEntry.time);
        }
    }

    static enum BisimType {
        NULL,
        STRONG,
        WEAK;

    }
}

